/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.business.pojo;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.invp.business.pojo.FieldMapConf;

public class BaseModel {
    private Map<String, DynamicObject> dataSourceMap = new HashMap<String, DynamicObject>();
    private Map<String, FieldMapConf> fieldMapConfMap = new HashMap<String, FieldMapConf>();

    public BaseModel(DynamicObject modelObj) {
        this.init(modelObj);
    }

    private void init(DynamicObject dataModel) {
        DynamicObjectCollection dataSourceEntries = dataModel.getDynamicObjectCollection("entryentityds");
        for (DynamicObject dataSourceEntry : dataSourceEntries) {
            String entityNumber = dataSourceEntry.getDynamicObject("srcbillds").getString("number");
            this.dataSourceMap.put(entityNumber, dataSourceEntry);
            FieldMapConf fieldMapConf = new FieldMapConf(dataSourceEntry.getDynamicObject("billfieldmap"));
            this.fieldMapConfMap.put(entityNumber, fieldMapConf);
        }
    }

    public QFilter getDataSourceFilter(String entityNumber) {
        DynamicObject dataSource = this.dataSourceMap.get(entityNumber);
        String filterJson = dataSource.getString("filtervalueds");
        if (StringUtils.isEmpty((String)filterJson)) {
            return null;
        }
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterJson, FilterCondition.class);
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        FilterBuilder filterBuilder = new FilterBuilder(dataEntityType, filterCondition);
        filterBuilder.buildFilter();
        return filterBuilder.getQFilter();
    }

    public FieldMapConf getFieldMapConf(String entityNumber) {
        return this.fieldMapConfMap.get(entityNumber);
    }
}

