/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.business.pojo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.botp.CRValByCondition;
import kd.bos.entity.botp.CRValByConditionType;
import kd.bos.entity.botp.CRValByConditions;
import kd.bos.entity.function.BOSUDFunction;
import kd.bos.entity.function.FunctionManage;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.UDFunction;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.scmc.invp.business.func.GetRelationOrg;

public class FieldMapConf {
    private String sourceEntityNum;
    private String targetEntityNum;
    private Map<String, String> fieldMap = new LinkedHashMap<String, String>();
    private Map<String, String> formulaMap = new LinkedHashMap<String, String>();
    private Map<String, String> condExpressionMap = new LinkedHashMap<String, String>();
    private List<String> sourceFields = new ArrayList<String>();
    private List<String> targetFields = new ArrayList<String>();
    private FunctionManage functionManage;

    public FieldMapConf(DynamicObject fieldMapObj) {
        this.init(fieldMapObj);
        this.functionManage = FunctionManage.get();
        this.functionManage.addFunc("GetRelationOrg", (BOSUDFunction)new GetRelationOrg());
    }

    private void init(DynamicObject fieldMapObj) {
        this.sourceEntityNum = fieldMapObj.getDynamicObject("sourcebill").getString("id");
        this.targetEntityNum = fieldMapObj.getDynamicObject("targetobj").getString("id");
        DynamicObjectCollection colMaps = fieldMapObj.getDynamicObjectCollection("colsmap");
        for (DynamicObject colMap : colMaps) {
            String selectValue = colMap.getString("selectvalue");
            String targetFiled = colMap.getString("targetobjcol");
            switch (selectValue) {
                case "0": {
                    String sourceFiled = colMap.getString("sourcebillcol");
                    this.fieldMap.put(targetFiled, sourceFiled);
                    break;
                }
                case "1": {
                    String sourceFormula = colMap.getString("formula_tag");
                    CRCondition crCondition = (CRCondition)SerializationUtils.fromJsonString((String)sourceFormula, CRCondition.class);
                    this.formulaMap.put(targetFiled, crCondition.getExpression());
                    break;
                }
                case "2": {
                    String sourceFormula = colMap.getString("formula_tag");
                    this.condExpressionMap.put(targetFiled, sourceFormula);
                    break;
                }
            }
        }
        for (Map.Entry<String, String> fieldsEntry : this.fieldMap.entrySet()) {
            this.sourceFields.add(fieldsEntry.getValue());
            this.targetFields.add(fieldsEntry.getKey());
        }
        this.targetFields.addAll(this.formulaMap.keySet());
        this.targetFields.addAll(this.condExpressionMap.keySet());
    }

    public String getMatchSelector(List<String> selectorFields) {
        StringBuilder selectorBuilder = new StringBuilder();
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)this.sourceEntityNum);
        HashSet<String> formulaSelector = new HashSet<String>();
        for (String selectorField : selectorFields) {
            if (selectorBuilder.length() > 0) {
                selectorBuilder.append(",");
            }
            if (this.targetFields.contains(selectorField)) {
                if (this.fieldMap.containsKey(selectorField)) {
                    selectorBuilder.append(this.fieldMap.get(selectorField)).append(" as ").append(selectorField);
                }
                if (this.formulaMap.containsKey(selectorField)) {
                    String[] variables;
                    selectorBuilder.append("null as ").append(selectorField);
                    String expression = this.formulaMap.get(selectorField);
                    for (String variable : variables = FormulaEngine.extractVariables((String)expression)) {
                        formulaSelector.add(variable + " as " + variable + "_XX");
                    }
                }
                if (!this.condExpressionMap.containsKey(selectorField)) continue;
                selectorBuilder.append("null as ").append(selectorField);
                String condExpression = this.condExpressionMap.get(selectorField);
                CRValByConditions valByConditions = (CRValByConditions)SerializationUtils.fromJsonString((String)condExpression, CRValByConditions.class);
                List conditionItems = valByConditions.getItems();
                for (CRValByCondition conditionItem : conditionItems) {
                    String[] variables;
                    String condFormula;
                    CRCondition condition = conditionItem.getCondition();
                    CRFormula formula = conditionItem.getFormula();
                    if (formula != null && StringUtils.isNotBlank((CharSequence)formula.getExpression())) {
                        String[] variables2;
                        for (String variable : variables2 = FormulaEngine.extractVariables((String)formula.getExpression())) {
                            formulaSelector.add(variable + " as " + variable + "_XX");
                        }
                    }
                    if (condition == null || !CRValByConditionType.ByCondition.equals((Object)conditionItem.getSelectType()) || !StringUtils.isNotBlank((CharSequence)(condFormula = condition.buildFullFormula(dataEntityType)))) continue;
                    for (String variable : variables = FormulaEngine.extractVariables((String)condFormula)) {
                        formulaSelector.add(variable + " as " + variable + "_XX");
                    }
                }
                continue;
            }
            selectorBuilder.append("null as ").append(selectorField);
        }
        if (!formulaSelector.isEmpty()) {
            if (selectorBuilder.length() > 0) {
                selectorBuilder.append(",");
            }
            selectorBuilder.append(String.join((CharSequence)",", formulaSelector));
        }
        return selectorBuilder.toString();
    }

    public Map<String, Object> getTargetValue(Map<String, Object> sourceValue) {
        String targetField;
        HashMap<String, Object> targetValue = new HashMap<String, Object>(16);
        BOSUDFunction[] bosUdFunctions = this.functionManage.getFuncMap().values().toArray(new BOSUDFunction[0]);
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)this.sourceEntityNum);
        for (Map.Entry<String, String> fieldMapEntry : this.fieldMap.entrySet()) {
            targetField = fieldMapEntry.getKey();
            String sourceField = fieldMapEntry.getValue();
            targetValue.put(targetField, sourceValue.get(sourceField));
        }
        for (Map.Entry<String, String> formulaEntry : this.formulaMap.entrySet()) {
            targetField = formulaEntry.getKey();
            String formula = formulaEntry.getValue();
            Object result = FormulaEngine.execExcelFormula((String)formula, sourceValue, (UDFunction[])bosUdFunctions);
            targetValue.put(targetField, result);
        }
        block2: for (Map.Entry<String, String> condExpressionEntry : this.condExpressionMap.entrySet()) {
            targetField = condExpressionEntry.getKey();
            String condExpression = condExpressionEntry.getValue();
            CRValByConditions valByConditions = (CRValByConditions)SerializationUtils.fromJsonString((String)condExpression, CRValByConditions.class);
            List conditionItems = valByConditions.getItems();
            for (CRValByCondition conditionItem : conditionItems) {
                String filterExpression;
                CRCondition condition = conditionItem.getCondition();
                boolean condResult = true;
                if (condition != null && CRValByConditionType.ByCondition.equals((Object)conditionItem.getSelectType()) && StringUtils.isNotBlank((CharSequence)(filterExpression = condition.buildFullFormula(entityType)))) {
                    condResult = (Boolean)FormulaEngine.execExcelFormula((String)filterExpression, sourceValue, (UDFunction[])bosUdFunctions);
                }
                if (!condResult) continue;
                CRFormula formula = conditionItem.getFormula();
                Object result = null;
                if (formula != null && StringUtils.isNotBlank((CharSequence)formula.getExpression())) {
                    result = FormulaEngine.execExcelFormula((String)formula.getExpression(), sourceValue, (UDFunction[])bosUdFunctions);
                }
                targetValue.put(targetField, result);
                continue block2;
            }
        }
        return targetValue;
    }

    public List<String> getFields(String entityNum) {
        ArrayList<String> fields = new ArrayList<String>();
        if (!this.sourceEntityNum.equals(entityNum) && !this.targetEntityNum.equals(entityNum)) {
            return fields;
        }
        if (entityNum.equals(this.sourceEntityNum)) {
            return this.sourceFields;
        }
        return this.targetFields;
    }

    public String getSourceEntityNum() {
        return this.sourceEntityNum;
    }

    public String getTargetEntityNum() {
        return this.targetEntityNum;
    }

    public Map<String, String> getFieldMap() {
        return this.fieldMap;
    }

    public Map<String, String> getFormulaMap() {
        return this.formulaMap;
    }

    public Map<String, String> getCondExpressionMap() {
        return this.condExpressionMap;
    }
}

