/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.business.pojo;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scmc.invp.business.pojo.InvLevelDimension;

public class InvLevel {
    private InvLevelDimension dimension;
    private String planType;
    private Long id;
    private String number;
    private Map<Long, DynamicObject> invLevelEntryMap;

    public InvLevel(DynamicObject invLevel) {
        this.init(invLevel);
    }

    public DynamicObject getInvLevelEntry(Long entryId) {
        return this.invLevelEntryMap.get(entryId);
    }

    private void init(DynamicObject invLevel) {
        DynamicObject dimensionObj = invLevel.getDynamicObject("dimension");
        this.dimension = new InvLevelDimension(dimensionObj);
        this.id = invLevel.getLong("id");
        this.number = invLevel.getString("number");
        this.invLevelEntryMap = new HashMap<Long, DynamicObject>();
        this.planType = invLevel.getString("mainplantype");
        String selector = this.getSelector(this.planType);
        Date today = TimeServiceHelper.today();
        QFilter filter = new QFilter("id", "=", (Object)this.id).and("entryentity.dateend", ">=", (Object)today).and("entryentity.datestart", "<=", (Object)today);
        DynamicObjectCollection invLevelEntries = QueryServiceHelper.query((String)"invp_invlevel", (String)selector, (QFilter[])filter.toArray());
        for (DynamicObject invLevelEntry : invLevelEntries) {
            this.invLevelEntryMap.put(invLevelEntry.getLong("id"), invLevelEntry);
        }
    }

    public String getSelector(String planType) {
        StringBuilder selectorBuilder = new StringBuilder();
        if ("A".equals(planType)) {
            selectorBuilder.append("reorder,");
            selectorBuilder.append("ecobatch,");
        }
        if ("D".equals(planType)) {
            selectorBuilder.append("tgtinvdays,");
            selectorBuilder.append("dailyconsume,");
            selectorBuilder.append("urgentinvdays,");
            selectorBuilder.append("supplytype,");
            selectorBuilder.append("supplyday,");
        }
        if ("B".equals(planType)) {
            selectorBuilder.append("max,");
            selectorBuilder.append("min,");
        }
        selectorBuilder.append("postprocessingtime,");
        selectorBuilder.append("deliverytime,");
        selectorBuilder.append("preprocessingtime,");
        selectorBuilder.append("leadtime,");
        selectorBuilder.append("id,");
        for (String dimensionField : this.dimension.getDimensions()) {
            selectorBuilder.append(dimensionField).append(",");
        }
        selectorBuilder.append("planner,");
        selectorBuilder.append("plangroup");
        return selectorBuilder.toString();
    }

    public String getPlanType() {
        return this.planType;
    }

    public InvLevelDimension getDimension() {
        return this.dimension;
    }

    public Long getId() {
        return this.id;
    }

    public String getNumber() {
        return this.number;
    }

    public Map<Long, DynamicObject> getInvLevelEntryMap() {
        return this.invLevelEntryMap;
    }
}

