/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.business.pojo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.scmc.invp.business.pojo.DemandModel;
import kd.scmc.invp.business.pojo.InvLevelDimension;
import kd.scmc.invp.business.pojo.InvSupplyPolicy;
import kd.scmc.invp.business.pojo.MatchMappingConfig;
import kd.scmc.invp.business.pojo.OutPutParam;
import kd.scmc.invp.business.pojo.SupplyModel;
import kd.scmc.invp.common.helper.ModelFilterHelper;

public class InvPlanScheme {
    private String mainPlanType;
    private InvLevelDimension dimension;
    private Integer planOutLook;
    private List<Long> planner;
    private List<Long> planGroup;
    private String invLevelFilterJson;
    private Map<Long, InvSupplyPolicy> supplyPolicyMap;
    private DemandModel demandModel;
    private MatchMappingConfig demand2SupplyMatchCof;
    private List<String> demandDsList;
    private Integer demandOutOfDate;
    private String[] demandOrder;
    private SupplyModel supplyModel;
    private Integer supplyOutOfDate;
    private List<String> supplyDsList;
    private Boolean autoAudit;
    private Boolean leadTimeLackAsc;
    private List<String> mergeBillFields;
    private Integer allowLeadTime;
    private Integer allowDelayTime;
    private Map<String, String> adjustPolicyMap;
    private List<OutPutParam> outPutParams;
    private MatchMappingConfig demand2LevelMatchCof;

    public InvPlanScheme(DynamicObject invPlanScheme) {
        this.init(invPlanScheme);
    }

    private void init(DynamicObject invPlanScheme) {
        this.demandOrder = this.getDemandOrder(invPlanScheme);
        this.mainPlanType = invPlanScheme.getString("mainplantype");
        this.dimension = new InvLevelDimension(invPlanScheme.getDynamicObject("dimension"));
        this.planOutLook = invPlanScheme.getInt("planoutlook");
        this.planner = ModelFilterHelper.getMulSelectBaseDataId(invPlanScheme.getDynamicObjectCollection("planner"));
        this.planGroup = ModelFilterHelper.getMulSelectBaseDataId(invPlanScheme.getDynamicObjectCollection("plangroup"));
        this.invLevelFilterJson = invPlanScheme.getString("invlevelfilter_tag");
        this.supplyPolicyMap = new HashMap<Long, InvSupplyPolicy>();
        DynamicObjectCollection orgParamEntries = invPlanScheme.getDynamicObjectCollection("orgparamentry");
        for (Object orgParamEntry : orgParamEntries) {
            this.supplyPolicyMap.put(orgParamEntry.getDynamicObject("entrydemandorg").getLong("id"), new InvSupplyPolicy(orgParamEntry.getDynamicObject("entrysupplypolicy")));
        }
        this.demandModel = new DemandModel(invPlanScheme.getDynamicObject("demandmodel"));
        this.demand2SupplyMatchCof = new MatchMappingConfig(invPlanScheme.getDynamicObject("suptodemmapping"));
        this.demand2LevelMatchCof = new MatchMappingConfig(invPlanScheme.getDynamicObject("demtolevelmapping"));
        this.demandOutOfDate = invPlanScheme.getInt("demdelayday");
        if (1 == invPlanScheme.getInt("outofdate")) {
            this.demandOutOfDate = -1;
        }
        this.demandDsList = new ArrayList<String>();
        DynamicObjectCollection demandParamEntries = invPlanScheme.getDynamicObjectCollection("demandparamentry");
        for (Object demandParamEntry : demandParamEntries) {
            if (!demandParamEntry.getBoolean("indemcal")) continue;
            this.demandDsList.add(demandParamEntry.getDynamicObject("demandsrc").getString("id"));
        }
        this.supplyModel = new SupplyModel(invPlanScheme.getDynamicObject("supplymodel"));
        this.supplyOutOfDate = invPlanScheme.getInt("supdelayday");
        if (1 == invPlanScheme.getInt("scoutofdate")) {
            this.supplyOutOfDate = -1;
        }
        this.supplyDsList = new ArrayList<String>();
        DynamicObjectCollection supplyParamEntries = invPlanScheme.getDynamicObjectCollection("supparamentry");
        for (Object supplyParamEntry : supplyParamEntries) {
            if (!supplyParamEntry.getBoolean("insupcal")) continue;
            this.supplyDsList.add(supplyParamEntry.getDynamicObject("supplydatasrc").getString("id"));
        }
        this.allowLeadTime = invPlanScheme.getInt("allowleadtime");
        this.allowDelayTime = invPlanScheme.getInt("allowdelaytime");
        this.adjustPolicyMap = new HashMap<String, String>();
        DynamicObjectCollection supAdjustEntries = invPlanScheme.getDynamicObjectCollection("supadjustentry");
        for (Object supAdjustEntry : supAdjustEntries) {
            this.adjustPolicyMap.put(supAdjustEntry.getDynamicObject("entitytype").getString("id"), supAdjustEntry.getString("adjuststrategy"));
        }
        this.autoAudit = invPlanScheme.getBoolean("autoauditplanadv");
        this.leadTimeLackAsc = invPlanScheme.getBoolean("leadtimelackasc");
        this.mergeBillFields = new ArrayList<String>();
        DynamicObjectCollection mergeBillEntries = invPlanScheme.getDynamicObjectCollection("outputresentry");
        for (DynamicObject mergeBillEntry : mergeBillEntries) {
            this.mergeBillFields.add(mergeBillEntry.getString("uniocolsign"));
        }
        this.outPutParams = new ArrayList<OutPutParam>();
        DynamicObjectCollection outPutEntries = invPlanScheme.getDynamicObjectCollection("outputparamentry");
        for (DynamicObject outPutEntry : outPutEntries) {
            boolean autoPut = outPutEntry.getBoolean("autoput");
            if (!autoPut) continue;
            String targetEntityNum = outPutEntry.getDynamicObject("targetputbill").getString("number");
            String filterJson = outPutEntry.getString("filtervalue");
            String botpId = outPutEntry.getDynamicObject("autoputbotp").getString("id");
            String targetStatus = outPutEntry.getString("targetbillstatus");
            this.outPutParams.add(new OutPutParam(autoPut, targetEntityNum, filterJson, botpId, targetStatus));
        }
    }

    public String[] getDemandOrder(DynamicObject invPlanScheme) {
        DynamicObjectCollection demandOrderCol = invPlanScheme.getDynamicObjectCollection("demprientry");
        ArrayList<String> orderList = new ArrayList<String>();
        for (DynamicObject demandOrderEntry : demandOrderCol) {
            String demandOrderField = demandOrderEntry.getString("demcolsign");
            String demandOrderType = demandOrderEntry.getString("demsorttype");
            orderList.add(demandOrderField + " " + demandOrderType);
        }
        return orderList.toArray(new String[0]);
    }

    public QFilter getDemandOrgFilter(String orgField) {
        if (!StringUtils.isEmpty((String)orgField)) {
            return new QFilter(orgField, "in", this.supplyPolicyMap.keySet());
        }
        return null;
    }

    public Set<Long> getDemandOrgIds() {
        return this.supplyPolicyMap.keySet();
    }

    public Integer getPlanOutLook() {
        return this.planOutLook;
    }

    public DemandModel getDemandModel() {
        return this.demandModel;
    }

    public List<String> getDemandDsList() {
        return this.demandDsList;
    }

    public Map<Long, InvSupplyPolicy> getSupplyPolicyMap() {
        return this.supplyPolicyMap;
    }

    public Integer getDemandOutOfDate() {
        return this.demandOutOfDate;
    }

    public String[] getDemandOrder() {
        return this.demandOrder;
    }

    public SupplyModel getSupplyModel() {
        return this.supplyModel;
    }

    public Integer getSupplyOutOfDate() {
        return this.supplyOutOfDate;
    }

    public List<String> getSupplyDsList() {
        return this.supplyDsList;
    }

    public Boolean getAutoAudit() {
        return this.autoAudit;
    }

    public List<String> getMergeBillFields() {
        return this.mergeBillFields;
    }

    public Integer getAllowLeadTime() {
        return this.allowLeadTime;
    }

    public Integer getAllowDelayTime() {
        return this.allowDelayTime;
    }

    public Map<String, String> getAdjustPolicyMap() {
        return this.adjustPolicyMap;
    }

    public List<OutPutParam> getOutPutParams() {
        return this.outPutParams;
    }

    public MatchMappingConfig getDemand2SupplyMatchCof() {
        return this.demand2SupplyMatchCof;
    }

    public MatchMappingConfig getDemand2LevelMatchCof() {
        return this.demand2LevelMatchCof;
    }

    public Boolean getLeadTimeLackAsc() {
        return this.leadTimeLackAsc;
    }

    public String getMainPlanType() {
        return this.mainPlanType;
    }

    public InvLevelDimension getDimension() {
        return this.dimension;
    }

    public List<Long> getPlanner() {
        return this.planner;
    }

    public List<Long> getPlanGroup() {
        return this.planGroup;
    }

    public String getInvLevelFilterJson() {
        return this.invLevelFilterJson;
    }
}

