/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.business.pojo;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;

public class MatchGroup {
    private DynamicObject invLevelEntryInfo;
    private List<Object[]> demandBills = new ArrayList<Object[]>();
    private List<Object[]> supplyBills = new ArrayList<Object[]>(16);

    public MatchGroup(DynamicObject invLevelEntryInfo) {
        this.invLevelEntryInfo = invLevelEntryInfo;
    }

    public DynamicObject getInvLevelEntryInfo() {
        return this.invLevelEntryInfo;
    }

    public void addDemandBills(Object[] demandBills) {
        this.demandBills.add(demandBills);
    }

    public void addSupplyBills(Object[] supplyBills) {
        this.supplyBills.add(supplyBills);
    }

    public BigDecimal getUsableQty(Map<String, Integer> demandIndex, Map<String, Integer> supplyIndex) {
        BigDecimal usableQty = BigDecimal.ZERO;
        Integer supplyQtyIndex = supplyIndex.get("baseqty");
        Integer demandQtyIndex = demandIndex.get("qty");
        Iterator<Object[]> iterator = this.supplyBills.iterator();
        while (iterator.hasNext()) {
            Object[] supplyBill = iterator.next();
            if (((BigDecimal)supplyBill[supplyQtyIndex]).compareTo(BigDecimal.ZERO) == 0) {
                iterator.remove();
                continue;
            }
            usableQty = usableQty.add((BigDecimal)supplyBill[supplyQtyIndex]);
            supplyBill[supplyQtyIndex.intValue()] = BigDecimal.ZERO;
            iterator.remove();
        }
        for (Object[] demandBill : this.demandBills) {
            usableQty = usableQty.subtract((BigDecimal)demandBill[demandQtyIndex]);
        }
        return usableQty;
    }

    public Map<String, Object> getLastDemandData(Map<String, Integer> demandIndex) {
        Object[] demandValue = this.demandBills.get(this.demandBills.size() - 1);
        HashMap<String, Object> demandData = new HashMap<String, Object>(16);
        for (Map.Entry<String, Integer> indexEntry : demandIndex.entrySet()) {
            demandData.put(indexEntry.getKey(), demandValue[indexEntry.getValue()]);
        }
        return demandData;
    }

    public List<Object[]> getDemandBills() {
        return this.demandBills;
    }
}

