/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.business.pojo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class MatchMappingConfig {
    private String targetEntity;
    private String sourceEntity;
    private DynamicObjectCollection matchEntries;
    private List<String> sourceFields = new ArrayList<String>();
    private List<String> targetFields = new ArrayList<String>();
    private Map<String, String> target2SourceMap = new HashMap<String, String>();
    private Map<String, String> source2TargetMap = new HashMap<String, String>();

    public MatchMappingConfig(DynamicObject matchMappingInfo) {
        this.init(matchMappingInfo);
    }

    private void init(DynamicObject matchMappingInfo) {
        this.targetEntity = matchMappingInfo.getDynamicObject("tgtentity").getString("number");
        this.sourceEntity = matchMappingInfo.getDynamicObject("srcentity").getString("number");
        this.matchEntries = matchMappingInfo.getDynamicObjectCollection("matchentry");
        for (DynamicObject matchEntry : this.matchEntries) {
            this.sourceFields.add(matchEntry.getString("srcmatchfieldkey"));
            this.targetFields.add(matchEntry.getString("tgtmatchfieldkey"));
            this.target2SourceMap.put(matchEntry.getString("tgtmatchfieldkey"), matchEntry.getString("srcmatchfieldkey"));
            this.source2TargetMap.put(matchEntry.getString("srcmatchfieldkey"), matchEntry.getString("tgtmatchfieldkey"));
        }
    }

    public DataSet getTargetInfoMap(DataSet targetSet, String entityNum) {
        String targetKey;
        HashMap groupField = new HashMap();
        HashMap<String, String> selectorMap = new HashMap<String, String>();
        selectorMap.put("id", "id");
        String fieldKey = entityNum.equals(this.targetEntity) ? "tgtmatchfieldkey" : "srcmatchfieldkey";
        for (Object matchEntry : this.matchEntries) {
            targetKey = matchEntry.getString(fieldKey);
            selectorMap.put(targetKey, targetKey);
            if (!"B".equals(matchEntry.get("matchtype"))) continue;
            groupField.put(targetKey, new HashSet());
        }
        if (!groupField.isEmpty()) {
            DataSet copyDataSet = targetSet.copy();
            for (Row row : copyDataSet) {
                for (Map.Entry fieldEntry : groupField.entrySet()) {
                    ((Set)fieldEntry.getValue()).add(row.get((String)fieldEntry.getKey()));
                }
            }
        }
        for (Object matchEntry : this.matchEntries) {
            if (!"B".equals(matchEntry.get("matchtype"))) continue;
            targetKey = matchEntry.getString(fieldKey);
            String groupDetailEntity = matchEntry.getDynamicObject("matchgroup").getDynamicObject("relationobj").getString("id");
            String groupKey = matchEntry.getDynamicObject("matchgroup").getString("groupkey");
            String dataKey = matchEntry.getDynamicObject("matchgroup").getString("datakey");
            Set groupValues = (Set)groupField.get(targetKey);
            String selector = groupKey + "," + dataKey;
            QFilter filter = new QFilter(groupKey, "in", (Object)groupValues);
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)groupDetailEntity, (String)selector, (QFilter[])filter.toArray(), (String)"");
            selectorMap.put(targetKey, dataKey + " " + targetKey);
            targetSet = targetSet.join(dataSet).on(targetKey, groupKey).select(selectorMap.values().toArray(new String[0])).finish();
            selectorMap.put(targetKey, targetKey);
        }
        return targetSet;
    }

    public QFilter getQFilter(Row targetInfo) {
        StringBuilder exp = new StringBuilder();
        ArrayList<Object> params = new ArrayList<Object>(this.matchEntries.size());
        String logic = "";
        for (DynamicObject row : this.matchEntries) {
            exp.append(' ').append(logic).append(' ');
            String leftBracket = row.getString("leftbracket");
            if (StringUtils.isNotBlank((CharSequence)leftBracket)) {
                exp.append(leftBracket);
            }
            String srcMatchField = row.getString("srcmatchfieldkey");
            String tgtMatchField = row.getString("tgtmatchfieldkey");
            String matchType = row.getString("matchtype");
            if ("B".equals(matchType)) {
                DynamicObject groupEntity;
                StringBuilder groupFilterBuilder = new StringBuilder();
                Long bdId = targetInfo.getLong(tgtMatchField);
                Map<Long, List<Long>> groupMap = this.groupMatch(bdId, groupEntity = row.getDynamicObject("matchgroup"));
                List<Long> groupValues = groupMap.get(bdId);
                if (ObjectUtils.isNotEmpty(groupValues)) {
                    groupFilterBuilder.append(srcMatchField).append(" in (?) ");
                    QFilter groupFilter = QFilter.of((String)groupFilterBuilder.toString(), (Object[])groupValues.toArray());
                    exp.append(groupFilter);
                } else {
                    exp.append(" 1 = 2 ");
                }
            } else {
                exp.append(srcMatchField).append(" = ? ");
                params.add(targetInfo.get(tgtMatchField));
            }
            String rightBracket = row.getString("rightbracket");
            if (StringUtils.isNotBlank((CharSequence)rightBracket)) {
                exp.append(rightBracket);
            }
            logic = row.getString("logic");
        }
        return QFilter.of((String)exp.toString(), (Object[])params.toArray());
    }

    private Map<Long, List<Long>> groupMatch(Long bdId, DynamicObject groupEntity) {
        if (null == groupEntity) {
            return Collections.emptyMap();
        }
        String groupType = (String)groupEntity.getDynamicObject("groupobj").getPkValue();
        String dataType = (String)groupEntity.getDynamicObject("dataobj").getPkValue();
        return (Map)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"DataGroupService", (String)"getGroupIds", (Object[])new Object[]{dataType, Collections.singleton(bdId), groupType});
    }

    public List<String> getFields(String entityNum) {
        ArrayList<String> fields = new ArrayList<String>();
        if (!this.sourceEntity.equals(entityNum) && !this.targetEntity.equals(entityNum)) {
            return fields;
        }
        if (entityNum.equals(this.sourceEntity)) {
            return this.sourceFields;
        }
        return this.targetFields;
    }

    public Map<String, String> getFieldMap(String keyEntity, String valueEntity) {
        if (this.targetEntity.equals(keyEntity)) {
            return this.target2SourceMap;
        }
        return this.source2TargetMap;
    }
}

