/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.business.pojo;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.scmc.invp.business.pojo.InvpDate;
import kd.scmc.invp.common.enums.PlanCalendarDayType;
import kd.scmc.invp.common.errorcode.InvPlanErrors;
import kd.scmc.invp.common.helper.InvPlanHelper;

public class PlanCalendar {
    private InvpDate maxDate = null;
    private InvpDate minDate = null;
    private Long orgId = null;
    private List<InvpDate> dates;
    private HashMap<Date, Integer> periods;
    private boolean isSatRest;
    private boolean isSunRest;
    private boolean isMonRest;
    private boolean isTueRest;
    private boolean isWenRest;
    private boolean isThuRest;
    private boolean isFriRest;
    private Date requireStartDate;
    private Date supplyStartDate;
    private Date endDate;
    private static final Log logger = LogFactory.getLog(PlanCalendar.class);

    public PlanCalendar(Long orgId) {
        this.orgId = orgId;
        this.initData();
    }

    public Date getRequireStartDate() {
        return this.requireStartDate;
    }

    public void setRequireStartDate(Date planDate, int delayPeriod) {
        this.requireStartDate = this.getStartDate(planDate, delayPeriod);
    }

    public Date getSupplyStartDate() {
        return this.supplyStartDate;
    }

    public void setSupplyStartDate(Date planDate, int delayPeriod) {
        this.supplyStartDate = this.getStartDate(planDate, delayPeriod);
    }

    private Date getStartDate(Date planDate, int delayPeriod) {
        if (delayPeriod < 0) {
            return this.minDate.getDate().getTime();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(planDate);
        calendar.add(5, -delayPeriod);
        return calendar.getTime().before(this.minDate.getDate().getTime()) ? this.minDate.getDate().getTime() : calendar.getTime();
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date planDate, int planOutLook) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(planDate);
        calendar.add(5, planOutLook);
        this.endDate = calendar.getTime().after(this.maxDate.getDate().getTime()) ? this.maxDate.getDate().getTime() : calendar.getTime();
    }

    private void initData() {
        this.dates = new ArrayList<InvpDate>(16);
        this.periods = new HashMap(16);
        Set calendarIds = (Set)DispatchServiceHelper.invokeBizService((String)"bd", (String)"mpdm", (String)"ICalendarService", (String)"getCalendarIdSet", (Object[])new Object[]{this.orgId, "A", "B"});
        if (calendarIds == null || calendarIds.isEmpty()) {
            String planOrgInfo = InvPlanHelper.getPlanOrgInfo(this.orgId);
            throw new KDBizException(InvPlanHelper.loadKDString("\u8ba1\u5212\u7ec4\u7ec7\uff1a{0}\uff0c\u672a\u8bbe\u7f6e\u53ef\u7528\u7684\u8ba1\u5212\u65e5\u5386\u3002", "InvPlanInitCalendar_0", planOrgInfo));
        }
        Long calendarId = (Long)new ArrayList(calendarIds).get(0);
        JSONObject calendarJson = (JSONObject)DispatchServiceHelper.invokeBizService((String)"bd", (String)"mpdm", (String)"ICalendarService", (String)"getCalendarData", (Object[])new Object[]{this.orgId, "A", "B", calendarId, null, null});
        Boolean isSuccess = calendarJson.getBoolean("issuccessful");
        if (!Boolean.TRUE.equals(isSuccess)) {
            throw new KDBizException(InvPlanErrors.getNoWorkCalendar(), new Object[]{calendarJson.getString("msg")});
        }
        DynamicObject defCal = BusinessDataServiceHelper.loadSingle((Object)calendarId, (String)"mpdm_calendar", (String)"issatrest,issunrest,ismonrest,istuerest,iswedrest,isthurest,isfrirest");
        this.isSatRest = defCal.getBoolean("issatrest");
        this.isSunRest = defCal.getBoolean("issunrest");
        this.isMonRest = defCal.getBoolean("ismonrest");
        this.isTueRest = defCal.getBoolean("istuerest");
        this.isWenRest = defCal.getBoolean("iswedrest");
        this.isThuRest = defCal.getBoolean("isthurest");
        this.isFriRest = defCal.getBoolean("isfrirest");
        if (this.isSatRest && this.isSunRest && this.isMonRest && this.isTueRest && this.isWenRest && this.isThuRest && this.isFriRest) {
            throw new KDBizException(InvPlanErrors.getNoWorkDayInCalendar(), new Object[0]);
        }
        JSONArray data = calendarJson.getJSONArray("data");
        if (data == null || data.isEmpty()) {
            throw new KDBizException(InvPlanErrors.getNoWorkCalendar(), new Object[]{"data empty"});
        }
        JSONObject calendarObj = data.getJSONObject(0);
        JSONObject workDateEntry = calendarObj.getJSONObject("workdateentry");
        ArrayList dateList = new ArrayList(workDateEntry.keySet());
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        dateList.sort((o1, o2) -> {
            try {
                return df.parse((String)o1).compareTo(df.parse((String)o2));
            }
            catch (ParseException e) {
                logger.error((Throwable)e);
                throw new KDBizException(e.getMessage());
            }
        });
        InvpDate previousWork = null;
        for (int i = 0; i < dateList.size(); ++i) {
            Calendar cal = Calendar.getInstance();
            String dateStr = (String)dateList.get(i);
            try {
                cal.setTime(df.parse(dateStr));
            }
            catch (ParseException e) {
                logger.error((Throwable)e);
                throw new KDBizException(e.getMessage());
            }
            PlanCalendar.nomalize(cal);
            PlanCalendarDayType dt = PlanCalendarDayType.valueOf(workDateEntry.getInteger(dateStr));
            InvpDate date = new InvpDate(cal, dt, i);
            this.dates.add(date);
            this.periods.put(cal.getTime(), i);
            date.setPreviousWorkDay(previousWork);
            if (!this.isWorkday(dt.getValue())) continue;
            previousWork = date;
            this.setNextWork(this.dates, previousWork, i);
            if (this.minDate == null) {
                this.minDate = date;
            }
            this.maxDate = date;
        }
    }

    private void setNextWork(List<InvpDate> dates, InvpDate nextDate, int len) {
        InvpDate date;
        for (int i = len - 1; i >= 0 && (date = dates.get(i)).getNextWorkDay() == null; --i) {
            date.setNextWorkDay(nextDate);
        }
    }

    public InvpDate getMinDate() {
        return this.minDate;
    }

    public InvpDate getMaxDate() {
        return this.maxDate;
    }

    public boolean isEmpty() {
        return this.dates.isEmpty();
    }

    private Calendar getWorkDate(Calendar cal, InvpDate invpDate, boolean isBack, int n) {
        if (invpDate != null) {
            return invpDate.getDate();
        }
        if (isBack) {
            InvpDate date = this.dates.get(0);
            cal = (Calendar)date.getDate().clone();
        } else {
            InvpDate date = this.dates.get(this.dates.size() - 1);
            cal = (Calendar)date.getDate().clone();
        }
        this.search(isBack, cal, n);
        return cal;
    }

    public Calendar getDate(Date date, boolean isBack, int n) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        PlanCalendar.nomalize(cal);
        date = cal.getTime();
        Date calStart = this.dates.get(0).getDate().getTime();
        Date calEnd = this.dates.get(this.dates.size() - 1).getDate().getTime();
        if (date.compareTo(calStart) < 0 || date.compareTo(calEnd) > 0) {
            this.search(isBack, cal, n);
            return cal;
        }
        InvpDate invpDate = this.dates.get(this.periods.get(date));
        if (invpDate != null) {
            if (isBack) {
                while (n > 0 && invpDate != null) {
                    invpDate = invpDate.getPreviousWorkDay();
                    --n;
                }
            } else {
                while (n > 0 && invpDate != null) {
                    invpDate = invpDate.getNextWorkDay();
                    --n;
                }
            }
        }
        if (invpDate == null) {
            ++n;
        }
        return this.getWorkDate(cal, invpDate, isBack, n);
    }

    private void search(boolean isBack, Calendar cal, int days) {
        if (this.isMonRest && this.isTueRest && this.isWenRest && this.isThuRest && this.isFriRest && this.isSatRest && this.isSunRest) {
            throw new KDBizException(new ErrorCode("NO_WORK_DAYS", InvPlanHelper.loadKDString("\u65e5\u5386\u65e0\u5de5\u4f5c\u65e5\u8bbe\u7f6e\uff0c\u8d85\u51fa\u8ba1\u5212\u65e5\u5386\u65f6\u95f4\u8ba1\u7b97\u5931\u8d25\u3002", "PlanCalendar_1", new Object[0])), new Object[0]);
        }
        block9: while (days > 0) {
            if (isBack) {
                cal.add(5, -1);
            } else {
                cal.add(5, 1);
            }
            int dayInWeek = cal.get(7);
            switch (dayInWeek) {
                case 2: {
                    if (!this.isMonRest) break;
                    continue block9;
                }
                case 3: {
                    if (!this.isTueRest) break;
                    continue block9;
                }
                case 4: {
                    if (!this.isWenRest) break;
                    continue block9;
                }
                case 5: {
                    if (!this.isThuRest) break;
                    continue block9;
                }
                case 6: {
                    if (!this.isFriRest) break;
                    continue block9;
                }
                case 7: {
                    if (!this.isSatRest) break;
                    continue block9;
                }
                case 1: {
                    if (!this.isSunRest) break;
                    continue block9;
                }
            }
            --days;
        }
    }

    private boolean isWorkday(int dateType) {
        return dateType == PlanCalendarDayType.WORKDAY.getValue() || dateType == PlanCalendarDayType.HALFWORKDAY.getValue();
    }

    public static void nomalize(Calendar cal) {
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
    }
}

