/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.business.step;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scmc.invp.business.pojo.InvPlanContext;
import kd.scmc.invp.business.pojo.InvPlanStepResult;
import kd.scmc.invp.business.step.IInvPlanStep;
import kd.scmc.invp.common.consts.InvPlanLogConstants;
import kd.scmc.invp.common.helper.InvPlanHelper;
import kd.scmc.invp.common.helper.InvpLogHelper;

public abstract class AbstractInvPlanStep
implements IInvPlanStep {
    private static final Log logger = LogFactory.getLog(AbstractInvPlanStep.class);
    protected StringBuilder infoMsgBuilder = new StringBuilder();
    protected StringBuilder errorMsgBuilder = new StringBuilder();
    protected InvPlanStepResult stepResult = new InvPlanStepResult();
    protected InvPlanContext ctx;
    protected Integer processDataCount = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InvPlanStepResult execute(InvPlanContext ctx) {
        this.beforeExecute();
        long startTime = System.currentTimeMillis();
        this.ctx = ctx;
        try {
            if (this.isUserStop().booleanValue()) {
                this.stepResult.setStepResult(InvPlanLogConstants.STEP_RESULT_USER_STOP);
            } else {
                this.innerExecute();
            }
            this.stepResult.setDetailMsg(this.infoMsgBuilder.toString() + this.errorMsgBuilder.toString());
        }
        catch (KDBizException e) {
            logger.error((Throwable)e);
            this.stepResult.setStepResult(InvPlanLogConstants.STEP_RESULT_ERROR);
            this.stepResult.setDetailMsg(e.getMessage());
        }
        catch (Throwable e) {
            logger.error(e);
            this.stepResult.setStepResult(InvPlanLogConstants.STEP_RESULT_ERROR);
            this.stepResult.setDetailMsg(InvPlanHelper.loadKDString("\u51fa\u73b0\u672a\u77e5\u5f02\u5e38\uff0c\u8bf7\u4e0e\u7ba1\u7406\u5458\u8054\u7cfb\u3002", "InvpCommonMsg", new Object[0]));
        }
        finally {
            this.processStepResult(startTime);
        }
        if (InvPlanLogConstants.STEP_RESULT_ERROR.equals(this.stepResult.getStepResult())) {
            InvpLogHelper.setPlanLogStatus(ctx.getCalcNum(), InvPlanLogConstants.STATUS_FAIL);
        }
        this.afterExecute();
        return this.stepResult;
    }

    private void processStepResult(long startTime) {
        if (this.processDataCount >= 0) {
            this.stepResult.setProcessData(this.processDataCount + "");
        }
        long endTime = System.currentTimeMillis();
        String stepTimeSpan = new BigDecimal(String.valueOf(endTime - startTime)).divide(new BigDecimal("60000"), 4, RoundingMode.UP).toPlainString();
        this.stepResult.setStepTimeSpan(stepTimeSpan);
    }

    private Boolean isUserStop() {
        String calNum = this.ctx.getCalcNum();
        DistributeSessionlessCache sessionLessCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("invPlanCalc");
        return InvPlanLogConstants.STATUS_USER_STOP.equals(sessionLessCache.get(calNum));
    }

    public abstract void innerExecute();

    public void beforeExecute() {
    }

    public void afterExecute() {
    }
}

