/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.business.step;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;
import kd.scmc.invp.business.pojo.InvPlanContext;
import kd.scmc.invp.business.pojo.InvPlanStepResult;
import kd.scmc.invp.business.step.IInvPlanStep;
import kd.scmc.invp.business.step.impl.InvPlanBatchPrepare;
import kd.scmc.invp.common.consts.InvPlanLogConstants;
import kd.scmc.invp.common.helper.InvPlanHelper;
import kd.scmc.invp.common.helper.InvpLogHelper;

public class InvPlanStepExecutor {
    private Long schemeId;
    private Long planOrgId;
    private Date planDate;
    private int outTime = 3600;
    private boolean debugMode = false;
    private Log logger = LogFactory.getLog(this.getClass());

    public InvPlanStepExecutor() {
    }

    public InvPlanStepExecutor(Long schemeId, Long planOrgId, Date planDate, int outTime, boolean debugMode) {
        this.schemeId = schemeId;
        this.planOrgId = planOrgId;
        this.planDate = planDate;
        this.outTime = outTime;
        this.debugMode = debugMode;
    }

    public Long execute() {
        String calculateNum = this.genCalculateNum();
        Long invPlanLogId = this.createInvPlanLog(calculateNum);
        this.asyncExecute(invPlanLogId, calculateNum);
        return invPlanLogId;
    }

    public void executeOneBatch(InvPlanContext ctx, List<Long> logIds, int rate) {
        Long logId;
        DynamicObject stepInfo;
        QFilter filter = new QFilter("entryentity.id", "in", logIds);
        DynamicObjectCollection calSteps = QueryServiceHelper.query((String)InvPlanLogConstants.INVP_INVPLAN_LOG, (String)"entryentity.id id,entryentity.calstep.algoimpletcalss calstep.algoimpletcalss", (QFilter[])filter.toArray());
        Map<Long, DynamicObject> calStepMap = calSteps.stream().collect(Collectors.toMap(calStep -> calStep.getLong("id"), calStep -> calStep));
        Long prepareId = logIds.get(0);
        InvPlanStepResult stepResult = this.executeBatchPrepareStep(prepareId, ctx);
        if (this.isStepFail(stepResult)) {
            return;
        }
        logIds.remove(prepareId);
        int stepRate = rate / logIds.size();
        rate -= stepRate * logIds.size();
        Iterator<Long> iterator = logIds.iterator();
        while (iterator.hasNext() && !this.isStepFail(stepResult = this.executeStep(stepInfo = calStepMap.get(logId = iterator.next()), ctx))) {
            InvpLogHelper.updateLogRate(ctx.getCalcNum(), stepRate, ctx.getLogId());
        }
        InvpLogHelper.updateLogRate(ctx.getCalcNum(), rate, ctx.getLogId());
    }

    private InvPlanStepResult executeBatchPrepareStep(Long prepareId, InvPlanContext ctx) {
        InvPlanBatchPrepare prepareStep = new InvPlanBatchPrepare();
        InvPlanStepResult stepResult = new InvPlanStepResult();
        try {
            stepResult = prepareStep.execute(ctx);
        }
        catch (Throwable e) {
            stepResult.setStepResult(InvPlanLogConstants.STEP_RESULT_ERROR);
            stepResult.setDetailMsg(InvPlanHelper.getExceptionMessage(e));
            InvpLogHelper.setPlanLogStatus(ctx.getCalcNum(), InvPlanLogConstants.STATUS_FAIL);
        }
        InvpLogHelper.updateInvPlanEntryLog(prepareId, stepResult);
        return stepResult;
    }

    private void asyncExecute(Long invPlanLogId, String calNum) {
        ThreadPools.executeOnce((String)("InvPlanStepExecutor" + calNum), () -> {
            this.logger.info("\u5e93\u5b58\u8ba1\u5212\u5f02\u6b65\u6267\u884c\u5f00\u59cb....");
            InvPlanContext ctx = this.buildContext();
            DynamicObject invPlanLog = this.getPlanLongInfo(invPlanLogId);
            DynamicObject algoScheme = this.getAlgoSchemeInfo();
            ctx.setLogId(invPlanLogId);
            ctx.setCalcNum(calNum);
            this.logger.error("\u672c\u6b21\u8ba1\u5212\u8fd0\u7b97\u7f16\u7801\u4e3a\uff1a" + calNum);
            boolean batchCal = algoScheme.getBoolean("batchcal");
            ctx.setBatchCal(batchCal);
            ctx.setDebugMode(this.debugMode);
            DLock lock = this.getDLock();
            ctx.setLock(lock);
            InvpLogHelper.setPlanLogStatus(calNum, InvPlanLogConstants.STATUS_RUNNING);
            InvpLogHelper.initLogRate(calNum);
            try {
                if (batchCal) {
                    this.doInvPlanByBatch(invPlanLog, algoScheme, ctx);
                } else {
                    this.doInvPlanCal(invPlanLog, ctx);
                }
            }
            finally {
                lock.unlock();
                InvpLogHelper.processLogInfo(invPlanLog, calNum);
                InvpLogHelper.clear(calNum);
                ctx.getMatchResultHelper().deleteEmptyMatchResult(ctx.getMatchDetailId());
            }
        });
    }

    private void doInvPlanByBatch(DynamicObject invPlanLog, DynamicObject algoScheme, InvPlanContext ctx) {
        block8: {
            DynamicObject logEntry;
            InvPlanStepResult stepResult;
            DynamicObjectCollection logEntries = invPlanLog.getDynamicObjectCollection(InvPlanLogConstants.ENTRY_ENTITY);
            String calcNum = ctx.getCalcNum();
            int rate = 20 / logEntries.size();
            for (int i = 0; i < logEntries.size() && !this.isStepFail(stepResult = this.executeStep(logEntry = (DynamicObject)logEntries.get(i), ctx)); ++i) {
                InvpLogHelper.updateLogRate(calcNum, rate, ctx.getLogId());
            }
            String calStatus = InvpLogHelper.getPlanLogStatus(calcNum);
            if (InvPlanLogConstants.STATUS_RUNNING.equals(calStatus)) {
                Map<Integer, List<Long>> log2BatchMap = this.buildBatchLog(invPlanLog, algoScheme, ctx);
                Map<Integer, Map<String, Map<String, Object>>> batchRangeMap = this.getSplitRangeMap(algoScheme.getInt("batchsize"), ctx.getCalRange());
                InvpLogHelper.initRunningBatchNum(calcNum, log2BatchMap.size());
                rate = 78 / log2BatchMap.size();
                for (Map.Entry<Integer, List<Long>> batchEntry : log2BatchMap.entrySet()) {
                    Integer batch = batchEntry.getKey();
                    List<Long> logIds = batchEntry.getValue();
                    Map<String, Object> params = this.buildBatchParam(ctx);
                    params.put("logentries", logIds);
                    params.put("calRange", batchRangeMap.get(batch));
                    params.put("rate", rate);
                    String batchKey = calcNum + "-batch" + batch;
                    this.cacheBatchParam(params, batchKey);
                    HashMap<String, Object> msgParam = new HashMap<String, Object>();
                    msgParam.put("batchKey", batchKey);
                    msgParam.put("calNum", calcNum);
                    msgParam.put("consumerSign", "InvpCalConsumer");
                    this.sendInvpCalMsg(msgParam);
                }
            } else {
                InvpLogHelper.processLogInfo(invPlanLog, calcNum);
                return;
            }
            ctx.getCalRange().clear();
            long startTime = System.currentTimeMillis();
            try {
                long endTime;
                do {
                    Thread.sleep(2000L);
                    int runningBatchNum = InvpLogHelper.getRunningBatchNum(calcNum);
                    String planLogStatus = InvpLogHelper.getPlanLogStatus(calcNum);
                    if (!InvPlanLogConstants.STATUS_RUNNING.equals(planLogStatus)) {
                        return;
                    }
                    if (runningBatchNum > 0) continue;
                    InvpLogHelper.setPlanLogStatus(calcNum, InvPlanLogConstants.STATUS_SUCCESS);
                    break block8;
                } while ((endTime = System.currentTimeMillis()) - startTime <= (long)this.outTime * 1000L);
                InvpLogHelper.setPlanLogStatus(calcNum, InvPlanLogConstants.STATUS_FAIL);
            }
            catch (InterruptedException e) {
                this.logger.error((Throwable)e);
            }
        }
    }

    private void cacheBatchParam(Map<String, Object> params, String batchKey) {
        DistributeSessionlessCache sessionLessCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("invPlanCalc");
        sessionLessCache.put(batchKey, (Object)SerializationUtils.toJsonString(params));
    }

    private void sendInvpCalMsg(Map<String, Object> params) {
        try (MessagePublisher pub = MQFactory.get().createSimplePublisher("scmc", "kd.scmc.invp.invpcal_queue");){
            pub.publish(SerializationUtils.toJsonString(params));
        }
    }

    private Map<String, Object> buildBatchParam(InvPlanContext ctx) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("schemeId", this.schemeId);
        params.put("planOrgId", this.planOrgId);
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        params.put("planDate", fmt.format(this.planDate));
        params.put("calNum", ctx.getCalcNum());
        params.put("matchDetailId", ctx.getMatchDetailId());
        params.put("logId", ctx.getLogId());
        params.put("debugMode", ctx.isDebugMode());
        return params;
    }

    private Map<Integer, Map<String, Map<String, Object>>> getSplitRangeMap(int batchSize, Map<String, Map<String, Object>> calRange) {
        HashMap<Integer, Map<String, Map<String, Object>>> batchRangeMap = new HashMap<Integer, Map<String, Map<String, Object>>>();
        int count = 0;
        int batch = 1;
        for (Map.Entry<String, Map<String, Object>> calEntry : calRange.entrySet()) {
            batchRangeMap.putIfAbsent(batch, new HashMap());
            ((Map)batchRangeMap.get(batch)).put(calEntry.getKey(), calEntry.getValue());
            if (++count != batchSize) continue;
            count = 0;
            ++batch;
        }
        return batchRangeMap;
    }

    private Map<Integer, List<Long>> buildBatchLog(DynamicObject invPlanLog, DynamicObject algoScheme, InvPlanContext ctx) {
        ArrayList<DynamicObject> calSteps = new ArrayList<DynamicObject>();
        DynamicObjectCollection algoEntries = algoScheme.getDynamicObjectCollection("entryentity");
        for (DynamicObject algoEntry : algoEntries) {
            DynamicObject algorithm = algoEntry.getDynamicObject("algorithm");
            String algoType = algorithm.getString("algotype");
            if ("1".equals(algoType)) continue;
            calSteps.add(algorithm);
        }
        int batch = this.getBatch(algoScheme.getInt("batchsize"), ctx.getCalRange().size());
        DynamicObjectCollection logEntries = invPlanLog.getDynamicObjectCollection(InvPlanLogConstants.ENTRY_ENTITY);
        LinkedHashMap<Integer, List<Long>> log2BatchMap = new LinkedHashMap<Integer, List<Long>>();
        for (int i = 1; i <= batch; ++i) {
            String batchName = InvPlanHelper.loadKDString("\u7b2c{0}\u6279\u8fd0\u7b97\u51c6\u5907", "InvPlanStepExecutor_4", i);
            long logEntryId = this.addLogEntry(logEntries, batchName, 0L);
            log2BatchMap.putIfAbsent(i, new ArrayList());
            ((List)log2BatchMap.get(i)).add(logEntryId);
            batchName = InvPlanHelper.loadKDString("\u7b2c{0}\u6279\u8fd0\u7b97-", "InvPlanStepExecutor_3", i);
            for (DynamicObject stepInfo : calSteps) {
                logEntryId = this.addLogEntry(logEntries, batchName + stepInfo.getString("name"), stepInfo.getLong("id"));
                ((List)log2BatchMap.get(i)).add(logEntryId);
            }
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{invPlanLog});
        return log2BatchMap;
    }

    private long addLogEntry(DynamicObjectCollection logEntries, String stepName, long stepId) {
        DynamicObject logEntry = logEntries.addNew();
        long id = DB.genGlobalLongId();
        logEntry.set("id", (Object)id);
        logEntry.set(InvPlanLogConstants.CAL_STEP, (Object)stepId);
        logEntry.set("stepseq", (Object)logEntries.size());
        logEntry.set("seq", (Object)logEntries.size());
        logEntry.set("stepname", (Object)stepName);
        return id;
    }

    private int getBatch(int batchSize, int totalSize) {
        int batch = totalSize / batchSize;
        if (totalSize % batchSize > 0) {
            ++batch;
        }
        return batch;
    }

    private boolean isStepFail(InvPlanStepResult stepResult) {
        String stepStatus = stepResult.getStepResult();
        return InvPlanLogConstants.STEP_RESULT_ERROR.equals(stepStatus) || InvPlanLogConstants.STEP_RESULT_USER_STOP.equals(stepStatus);
    }

    private void doInvPlanCal(DynamicObject invPlanLog, InvPlanContext ctx) {
        DynamicObject logEntry;
        InvPlanStepResult stepResult;
        String calNum = invPlanLog.getString(InvPlanLogConstants.CAL_NUM);
        DynamicObjectCollection logEntries = invPlanLog.getDynamicObjectCollection(InvPlanLogConstants.ENTRY_ENTITY);
        int rate = 100 / logEntries.size();
        for (int i = 0; i < logEntries.size() && !this.isStepFail(stepResult = this.executeStep(logEntry = (DynamicObject)logEntries.get(i), ctx)); ++i) {
            InvpLogHelper.updateLogRate(calNum, rate, ctx.getLogId());
        }
        String planLogStatus = InvpLogHelper.getPlanLogStatus(calNum);
        if (planLogStatus.equals(InvPlanLogConstants.STATUS_RUNNING)) {
            InvpLogHelper.setPlanLogStatus(calNum, InvPlanLogConstants.STATUS_SUCCESS);
        }
    }

    private DLock getDLock() {
        String tenantId = RequestContext.get().getTenantId();
        StringBuilder lockDescription = new StringBuilder();
        lockDescription.append(InvPlanHelper.loadKDString("\u5e93\u5b58\u8ba1\u5212", "InvPlanStepExecutor_0", new Object[0]));
        lockDescription.append("-").append(this.planOrgId);
        DLock lock = DLock.create((String)(tenantId + "-invplan-" + this.planOrgId), (String)lockDescription.toString());
        return lock;
    }

    private InvPlanContext buildContext() {
        InvPlanContext ctx = new InvPlanContext();
        ctx.setSchemeId(this.schemeId);
        ctx.setPlanOrg(this.planOrgId);
        ctx.setPlanDate(this.planDate);
        return ctx;
    }

    private DynamicObject getPlanLongInfo(Long invPlanLogId) {
        DynamicObject invPlanLog = BusinessDataServiceHelper.loadSingle((Object)invPlanLogId, (String)InvPlanLogConstants.INVP_INVPLAN_LOG);
        return invPlanLog;
    }

    private DynamicObject getAlgoSchemeInfo() {
        QFilter filter = new QFilter("id", "=", (Object)this.schemeId);
        DynamicObject scheme = QueryServiceHelper.queryOne((String)"invp_scheme", (String)"algorithmplan.id", (QFilter[])filter.toArray());
        long algoSchemeId = scheme.getLong("algorithmplan.id");
        String selector = "batchcal,batchsize,entryentity.algorithm,entryentity.algorithm.implclass,entryentity.algorithm.algotype,entryentity.isbatchcal";
        DynamicObject algoScheme = BusinessDataServiceHelper.loadSingleFromCache((Object)algoSchemeId, (String)"invp_algoconfig", (String)selector);
        return algoScheme;
    }

    private InvPlanStepResult executeStep(DynamicObject calStepInfo, InvPlanContext ctx) {
        InvPlanStepResult stepResult = new InvPlanStepResult();
        long logEntryId = calStepInfo.getLong("id");
        try {
            Class implClazz;
            String implClass = calStepInfo.getString("calstep.algoimpletcalss");
            if (StringUtils.isEmpty((String)implClass)) {
                throw new KDBizException(InvPlanHelper.loadKDString("\u7b97\u6cd5\u8282\u70b9\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u7b97\u6cd5\u65b9\u6848\u914d\u7f6e\u3002", "InvPlanStepExecutor_1", new Object[0]));
            }
            try {
                implClazz = TypesContainer.getOrRegister((String)implClass);
            }
            catch (Exception e) {
                throw new KDBizException(InvPlanHelper.loadKDString("\u7b97\u6cd5\u5b9e\u73b0\u7c7b\uff1a{0}\u672a\u627e\u5230\uff0c\u8bf7\u68c0\u67e5\u7b97\u6cd5\u6ce8\u518c\u914d\u7f6e\u3002", "InvPlanStepExecutor_2", implClass));
            }
            if (implClazz != null) {
                IInvPlanStep splitTaskExecutor = (IInvPlanStep)implClazz.newInstance();
                stepResult = splitTaskExecutor.execute(ctx);
            }
        }
        catch (Throwable e) {
            this.logger.error(e);
            stepResult.setStepResult(InvPlanLogConstants.STEP_RESULT_ERROR);
            stepResult.setDetailMsg(InvPlanHelper.loadKDString("\u51fa\u73b0\u672a\u77e5\u5f02\u5e38\uff0c\u8bf7\u4e0e\u7ba1\u7406\u5458\u8054\u7cfb\u3002", "InvpCommonMsg", new Object[0]));
            InvpLogHelper.setPlanLogStatus(ctx.getCalcNum(), InvPlanLogConstants.STATUS_FAIL);
        }
        InvpLogHelper.updateInvPlanEntryLog(logEntryId, stepResult);
        return stepResult;
    }

    public Long createInvPlanLog(String calculateNum) {
        DynamicObject calcLogInfo = BusinessDataServiceHelper.newDynamicObject((String)InvPlanLogConstants.INVP_INVPLAN_LOG);
        calcLogInfo.set(InvPlanLogConstants.PLAN_ORG, (Object)this.planOrgId);
        calcLogInfo.set(InvPlanLogConstants.SCHEME, (Object)this.schemeId);
        String planType = this.getPlanType();
        calcLogInfo.set("plantype", (Object)planType);
        calcLogInfo.set(InvPlanLogConstants.CAL_NUM, (Object)calculateNum);
        calcLogInfo.set(InvPlanLogConstants.STATUS, (Object)InvPlanLogConstants.STEP_RESULT_FINISH);
        calcLogInfo.set(InvPlanLogConstants.START_TIME, (Object)TimeServiceHelper.now());
        RequestContext requestContext = RequestContext.get();
        calcLogInfo.set(InvPlanLogConstants.EXECUTOR, (Object)requestContext.getCurrUserId());
        QFilter filter = new QFilter("id", "=", (Object)this.schemeId);
        DynamicObjectCollection stepCol = QueryServiceHelper.query((String)this.getClass().getName(), (String)"invp_scheme", (String)"algorithmplan.batchcal batchcal,algorithmplan.entryentity.algorithm.id id,algorithmplan.entryentity.algorithm.name name,algorithmplan.entryentity.algorithm.algotype algotype ", (QFilter[])filter.toArray(), (String)"algorithmplan.entryentity.seq");
        DynamicObjectCollection logEntries = calcLogInfo.getDynamicObjectCollection(InvPlanLogConstants.ENTRY_ENTITY);
        for (DynamicObject stepInfo : stepCol) {
            if (stepInfo.getBoolean("batchcal")) {
                if (!"1".equals(stepInfo.getString("algotype"))) continue;
                this.addLogEntry(logEntries, stepInfo.getString("name"), stepInfo.getLong("id"));
                continue;
            }
            this.addLogEntry(logEntries, stepInfo.getString("name"), stepInfo.getLong("id"));
        }
        Object[] logArr = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{calcLogInfo});
        return ((DynamicObject)logArr[0]).getLong("id");
    }

    private String getPlanType() {
        QFilter filter = new QFilter("id", "=", (Object)this.schemeId);
        DynamicObject scheme = QueryServiceHelper.queryOne((String)"invp_scheme", (String)"mainplantype", (QFilter[])filter.toArray());
        String planType = scheme.getString("mainplantype");
        return planType;
    }

    private String genCalculateNum() {
        ORM orm = ORM.create();
        return orm.genLongId(InvPlanLogConstants.INVP_INVPLAN_LOG) + "";
    }
}

