/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.business.step.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.invp.business.pojo.InvPlanScheme;
import kd.scmc.invp.business.pojo.OutPutParam;
import kd.scmc.invp.business.step.AbstractInvPlanStep;
import kd.scmc.invp.common.consts.InvPlanLogConstants;
import kd.scmc.invp.common.helper.InvPlanHelper;

public class InvPlanAutoOutPut
extends AbstractInvPlanStep {
    @Override
    public void innerExecute() {
        this.autoOutPut();
    }

    private void autoOutPut() {
        InvPlanScheme scheme = this.ctx.getScheme();
        if (!scheme.getAutoAudit().booleanValue()) {
            return;
        }
        Set<Object> adviseIdSet = this.ctx.getAuditAdviseIds();
        if (adviseIdSet == null || adviseIdSet.isEmpty()) {
            return;
        }
        List<OutPutParam> outPutParamColl = scheme.getOutPutParams();
        HashMap<String, Integer> saveBillCountMap = new HashMap<String, Integer>();
        HashMap<String, Integer> submitBillCountMap = new HashMap<String, Integer>();
        HashMap<String, Integer> auditBillCountMap = new HashMap<String, Integer>();
        for (OutPutParam outPutParam : outPutParamColl) {
            String billOp;
            List targetBillIds;
            if (!outPutParam.getAutoOutput().booleanValue()) continue;
            String targetEntityNum = outPutParam.getTargetEntityNum();
            String targetBillName = MetadataServiceHelper.getDataEntityType((String)targetEntityNum).getDisplayName().getLocaleValue();
            saveBillCountMap.putIfAbsent(targetBillName, 0);
            List<ListSelectedRow> outPutSelectedRow = this.getOutPutSelectedRow(adviseIdSet, outPutParam);
            if (outPutSelectedRow == null || outPutSelectedRow.isEmpty()) continue;
            List<DynamicObject> targetBillList = this.convertBill(outPutParam, targetEntityNum, targetBillName, outPutSelectedRow);
            saveBillCountMap.put(targetBillName, (Integer)saveBillCountMap.get(targetBillName) + targetBillList.size());
            this.processDataCount = this.processDataCount + targetBillList.size();
            OperationResult saveResult = this.saveBills(targetEntityNum, targetBillName, targetBillList);
            if (saveResult == null || (targetBillIds = saveResult.getSuccessPkIds()) == null || targetBillIds.isEmpty() || !(billOp = outPutParam.getTargetStatus()).equals("B") && !billOp.equals("C")) continue;
            submitBillCountMap.putIfAbsent(targetBillName, 0);
            submitBillCountMap.put(targetBillName, (Integer)submitBillCountMap.get(targetBillName) + targetBillIds.size());
            String message = InvPlanHelper.loadKDString("{0}\u63d0\u4ea4\u5931\u8d25\uff1a", "InvPlanStorePlanAdvise_2", targetBillName);
            Set<Object> submitIdSet = InvPlanHelper.doBillOperation("submit", targetEntityNum, targetBillIds.toArray(), message, this.errorMsgBuilder);
            if (!billOp.equals("C") || submitIdSet == null || submitIdSet.isEmpty()) continue;
            auditBillCountMap.putIfAbsent(targetBillName, 0);
            auditBillCountMap.put(targetBillName, (Integer)auditBillCountMap.get(targetBillName) + submitIdSet.size());
            message = InvPlanHelper.loadKDString("{0}\u5ba1\u6838\u5931\u8d25\uff1a", "InvPlanStorePlanAdvise_3", targetBillName);
            InvPlanHelper.doBillOperation("audit", targetEntityNum, submitIdSet.toArray(), message, this.infoMsgBuilder);
        }
        for (Map.Entry entry : saveBillCountMap.entrySet()) {
            this.infoMsgBuilder.append(InvPlanHelper.loadKDString("\u4fdd\u5b58\u7684{0}\u6570\u91cf\uff1a{1}\u6761\u3002", "InvPlanStorePlanAdvise_0", entry.getKey(), entry.getValue())).append("\n");
        }
        for (Map.Entry entry : submitBillCountMap.entrySet()) {
            this.infoMsgBuilder.append(InvPlanHelper.loadKDString("\u63d0\u4ea4\u7684{0}\u6570\u91cf\uff1a{1}\u6761\u3002", "InvPlanStorePlanAdvise_7", entry.getKey(), entry.getValue())).append("\n");
        }
        for (Map.Entry entry : auditBillCountMap.entrySet()) {
            this.infoMsgBuilder.append(InvPlanHelper.loadKDString("\u5ba1\u6838\u7684{0}\u6570\u91cf\uff1a{1}\u6761\u3002", "InvPlanStorePlanAdvise_8", entry.getKey(), entry.getValue())).append("\n");
        }
        if (!StringUtils.isEmpty((String)this.errorMsgBuilder.toString())) {
            this.stepResult.setStepResult(InvPlanLogConstants.STEP_RESULT_PART_ERROR);
        }
    }

    private List<DynamicObject> convertBill(OutPutParam outPutParam, String targetEntityNum, String targetBillName, List<ListSelectedRow> outPutSelectedRow) {
        ConvertOperationResult result = this.convertBill("invp_plan_advice", targetEntityNum, outPutSelectedRow, outPutParam.getBotpRuleId(), false);
        if (!result.isSuccess()) {
            this.errorMsgBuilder.append(InvPlanHelper.loadKDString("{0}\u8f6c\u6362\u5931\u8d25\uff1a", "InvPlanStorePlanAdvise_6", targetBillName)).append("\n");
            this.errorMsgBuilder.append(this.getConvertErrorMsg(result));
        }
        MainEntityType planAdviseEntity = EntityMetadataCache.getDataEntityType((String)targetEntityNum);
        List targetBillList = result.loadTargetDataObjects((objects, dataEntityType) -> BusinessDataServiceHelper.loadRefence((Object[])objects, (IDataEntityType)dataEntityType), planAdviseEntity);
        return targetBillList;
    }

    private OperationResult saveBills(String targetEntityNum, String targetBillName, List<DynamicObject> targetBillList) {
        OperationResult saveResult = null;
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                saveResult = SaveServiceHelper.saveOperate((String)targetEntityNum, (DynamicObject[])targetBillList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
                if (!saveResult.isSuccess()) {
                    this.errorMsgBuilder.append(InvPlanHelper.loadKDString("{0}\u4fdd\u5b58\u5931\u8d25\uff1a", "InvPlanStorePlanAdvise_1", targetBillName)).append("\n");
                    this.errorMsgBuilder.append(InvPlanHelper.getBillOperateErrorMsg(saveResult));
                }
            }
            catch (Throwable e) {
                this.errorMsgBuilder.append(InvPlanHelper.loadKDString("{0}\u4fdd\u5b58\u5931\u8d25\uff1a", "InvPlanStorePlanAdvise_1", targetBillName)).append("\n");
                this.errorMsgBuilder.append(InvPlanHelper.getExceptionMessage(e));
                txHandle.markRollback();
            }
        }
        return saveResult;
    }

    private List<ListSelectedRow> getOutPutSelectedRow(Set<Object> adviseIdSet, OutPutParam outPutParam) {
        QFilter outPutFilter = new QFilter("id", "in", adviseIdSet);
        String filterJson = outPutParam.getFilterJson();
        if (!StringUtils.isEmpty((String)filterJson)) {
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterJson, FilterCondition.class);
            MainEntityType adviseEntityType = MetadataServiceHelper.getDataEntityType((String)"invp_plan_advice");
            FilterBuilder builder = new FilterBuilder(adviseEntityType, filterCondition);
            builder.buildFilter();
            outPutFilter.and(builder.getQFilter());
        }
        DataSet bills = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"invp_plan_advice", (String)"id,billno,entryentity.id", (QFilter[])outPutFilter.toArray(), (String)"");
        ArrayList<ListSelectedRow> rowList = new ArrayList<ListSelectedRow>(16);
        for (Row bill : bills) {
            ListSelectedRow selectedRow = new ListSelectedRow();
            selectedRow.setBillNo(bill.getString("billno"));
            selectedRow.setPrimaryKeyValue((Object)bill.getLong("id"));
            selectedRow.setEntryEntityKey("entryentity");
            selectedRow.setEntryPrimaryKeyValue((Object)bill.getLong("entryentity.id"));
            rowList.add(selectedRow);
        }
        return rowList;
    }

    private ConvertOperationResult convertBill(String sourceEntity, String targetEntity, List<ListSelectedRow> selectedRows, String botpRuleId, boolean isSave) {
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber(sourceEntity);
        pushArgs.setTargetEntityNumber(targetEntity);
        pushArgs.setSelectedRows(selectedRows);
        pushArgs.setShowReport(true);
        pushArgs.setHasRight(false);
        pushArgs.setBuildConvReport(true);
        if (botpRuleId != null) {
            pushArgs.setRuleId(botpRuleId);
        }
        ConvertOperationResult covertResult = isSave ? ConvertServiceHelper.pushAndSave((PushArgs)pushArgs) : ConvertServiceHelper.push((PushArgs)pushArgs);
        return covertResult;
    }

    private String getConvertErrorMsg(ConvertOperationResult result) {
        StringBuilder errorMsgBuilder = new StringBuilder();
        if (!StringUtils.isEmpty((String)result.getMessage())) {
            errorMsgBuilder.append(result.getMessage()).append("\n");
        }
        if (result.getBillReports() != null && !result.getBillReports().isEmpty()) {
            errorMsgBuilder.append(result.getBillReports().toString()).append("\n");
        }
        return errorMsgBuilder.toString();
    }
}

