/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.business.step.impl;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.invp.business.pojo.AdjustInfo;
import kd.scmc.invp.business.pojo.FieldMapConf;
import kd.scmc.invp.business.pojo.InvPlanScheme;
import kd.scmc.invp.business.pojo.MatchGroup;
import kd.scmc.invp.business.pojo.PlanCalendar;
import kd.scmc.invp.business.step.AbstractInvPlanStep;
import kd.scmc.invp.business.step.strategy.IInvPlanStrategy;
import kd.scmc.invp.business.step.strategy.InvPlanMinMaxStrategy;
import kd.scmc.invp.business.step.strategy.InvPlanPeriodicStrategy;
import kd.scmc.invp.business.step.strategy.InvPlanReorderPointStrategy;
import kd.scmc.invp.common.helper.InvPlanHelper;
import kd.scmc.invp.common.helper.MatchResultHelper;

public class InvPlanCalcPurDemand
extends AbstractInvPlanStep {
    private Set<Long> wholeAdjustIds = new HashSet<Long>();

    @Override
    public void innerExecute() {
        this.matchDemandAndSupply();
    }

    private void buildAdviseInfo(List<String> mergeBillFields, Map<String, DynamicObject> planAdviseMap, Map<String, Object> planAdvise) {
        String mergeKey = this.getMergeKey(planAdvise, mergeBillFields);
        if (!StringUtils.isEmpty((String)mergeKey)) {
            if (!planAdviseMap.containsKey(mergeKey)) {
                planAdviseMap.put(mergeKey, this.createNewAdvise(planAdvise));
            }
        } else {
            DynamicObject newAdvise = this.createNewAdvise(planAdvise);
            mergeKey = newAdvise.getString("id");
            planAdviseMap.put(mergeKey, newAdvise);
        }
        DynamicObject adviseInfo = planAdviseMap.get(mergeKey);
        planAdvise.put("billno", adviseInfo.getString("id"));
        this.createNewAdviseEntry(adviseInfo, planAdvise);
    }

    private void createNewAdviseEntry(DynamicObject adviseInfo, Map<String, Object> planAdvise) {
        DynamicObject entry = adviseInfo.getDynamicObjectCollection("entryentity").addNew();
        int seq = adviseInfo.getDynamicObjectCollection("entryentity").size();
        entry.set("seq", (Object)seq);
        planAdvise.put("entryentity.seq", seq);
        for (Map.Entry<String, Object> adviseEntry : planAdvise.entrySet()) {
            if (!adviseEntry.getKey().contains("entryentity")) continue;
            entry.set(adviseEntry.getKey().replace("entryentity.", ""), adviseEntry.getValue());
        }
    }

    private DynamicObject createNewAdvise(Map<String, Object> planAdvise) {
        DynamicObject adviseInfo = BusinessDataServiceHelper.newDynamicObject((String)"invp_plan_advice");
        Long id = DB.genGlobalLongId();
        adviseInfo.set("id", (Object)id);
        for (Map.Entry<String, Object> adviseMap : planAdvise.entrySet()) {
            if (adviseMap.getKey().contains("entryentity")) continue;
            adviseInfo.set(adviseMap.getKey(), adviseMap.getValue());
        }
        return adviseInfo;
    }

    private Map<String, Object> demand2Advise(Map<String, Object> lastDemandData, FieldMapConf resultMapConf, DynamicObject invLevelEntry, BigDecimal orderQty) {
        Map<String, Object> planAdvise = resultMapConf.getTargetValue(lastDemandData);
        planAdvise.put("entryentity.unpushqty", planAdvise.getOrDefault("entryentity.qty", BigDecimal.ZERO));
        planAdvise.put("plancalnum", this.ctx.getCalcNum());
        planAdvise.put("planscheme", this.ctx.getSchemeId());
        planAdvise.put("org", this.ctx.getPlanOrg());
        planAdvise.put("creator", RequestContext.get().getCurrUserId());
        planAdvise.put("entryentity.planuser", invLevelEntry.get("planner"));
        planAdvise.put("entryentity.plangroup", invLevelEntry.get("plangroup"));
        planAdvise.put("entryentity.qty", orderQty);
        planAdvise.put("entryentity.confirmqty", orderQty);
        planAdvise.put("entryentity.unpushqty", orderQty);
        return planAdvise;
    }

    private void matchDemAndAdviseSup(Object[] demandBill, Object[] advise2Supply, String dateMsg) {
        Integer demandQtyIndex = this.ctx.getDemandFieldIndexMap().get("qty");
        Integer supplyQtyIndex = this.ctx.getSupplyFieldIndexMap().get("baseqty");
        BigDecimal demandQty = (BigDecimal)demandBill[demandQtyIndex];
        if (this.ctx.isDebugMode()) {
            this.infoMsgBuilder.append("advise match demandQty:").append(demandQty).append("\n");
        }
        if (demandQty.compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal matchQty;
            BigDecimal supplyBaseQty;
            BigDecimal bigDecimal = supplyBaseQty = advise2Supply[supplyQtyIndex] == null ? BigDecimal.ZERO : (BigDecimal)advise2Supply[supplyQtyIndex];
            if (this.ctx.isDebugMode()) {
                this.infoMsgBuilder.append("advise match supplyBaseQty:").append(supplyBaseQty).append("\n");
            }
            BigDecimal bigDecimal2 = matchQty = demandQty.compareTo(supplyBaseQty) < 0 ? demandQty : supplyBaseQty;
            if (this.ctx.isDebugMode()) {
                this.infoMsgBuilder.append("advise match matchQty:").append(matchQty).append("\n");
            }
            this.addMatchResultEntry(demandBill, advise2Supply, new AdjustInfo("A", BigDecimal.ZERO, null), matchQty, dateMsg);
            advise2Supply[supplyQtyIndex.intValue()] = supplyBaseQty.subtract(matchQty);
            demandBill[demandQtyIndex.intValue()] = demandQty.subtract(matchQty);
        }
    }

    private Map<Long, MatchGroup> matchDemandAndSupply() {
        InvPlanScheme scheme = this.ctx.getScheme();
        Integer allowDelayTime = scheme.getAllowDelayTime();
        Integer allowLeadTime = scheme.getAllowLeadTime();
        Map<String, String> adjustPolicyMap = scheme.getAdjustPolicyMap();
        Map<String, Integer> supplyFieldIndex = this.ctx.getSupplyFieldIndexMap();
        Map<String, Integer> demandFieldIndex = this.ctx.getDemandFieldIndexMap();
        HashMap<Long, MatchGroup> matchGroupMap = new HashMap<Long, MatchGroup>();
        int demandQtyIndex = demandFieldIndex.get("qty");
        int demandNumIndex = demandFieldIndex.get("billno");
        int supplyQtyIndex = supplyFieldIndex.get("baseqty");
        int supplyNumIndex = supplyFieldIndex.get("billno");
        int demandDateIndex = demandFieldIndex.get("demanddate");
        int levelMatchKeyIndex = demandFieldIndex.get("invlevelmatchkey");
        int supplyDateIndex = supplyFieldIndex.get("supplydate");
        int supplyBillTypeIndex = supplyFieldIndex.get("srcbill");
        int supplyEntryIdIndex = supplyFieldIndex.get("billentryid");
        IInvPlanStrategy invPlanStrategy = this.getStrategy();
        Boolean leadTimeLackAsc = scheme.getLeadTimeLackAsc();
        PlanCalendar planCalendar = this.ctx.getPlanCalendar();
        LinkedHashMap<String, DynamicObject> planAdviseMap = new LinkedHashMap<String, DynamicObject>();
        List<String> mergeBillFields = scheme.getMergeBillFields();
        HashSet<Object> newAdviceNums = new HashSet<Object>();
        Map<String, List<Object[]>> demandBillMap = this.ctx.getDemandBillMap();
        for (Map.Entry<String, List<Object[]>> billMapEntry : demandBillMap.entrySet()) {
            List<Object[]> demandBills;
            String matchKey = billMapEntry.getKey();
            if (this.ctx.isDebugMode()) {
                this.infoMsgBuilder.append("matchKey:").append(matchKey).append("\n");
            }
            if ((demandBills = billMapEntry.getValue()).isEmpty()) {
                if (!this.ctx.isDebugMode()) continue;
                this.infoMsgBuilder.append("no demand bill").append("\n");
                continue;
            }
            Map<String, List<Object[]>> supplyBillMap = this.ctx.getSupplyBillMap();
            if (!supplyBillMap.containsKey(matchKey)) {
                supplyBillMap.put(matchKey, new ArrayList());
            }
            List<Object[]> invpSupplyBill = supplyBillMap.get(matchKey);
            Object[] demandBill22 = demandBills.get(0);
            String invLevelMatchKey = (String)demandBill22[levelMatchKeyIndex];
            if (this.ctx.getCalRange().get(invLevelMatchKey) == null) continue;
            Long invLevelId = (Long)this.ctx.getCalRange().get(invLevelMatchKey).get("id");
            DynamicObject invLevelInfo = this.ctx.getInvLevelMap().get(invLevelId);
            for (Object[] demandBill22 : demandBills) {
                if (this.ctx.isDebugMode()) {
                    this.infoMsgBuilder.append("demandBillNum:").append(demandBill22[demandNumIndex]).append("\n");
                }
                Date demandDate = (Date)demandBill22[demandDateIndex];
                demandDate = InvPlanHelper.getPureDate(demandDate);
                demandBill22[demandDateIndex] = demandDate;
                if (this.ctx.isDebugMode()) {
                    this.infoMsgBuilder.append("demandDate:").append(demandDate).append("\n");
                }
                BigDecimal usableBaseQty = BigDecimal.ZERO;
                BigDecimal demandBaseQty = (BigDecimal)demandBill22[demandQtyIndex];
                if (this.ctx.isDebugMode()) {
                    this.infoMsgBuilder.append("demandQty:").append(demandBaseQty).append("\n");
                }
                usableBaseQty = usableBaseQty.subtract(demandBaseQty);
                Date supplyBeginDate = this.getPastOrFeatureDate(demandDate, -1 * allowDelayTime);
                Date supplyEndDate = this.getPastOrFeatureDate(demandDate, allowLeadTime);
                if (this.ctx.isDebugMode()) {
                    this.infoMsgBuilder.append("supplyBeginDate:").append(supplyBeginDate).append("\t");
                    this.infoMsgBuilder.append("supplyEndDate:").append(supplyEndDate).append("\n");
                }
                Iterator<Object[]> iterator = invpSupplyBill.iterator();
                while (iterator.hasNext()) {
                    BigDecimal bigDecimal;
                    Object[] supplyBill = iterator.next();
                    String entityNum = (String)supplyBill[supplyBillTypeIndex];
                    if (this.ctx.isDebugMode()) {
                        this.infoMsgBuilder.append("supplyEntityNum:").append(entityNum).append("\n");
                    }
                    BigDecimal supplyBaseQty = (BigDecimal)supplyBill[supplyQtyIndex];
                    if (this.ctx.isDebugMode()) {
                        this.infoMsgBuilder.append("supplyBaseQty:").append(supplyBaseQty).append("\n");
                    }
                    if (supplyBaseQty.compareTo(BigDecimal.ZERO) == 0) {
                        iterator.remove();
                        continue;
                    }
                    Date supplyDate = (Date)supplyBill[supplyDateIndex];
                    supplyDate = InvPlanHelper.getPureDate(supplyDate);
                    supplyBill[supplyDateIndex] = supplyDate;
                    if (this.ctx.isDebugMode()) {
                        this.infoMsgBuilder.append("supplyDate:").append(supplyDate).append("\n");
                    }
                    if (supplyDate.compareTo(supplyBeginDate) < 0 || supplyDate.compareTo(supplyEndDate) > 0) continue;
                    usableBaseQty = usableBaseQty.add(supplyBaseQty);
                    BigDecimal bigDecimal2 = bigDecimal = demandBaseQty.compareTo(supplyBaseQty) > 0 ? supplyBaseQty : demandBaseQty;
                    if (this.ctx.isDebugMode()) {
                        this.infoMsgBuilder.append("matchBaseQty:").append(bigDecimal).append("\n");
                    }
                    String adjustPolicy = adjustPolicyMap.get(entityNum);
                    if (this.ctx.isDebugMode()) {
                        this.infoMsgBuilder.append("adjustPolicy:").append(adjustPolicy).append("\n");
                    }
                    Long entryId = (Long)supplyBill[supplyEntryIdIndex];
                    if (bigDecimal.compareTo(BigDecimal.ZERO) != 0) {
                        AdjustInfo adjustInfo = this.buildAdjustInfo(demandDate, entryId, supplyBaseQty, supplyDate, bigDecimal, adjustPolicy);
                        this.addMatchResultEntry(demandBill22, supplyBill, adjustInfo, bigDecimal, "");
                        if ("A".equals(adjustPolicy) && adjustInfo.getAdjustDate() != null) {
                            supplyBill[supplyDateIndex] = adjustInfo.getAdjustDate();
                        }
                        demandBaseQty = demandBaseQty.subtract(bigDecimal);
                        supplyBaseQty = supplyBaseQty.subtract(bigDecimal);
                        demandBill22[demandQtyIndex] = demandBaseQty;
                        supplyBill[supplyQtyIndex] = supplyBaseQty;
                    }
                    if (((BigDecimal)supplyBill[supplyQtyIndex]).compareTo(BigDecimal.ZERO) != 0) continue;
                    iterator.remove();
                }
                if (this.ctx.isDebugMode()) {
                    this.infoMsgBuilder.append("usableBaseQty:").append(usableBaseQty).append("\n");
                }
                if (!invPlanStrategy.needCreateAdvise(usableBaseQty, invLevelInfo).booleanValue()) continue;
                BigDecimal orderQty = invPlanStrategy.calcOrderQty(usableBaseQty, invLevelInfo);
                if (this.ctx.isDebugMode()) {
                    this.infoMsgBuilder.append("orderQty:").append(orderQty).append("\n");
                }
                if (orderQty.compareTo(BigDecimal.ZERO) <= 0) continue;
                FieldMapConf resultMapConf = scheme.getDemandModel().getResultMapConf();
                Map<String, Object> planAdvise = this.demand2Advise(this.getBillMap(demandBill22, demandFieldIndex), resultMapConf, invLevelInfo, orderQty);
                this.calcAdviseDate(leadTimeLackAsc, planCalendar, demandDate, invLevelInfo, planAdvise);
                if (this.ctx.isDebugMode()) {
                    this.infoMsgBuilder.append("create one advise").append("\n");
                }
                ArrayList<Map<String, Object>> adviseList = new ArrayList<Map<String, Object>>();
                adviseList.add(planAdvise);
                usableBaseQty = usableBaseQty.add(orderQty);
                if ("A".equals(scheme.getMainPlanType())) {
                    int i = 0;
                    while (invPlanStrategy.needCreateAdvise(usableBaseQty, invLevelInfo).booleanValue() && ++i < 100) {
                        HashMap<String, Object> hashMap = new HashMap<String, Object>();
                        hashMap.putAll(planAdvise);
                        adviseList.add(hashMap);
                        usableBaseQty = usableBaseQty.add(orderQty);
                        if (!this.ctx.isDebugMode()) continue;
                        this.infoMsgBuilder.append("reorder type create one advise ").append("\n");
                    }
                }
                for (Map map : adviseList) {
                    this.buildAdviseInfo(mergeBillFields, planAdviseMap, map);
                    newAdviceNums.add(planAdvise.get("billno"));
                    Object[] advise2Supply = this.advise2Supply(map);
                    invpSupplyBill.add(advise2Supply);
                    String dateMsg = this.getAdviseDateExpMsg(map);
                    this.matchDemAndAdviseSup(demandBill22, advise2Supply, dateMsg);
                }
            }
            BigDecimal occupyQty = invPlanStrategy.calcOccupyQty(invLevelInfo);
            if (this.ctx.isDebugMode()) {
                this.infoMsgBuilder.append("level occupy start").append("\n");
                this.infoMsgBuilder.append("occupyQty:").append(occupyQty).append("\n");
            }
            BigDecimal unOccupyQty = occupyQty;
            invpSupplyBill.sort((bill1, bill2) -> {
                String entityNum1 = (String)bill1[supplyBillTypeIndex];
                String entityNum2 = (String)bill2[supplyBillTypeIndex];
                int order1 = 3;
                int order2 = 3;
                if ("im_inv_realbalance".equals(entityNum1)) {
                    order1 = 1;
                } else if (newAdviceNums.contains(bill1[supplyNumIndex])) {
                    order1 = 2;
                }
                if ("im_inv_realbalance".equals(entityNum2)) {
                    order2 = 1;
                } else if (newAdviceNums.contains(bill2[supplyNumIndex])) {
                    order2 = 2;
                }
                return order1 - order2;
            });
            for (Object[] supplyBill : invpSupplyBill) {
                String entityNum = (String)supplyBill[supplyBillTypeIndex];
                BigDecimal supplyBaseQty = (BigDecimal)supplyBill[supplyQtyIndex];
                if (this.ctx.isDebugMode()) {
                    this.infoMsgBuilder.append("supplyEntity:").append(entityNum).append("\t");
                    this.infoMsgBuilder.append("supplyNumber:").append(supplyBill[supplyNumIndex]).append("\t");
                    this.infoMsgBuilder.append("supplyBaseQty:").append(supplyBaseQty).append("\n");
                }
                if (supplyBaseQty.compareTo(BigDecimal.ZERO) <= 0) continue;
                String adjustPolicy = adjustPolicyMap.get(entityNum);
                if (unOccupyQty.compareTo(BigDecimal.ZERO) > 0) {
                    BigDecimal matchQty;
                    BigDecimal bigDecimal = matchQty = unOccupyQty.compareTo(supplyBaseQty) > 0 ? supplyBaseQty : unOccupyQty;
                    if ("A".equals(adjustPolicy)) {
                        matchQty = supplyBaseQty;
                    }
                    if (this.ctx.isDebugMode()) {
                        this.infoMsgBuilder.append("adjustPolicy").append(adjustPolicy).append("\t");
                        this.infoMsgBuilder.append("matchQty").append(matchQty).append("\n");
                    }
                    this.addLevelMatchResultEntry(occupyQty, matchQty, unOccupyQty, supplyBill, invLevelInfo);
                    supplyBaseQty = supplyBaseQty.subtract(matchQty);
                    supplyBill[supplyQtyIndex] = supplyBaseQty;
                    unOccupyQty = unOccupyQty.subtract(matchQty);
                }
                if (supplyBaseQty.compareTo(BigDecimal.ZERO) > 0 && !"C".equals(adjustPolicy)) {
                    if (this.ctx.isDebugMode()) {
                        this.infoMsgBuilder.append("cancelQty").append(supplyBaseQty).append("\n");
                    }
                    this.addCancelMatchResultEntry(supplyBill);
                }
                if (!this.ctx.isDebugMode()) continue;
                this.infoMsgBuilder.append("level occupy end").append("\n");
            }
        }
        this.ctx.setPlanAdviseMap(planAdviseMap);
        return matchGroupMap;
    }

    private String getAdviseDateExpMsg(Map<String, Object> advise) {
        Date planDate = this.ctx.getPlanDate();
        Date prepareDate = (Date)advise.get("entryentity.plandate");
        Date startDate = (Date)advise.get("entryentity.startdate");
        Date finishDate = (Date)advise.get("entryentity.finishdate");
        StringBuilder expMsgSb = new StringBuilder();
        if (prepareDate != null && prepareDate.before(planDate)) {
            expMsgSb.append(InvPlanHelper.loadKDString("\u65b0\u589e\u8ba1\u5212\u51c6\u5907\u65e5\u671f\u5728\u8fc7\u53bb", "InvPlanCalcPurDemand_5", new Object[0])).append("\n");
        }
        if (startDate != null && startDate.before(planDate)) {
            expMsgSb.append(InvPlanHelper.loadKDString("\u65b0\u589e\u8ba1\u5212\u5f00\u59cb\u65e5\u671f\u5728\u8fc7\u53bb", "InvPlanCalcPurDemand_6", new Object[0])).append("\n");
        }
        if (finishDate != null && finishDate.before(planDate)) {
            expMsgSb.append(InvPlanHelper.loadKDString("\u65b0\u589e\u8ba1\u5212\u7ed3\u675f\u65e5\u671f\u5728\u8fc7\u53bb", "InvPlanCalcPurDemand_7", new Object[0])).append("\n");
        }
        return expMsgSb.toString();
    }

    private void calcAdviseDate(Boolean leadTimeLackAsc, PlanCalendar planCalendar, Date demandDate, DynamicObject invLevelInfo, Map<String, Object> planAdvise) {
        int postTime = invLevelInfo.getInt("postprocessingtime");
        int deliveryTime = invLevelInfo.getInt("deliverytime");
        int preTime = invLevelInfo.getInt("preprocessingtime");
        int leadTime = invLevelInfo.getInt("leadtime");
        if (postTime > 0 && deliveryTime > 0 && preTime > 0) {
            Date usableDate = demandDate;
            Date planFinishDate = planCalendar.getDate(usableDate, true, postTime).getTime();
            Date planStartDate = planCalendar.getDate(planFinishDate, true, deliveryTime).getTime();
            Date planPrepareDate = planCalendar.getDate(planStartDate, true, preTime).getTime();
            if (planPrepareDate.before(this.ctx.getPlanDate()) && leadTimeLackAsc.booleanValue()) {
                planPrepareDate = this.ctx.getPlanDate();
                planStartDate = planCalendar.getDate(planPrepareDate, false, preTime).getTime();
                planFinishDate = planCalendar.getDate(planStartDate, false, deliveryTime).getTime();
                usableDate = planCalendar.getDate(planFinishDate, false, postTime).getTime();
            }
            planAdvise.put("entryentity.date", usableDate);
            planAdvise.put("entryentity.finishdate", planFinishDate);
            planAdvise.put("entryentity.startdate", planStartDate);
            planAdvise.put("entryentity.plandate", planPrepareDate);
        } else {
            Date usableDate = demandDate;
            Date planPrepareDate = planCalendar.getDate(usableDate, true, leadTime).getTime();
            if (planPrepareDate.before(this.ctx.getPlanDate()) && leadTimeLackAsc.booleanValue()) {
                planPrepareDate = this.ctx.getPlanDate();
                usableDate = planCalendar.getDate(planPrepareDate, false, leadTime).getTime();
            }
            planAdvise.put("entryentity.date", usableDate);
            planAdvise.put("entryentity.plandate", planPrepareDate);
        }
    }

    private Object[] advise2Supply(Map<String, Object> planAdvise) {
        FieldMapConf result2supMapConf = this.ctx.getScheme().getSupplyModel().getResult2supMapConf();
        Map<String, Object> supplyBill = result2supMapConf.getTargetValue(planAdvise);
        supplyBill.put("originbaseqty", supplyBill.get("baseqty"));
        List<String> matchFields = this.ctx.getScheme().getDemand2SupplyMatchCof().getFields("invp_supply_model");
        supplyBill.put("flexmetricid", this.getMatchDimensionValue(supplyBill, matchFields));
        Map<String, Integer> supFieldIndex = this.ctx.getSupplyFieldIndexMap();
        Object[] supplyValues = new Object[supFieldIndex.size()];
        for (Map.Entry<String, Object> supplyBillEntry : supplyBill.entrySet()) {
            supplyValues[supFieldIndex.get((Object)supplyBillEntry.getKey()).intValue()] = supplyBillEntry.getValue();
        }
        return supplyValues;
    }

    private String getMatchDimensionValue(Map<String, Object> supplyBill, List<String> matchFields) {
        StringBuilder filedSb = new StringBuilder();
        Object fieldValue = null;
        for (String matchField : matchFields) {
            fieldValue = supplyBill.get(matchField);
            if (supplyBill.get(matchField) instanceof DynamicObject) {
                fieldValue = ((DynamicObject)supplyBill.get(matchField)).get("id");
            }
            if (fieldValue == null) {
                fieldValue = "null";
            }
            filedSb.append(fieldValue).append("$");
        }
        return filedSb.toString();
    }

    private String getMergeKey(Map<String, Object> planAdvise, List<String> mergeBillFields) {
        StringBuilder mergeKeyBuilder = new StringBuilder();
        for (String mergeBillField : mergeBillFields) {
            if (planAdvise.containsKey(mergeBillField)) {
                mergeKeyBuilder.append(planAdvise.get(mergeBillField));
            } else {
                mergeKeyBuilder.append("null");
            }
            mergeKeyBuilder.append("$");
        }
        return mergeKeyBuilder.toString();
    }

    private void addLevelMatchResultEntry(BigDecimal occupyQty, BigDecimal matchQty, BigDecimal unOccupyQty, Object[] supplyBill, DynamicObject invLevelInfo) {
        Map<String, Integer> supplyFieldIndexMap = this.ctx.getSupplyFieldIndexMap();
        Long matchResultId = this.ctx.getMatchDetailId();
        Map<String, Integer> matchEntryIndexMap = this.ctx.getMatchEntryIndexMap();
        MatchResultHelper matchResultHelper = this.ctx.getMatchResultHelper();
        Object[] matchResultEntry = matchResultHelper.newEntry();
        matchResultEntry[matchEntryIndexMap.get((Object)"id").intValue()] = matchResultId;
        matchResultEntry[matchEntryIndexMap.get((Object)"entryid").intValue()] = DB.genGlobalLongId();
        Map<String, String> supplyFieldMap = this.ctx.getSupply2MatchMap();
        for (Map.Entry<String, String> supplyEntry : supplyFieldMap.entrySet()) {
            Object supplyValue = supplyBill[supplyFieldIndexMap.get(supplyEntry.getValue())];
            if (ObjectUtils.isEmpty((Object)supplyValue)) continue;
            if (supplyValue instanceof Date) {
                supplyValue = new Timestamp(((Date)supplyValue).getTime());
            }
            matchResultEntry[matchEntryIndexMap.get((Object)supplyEntry.getKey()).intValue()] = supplyValue;
        }
        matchResultEntry[matchEntryIndexMap.get((Object)"supplyqty").intValue()] = matchQty;
        matchResultEntry[matchEntryIndexMap.get((Object)"demandqty").intValue()] = unOccupyQty;
        matchResultEntry[matchEntryIndexMap.get((Object)"srcdemandqty").intValue()] = occupyQty;
        Timestamp supplyDate = supplyBill[supplyFieldIndexMap.get("supplydate")] == null ? null : new Timestamp(((Date)supplyBill[supplyFieldIndexMap.get("supplydate")]).getTime());
        matchResultEntry[matchEntryIndexMap.get((Object)"demanddate").intValue()] = supplyDate;
        matchResultEntry[matchEntryIndexMap.get((Object)"dembilltype").intValue()] = "invp_invlevel";
        matchResultEntry[matchEntryIndexMap.get((Object)"billno").intValue()] = invLevelInfo.get("number");
        matchResultEntry[matchEntryIndexMap.get((Object)"dembillseq").intValue()] = 0;
        matchResultEntry[matchEntryIndexMap.get((Object)"adjustsuggest").intValue()] = "A";
        String expMsg = InvPlanHelper.loadKDString("\u5e93\u5b58\u6c34\u4f4d\u5360\u7528", "InvPlanCalcPurDemand_0", new Object[0]);
        matchResultEntry[matchEntryIndexMap.get((Object)"exception").intValue()] = expMsg;
        matchResultEntry[matchEntryIndexMap.get((Object)"exception_tag").intValue()] = expMsg;
        matchResultEntry[matchEntryIndexMap.get((Object)"seq").intValue()] = this.ctx.getMatchEntrySeq().getAndIncrement();
        matchResultHelper.addEntry(matchResultEntry);
        Integer n = this.processDataCount;
        Integer n2 = this.processDataCount = Integer.valueOf(this.processDataCount + 1);
    }

    private void addCancelMatchResultEntry(Object[] supplyBill) {
        Map<String, Integer> supplyFieldIndexMap = this.ctx.getSupplyFieldIndexMap();
        BigDecimal supplyQty = (BigDecimal)supplyBill[supplyFieldIndexMap.get("baseqty")];
        Long matchResultId = this.ctx.getMatchDetailId();
        MatchResultHelper matchResultHelper = this.ctx.getMatchResultHelper();
        Object[] matchResultEntry = matchResultHelper.newEntry();
        Map<String, Integer> matchEntryIndexMap = this.ctx.getMatchEntryIndexMap();
        matchResultEntry[matchEntryIndexMap.get((Object)"id").intValue()] = matchResultId;
        matchResultEntry[matchEntryIndexMap.get((Object)"entryid").intValue()] = DB.genGlobalLongId();
        Map<String, String> supplyFieldMap = this.ctx.getSupply2MatchMap();
        for (Map.Entry<String, String> supplyEntry : supplyFieldMap.entrySet()) {
            Object supplyValue = supplyBill[supplyFieldIndexMap.get(supplyEntry.getValue())];
            if (ObjectUtils.isEmpty((Object)supplyValue)) continue;
            if (supplyValue instanceof Date) {
                supplyValue = new Timestamp(((Date)supplyValue).getTime());
            }
            matchResultEntry[matchEntryIndexMap.get((Object)supplyEntry.getKey()).intValue()] = supplyValue;
        }
        matchResultEntry[matchEntryIndexMap.get((Object)"supplyqty").intValue()] = supplyQty;
        matchResultEntry[matchEntryIndexMap.get((Object)"adjustsuggest").intValue()] = "F";
        matchResultEntry[matchEntryIndexMap.get((Object)"seq").intValue()] = this.ctx.getMatchEntrySeq().getAndIncrement();
        matchResultHelper.addEntry(matchResultEntry);
        Integer n = this.processDataCount;
        Integer n2 = this.processDataCount = Integer.valueOf(this.processDataCount + 1);
    }

    private void addMatchResultEntry(Object[] demandBill, Object[] supplyBill, AdjustInfo adjustInfo, BigDecimal matchQty, String dateMsg) {
        StringBuilder expMsgSb = new StringBuilder();
        Map<String, Integer> supplyFieldIndexMap = this.ctx.getSupplyFieldIndexMap();
        Map<String, Integer> demandFieldIndexMap = this.ctx.getDemandFieldIndexMap();
        Long matchResultId = this.ctx.getMatchDetailId();
        Map<String, Integer> matchEntryIndexMap = this.ctx.getMatchEntryIndexMap();
        MatchResultHelper matchResultHelper = this.ctx.getMatchResultHelper();
        Object[] matchResultEntry = matchResultHelper.newEntry();
        matchResultEntry[matchEntryIndexMap.get((Object)"id").intValue()] = matchResultId;
        matchResultEntry[matchEntryIndexMap.get((Object)"entryid").intValue()] = DB.genGlobalLongId();
        Map<String, String> demandFieldMap = this.ctx.getDemand2MatchMap();
        Map<String, String> supplyFieldMap = this.ctx.getSupply2MatchMap();
        for (Map.Entry<String, String> demandEntry : demandFieldMap.entrySet()) {
            Object demandValue = demandBill[demandFieldIndexMap.get(demandEntry.getValue())];
            if (ObjectUtils.isEmpty((Object)demandValue)) continue;
            if (demandValue instanceof Date) {
                demandValue = new Timestamp(((Date)demandValue).getTime());
            }
            matchResultEntry[matchEntryIndexMap.get((Object)demandEntry.getKey()).intValue()] = demandValue;
        }
        for (Map.Entry<String, String> supplyEntry : supplyFieldMap.entrySet()) {
            Object supplyValue = supplyBill[supplyFieldIndexMap.get(supplyEntry.getValue())];
            if (ObjectUtils.isEmpty((Object)supplyValue)) continue;
            if (supplyValue instanceof Date) {
                supplyValue = new Timestamp(((Date)supplyValue).getTime());
            }
            matchResultEntry[matchEntryIndexMap.get((Object)supplyEntry.getKey()).intValue()] = supplyValue;
        }
        Date planDate = this.ctx.getPlanDate();
        Date demandDate = (Date)demandBill[demandFieldIndexMap.get("demanddate")];
        Date supplyDate = (Date)demandBill[demandFieldIndexMap.get("demanddate")];
        if (demandDate != null && demandDate.before(planDate)) {
            expMsgSb.append(InvPlanHelper.loadKDString("\u9700\u6c42\u65e5\u671f\u5728\u8fc7\u53bb", "InvPlanCalcPurDemand_3", new Object[0])).append("\n");
        }
        if (supplyDate != null && supplyDate.before(planDate)) {
            expMsgSb.append(InvPlanHelper.loadKDString("\u4f9b\u5e94\u65e5\u671f\u5728\u8fc7\u53bb", "InvPlanCalcPurDemand_4", new Object[0])).append("\n");
        }
        expMsgSb.append(dateMsg);
        matchResultEntry[matchEntryIndexMap.get((Object)"supplyqty").intValue()] = matchQty;
        if (adjustInfo != null) {
            String adjustType = adjustInfo.getAdjustType();
            matchResultEntry[matchEntryIndexMap.get((Object)"adjustsuggest").intValue()] = adjustType;
            if ("B".equals(adjustType)) {
                expMsgSb.append(InvPlanHelper.loadKDString("\u5efa\u8bae\u63d0\u524d", "InvPlanCalcPurDemand_1", new Object[0])).append("\n");
            }
            if ("D".equals(adjustType)) {
                expMsgSb.append(InvPlanHelper.loadKDString("\u5efa\u8bae\u5ef6\u540e", "InvPlanCalcPurDemand_2", new Object[0])).append("\n");
            }
            matchResultEntry[matchEntryIndexMap.get((Object)"adjustqty").intValue()] = adjustInfo.getAdjustQty();
            Timestamp adjustDate = adjustInfo.getAdjustDate() == null ? null : new Timestamp(adjustInfo.getAdjustDate().getTime());
            matchResultEntry[matchEntryIndexMap.get((Object)"adjustdate").intValue()] = adjustDate;
        }
        matchResultEntry[matchEntryIndexMap.get((Object)"seq").intValue()] = this.ctx.getMatchEntrySeq().getAndIncrement();
        String expMsg = expMsgSb.toString();
        matchResultEntry[matchEntryIndexMap.get((Object)"exception_tag").intValue()] = expMsg;
        if (expMsg.length() > 250) {
            expMsg = expMsg.substring(0, 200);
        }
        matchResultEntry[matchEntryIndexMap.get((Object)"exception").intValue()] = expMsg;
        matchResultHelper.addEntry(matchResultEntry);
        Integer n = this.processDataCount;
        Integer n2 = this.processDataCount = Integer.valueOf(this.processDataCount + 1);
    }

    private AdjustInfo buildAdjustInfo(Date demandDate, Long entryId, BigDecimal supplyBaseQty, Date supplyDate, BigDecimal matchQty, String adjustPolicy) {
        String adjustType = "A";
        BigDecimal adjustBaseQty = BigDecimal.ZERO;
        Date adjustDate = null;
        if (!StringUtils.isEmpty((String)adjustPolicy) && !"C".equals(adjustPolicy)) {
            if (supplyDate.before(demandDate)) {
                adjustType = "D";
            }
            if (supplyDate.after(demandDate)) {
                adjustType = "B";
            }
            if (!adjustType.equals("A")) {
                adjustDate = demandDate;
                adjustBaseQty = matchQty;
                if ("A".equals(adjustPolicy)) {
                    if (this.wholeAdjustIds.add(entryId)) {
                        adjustBaseQty = supplyBaseQty;
                    } else {
                        adjustType = "A";
                        adjustBaseQty = BigDecimal.ZERO;
                        adjustDate = null;
                    }
                }
            }
        }
        if (this.ctx.isDebugMode()) {
            this.infoMsgBuilder.append("adjustType:").append(adjustType).append("\t");
            this.infoMsgBuilder.append("adjustBaseQty:").append(adjustBaseQty).append("\t");
            this.infoMsgBuilder.append("adjustDate:").append(adjustDate).append("\n");
        }
        return new AdjustInfo(adjustType, adjustBaseQty, adjustDate);
    }

    private Date getPastOrFeatureDate(Date originDate, int dayCount) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(originDate);
        calendar.add(5, dayCount);
        return calendar.getTime();
    }

    private IInvPlanStrategy getStrategy() {
        String planType = this.ctx.getScheme().getMainPlanType();
        IInvPlanStrategy invPlanStrategy = new InvPlanMinMaxStrategy();
        switch (planType) {
            case "A": {
                invPlanStrategy = new InvPlanReorderPointStrategy();
                break;
            }
            case "D": {
                invPlanStrategy = new InvPlanPeriodicStrategy();
                break;
            }
        }
        return invPlanStrategy;
    }

    public Map<String, Object> getBillMap(Object[] bill, Map<String, Integer> indexMap) {
        HashMap<String, Object> demandData = new HashMap<String, Object>(16);
        for (Map.Entry<String, Integer> indexEntry : indexMap.entrySet()) {
            demandData.put(indexEntry.getKey(), bill[indexEntry.getValue()]);
        }
        return demandData;
    }
}

