/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.business.step.impl;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.invp.business.step.AbstractInvPlanStep;
import kd.scmc.invp.common.consts.InvPlanLogConstants;
import kd.scmc.invp.common.helper.InvPlanHelper;

public class InvPlanClearHistoryData
extends AbstractInvPlanStep {
    @Override
    public void innerExecute() {
        this.clearHistoryPlanAdvise();
    }

    private void clearHistoryPlanAdvise() {
        int successCount = 0;
        int failCount = 0;
        List<Long> idList = this.getNeedClearIds();
        if (!idList.isEmpty()) {
            this.processDataCount = this.processDataCount + idList.size();
            try (TXHandle txHandle = TX.requiresNew();){
                try {
                    OperationResult result = OperationServiceHelper.executeOperate((String)"delete", (String)"invp_plan_advice", (Object[])idList.toArray(), (OperateOption)OperateOption.create());
                    if (!result.isSuccess()) {
                        this.errorMsgBuilder.append(InvPlanHelper.loadKDString("\u6e05\u7406\u5386\u53f2\u8ba1\u5212\u5efa\u8bae\u5931\u8d25\uff1a", "InvPlanClearHistoryData_0", new Object[0])).append("\n");
                        this.errorMsgBuilder.append(InvPlanHelper.getBillOperateErrorMsg(result));
                    }
                }
                catch (Exception e) {
                    this.errorMsgBuilder.append(InvPlanHelper.loadKDString("\u6e05\u7406\u5386\u53f2\u8ba1\u5212\u5efa\u8bae\u5931\u8d25\uff1a", "InvPlanClearHistoryData_0", new Object[0])).append("\n");
                    this.errorMsgBuilder.append(InvPlanHelper.getExceptionMessage(e));
                    txHandle.markRollback();
                }
            }
            idList = this.getNeedClearIds();
            failCount = idList.size();
            successCount = this.processDataCount - failCount;
        }
        this.infoMsgBuilder.append(InvPlanHelper.loadKDString("\u6e05\u7406\u5386\u53f2\u6570\u636e\uff1a\u6210\u529f{0}\u6761\uff0c\u5931\u8d25{1}\u6761\u3002", "InvPlanClearHistoryData_1", successCount, failCount)).append("\n");
        if (!StringUtils.isEmpty((String)this.errorMsgBuilder.toString())) {
            this.stepResult.setStepResult(InvPlanLogConstants.STEP_RESULT_PART_ERROR);
        }
    }

    private List<Long> getNeedClearIds() {
        Long schemeId = this.ctx.getSchemeId();
        ArrayList<Long> idList = new ArrayList<Long>();
        QFilter filter = new QFilter("planscheme", "=", (Object)schemeId).and(new QFilter("billstatus", "=", (Object)"A"));
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"invp_plan_advice", (String)"id", (QFilter[])filter.toArray(), (String)"");
        for (Row row : dataSet) {
            idList.add(row.getLong("id"));
        }
        return idList;
    }
}

