/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.business.step.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.invp.business.func.ExpressionCalcFunc;
import kd.scmc.invp.business.func.MatchDimensionTransFunc;
import kd.scmc.invp.business.pojo.FieldMapConf;
import kd.scmc.invp.business.pojo.InvPlanScheme;
import kd.scmc.invp.business.pojo.MatchMappingConfig;
import kd.scmc.invp.business.pojo.PlanCalendar;
import kd.scmc.invp.business.step.AbstractInvPlanStep;
import kd.scmc.invp.common.consts.InvPlanLogConstants;
import kd.scmc.invp.common.helper.InvPlanHelper;

public class InvPlanGetDemandData
extends AbstractInvPlanStep {
    @Override
    public void innerExecute() {
        this.getDemandData();
    }

    private void getDemandData() {
        InvPlanScheme scheme = this.ctx.getScheme();
        List<String> demandDsList = scheme.getDemandDsList();
        DataSet allDemandData = null;
        for (String entityNum : demandDsList) {
            DataSet dataSet = this.getDemandDataSet(scheme, entityNum);
            allDemandData = InvPlanHelper.mergeDataSet(allDemandData, dataSet);
        }
        HashMap<String, List<Object[]>> demandBillMap = new HashMap<String, List<Object[]>>(16);
        HashSet<String> noDemandLevelMatchKeys = new HashSet<String>();
        noDemandLevelMatchKeys.addAll(this.ctx.getCalRange().keySet());
        if (allDemandData != null) {
            allDemandData = allDemandData.addField("qty", "originqty");
            allDemandData = allDemandData.addField("'0'", "invlevelmatchkey");
            allDemandData = allDemandData.map((MapFunction)new MatchDimensionTransFunc(allDemandData.getRowMeta(), scheme.getDemand2LevelMatchCof().getFields("invp_demand_model"), "invlevelmatchkey"));
            allDemandData = allDemandData.filter("invlevelmatchkey<> '0' and qty>0");
            allDemandData = allDemandData.orderBy(scheme.getDemandOrder());
            this.ctx.setDemandFieldIndexMap(InvPlanHelper.getFieldIndexMap(allDemandData.getRowMeta()));
            for (Row row : allDemandData) {
                Integer n = this.processDataCount;
                this.processDataCount = this.processDataCount + 1;
                Integer n2 = this.processDataCount;
                String matchKey = row.get("org") + "$" + row.get("flexmetricid");
                if (!demandBillMap.containsKey(matchKey)) {
                    demandBillMap.put(matchKey, new ArrayList());
                }
                ((List)demandBillMap.get(matchKey)).add(RowUtil.toArray((Row)row));
                noDemandLevelMatchKeys.remove(row.get("invlevelmatchkey"));
            }
        }
        if (demandBillMap.isEmpty()) {
            this.stepResult.setStepResult(InvPlanLogConstants.STEP_RESULT_PART_ERROR);
            this.errorMsgBuilder.append(InvPlanHelper.loadKDString("\u65e0\u7b26\u5408\u6761\u4ef6\u7684\u9700\u6c42\uff0c\u8bf7\u68c0\u67e5\u9700\u6c42\u6a21\u578b\u914d\u7f6e", "InvPlanGetDemandData_0", new Object[0])).append("\n");
        } else {
            this.infoMsgBuilder.append(InvPlanHelper.loadKDString("\u83b7\u53d6\u7684\u9700\u6c42\u6570\u636e\u5171\uff1a{0}\u6761\u3002", "InvPlanGetDemandData_1", this.processDataCount)).append("\n");
        }
        Map<Long, Long> materialUnitMap = this.getMaterialUnitMap(noDemandLevelMatchKeys);
        int demandOrgIndex = this.ctx.getDemandFieldIndexMap().get("org");
        int flexIndex = this.ctx.getDemandFieldIndexMap().get("flexmetricid");
        for (String noDemandKey : noDemandLevelMatchKeys) {
            Map<String, Object> levelValueMap = this.ctx.getCalRange().get(noDemandKey);
            Object[] demandBill = this.transLevel2Demand(noDemandKey, levelValueMap, materialUnitMap);
            String flexValue = (String)demandBill[flexIndex];
            Long demandOrgId = (Long)demandBill[demandOrgIndex];
            String matchKey = demandOrgId + "$" + flexValue;
            if (!demandBillMap.containsKey(matchKey)) {
                demandBillMap.put(matchKey, new ArrayList());
            }
            ((List)demandBillMap.get(matchKey)).add(demandBill);
        }
        if (this.ctx.isDebugMode()) {
            this.infoMsgBuilder.append("noDemandLevelMatchKeys:\n");
            this.infoMsgBuilder.append(noDemandLevelMatchKeys).append("\n");
        }
        this.ctx.setDemandBillMap(demandBillMap);
    }

    private DataSet getDemandDataSet(InvPlanScheme scheme, String entityNum) {
        List<String> selectorFields = this.ctx.getDemandFields();
        FieldMapConf fieldMapConf = scheme.getDemandModel().getFieldMapConf(entityNum);
        QFilter[] filter = this.getFilters(scheme, entityNum);
        if (this.ctx.isDebugMode()) {
            this.infoMsgBuilder.append("entityNum:").append(entityNum).append("\n").append("demandFilter:\n");
            for (QFilter qFilter : filter) {
                if (qFilter == null) continue;
                this.infoMsgBuilder.append(qFilter).append("\n");
            }
        }
        String selector = fieldMapConf.getMatchSelector(selectorFields);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entityNum, (String)selector, (QFilter[])filter, (String)"");
        Map<String, String> formulaMap = fieldMapConf.getFormulaMap();
        Map<String, String> condExpressionMap = fieldMapConf.getCondExpressionMap();
        List<String> matchFields = scheme.getDemand2SupplyMatchCof().getFields("invp_demand_model");
        RowMeta rowMeta = dataSet.getRowMeta();
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityNum);
        dataSet = dataSet.map((MapFunction)new ExpressionCalcFunc(dataEntityType, rowMeta, formulaMap, condExpressionMap)).map((MapFunction)new MatchDimensionTransFunc(rowMeta, matchFields, "flexmetricid")).select(selectorFields.toArray(new String[0]));
        return dataSet;
    }

    private QFilter[] getFilters(InvPlanScheme scheme, String entityNum) {
        FieldMapConf fieldMapConf = scheme.getDemandModel().getFieldMapConf(entityNum);
        QFilter dateFilter = this.getDateFilter(fieldMapConf);
        QFilter orgFilter = this.getOrgFilter(scheme.getDemandOrgIds(), fieldMapConf);
        QFilter dataSourceFilter = scheme.getDemandModel().getDataSourceFilter(entityNum);
        QFilter rangeFilter = this.getRangeFilter(fieldMapConf);
        QFilter[] filter = new QFilter[]{dateFilter, orgFilter, dataSourceFilter, rangeFilter};
        return filter;
    }

    private Map<Long, Long> getMaterialUnitMap(Set<String> noDemandLevelMatchKeys) {
        HashMap<Long, Long> materialUnitMap = new HashMap<Long, Long>();
        Map<String, String> demand2LevelFieldMap = this.ctx.getScheme().getDemand2LevelMatchCof().getFieldMap("invp_demand_model", "invp_invlevel");
        String materialKey = demand2LevelFieldMap.get("materiel");
        if (!StringUtils.isEmpty((String)materialKey)) {
            HashSet<Object> materialIds = new HashSet<Object>(noDemandLevelMatchKeys.size());
            for (String noDemandKey : noDemandLevelMatchKeys) {
                Object materialId = this.ctx.getCalRange().get(noDemandKey).get(materialKey);
                materialIds.add(materialId);
            }
            QFilter filter = new QFilter("id", "in", materialIds);
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_material", (String)"id,baseunit", (QFilter[])filter.toArray(), (String)"");
            for (Row row : dataSet) {
                materialUnitMap.put(row.getLong("id"), row.getLong("baseunit"));
            }
        }
        return materialUnitMap;
    }

    private Object[] transLevel2Demand(String noDemandKey, Map<String, Object> levelValueMap, Map<Long, Long> materialUnitMap) {
        Map<String, Integer> demandFieldIndexMap = this.ctx.getDemandFieldIndexMap();
        Object[] demandBill = new Object[demandFieldIndexMap.size()];
        Map<String, String> level2DemandFieldMap = this.ctx.getScheme().getDemand2LevelMatchCof().getFieldMap("invp_invlevel", "invp_demand_model");
        for (Map.Entry<String, String> matchEntry : level2DemandFieldMap.entrySet()) {
            String levelKey = matchEntry.getKey();
            String demandKey = matchEntry.getValue();
            demandBill[demandFieldIndexMap.get((Object)demandKey).intValue()] = levelValueMap.get(levelKey);
            if (!"materiel".equals(demandKey)) continue;
            Long basUnit = materialUnitMap.get(levelValueMap.get(levelKey));
            demandBill[demandFieldIndexMap.get((Object)"baseunit").intValue()] = basUnit;
        }
        DynamicObject invLevelInfo = this.ctx.getInvLevelMap().get((Long)levelValueMap.get("id"));
        demandBill[demandFieldIndexMap.get((Object)"qty").intValue()] = BigDecimal.ZERO;
        demandBill[demandFieldIndexMap.get((Object)"originqty").intValue()] = BigDecimal.ZERO;
        demandBill[demandFieldIndexMap.get((Object)"demanddate").intValue()] = this.ctx.getPlanDate();
        demandBill[demandFieldIndexMap.get((Object)"billid").intValue()] = levelValueMap.get("id");
        demandBill[demandFieldIndexMap.get((Object)"billentryid").intValue()] = levelValueMap.get("id");
        demandBill[demandFieldIndexMap.get((Object)"linenum").intValue()] = 0;
        demandBill[demandFieldIndexMap.get((Object)"billno").intValue()] = invLevelInfo.getString("number");
        demandBill[demandFieldIndexMap.get((Object)"srcbill").intValue()] = "invp_invlevel";
        demandBill[demandFieldIndexMap.get((Object)"invlevelmatchkey").intValue()] = noDemandKey;
        List<String> matchFields = this.ctx.getScheme().getDemand2SupplyMatchCof().getFields("invp_demand_model");
        String matchValue = this.getMatchValue(demandFieldIndexMap, demandBill, matchFields);
        demandBill[demandFieldIndexMap.get((Object)"flexmetricid").intValue()] = matchValue;
        return demandBill;
    }

    private String getMatchValue(Map<String, Integer> demandFieldIndexMap, Object[] demandBill, List<String> matchFields) {
        StringBuilder matchValueBuilder = new StringBuilder();
        for (String matchField : matchFields) {
            Object fieldValue = demandBill[demandFieldIndexMap.get(matchField)];
            if (fieldValue instanceof DynamicObject) {
                fieldValue = ((DynamicObject)fieldValue).get("id");
            }
            if (fieldValue == null) {
                fieldValue = "null";
            }
            matchValueBuilder.append(fieldValue).append("$");
        }
        return matchValueBuilder.toString();
    }

    private QFilter getDateFilter(FieldMapConf fieldMapConf) {
        String dateField = fieldMapConf.getFieldMap().get("demanddate");
        if (StringUtils.isEmpty((String)dateField)) {
            return null;
        }
        PlanCalendar planCalendar = this.ctx.getPlanCalendar();
        Date demandStartDate = planCalendar.getRequireStartDate();
        Date endDate = planCalendar.getEndDate();
        QFilter filter = new QFilter(dateField, ">=", (Object)demandStartDate).and(dateField, "<=", (Object)endDate);
        return filter;
    }

    private QFilter getRangeFilter(FieldMapConf fieldMapConf) {
        MatchMappingConfig demand2LevelMatchCof = this.ctx.getScheme().getDemand2LevelMatchCof();
        Map<String, String> target2SourceMap = demand2LevelMatchCof.getFieldMap("invp_invlevel", "invp_demand_model");
        Map<String, String> fieldMap = fieldMapConf.getFieldMap();
        Map<String, Map<String, Object>> calRange = this.ctx.getCalRange();
        HashMap valueMap = new HashMap();
        for (Map<String, Object> range : calRange.values()) {
            range.forEach((field, value) -> {
                String sourDemandField = (String)fieldMap.get(target2SourceMap.get(field));
                if (!StringUtils.isEmpty((String)sourDemandField)) {
                    if (!valueMap.containsKey(sourDemandField)) {
                        valueMap.put(sourDemandField, new HashSet());
                    }
                    ((Set)valueMap.get(sourDemandField)).add(value);
                }
            });
        }
        QFilter rangeFilter = null;
        if (!valueMap.isEmpty()) {
            for (Map.Entry valueEntry : valueMap.entrySet()) {
                if (rangeFilter == null) {
                    rangeFilter = new QFilter((String)valueEntry.getKey(), "in", valueEntry.getValue());
                    continue;
                }
                rangeFilter = rangeFilter.and((String)valueEntry.getKey(), "in", valueEntry.getValue());
            }
        }
        return rangeFilter;
    }

    private QFilter getOrgFilter(Set<Long> demandOrgIds, FieldMapConf fieldMapConf) {
        String orgField = fieldMapConf.getFieldMap().get("org");
        QFilter orgFilter = null;
        if (!StringUtils.isEmpty((String)orgField)) {
            orgFilter = new QFilter(orgField, "in", demandOrgIds);
        }
        return orgFilter;
    }

    public Long getMatchInvLevelEntry(Row demandBill) {
        MatchMappingConfig matchMappingConfig = this.ctx.getScheme().getDemand2LevelMatchCof();
        List<String> demandMatchField = matchMappingConfig.getFields("invp_demand_model");
        String matchKey = InvPlanHelper.getMatchKey(demandBill, demandMatchField);
        return (Long)this.ctx.getCalRange().get(matchKey).get("id");
    }
}

