/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.business.step.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowUtil;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.invp.business.pojo.InvLevelDimension;
import kd.scmc.invp.business.pojo.InvPlanScheme;
import kd.scmc.invp.business.pojo.MatchMappingConfig;
import kd.scmc.invp.business.step.AbstractInvPlanStep;
import kd.scmc.invp.common.consts.InvPlanLogConstants;
import kd.scmc.invp.common.helper.InvPlanHelper;

public class InvPlanGetMatRange
extends AbstractInvPlanStep {
    @Override
    public void innerExecute() {
        this.initCalRange();
        if (!this.ctx.getBatchCal().booleanValue() && this.ctx.getCalRange().size() > 0) {
            InvPlanHelper.initInvLevel(this.ctx);
        }
    }

    private void initCalRange() {
        String invLevelFilterJson;
        InvPlanScheme scheme = this.ctx.getScheme();
        InvLevelDimension dimension = scheme.getDimension();
        String mainPlanType = scheme.getMainPlanType();
        List<Long> planner = scheme.getPlanner();
        List<Long> planGroup = scheme.getPlanGroup();
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("enable", "=", (Object)"1"));
        filters.add(new QFilter("status", "=", (Object)"C"));
        filters.add(new QFilter("dimension", "=", (Object)dimension.getId()));
        filters.add(new QFilter("mainplantype", "=", (Object)mainPlanType));
        if (planner.size() > 0) {
            filters.add(new QFilter("planner", "in", planner));
        }
        if (planGroup.size() > 0) {
            filters.add(new QFilter("plangroup", "in", planGroup));
        }
        if (dimension.getDimensions().contains("bos_org")) {
            Set<Long> demandOrgs = scheme.getSupplyPolicyMap().keySet();
            filters.add(new QFilter("bos_org", "in", demandOrgs));
        }
        if (!StringUtils.isEmpty((String)(invLevelFilterJson = scheme.getInvLevelFilterJson()))) {
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)invLevelFilterJson, FilterCondition.class);
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"invp_invlevel");
            FilterBuilder filterBuilder = new FilterBuilder(dataEntityType, filterCondition);
            filterBuilder.buildFilter();
            filters.add(filterBuilder.getQFilter());
        }
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"invp_invlevel", (Long)this.ctx.getPlanOrg());
        filters.add(baseDataFilter);
        MatchMappingConfig demand2LevelMatchCof = scheme.getDemand2LevelMatchCof();
        List<String> fields = demand2LevelMatchCof.getFields("invp_invlevel");
        StringBuilder selectorBuilder = new StringBuilder("id");
        for (String field : fields) {
            selectorBuilder.append(",").append(field);
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"invp_invlevel", (String)selectorBuilder.toString(), (QFilter[])filters.toArray(new QFilter[0]), (String)"");
        DataSet targetSet = demand2LevelMatchCof.getTargetInfoMap(dataSet, "invp_invlevel");
        Map<String, String> fieldMap = demand2LevelMatchCof.getFieldMap("invp_demand_model", "invp_invlevel");
        String orgField = fieldMap.get("org");
        String materialField = fieldMap.get("materiel");
        Map<Long, Set<Long>> orgMatIdSet = this.getOrgUsableMaterial(orgField, materialField, targetSet.copy());
        HashMap<String, Map<String, Object>> calRange = new HashMap<String, Map<String, Object>>();
        for (Row row : targetSet) {
            if (!orgMatIdSet.get(row.getLong(orgField)).contains(row.get(materialField))) continue;
            calRange.put(InvPlanHelper.getMatchKey(row, demand2LevelMatchCof.getFields("invp_invlevel")), RowUtil.toMap((Row)row));
        }
        this.processDataCount = calRange.size();
        if (this.processDataCount == 0) {
            this.errorMsgBuilder.append(InvPlanHelper.loadKDString("\u65e0\u7b26\u5408\u6761\u4ef6\u7684\u7269\u6599\uff0c\u8bf7\u68c0\u67e5\u5e93\u5b58\u6c34\u4f4d\u4fe1\u606f\u914d\u7f6e", "InvPlanGetMatRange_0", new Object[0]));
            this.stepResult.setStepResult(InvPlanLogConstants.STEP_RESULT_ERROR);
        }
        this.ctx.setCalRange(calRange);
    }

    private Map<Long, Set<Long>> getOrgUsableMaterial(String orgField, String materialField, DataSet levelDataSet) {
        Long orgId;
        HashMap<Long, Set<Long>> orgMatIdSet = new HashMap<Long, Set<Long>>();
        QFilter statusFilter = new QFilter("status", "=", (Object)"C").and("enable", "=", (Object)"1");
        HashMap org2MatIdSet = new HashMap();
        for (Row row : levelDataSet) {
            orgId = row.getLong(orgField);
            if (!org2MatIdSet.containsKey(orgId)) {
                org2MatIdSet.put(orgId, new HashSet());
            }
            ((Set)org2MatIdSet.get(orgId)).add(row.getLong(materialField));
        }
        for (Map.Entry orgMatEntry : org2MatIdSet.entrySet()) {
            orgId = (Long)orgMatEntry.getKey();
            QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_material", (Long)orgId);
            QFilter rangeFilter = new QFilter("id", "in", orgMatEntry.getValue());
            DataSet matDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_material", (String)"masterid", (QFilter[])new QFilter[]{statusFilter, baseDataFilter, rangeFilter}, (String)"");
            if (!orgMatIdSet.containsKey(orgId)) {
                orgMatIdSet.put(orgId, new HashSet());
            }
            for (Row row : matDataSet) {
                ((Set)orgMatIdSet.get(orgId)).add(row.getLong("masterid"));
            }
        }
        return orgMatIdSet;
    }
}

