/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.business.step.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.invp.business.func.ExpressionCalcFunc;
import kd.scmc.invp.business.func.MatchDimensionTransFunc;
import kd.scmc.invp.business.func.SupplyOrderFunc;
import kd.scmc.invp.business.pojo.FieldMapConf;
import kd.scmc.invp.business.pojo.InvPlanScheme;
import kd.scmc.invp.business.pojo.InvSupplyPolicy;
import kd.scmc.invp.business.pojo.MatchMappingConfig;
import kd.scmc.invp.business.pojo.PlanCalendar;
import kd.scmc.invp.business.pojo.SupplyModel;
import kd.scmc.invp.business.step.AbstractInvPlanStep;
import kd.scmc.invp.common.helper.InvPlanHelper;

public class InvPlanGetSupplyData
extends AbstractInvPlanStep {
    @Override
    public void innerExecute() {
        this.getSupplyData();
    }

    private void getSupplyData() {
        Object dataSet;
        InvPlanScheme scheme = this.ctx.getScheme();
        List<String> supplyDsList = scheme.getSupplyDsList();
        Map<Long, InvSupplyPolicy> supplyPolicyMap = scheme.getSupplyPolicyMap();
        HashMap<Long, Object[]> id2ValueArrMap = new HashMap<Long, Object[]>();
        HashMap<String, List<Object[]>> supplyBillMap = new HashMap<String, List<Object[]>>();
        if (supplyDsList.contains("im_inv_realbalance")) {
            supplyPolicyMap.forEach((orgId, supplyPolicy) -> {
                DataSet dataSet = this.getSupplyBillData((InvSupplyPolicy)supplyPolicy, "im_inv_realbalance");
                this.processSupplyDate((Map<Long, Object[]>)id2ValueArrMap, (Map<String, List<Object[]>>)supplyBillMap, dataSet, (Long)orgId);
            });
        }
        supplyDsList.remove("im_inv_realbalance");
        DataSet allDataSet = null;
        for (int i = 0; i < supplyDsList.size(); ++i) {
            String entityNum = supplyDsList.get(i);
            dataSet = this.getSupplyBillData(null, entityNum);
            dataSet = dataSet.addField(i + "", "entityorder");
            allDataSet = InvPlanHelper.mergeDataSet(allDataSet, dataSet);
        }
        if (allDataSet != null) {
            allDataSet = allDataSet.orderBy(new String[]{"supplydate", "entityorder"});
            allDataSet = allDataSet.removeFields(new String[]{"entityorder"});
            for (Row row : allDataSet) {
                dataSet = this.processDataCount;
                Integer n = this.processDataCount = Integer.valueOf(this.processDataCount + 1);
                Object[] valueArr = RowUtil.toArray((Row)row);
                Long entryId = row.getLong("billentryid");
                id2ValueArrMap.putIfAbsent(entryId, valueArr);
                Object[] rowValue = (Object[])id2ValueArrMap.get(entryId);
                String matchKey = row.getString("flexmetricid");
                for (Long orgId2 : supplyPolicyMap.keySet()) {
                    if (!supplyBillMap.containsKey(orgId2 + "$" + matchKey)) {
                        supplyBillMap.put(orgId2 + "$" + matchKey, new ArrayList());
                    }
                    ((List)supplyBillMap.get(orgId2 + "$" + matchKey)).add(rowValue);
                }
            }
        }
        id2ValueArrMap.clear();
        this.infoMsgBuilder.append(InvPlanHelper.loadKDString("\u83b7\u53d6\u7684\u4f9b\u5e94\u6570\u636e\u5171\uff1a{0}\u6761\u3002", "InvPlanGetSupplyData_0", this.processDataCount));
        this.ctx.setSupplyBillMap(supplyBillMap);
    }

    private void processSupplyDate(Map<Long, Object[]> id2ValueArrMap, Map<String, List<Object[]>> supplyBillMap, DataSet dataSet, Long orgId) {
        for (Row row : dataSet) {
            Integer n = this.processDataCount;
            Integer n2 = this.processDataCount = Integer.valueOf(this.processDataCount + 1);
            Object[] valueArr = RowUtil.toArray((Row)row);
            Long entryId = row.getLong("billentryid");
            id2ValueArrMap.putIfAbsent(entryId, valueArr);
            Object[] rowValue = id2ValueArrMap.get(entryId);
            String matchKey = row.getString("flexmetricid");
            if (!supplyBillMap.containsKey(orgId + "$" + matchKey)) {
                supplyBillMap.put(orgId + "$" + matchKey, new ArrayList());
            }
            supplyBillMap.get(orgId + "$" + matchKey).add(rowValue);
        }
    }

    private DataSet getSupplyBillData(InvSupplyPolicy supplyPolicy, String entityNum) {
        InvPlanScheme scheme = this.ctx.getScheme();
        SupplyModel supplyModel = scheme.getSupplyModel();
        List<String> selectorFields = this.ctx.getSupplyFields();
        FieldMapConf fieldMapConf = supplyModel.getFieldMapConf(entityNum);
        String selectors = fieldMapConf.getMatchSelector(selectorFields);
        List<QFilter> filters = this.getFilters(supplyModel, supplyPolicy, entityNum);
        if (this.ctx.isDebugMode()) {
            this.infoMsgBuilder.append("entityNum:").append(entityNum).append("\n").append("supplyFilter:\n");
            for (QFilter qFilter : filters) {
                if (qFilter == null) continue;
                this.infoMsgBuilder.append(qFilter).append("\n");
            }
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entityNum, (String)selectors, (QFilter[])filters.toArray(new QFilter[0]), (String)"");
        RowMeta rowMeta = dataSet.getRowMeta();
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityNum);
        dataSet = dataSet.map((MapFunction)new ExpressionCalcFunc(dataEntityType, rowMeta, fieldMapConf.getFormulaMap(), fieldMapConf.getCondExpressionMap())).map((MapFunction)new MatchDimensionTransFunc(rowMeta, scheme.getDemand2SupplyMatchCof().getFields("invp_supply_model"), "flexmetricid"));
        if (entityNum.equals("im_inv_realbalance")) {
            dataSet = dataSet.addFields(new String[]{"-1", "-1", "-1", "-1"}, new String[]{"priority", "supplypriority", "invstatuspriority", "invtypepriority"});
            rowMeta = dataSet.getRowMeta();
            dataSet = dataSet.map((MapFunction)new SupplyOrderFunc(rowMeta, supplyPolicy));
            dataSet = dataSet.orderBy(new String[]{"invtypepriority", "invstatuspriority", "priority", "supplypriority"});
        }
        dataSet = dataSet.select(selectorFields.toArray(new String[0]));
        dataSet = dataSet.addField("baseqty", "originbaseqty");
        if (this.ctx.getSupplyFieldIndexMap() == null) {
            this.ctx.setSupplyFieldIndexMap(InvPlanHelper.getFieldIndexMap(dataSet.getRowMeta()));
        }
        return dataSet;
    }

    private List<QFilter> getFilters(SupplyModel supplyModel, InvSupplyPolicy supplyPolicy, String entityNum) {
        QFilter dateFilter;
        QFilter rangeFilter;
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        FieldMapConf fieldMapConf = supplyModel.getFieldMapConf(entityNum);
        QFilter dataSourceFilter = supplyModel.getDataSourceFilter(entityNum);
        filters.add(dataSourceFilter);
        if (entityNum.equals("im_inv_realbalance")) {
            String storageOrgField = fieldMapConf.getFieldMap().get("invorg");
            String warehouseField = fieldMapConf.getFieldMap().get("supplywarehouse");
            String locationField = fieldMapConf.getFieldMap().get("supplylocation");
            String storeStateField = fieldMapConf.getFieldMap().get("invstatus");
            String storeTypeField = fieldMapConf.getFieldMap().get("invtype");
            List<QFilter> policyFilterList = supplyPolicy.getPolicyFilterList(storageOrgField, warehouseField, locationField, storeTypeField, storeStateField, entityNum);
            filters.addAll(policyFilterList);
        }
        if ((rangeFilter = this.getRangeFilter(fieldMapConf)) != null) {
            filters.add(rangeFilter);
        }
        if ((dateFilter = this.getDateFilter(fieldMapConf)) != null) {
            filters.add(dateFilter);
        }
        return filters;
    }

    private QFilter getRangeFilter(FieldMapConf fieldMapConf) {
        MatchMappingConfig demand2LevelMatchCof = this.ctx.getScheme().getDemand2LevelMatchCof();
        Map<String, String> target2SourceMap = demand2LevelMatchCof.getFieldMap("invp_invlevel", "invp_demand_model");
        Map<String, String> demand2SupMap = this.ctx.getScheme().getDemand2SupplyMatchCof().getFieldMap("invp_demand_model", "invp_supply_model");
        Map<String, String> fieldMap = fieldMapConf.getFieldMap();
        Map<String, Map<String, Object>> calRange = this.ctx.getCalRange();
        HashMap valueMap = new HashMap();
        for (Map<String, Object> range : calRange.values()) {
            range.forEach((field, value) -> {
                String supplyField;
                String demandField = (String)target2SourceMap.get(field);
                if (demand2SupMap.containsKey(demandField) && !StringUtils.isEmpty((String)(supplyField = (String)fieldMap.get(demand2SupMap.get(demandField))))) {
                    if (!valueMap.containsKey(supplyField)) {
                        valueMap.put(supplyField, new HashSet());
                    }
                    ((Set)valueMap.get(supplyField)).add(value);
                }
            });
        }
        QFilter rangeFilter = null;
        if (!valueMap.isEmpty()) {
            for (Map.Entry valueEntry : valueMap.entrySet()) {
                if (rangeFilter == null) {
                    rangeFilter = new QFilter((String)valueEntry.getKey(), "in", valueEntry.getValue());
                    continue;
                }
                rangeFilter = rangeFilter.and((String)valueEntry.getKey(), "in", valueEntry.getValue());
            }
        }
        return rangeFilter;
    }

    private QFilter getDateFilter(FieldMapConf fieldMapConf) {
        String dateField = fieldMapConf.getFieldMap().get("supplydate");
        if (StringUtils.isEmpty((String)dateField)) {
            return null;
        }
        PlanCalendar planCalendar = this.ctx.getPlanCalendar();
        Date supplyStartDate = planCalendar.getSupplyStartDate();
        Date endDate = planCalendar.getEndDate();
        QFilter filter = new QFilter(dateField, ">=", (Object)supplyStartDate).and(dateField, "<=", (Object)endDate);
        return filter;
    }
}

