/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.business.step.impl;

import java.util.Set;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.scmc.invp.business.pojo.InvPlanScheme;
import kd.scmc.invp.business.pojo.PlanCalendar;
import kd.scmc.invp.business.step.AbstractInvPlanStep;
import kd.scmc.invp.common.consts.InvPlanLogConstants;
import kd.scmc.invp.common.helper.InvPlanHelper;

public class InvPlanInitCalendar
extends AbstractInvPlanStep {
    @Override
    public void innerExecute() {
        this.initCalendar();
    }

    private void initCalendar() {
        InvPlanScheme scheme = this.ctx.getScheme();
        Long planOrg = this.ctx.getPlanOrg();
        if (!this.checkCalender(planOrg)) {
            return;
        }
        if (this.ctx.getBatchCal().booleanValue()) {
            return;
        }
        PlanCalendar planCalendar = new PlanCalendar(planOrg);
        if (!planCalendar.isEmpty()) {
            planCalendar.setRequireStartDate(this.ctx.getPlanDate(), scheme.getDemandOutOfDate());
            planCalendar.setSupplyStartDate(this.ctx.getPlanDate(), scheme.getSupplyOutOfDate());
            planCalendar.setEndDate(this.ctx.getPlanDate(), scheme.getPlanOutLook());
        }
        this.processDataCount = 1;
        this.ctx.setPlanCalendar(planCalendar);
    }

    private boolean checkCalender(Long planOrg) {
        Set calendarIds = (Set)DispatchServiceHelper.invokeBizService((String)"bd", (String)"mpdm", (String)"ICalendarService", (String)"getCalendarIdSet", (Object[])new Object[]{planOrg, "A", "B"});
        if (calendarIds == null || calendarIds.isEmpty()) {
            String planOrgInfo = InvPlanHelper.getPlanOrgInfo(planOrg);
            this.errorMsgBuilder.append(InvPlanHelper.loadKDString("\u8ba1\u5212\u7ec4\u7ec7\uff1a{0}\uff0c\u672a\u8bbe\u7f6e\u53ef\u7528\u7684\u8ba1\u5212\u65e5\u5386\u3002", "InvPlanInitCalendar_0", planOrgInfo)).append("\n");
        }
        if (this.errorMsgBuilder.length() > 0) {
            this.stepResult.setStepResult(InvPlanLogConstants.STEP_RESULT_ERROR);
            return false;
        }
        return true;
    }
}

