/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.business.step.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.dlock.DLock;
import kd.bos.entity.MainEntityType;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.invp.business.pojo.InvPlanScheme;
import kd.scmc.invp.business.step.AbstractInvPlanStep;
import kd.scmc.invp.common.consts.InvPlanLogConstants;
import kd.scmc.invp.common.helper.InvPlanHelper;

public class InvPlanPrepare
extends AbstractInvPlanStep {
    @Override
    public void innerExecute() {
        this.processDataCount = -1;
        Boolean result = this.checkMutex();
        if (!result.booleanValue()) {
            return;
        }
        DynamicObject invPlanObj = InvPlanHelper.getInvPlanSchemeDynamicObj(this.ctx.getSchemeId());
        result = this.checkScheme(invPlanObj);
        if (!result.booleanValue()) {
            return;
        }
        this.buildInvPlanScheme(invPlanObj);
        result = this.checkMatchLevel();
        if (!result.booleanValue()) {
            return;
        }
        this.initMatchResultInfo();
        if (!this.ctx.getBatchCal().booleanValue()) {
            this.ctx.setMatchEntryIndexMap(this.ctx.getMatchResultHelper().getFieldIndexMap());
            this.initBillFields();
            this.initBill2MatchResultMatchMap();
        }
    }

    private Boolean checkMatchLevel() {
        InvPlanScheme scheme = this.ctx.getScheme();
        List<String> dimensions = scheme.getDimension().getDimensions();
        List<String> levelField = scheme.getDemand2LevelMatchCof().getFields("invp_invlevel");
        boolean result = true;
        for (String field : dimensions) {
            if (field.equals("bd_materialgroupstandard") || levelField.contains(field)) continue;
            result = false;
            break;
        }
        if (!result) {
            this.errorMsgBuilder.append(InvPlanHelper.loadKDString("\u9700\u6c42\u4e0e\u6c34\u4f4d\u5339\u914d\u7ef4\u5ea6\u4e2d\uff0c\u9700\u5305\u542b\u5e93\u5b58\u6c34\u4f4d\u7ef4\u5ea6\u4e2d\u7684\u6240\u6709\u7ef4\u5ea6\u5b57\u6bb5\u3002", "InvPlanPrepare_19", new Object[0]));
            this.stepResult.setStepResult(InvPlanLogConstants.STEP_RESULT_ERROR);
        }
        result = true;
        for (String field : levelField) {
            if (dimensions.contains(field)) continue;
            result = false;
            break;
        }
        if (!result) {
            this.errorMsgBuilder.append(InvPlanHelper.loadKDString("\u9700\u6c42\u4e0e\u6c34\u4f4d\u5339\u914d\u7ef4\u5ea6\u4e2d\uff0c\u4e0d\u80fd\u5305\u542b\u5e93\u5b58\u6c34\u4f4d\u7ef4\u5ea6\u4ee5\u5916\u7684\u7ef4\u5ea6\u5b57\u6bb5\u3002", "InvPlanPrepare_13", new Object[0]));
            this.stepResult.setStepResult(InvPlanLogConstants.STEP_RESULT_ERROR);
        }
        return result;
    }

    protected void initBill2MatchResultMatchMap() {
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        fieldMap.put("material", "materiel");
        fieldMap.put("demandorg", "supplyorg");
        fieldMap.put("supplyorg", "supplyorg");
        fieldMap.put("supplybilltype", "srcbill");
        fieldMap.put("supplybillno", "billno");
        fieldMap.put("supplybillseq", "linenum");
        fieldMap.put("warehouse", "supplywarehouse");
        fieldMap.put("location", "supplylocation");
        fieldMap.put("supinvstatus", "invstatus");
        fieldMap.put("supinvtype", "invtype");
        fieldMap.put("srcsupplyqty", "originbaseqty");
        fieldMap.put("supplydate", "supplydate");
        this.ctx.setSupply2MatchMap(fieldMap);
        fieldMap = new HashMap();
        fieldMap.put("dembilltype", "srcbill");
        fieldMap.put("billno", "billno");
        fieldMap.put("dembillseq", "linenum");
        fieldMap.put("demandqty", "qty");
        fieldMap.put("srcdemandqty", "originqty");
        fieldMap.put("baseunit", "baseunit");
        fieldMap.put("demanddate", "demanddate");
        this.ctx.setDemand2MatchMap(fieldMap);
    }

    protected void initBillFields() {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"invp_demand_model");
        ArrayList<String> fields = new ArrayList<String>(dataEntityType.getAllFields().keySet());
        this.ctx.setDemandFields(fields);
        dataEntityType = MetadataServiceHelper.getDataEntityType((String)"invp_supply_model");
        fields = new ArrayList(dataEntityType.getAllFields().keySet());
        this.ctx.setSupplyFields(fields);
    }

    private Boolean checkScheme(DynamicObject invPlanObj) {
        if ("0".equals(invPlanObj.getString("enable"))) {
            this.errorMsgBuilder.append(InvPlanHelper.loadKDString("\u5e93\u5b58\u8ba1\u5212\u65b9\u6848\uff08\u7f16\u7801\uff1a{0}\uff09\u5df2\u7981\u7528\uff0c\u8bf7\u68c0\u67e5\u3002", "InvPlanPrepare_15", invPlanObj.getString("number")));
        }
        if (!"C".equals(invPlanObj.getString("status"))) {
            this.errorMsgBuilder.append(InvPlanHelper.loadKDString("\u5e93\u5b58\u8ba1\u5212\u65b9\u6848\uff08\u7f16\u7801\uff1a{0}\uff09\u672a\u5ba1\u6838\uff0c\u8bf7\u68c0\u67e5\u3002", "InvPlanPrepare_16", invPlanObj.getString("number")));
        }
        DynamicObjectCollection orgEntries = invPlanObj.getDynamicObjectCollection("orgparamentry");
        this.errorMsgBuilder.append(this.checkDemandOrgEntry(orgEntries));
        DynamicObject demandModelInfo = invPlanObj.getDynamicObject("demandmodel");
        this.errorMsgBuilder.append(this.checkDemandModel(demandModelInfo));
        DynamicObject supplyModelInfo = invPlanObj.getDynamicObject("supplymodel");
        this.errorMsgBuilder.append(this.checkSupplyModel(supplyModelInfo));
        DynamicObject matchDimension = invPlanObj.getDynamicObject("suptodemmapping");
        this.errorMsgBuilder.append(this.checkMatchMapConfig(matchDimension));
        DynamicObject demand2LevelMap = invPlanObj.getDynamicObject("demtolevelmapping");
        this.errorMsgBuilder.append(this.checkMatchMapConfig(demand2LevelMap));
        DynamicObjectCollection demandSrcEntries = invPlanObj.getDynamicObjectCollection("demandparamentry");
        this.errorMsgBuilder.append(this.checkDemandDsEntry(demandSrcEntries, demandModelInfo));
        DynamicObjectCollection supplySrcEntries = invPlanObj.getDynamicObjectCollection("supparamentry");
        this.errorMsgBuilder.append(this.checkSupplyDsEntry(supplySrcEntries, supplyModelInfo));
        DynamicObjectCollection outPutEntries = invPlanObj.getDynamicObjectCollection("outputparamentry");
        this.errorMsgBuilder.append(this.checkOutPutEntry(outPutEntries));
        DynamicObject algoPlan = invPlanObj.getDynamicObject("algorithmplan");
        this.errorMsgBuilder.append(this.checkAlgoPlan(algoPlan));
        if (!StringUtils.isEmpty((String)this.errorMsgBuilder.toString())) {
            this.stepResult.setStepResult(InvPlanLogConstants.STEP_RESULT_ERROR);
            return false;
        }
        return true;
    }

    private String checkAlgoPlan(DynamicObject algoPlan) {
        StringBuilder checkBuilder = new StringBuilder();
        String status = algoPlan.getString("enable");
        if ("0".equals(status)) {
            String number = algoPlan.getString("number");
            checkBuilder.append(InvPlanHelper.loadKDString("\u7b97\u6cd5\u65b9\u6848\uff08\u7f16\u7801\uff1a{0}\uff09\u5df2\u7981\u7528\uff0c\u8bf7\u68c0\u67e5\u3002", "InvPlanPrepare_14", number));
        }
        if (!"C".equals(algoPlan.getString("status"))) {
            checkBuilder.append(InvPlanHelper.loadKDString("\u7b97\u6cd5\u65b9\u6848\uff08\u7f16\u7801\uff1a{0}\uff09\u672a\u5ba1\u6838\uff0c\u8bf7\u68c0\u67e5\u3002", "InvPlanPrepare_18", algoPlan.getString("number")));
        }
        if (algoPlan.getBoolean("batchcal")) {
            DynamicObjectCollection entries = algoPlan.getDynamicObjectCollection("entryentity");
            HashSet<String> algoType = new HashSet<String>();
            for (DynamicObject entry : entries) {
                algoType.add(entry.getDynamicObject("algorithm").getString("algotype"));
            }
            if (algoType.size() < 3) {
                checkBuilder.append(InvPlanHelper.loadKDString("\u7b97\u6cd5\u65b9\u6848\u542f\u7528\u5206\u6279\u8fd0\u7b97\u65f6\u5fc5\u987b\u5305\u542b\u8fd0\u7b97\u51c6\u5907\u3001\u8fd0\u7b97\u6267\u884c\u3001\u7ed3\u679c\u5904\u7406\u4e09\u79cd\u7c7b\u578b\u7684\u7b97\u6cd5\uff0c\u5f53\u524d\u7b97\u6cd5\u65b9\u6848\uff08\u7f16\u7801\uff1a{0}\uff09\u4e0d\u6ee1\u8db3\u6761\u4ef6\uff0c\u8bf7\u68c0\u67e5\u3002", "InvPlanPrepare_20", algoPlan.getString("number")));
            }
        }
        return checkBuilder.toString();
    }

    private String checkDemandOrgEntry(DynamicObjectCollection orgEntries) {
        StringBuilder msgBuilder = new StringBuilder();
        for (DynamicObject orgEntry : orgEntries) {
            DynamicObject invStrategy = orgEntry.getDynamicObject("entrysupplypolicy");
            msgBuilder.append(this.checkInvStrategy(invStrategy));
        }
        return msgBuilder.toString();
    }

    private String checkSupplyDsEntry(DynamicObjectCollection supplySrcEntries, DynamicObject supplyModelInfo) {
        StringBuilder msgBuilder = new StringBuilder();
        DynamicObjectCollection modelEntries = supplyModelInfo.getDynamicObjectCollection("entryentityds");
        HashSet<String> supplyEntitySet = new HashSet<String>(modelEntries.size());
        for (DynamicObject modelEntry : modelEntries) {
            supplyEntitySet.add(modelEntry.getDynamicObject("srcbillds").getString("number"));
        }
        Boolean hasDataSource = false;
        for (DynamicObject supplySrcEntry : supplySrcEntries) {
            DynamicObject entityInfo = supplySrcEntry.getDynamicObject("supplydatasrc");
            if (!supplyEntitySet.contains(entityInfo.getString("number"))) {
                msgBuilder.append(ResManager.loadKDString((String)"\u4f9b\u5e94\u53c2\u6570\u7684\u4f9b\u5e94\u6570\u636e\u6765\u6e90\u4e2d\u4f9b\u5e94\u6765\u6e90\u5b9e\u4f53-{0}\uff0c\u5df2\u4ece\u4f9b\u5e94\u6a21\u578b\u7684\u4f9b\u5e94\u6570\u636e\u6e90\u914d\u7f6e\u4e2d\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"InvPlanPrepare_6", (String)"scmc-invp-form", (Object[])new Object[]{entityInfo.getString("name")})).append("\n");
            }
            if (!supplySrcEntry.getBoolean("insupcal")) continue;
            hasDataSource = true;
        }
        if (!hasDataSource.booleanValue()) {
            msgBuilder.append(InvPlanHelper.loadKDString("\u4f9b\u5e94\u53c2\u6570\u65e0\u53c2\u4e0e\u8fd0\u7b97\u7684\u4f9b\u5e94\u6765\u6e90\u5b9e\u4f53\uff0c\u8bf7\u68c0\u67e5\u3002", "InvPlanPrepare_12", new Object[0])).append("\n");
        }
        return msgBuilder.toString();
    }

    private String checkDemandDsEntry(DynamicObjectCollection demandSrcEntries, DynamicObject demandModelInfo) {
        StringBuilder msgBuilder = new StringBuilder();
        DynamicObjectCollection modelEntries = demandModelInfo.getDynamicObjectCollection("entryentityds");
        HashSet<String> demandEntitySet = new HashSet<String>(modelEntries.size());
        for (DynamicObject modelEntry : modelEntries) {
            demandEntitySet.add(modelEntry.getDynamicObject("srcbillds").getString("number"));
        }
        Boolean hasDataSource = false;
        for (DynamicObject demandSrcEntry : demandSrcEntries) {
            DynamicObject entityInfo = demandSrcEntry.getDynamicObject("demandsrc");
            if (!demandEntitySet.contains(entityInfo.getString("number"))) {
                msgBuilder.append(ResManager.loadKDString((String)"\u9700\u6c42\u53c2\u6570\u7684\u9700\u6c42\u6570\u636e\u6765\u6e90\u4e2d\u9700\u6c42\u6765\u6e90\u5b9e\u4f53-{0}\uff0c\u5df2\u4ece\u9700\u6c42\u6a21\u578b\u7684\u9700\u6c42\u6570\u636e\u6e90\u914d\u7f6e\u4e2d\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"InvPlanPrepare_5", (String)"scmc-invp-form", (Object[])new Object[]{entityInfo.getString("name")})).append("\n");
            }
            if (!demandSrcEntry.getBoolean("indemcal")) continue;
            hasDataSource = true;
        }
        if (!hasDataSource.booleanValue()) {
            msgBuilder.append(InvPlanHelper.loadKDString("\u9700\u6c42\u53c2\u6570\u65e0\u53c2\u4e0e\u8fd0\u7b97\u7684\u9700\u6c42\u6765\u6e90\u5b9e\u4f53\uff0c\u8bf7\u68c0\u67e5\u3002", "InvPlanPrepare_11", new Object[0])).append("\n");
        }
        return msgBuilder.toString();
    }

    private String checkMatchMapConfig(DynamicObject matchMapConf) {
        StringBuilder msgBuilder = new StringBuilder();
        if ("0".equals(matchMapConf.getString("enable"))) {
            msgBuilder.append(ResManager.loadKDString((String)"\u5339\u914d\u6620\u5c04\u914d\u7f6e\uff08\u7f16\u7801\uff1a{0}\uff09\u5df2\u7981\u7528\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"InvPlanPrepare_7", (String)"scmc-invp-form", (Object[])new Object[]{matchMapConf.get("number")})).append("\n");
        }
        return msgBuilder.toString();
    }

    private String checkSupplyModel(DynamicObject supplyModelInfo) {
        StringBuilder msgBuilder = new StringBuilder();
        if ("0".equals(supplyModelInfo.getString("enable"))) {
            msgBuilder.append(ResManager.loadKDString((String)"\u4f9b\u5e94\u6a21\u578b\uff08\u7f16\u7801\uff1a{0}\uff09\u5df2\u7981\u7528\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"InvPlanPrepare_4", (String)"scmc-invp-form", (Object[])new Object[]{supplyModelInfo.get("number")})).append("\n");
        }
        DynamicObjectCollection modelEntries = supplyModelInfo.getDynamicObjectCollection("entryentityds");
        for (DynamicObject modelEntry : modelEntries) {
            DynamicObject billFieldMapInfo = modelEntry.getDynamicObject("billfieldmap");
            msgBuilder.append(this.checkFieldMapConfig(billFieldMapInfo));
        }
        msgBuilder.append(this.checkFieldMapConfig(supplyModelInfo.getDynamicObject("outputmappingsupply")));
        return msgBuilder.toString();
    }

    private String checkDemandModel(DynamicObject demandModelInfo) {
        StringBuilder msgBuilder = new StringBuilder();
        if ("0".equals(demandModelInfo.getString("enable"))) {
            msgBuilder.append(ResManager.loadKDString((String)"\u9700\u6c42\u6a21\u578b\uff08\u7f16\u7801\uff1a{0}\uff09\u5df2\u7981\u7528\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"InvPlanPrepare_2", (String)"scmc-invp-form", (Object[])new Object[]{demandModelInfo.get("number")})).append("\n");
        }
        DynamicObjectCollection modelEntries = demandModelInfo.getDynamicObjectCollection("entryentityds");
        for (DynamicObject modelEntry : modelEntries) {
            DynamicObject billFieldMapInfo = modelEntry.getDynamicObject("billfieldmap");
            if (billFieldMapInfo.getBoolean("isenable")) continue;
            msgBuilder.append(ResManager.loadKDString((String)"\u5b57\u6bb5\u6620\u5c04\u914d\u7f6e\uff08\u7f16\u7801\uff1a{0}\uff09\u5df2\u7981\u7528\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"InvPlanPrepare_3", (String)"scmc-invp-form", (Object[])new Object[]{billFieldMapInfo.get("number")})).append("\n");
        }
        msgBuilder.append(this.checkFieldMapConfig(demandModelInfo.getDynamicObject("outputresult")));
        return msgBuilder.toString();
    }

    private String checkInvStrategy(DynamicObject invStrategy) {
        StringBuilder msgBuilder = new StringBuilder();
        String enable = invStrategy.getString("enable");
        if ("0".equals(enable)) {
            msgBuilder.append(ResManager.loadKDString((String)"\u5e93\u5b58\u4f9b\u5e94\u7b56\u7565\uff08\u7f16\u7801\uff1a{0}\uff09\u5df2\u7981\u7528\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"InvPlanPrepare_1", (String)"scmc-invp-form", (Object[])new Object[]{invStrategy.get("number")})).append("\n");
        }
        return msgBuilder.toString();
    }

    private String checkInvLevel(DynamicObject invLevelInfo) {
        StringBuilder msgBuilder = new StringBuilder();
        if (invLevelInfo != null) {
            if ("0".equals(invLevelInfo.getString("enable"))) {
                msgBuilder.append(ResManager.loadKDString((String)"\u5e93\u5b58\u6c34\u4f4d\uff08\u7f16\u7801\uff1a{0}\uff09\u5df2\u7981\u7528\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"InvPlanPrepare_0", (String)"scmc-invp-form", (Object[])new Object[]{invLevelInfo.get("number")})).append("\n");
            }
            if (!"C".equals(invLevelInfo.getString("status"))) {
                msgBuilder.append(InvPlanHelper.loadKDString("\u5e93\u5b58\u6c34\u4f4d\uff08\u7f16\u7801\uff1a{0}\uff09\u672a\u5ba1\u6838\uff0c\u8bf7\u68c0\u67e5\u3002", "InvPlanPrepare_17", invLevelInfo.get("number"))).append("\n");
            }
        }
        return msgBuilder.toString();
    }

    private String checkFieldMapConfig(DynamicObject fieldMapConf) {
        StringBuilder msgBuilder = new StringBuilder();
        if (!fieldMapConf.getBoolean("isenable")) {
            msgBuilder.append(ResManager.loadKDString((String)"\u5b57\u6bb5\u6620\u5c04\u914d\u7f6e\uff08\u7f16\u7801\uff1a{0}\uff09\u5df2\u7981\u7528\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"InvPlanPrepare_3", (String)"scmc-invp-form", (Object[])new Object[]{fieldMapConf.get("number")})).append("\n");
        }
        return msgBuilder.toString();
    }

    private String checkOutPutEntry(DynamicObjectCollection outPutEntries) {
        StringBuilder msgBuilder = new StringBuilder();
        int seq = 0;
        for (DynamicObject outPutEntry : outPutEntries) {
            ++seq;
            if (!outPutEntry.getBoolean("autoput")) continue;
            DynamicObject botpInfo = outPutEntry.getDynamicObject("autoputbotp");
            if (botpInfo == null) {
                msgBuilder.append(ResManager.loadKDString((String)"\u6295\u653e\u53c2\u6570\u7b2c{0}\u884c\u5355\u636e\u8f6c\u6362\u89c4\u5219\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"InvPlanPrepare_8", (String)"scmc-invp-form", (Object[])new Object[]{seq})).append("\n");
                continue;
            }
            if (botpInfo.getBoolean("enabled")) continue;
            msgBuilder.append(ResManager.loadKDString((String)"\u5355\u636e\u8f6c\u6362\u89c4\u5219\uff08\u7f16\u7801\uff1a{0}\uff09\u5df2\u7981\u7528\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"InvPlanPrepare_9", (String)"scmc-invp-form", (Object[])new Object[]{botpInfo.get("number")})).append("\n");
        }
        return msgBuilder.toString();
    }

    private void initMatchResultInfo() {
        DynamicObject matchDetailInfo = BusinessDataServiceHelper.newDynamicObject((String)"invp_match_detail");
        matchDetailInfo.set("id", (Object)DB.genGlobalLongId());
        matchDetailInfo.set("plancalnum", (Object)this.ctx.getCalcNum());
        matchDetailInfo.set("planscheme", (Object)this.ctx.getSchemeId());
        matchDetailInfo.set("createdate", (Object)TimeServiceHelper.now());
        matchDetailInfo.set("planorg", (Object)this.ctx.getPlanOrg());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{matchDetailInfo});
        this.ctx.setMatchDetailId(matchDetailInfo.getLong("id"));
    }

    protected void buildInvPlanScheme(DynamicObject invPlanObj) {
        InvPlanScheme scheme = new InvPlanScheme(invPlanObj);
        this.ctx.setScheme(scheme);
    }

    private Boolean checkMutex() {
        DLock lock = this.ctx.getLock();
        if (!lock.tryLock()) {
            this.errorMsgBuilder.append(InvPlanHelper.loadKDString("\u5f53\u524d\u8ba1\u5212\u7ec4\u7ec7\u6b63\u5728\u8fdb\u884c\u5e93\u5b58\u8ba1\u5212\u8fd0\u7b97\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", "InvPlanPrepare_10", new Object[0]));
            this.stepResult.setStepResult(InvPlanLogConstants.STEP_RESULT_ERROR);
            return false;
        }
        return true;
    }
}

