/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.business.step.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.invp.business.step.AbstractInvPlanStep;
import kd.scmc.invp.common.helper.InvPlanHelper;

public class InvPlanStorePlanAdvise
extends AbstractInvPlanStep {
    @Override
    public void innerExecute() {
        this.storePlanAdvise();
    }

    private void storePlanAdvise() {
        Map<String, DynamicObject> planAdviseMap = this.ctx.getPlanAdviseMap();
        ArrayList<DynamicObject> planAdvises = new ArrayList<DynamicObject>(planAdviseMap.values());
        this.processDataCount = this.processDataCount + planAdvises.size();
        this.ctx.getMatchResultHelper().saveEntry();
        List<Object> resultIds = this.savePlanPlanResult(planAdvises);
        this.autoAuditResult(resultIds);
    }

    private void autoAuditResult(List<Object> resultIds) {
        if (this.ctx.getScheme().getAutoAudit().booleanValue() && !resultIds.isEmpty()) {
            String resultName = MetadataServiceHelper.getDataEntityType((String)"invp_plan_advice").getDisplayName().getLocaleValue();
            this.infoMsgBuilder.append(InvPlanHelper.loadKDString("\u63d0\u4ea4\u7684{0}\u6570\u91cf\uff1a{1}\u6761", "InvPlanStorePlanAdvise_4", resultName, resultIds.size())).append("\n");
            String message = InvPlanHelper.loadKDString("{0}\u63d0\u4ea4\u5931\u8d25\uff1a", "InvPlanStorePlanAdvise_2", resultName);
            Set<Object> submitIds = InvPlanHelper.doBillOperation("submit", "invp_plan_advice", resultIds.toArray(), message, this.errorMsgBuilder);
            if (!submitIds.isEmpty()) {
                this.infoMsgBuilder.append(InvPlanHelper.loadKDString("\u5ba1\u6838\u7684{0}\u6570\u91cf\uff1a{1}\u6761", "InvPlanStorePlanAdvise_5", resultName, submitIds.size())).append("\n");
                message = InvPlanHelper.loadKDString("{0}\u5ba1\u6838\u5931\u8d25\uff1a", "InvPlanStorePlanAdvise_3", resultName);
                Set<Object> auditIds = InvPlanHelper.doBillOperation("audit", "invp_plan_advice", submitIds.toArray(), message, this.errorMsgBuilder);
                this.ctx.getAuditAdviseIds().addAll(auditIds);
            }
        }
    }

    private List<Object> savePlanPlanResult(List<DynamicObject> planResults) {
        String entityName = MetadataServiceHelper.getDataEntityType((String)"invp_plan_advice").getDisplayName().getLocaleValue();
        this.infoMsgBuilder.append(InvPlanHelper.loadKDString("\u4fdd\u5b58\u7684{0}\u6570\u91cf\uff1a{1}\u6761\u3002", "InvPlanStorePlanAdvise_0", entityName, planResults.size())).append("\n");
        List<Object> successPkIds = new ArrayList<Object>();
        if (planResults.isEmpty()) {
            return successPkIds;
        }
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                OperationResult result = SaveServiceHelper.saveOperate((String)"invp_plan_advice", (DynamicObject[])planResults.toArray(new DynamicObject[0]));
                if (!result.isSuccess()) {
                    String saveErrorMsg = InvPlanHelper.getBillOperateErrorMsg(result);
                    this.errorMsgBuilder.append(InvPlanHelper.loadKDString("{0}\u4fdd\u5b58\u5931\u8d25\uff1a", "InvPlanStorePlanAdvise_1", entityName)).append("\n");
                    this.errorMsgBuilder.append(saveErrorMsg);
                } else {
                    successPkIds = result.getSuccessPkIds();
                }
                this.processMatchDetail(result);
            }
            catch (Throwable e) {
                this.errorMsgBuilder.append(InvPlanHelper.loadKDString("{0}\u4fdd\u5b58\u5931\u8d25\uff1a", "InvPlanStorePlanAdvise_1", entityName)).append("\n");
                this.errorMsgBuilder.append(InvPlanHelper.getExceptionMessage(e));
                txHandle.markRollback();
            }
        }
        planResults.clear();
        return successPkIds;
    }

    private void processMatchDetail(OperationResult result) {
        Map<String, String> errorMap = null;
        if (!result.isSuccess()) {
            List allErrorOrValidateInfo = result.getAllErrorOrValidateInfo();
            errorMap = InvPlanHelper.getOperateErrorMsg(allErrorOrValidateInfo);
        }
        Map billNos = result.getBillNos();
        HashSet<String> adviseIdSet = new HashSet<String>();
        if (errorMap != null) {
            adviseIdSet.addAll(errorMap.keySet());
        }
        adviseIdSet.addAll(billNos.keySet().stream().map(id -> id.toString()).collect(Collectors.toList()));
        Long matchResultId = this.ctx.getMatchDetailId();
        QFilter filter = new QFilter("id", "=", (Object)matchResultId).and("entryentity.supplybilltype", "=", (Object)"invp_plan_advice").and("entryentity.supplybillno", "in", adviseIdSet);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"invp_match_detail", (String)"entryentity.id,entryentity.supplybillno", (QFilter[])filter.toArray(), (String)"");
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        for (Row row : dataSet) {
            Object[] param = new Object[4];
            Long entryId = row.getLong("entryentity.id");
            String supplyBillId = row.getString("entryentity.supplybillno");
            param[0] = supplyBillId;
            boolean needUpdate = false;
            if (billNos.containsKey(supplyBillId)) {
                needUpdate = true;
                param[0] = billNos.get(supplyBillId);
            }
            param[1] = "";
            param[2] = "";
            if (errorMap != null && errorMap.containsKey(supplyBillId)) {
                needUpdate = true;
                String errMsg = errorMap.get(supplyBillId);
                param[2] = errMsg;
                if (errMsg.length() > 50) {
                    errMsg = errMsg.substring(0, 50);
                }
                param[1] = errMsg;
            }
            param[3] = entryId;
            if (!needUpdate) continue;
            paramList.add(param);
        }
        if (!paramList.isEmpty()) {
            String sql = "UPDATE T_INVP_MATCHDETAIL_ENTRY SET FSUPPLYBILLNO = ? ,FEXCEPTION = FEXCEPTION||?,FEXCEPTION_TAG = FEXCEPTION_TAG||?  WHERE FENTRYID = ?;";
            DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)sql, paramList);
        }
    }
}

