/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.business.step.strategy;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.scmc.invp.business.step.strategy.IInvPlanStrategy;

public class InvPlanPeriodicStrategy
implements IInvPlanStrategy {
    @Override
    public BigDecimal calcOrderQty(BigDecimal usableBaseQty, DynamicObject invLevelInfo) {
        BigDecimal dailyConsume = invLevelInfo.getBigDecimal("dailyconsume");
        BigDecimal tarInvDay = invLevelInfo.getBigDecimal("tgtinvdays");
        return dailyConsume.multiply(tarInvDay).subtract(usableBaseQty);
    }

    @Override
    public Boolean needCreateAdvise(BigDecimal usableBaseQty, DynamicObject invLevelInfo) {
        BigDecimal urgentInvDays = invLevelInfo.getBigDecimal("urgentinvdays");
        BigDecimal dailyConsume = invLevelInfo.getBigDecimal("dailyconsume");
        if (usableBaseQty.compareTo(dailyConsume.multiply(urgentInvDays)) <= 0) {
            return true;
        }
        String supplyType = invLevelInfo.getString("supplytype");
        List supplyDay = (List)invLevelInfo.get("supplyday");
        Calendar calendar = Calendar.getInstance();
        if ("A".equals(supplyType)) {
            Set<Integer> weekDay = this.transWeekDay(supplyDay);
            return weekDay.contains(calendar.get(7));
        }
        if ("B".equals(supplyType)) {
            return supplyDay.contains(calendar.get(5));
        }
        return false;
    }

    @Override
    public BigDecimal calcOccupyQty(DynamicObject invLevelInfo) {
        BigDecimal dailyConsume = invLevelInfo.getBigDecimal("dailyconsume");
        BigDecimal tarInvDay = invLevelInfo.getBigDecimal("tgtinvdays");
        return dailyConsume.multiply(tarInvDay);
    }

    private Set<Integer> transWeekDay(List<Integer> supplyDays) {
        HashSet<Integer> weekDays = new HashSet<Integer>(supplyDays.size());
        for (Integer supplyDay : supplyDays) {
            int weekDay = -1;
            switch (supplyDay) {
                case 1: {
                    weekDay = 2;
                    break;
                }
                case 2: {
                    weekDay = 3;
                    break;
                }
                case 3: {
                    weekDay = 4;
                    break;
                }
                case 4: {
                    weekDay = 5;
                    break;
                }
                case 5: {
                    weekDay = 6;
                    break;
                }
                case 6: {
                    weekDay = 7;
                    break;
                }
                case 7: {
                    weekDay = 1;
                    break;
                }
            }
            weekDays.add(weekDay);
        }
        return weekDays;
    }
}

