/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.common.consts;

import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class InventoryDimension
implements Serializable {
    private Set<Entry> entrys;
    private List<String> entityNames;

    public InventoryDimension(Object id) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", id)};
        this._init(filters);
    }

    public InventoryDimension(String org, String number) {
        QFilter[] filters = new QFilter[]{new QFilter("createorg.number", "=", (Object)org), new QFilter("number", "=", (Object)number)};
        this._init(filters);
    }

    public InventoryDimension() {
        this._init(null);
    }

    private void _init(QFilter[] filters) {
        this.entrys = new LinkedHashSet<Entry>(3);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"InventoryLevelBasePlugin.getElementList", (String)"msplan_plan_dimension", (String)"entryentity.dimensionname,entryentity.associationobject", (QFilter[])filters, (String)"entryentity.seq");){
            for (Row d : ds) {
                String name = d.getString(0);
                String entity = d.getString(1);
                this.addEntry(name, entity);
            }
        }
        this.entrys = this.entrys.stream().sorted(Comparator.comparing(Entry::getEntityName).reversed()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private void addEntry(String displayName, String entityName) {
        Entry entry = new Entry(displayName, entityName);
        this.entrys.add(entry);
    }

    public boolean exist(String entityName) {
        return this.getEntityNames().contains(entityName);
    }

    public List<String> getEntityNames() {
        if (this.entityNames == null) {
            this.entityNames = this.entrys.stream().map(Entry::getEntityName).collect(Collectors.toList());
        }
        return this.entityNames;
    }

    public Map<String, String> getEntityToNameMap() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(8);
        for (Entry entry : this.entrys) {
            map.put(entry.entityName, entry.displayName);
        }
        return map;
    }

    public boolean hasMt() {
        List<String> entityNames = this.getEntityNames();
        return entityNames.contains("bd_material");
    }

    public boolean hasGrp() {
        List<String> entityNames = this.getEntityNames();
        return entityNames.contains("bd_materialgroup");
    }

    public boolean hasMtAndGrp() {
        List<String> entityNames = this.getEntityNames();
        return entityNames.contains("bd_material") && entityNames.contains("bd_materialgroup");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InventoryDimension that = (InventoryDimension)o;
        if (that.entrys.size() != this.entrys.size()) {
            return false;
        }
        return that.entrys.containsAll(this.entrys);
    }

    public int hashCode() {
        return Objects.hash(this.entrys);
    }

    public int getIndex(String type) {
        return this.getEntityNames().indexOf(type);
    }

    public Map<String, Integer> getIndex() {
        HashMap<String, Integer> map = new HashMap<String, Integer>(8);
        List<String> entityNames = this.getEntityNames();
        for (int i = 0; i < entityNames.size(); ++i) {
            map.put(entityNames.get(i), i);
        }
        return map;
    }

    public static class Entry
    implements Serializable {
        static final long serialVersionUID = 42L;
        private String displayName;
        private String type = "A";
        private String entityName;

        public Entry(String displayName, String entityName) {
            this.displayName = displayName;
            this.entityName = entityName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getEntityName() {
            return this.entityName;
        }

        public void setEntityName(String entityName) {
            this.entityName = entityName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            return Objects.equals(this.entityName, entry.entityName);
        }

        public int hashCode() {
            return Objects.hash(this.entityName);
        }
    }
}

