/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.common.helper;

import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import org.apache.commons.lang3.StringUtils;

public class BalKeyHelper {
    static String calKeyStr(Row row, List<String> keyCols) {
        StringBuilder sb = new StringBuilder();
        for (String keyCol : keyCols) {
            Object value = row.get(keyCol);
            if (BalKeyHelper.isDbDefaultValue(value)) continue;
            sb.append(keyCol).append(':').append(value).append(',');
        }
        return BalKeyHelper.getKeyStr(sb.toString());
    }

    public static String calKeyStr(Map<String, Object> dimensionMap) {
        StringBuilder sb = new StringBuilder();
        List keyCols = dimensionMap.keySet().stream().sorted().collect(Collectors.toList());
        for (String keyCol : keyCols) {
            if ("invlevelid".equals(keyCol)) continue;
            Object value = dimensionMap.get(keyCol);
            if (value instanceof DynamicObject) {
                value = ((DynamicObject)value).getPkValue();
            }
            if (BalKeyHelper.isDbDefaultValue(value)) continue;
            sb.append(keyCol).append(':').append(value).append(',');
        }
        return BalKeyHelper.getKeyStr(sb.toString());
    }

    private static boolean isDbDefaultValue(Object value) {
        if (value == null) {
            return true;
        }
        if (value.getClass() == String.class) {
            return StringUtils.isBlank((CharSequence)((String)value));
        }
        if (value.getClass() == BigDecimal.class) {
            return ((BigDecimal)value).compareTo(BigDecimal.ZERO) == 0;
        }
        return value.toString().equals("0");
    }

    static String getKeyStr(String message) {
        return BalKeyHelper.getSHA256Base64Str(message);
    }

    private static String getSHA256Base64Str(String message) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(message.getBytes(StandardCharsets.UTF_8));
            byte[] computation = digest.digest();
            return Base64.getEncoder().encodeToString(computation);
        }
        catch (NoSuchAlgorithmException e1) {
            throw new KDBizException(String.format("BalanceUtil:[%s] args:[%s]", e1.getMessage(), message));
        }
    }
}

