/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.common.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.invp.business.bean.DacExceptionFilter;
import kd.scmc.invp.business.bean.DacSummaryInfo;
import kd.scmc.invp.business.bean.DateRangeFilter;
import kd.scmc.invp.common.helper.BalKeyHelper;
import kd.scmc.invp.common.helper.InvPlanHelper;
import kd.scmc.invp.common.helper.ModelFilterHelper;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.apache.commons.lang3.StringUtils;

public class DacModelHelper {
    private static final Log log = LogFactory.getLog(DacModelHelper.class);

    public static void calc(Object schemeId, List<Object> invLevelIdList) {
        DynamicObject dacSchemeDym = BusinessDataServiceHelper.loadSingleFromCache((Object)schemeId, (String)"invp_dailyavgcomsumption");
        DynamicObject matchDimensionDym = ModelFilterHelper.loadFullDym(dacSchemeDym.getDynamicObject("matchdimension"));
        DynamicObject modelDym = ModelFilterHelper.loadFullDym(dacSchemeDym.getDynamicObject("consumptionmodel"));
        Map<String, QFilter> srcFilterMap = ModelFilterHelper.buildSrcDataFilter(modelDym);
        Map<String, String> selectFieldMap = ModelFilterHelper.buildSelectFields(modelDym);
        MultiKeyMap<String, BidiMap<String, String>> fieldMap = ModelFilterHelper.buildFieldMap(modelDym);
        BidiMap<String, String> resultFieldMap = ModelFilterHelper.buildDimensionFieldMap();
        List<DateRangeFilter> dateRangeFilterList = DacModelHelper.buildDateRangeFilter(dacSchemeDym);
        ArrayList<DynamicObject> recordList = new ArrayList<DynamicObject>(4);
        List<Map<String, Object>> dimensionList = ModelFilterHelper.getDimensionMap(dacSchemeDym, invLevelIdList);
        DynamicObjectCollection exceptionEntry = dacSchemeDym.getDynamicObjectCollection("exceptionentry");
        HashMap<String, DacSummaryInfo> summaryInfoMap = new HashMap<String, DacSummaryInfo>(dimensionList.size());
        if (CollectionUtils.isNotEmpty((Collection)exceptionEntry)) {
            for (Map<String, Object> map : dimensionList) {
                HashMap<String, QFilter> hashMap = new HashMap<String, QFilter>();
                Set<Map.Entry<String, QFilter>> entrySet = srcFilterMap.entrySet();
                String keycol = BalKeyHelper.calKeyStr(map);
                DacSummaryInfo dacSummaryInfo = new DacSummaryInfo();
                for (DateRangeFilter dateRangeFilter : dateRangeFilterList) {
                    for (Map.Entry<String, QFilter> entry : entrySet) {
                        String entityKey = entry.getKey();
                        QFilter srcFilter = entry.getValue();
                        QFilter dimensionQFilter = ModelFilterHelper.buildModelDimensionQFilter(matchDimensionDym, map, (BidiMap<String, String>)((BidiMap)fieldMap.get((Object)"invp_dac_model", (Object)entityKey)));
                        String string = (String)((BidiMap)fieldMap.get((Object)"invp_dac_model", (Object)entityKey)).get((Object)"billdate");
                        QFilter mergeFilter = ModelFilterHelper.mergeFilter(srcFilter, dimensionQFilter, dateRangeFilter.getQFilter(string));
                        hashMap.put(entityKey, mergeFilter);
                    }
                    DataSet dataSet = ModelFilterHelper.loadUnionDataSet(srcFilterMap.keySet(), selectFieldMap, hashMap);
                    Throwable throwable = null;
                    try {
                        while (dataSet.hasNext()) {
                            Row row = dataSet.next();
                            BigDecimal baseQty = row.getBigDecimal("baseqty");
                            dacSummaryInfo.add(baseQty);
                        }
                    }
                    catch (Throwable row) {
                        Throwable throwable2 = row;
                        throw row;
                    }
                    finally {
                        if (dataSet == null) continue;
                        if (throwable != null) {
                            try {
                                dataSet.close();
                            }
                            catch (Throwable row) {
                                throwable.addSuppressed(row);
                            }
                            continue;
                        }
                        dataSet.close();
                    }
                }
                summaryInfoMap.put(keycol, dacSummaryInfo);
            }
        }
        HashMap<Object, BigDecimal> updateLevelMap = new HashMap<Object, BigDecimal>(dimensionList.size() * 2);
        for (Map<String, Object> map : dimensionList) {
            HashMap<String, QFilter> qFilterMap = new HashMap<String, QFilter>();
            Set<Map.Entry<String, QFilter>> entrySet = srcFilterMap.entrySet();
            BigDecimal dacQty = new BigDecimal(0);
            String keycol = BalKeyHelper.calKeyStr(map);
            DacSummaryInfo summaryInfo = (DacSummaryInfo)summaryInfoMap.get(keycol);
            BigDecimal avgQty = null != summaryInfo ? summaryInfo.avg() : BigDecimal.ZERO;
            List<DacExceptionFilter> list = DacModelHelper.buildDacExceptionFilterList(dacSchemeDym, avgQty);
            for (DateRangeFilter dateRangeFilter : dateRangeFilterList) {
                for (Map.Entry entry : entrySet) {
                    String entityKey = (String)entry.getKey();
                    QFilter srcFilter = (QFilter)entry.getValue();
                    QFilter dimensionQFilter = ModelFilterHelper.buildModelDimensionQFilter(matchDimensionDym, map, (BidiMap<String, String>)((BidiMap)fieldMap.get((Object)"invp_dac_model", (Object)entityKey)));
                    String dateField = (String)((BidiMap)fieldMap.get((Object)"invp_dac_model", (Object)entityKey)).get((Object)"billdate");
                    QFilter mergeFilter = ModelFilterHelper.mergeFilter(srcFilter, dimensionQFilter, dateRangeFilter.getQFilter(dateField));
                    qFilterMap.put(entityKey, mergeFilter);
                }
                BigDecimal summaryQty = new BigDecimal(0);
                try (DataSet dataSet = ModelFilterHelper.loadUnionDataSet(srcFilterMap.keySet(), selectFieldMap, qFilterMap);){
                    while (dataSet.hasNext()) {
                        Row row = dataSet.next();
                        boolean isAdd = true;
                        BigDecimal baseQty = row.getBigDecimal("baseqty");
                        for (DacExceptionFilter dacExceptionFilter : list) {
                            if (!dacExceptionFilter.isFilterData(row, baseQty)) continue;
                            isAdd = false;
                            break;
                        }
                        if (!isAdd) continue;
                        summaryQty = summaryQty.add(baseQty);
                    }
                }
                summaryQty = summaryQty.multiply(dateRangeFilter.getFactor());
                BigDecimal bigDecimal = summaryQty.divide(dateRangeFilter.getPeriodDays(), 4, 4);
                dacQty = dacQty.add(bigDecimal);
            }
            BigDecimal adjustfactor = dacSchemeDym.getBigDecimal("adjustfactor");
            if (BigDecimal.ONE.compareTo(adjustfactor) != 0) {
                dacQty = dacQty.multiply(adjustfactor).setScale(4, 4);
            }
            dacQty = dacQty.setScale(2, 4);
            InvPlanHelper.maxValueCheck(dacQty);
            Object invLevelId = map.get("invlevelid");
            updateLevelMap.put(invLevelId, dacQty);
            DynamicObject record = DacModelHelper.buildRecord(resultFieldMap, map, dacSchemeDym, dacQty);
            recordList.add(record);
        }
        String string = dacSchemeDym.getString("updatetype");
        DacModelHelper.saveDacRecord(recordList, "A".equals(string));
        DacModelHelper.updateInvLevelInfo(dacSchemeDym, updateLevelMap);
    }

    @Deprecated
    public static void updateLogStatus(Object masterId, Object subTaskNo, String status, Date execTime, Exception e) {
        long cost = System.currentTimeMillis() - execTime.getTime();
        QFilter filter = new QFilter("subtaskno", "=", (Object)subTaskNo.toString());
        filter.and("mastertaskno", "=", (Object)masterId.toString());
        DynamicObject task = BusinessDataServiceHelper.loadSingle((String)"invp_dac_callog", (QFilter[])filter.toArray());
        task.set("status", (Object)status);
        task.set("subtaskstart", (Object)execTime);
        task.set("msgusertime", (Object)cost);
        if (e != null) {
            String errMsg = DacModelHelper.parseMsg(e);
            task.set("errormsg", (Object)(errMsg.length() > 1500 ? errMsg.substring(0, 1500) : errMsg));
            task.set("errormsg_tag", (Object)errMsg);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{task});
    }

    private static String parseMsg(Exception e) {
        StackTraceElement[] stackTrace;
        StringBuilder msgStr = new StringBuilder();
        msgStr.append(e.getMessage());
        for (StackTraceElement stackTraceElement : stackTrace = e.getStackTrace()) {
            msgStr.append("\r\n at ").append(stackTraceElement);
        }
        return msgStr.toString();
    }

    private static void updateInvLevelInfo(DynamicObject dacSchemeDym, Map<Object, BigDecimal> updateLevelMap) {
        DynamicObject[] invLevels;
        String planType = dacSchemeDym.getString("mainplantype");
        String invleveFieldKey = dacSchemeDym.getString("invlevelfieldkey");
        if (StringUtils.isBlank((CharSequence)invleveFieldKey)) {
            log.info("\u6ca1\u6709\u914d\u7f6e\u5e93\u5b58\u6c34\u4f4d\u4fe1\u606f\u5b57\u6bb5\uff0c\u65e0\u9700\u66f4\u65b0");
            return;
        }
        Set<String> selectFields = DacModelHelper.buildSelectedFields(invleveFieldKey);
        for (DynamicObject invLevel : invLevels = BusinessDataServiceHelper.load((String)"invp_invlevel", (String)String.join((CharSequence)",", selectFields), (QFilter[])new QFilter("id", "in", updateLevelMap.keySet()).toArray())) {
            Object pkValue = invLevel.getPkValue();
            BigDecimal dacQty = updateLevelMap.get(pkValue);
            invLevel.set(invleveFieldKey, (Object)dacQty);
            DacModelHelper.reCalFieldsValue(invLevel, planType);
        }
        SaveServiceHelper.update((DynamicObject[])invLevels, (OperateOption)OperateOption.create());
    }

    private static Set<String> buildSelectedFields(String invLevelField) {
        HashSet<String> selectFields = new HashSet<String>(6);
        selectFields.add("reorder");
        selectFields.add("safeinv");
        selectFields.add("leadtime");
        selectFields.add("dailyconsume");
        selectFields.add(invLevelField);
        selectFields.add("id");
        return selectFields;
    }

    private static void reCalFieldsValue(DynamicObject invLevel, String planType) {
        BigDecimal dacQty = invLevel.getBigDecimal("dailyconsume");
        if ("A".equals(planType) && dacQty.compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal safeInv = invLevel.getBigDecimal("safeinv");
            BigDecimal leadTime = invLevel.getBigDecimal("leadtime");
            BigDecimal reOrder = safeInv.add(leadTime.multiply(dacQty)).setScale(2, RoundingMode.HALF_UP);
            InvPlanHelper.maxValueCheck(reOrder);
            invLevel.set("reorder", (Object)reOrder);
        }
    }

    private static DynamicObject buildRecord(BidiMap<String, String> resultFieldMap, Map<String, Object> dimensionMap, DynamicObject schemaDym, BigDecimal dailAvgCnt) {
        DynamicObject record = BusinessDataServiceHelper.newDynamicObject((String)"invp_dac_record");
        record.set("schema", (Object)schemaDym);
        record.set("createtime", (Object)new Date());
        record.set("consumeperday", (Object)dailAvgCnt);
        for (Map.Entry<String, Object> dimensionEntry : dimensionMap.entrySet()) {
            String dimensionField = dimensionEntry.getKey();
            if ("invlevelid".equals(dimensionField)) continue;
            String recordField = (String)resultFieldMap.get((Object)dimensionField);
            Object val = dimensionEntry.getValue();
            record.set(recordField, val);
        }
        String keycol = BalKeyHelper.calKeyStr(dimensionMap);
        record.set("keycol", (Object)keycol);
        return record;
    }

    private static List<DacExceptionFilter> buildDacExceptionFilterList(DynamicObject dacSchemeDym, BigDecimal avgBaseQty) {
        DynamicObjectCollection cfgRows = dacSchemeDym.getDynamicObjectCollection("exceptionentry");
        ArrayList<DacExceptionFilter> filterList = new ArrayList<DacExceptionFilter>(cfgRows.size());
        for (DynamicObject cfgRow : cfgRows) {
            String filter = cfgRow.getString("preruleformula_tag");
            BigDecimal overpercent = cfgRow.getBigDecimal("overpercent");
            BigDecimal underpercent = cfgRow.getBigDecimal("underpercent");
            DacExceptionFilter dacExceptionFilter = new DacExceptionFilter("invp_dac_model", filter, avgBaseQty, overpercent, underpercent);
            filterList.add(dacExceptionFilter);
        }
        return filterList;
    }

    private static void saveDacRecord(List<DynamicObject> records, boolean isAppend) {
        if (isAppend) {
            log.info("\u8ffd\u52a0\u5199\u5165\u65e5\u5fd7\u8bb0\u5f55\uff0c\u603b\u8ba1 {} \u6761", (Object)records.size());
            SaveServiceHelper.save((DynamicObject[])records.toArray(new DynamicObject[0]));
            return;
        }
        ArrayList<DynamicObject> updateRecordList = new ArrayList<DynamicObject>(records.size());
        Iterator<DynamicObject> iterator = records.iterator();
        HashSet<Long> oldIds = new HashSet<Long>(records.size());
        while (iterator.hasNext()) {
            DynamicObject record = iterator.next();
            Long pkId = DacModelHelper.findHistory(record);
            if (null == pkId) continue;
            record.set("id", (Object)pkId);
            updateRecordList.add(record);
            oldIds.add(pkId);
            iterator.remove();
        }
        if (CollectionUtils.isNotEmpty(updateRecordList)) {
            log.info("\u8986\u84cb\u5199\u5165\u65e5\u5fd7\u8bb0\u5f55\uff0c\u603b\u8ba1 {} \u6761", (Object)updateRecordList.size());
            try (TXHandle txHandle = TX.requiresNew();){
                try {
                    DeleteServiceHelper.delete((String)"invp_dac_record", (QFilter[])new QFilter("id", "in", oldIds).toArray());
                    SaveServiceHelper.save((DynamicObject[])updateRecordList.toArray(new DynamicObject[0]));
                }
                catch (Exception exception) {
                    log.error("\u66f4\u65b0\u73b0\u6709\u65e5\u5747\u6d88\u8017\u91cf\u5931\u8d25\uff0c\u5b89\u5168\u5e93\u5b58id\uff1a{}", oldIds);
                }
            }
        }
        if (CollectionUtils.isNotEmpty(records)) {
            log.info("\u65b0\u589e\u5199\u5165\u65e5\u5fd7\u8bb0\u5f55\uff0c\u603b\u8ba1 {} \u6761", (Object)records.size());
            SaveServiceHelper.save((DynamicObject[])records.toArray(new DynamicObject[0]));
        }
    }

    private static Long findHistory(DynamicObject record) {
        QFilter filter = DacModelHelper.buildRecordQFilter(record);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"invp_dac_record", (String)"id", (QFilter[])filter.toArray());
        if (null != dynamicObject) {
            return dynamicObject.getLong("id");
        }
        return null;
    }

    private static QFilter buildRecordQFilter(DynamicObject dynamicObject) {
        String keycol = dynamicObject.getString("keycol");
        Long schemaId = dynamicObject.getDynamicObject("schema").getLong("id");
        QFilter qFilter = new QFilter("keycol", "=", (Object)keycol);
        qFilter.and("schema", "=", (Object)schemaId);
        return qFilter;
    }

    private static List<DateRangeFilter> buildDateRangeFilter(DynamicObject cfgDym) {
        Date today = KDDateUtils.today();
        ArrayList<DateRangeFilter> filterList = new ArrayList<DateRangeFilter>(4);
        DynamicObjectCollection rows = cfgDym.getDynamicObjectCollection("matchentry");
        for (DynamicObject row : rows) {
            Integer preYear = row.getInt("dateselector");
            Integer start = row.getInt("begindate");
            Integer end = row.getInt("enddate");
            BigDecimal factor = row.getBigDecimal("factor");
            DateRangeFilter dateRangeFilter = new DateRangeFilter(today, preYear, start, end, factor);
            filterList.add(dateRangeFilter);
        }
        return filterList;
    }
}

