/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.common.helper;

import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.BillTreeBuildParameter;
import kd.bos.designer.botp.EntityParseHelper;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.treebuilder.EntityFieldTreeBuildOption;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.scmc.invp.business.IColsSelectStrategy;
import kd.scmc.invp.common.colsassist.SelectParams;
import kd.scmc.invp.common.consts.PropertyDataType;
import kd.scmc.invp.common.helper.MetaHelper;
import org.apache.commons.lang3.ObjectUtils;

public class FormShowHelper {
    public static void showFilterForm(AbstractFormPlugin formPlugin, IDataModel dataModel, String entityNumber, String filterJsonKey, String closeCallBackActionId) {
        String filterJson = dataModel.getDataEntity().getString(filterJsonKey);
        String filedNodes = formPlugin.getPageCache().get("fieldnodes");
        String entityNumberCache = formPlugin.getPageCache().get("entitynumbercachekey");
        if (StringUtils.isEmpty((CharSequence)entityNumberCache) || !entityNumberCache.equals(entityNumber)) {
            formPlugin.getPageCache().put("entitynumbercachekey", entityNumber);
            filedNodes = "";
        }
        if (StringUtils.isBlank((CharSequence)filedNodes)) {
            MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
            BillTreeBuildParameter parameter = new BillTreeBuildParameter(entityType);
            parameter.setOnlyPhysicsField(false);
            TreeNode treeNode = EntityParseHelper.buildBillTreeNodes((BillTreeBuildParameter)parameter);
            filedNodes = SerializationUtils.toJsonString((Object)treeNode);
            formPlugin.getPageCache().put("fieldnodes", filedNodes);
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("assigncfg_filtercondition");
        showParameter.setCaption(ResManager.loadKDString((String)"\u8fc7\u6ee4\u6761\u4ef6", (String)"FormShowHelper_0", (String)"scmc-invp-form", (Object[])new Object[0]));
        showParameter.getCustomParams().put("formula", filterJson);
        showParameter.getCustomParams().put("entitynumber", entityNumber);
        showParameter.getCustomParams().put("treenodes", filedNodes);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)formPlugin, closeCallBackActionId));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        IFormView view = formPlugin.getView();
        view.showForm(showParameter);
    }

    public static void showEntryFilterForm(AbstractFormPlugin formPlugin, IDataModel dataModel, String entityNumber, int currentRowIndex, String filterJsonKey, String closeCallBackActionId) {
        String filterJson = (String)dataModel.getValue(filterJsonKey, currentRowIndex);
        String filedNodes = formPlugin.getPageCache().get("fieldnodes");
        String entityNumberCache = formPlugin.getPageCache().get("entitynumbercachekey");
        if (StringUtils.isEmpty((CharSequence)entityNumberCache) || !entityNumberCache.equals(entityNumber)) {
            formPlugin.getPageCache().put("entitynumbercachekey", entityNumber);
            filedNodes = "";
        }
        if (StringUtils.isBlank((CharSequence)filedNodes)) {
            MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
            BillTreeBuildParameter parameter = new BillTreeBuildParameter(entityType);
            parameter.setOnlyPhysicsField(false);
            TreeNode treeNode = EntityParseHelper.buildBillTreeNodes((BillTreeBuildParameter)parameter);
            filedNodes = SerializationUtils.toJsonString((Object)treeNode);
            formPlugin.getPageCache().put("fieldnodes", filedNodes);
        }
        formPlugin.getPageCache().put("rowIndex", String.valueOf(currentRowIndex));
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("assigncfg_filtercondition");
        showParameter.setCaption(ResManager.loadKDString((String)"\u8fc7\u6ee4\u6761\u4ef6", (String)"FormShowHelper_0", (String)"scmc-invp-form", (Object[])new Object[0]));
        showParameter.getCustomParams().put("formula", filterJson);
        showParameter.getCustomParams().put("entitynumber", entityNumber);
        showParameter.getCustomParams().put("treenodes", filedNodes);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)formPlugin, closeCallBackActionId));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        IFormView view = formPlugin.getView();
        view.showForm(showParameter);
    }

    public static void closeCallSetFilter(IDataModel dataModel, IPageCache pageCache, String returnData, String filterDesc, String filterJson, String filterFormula) {
        CRCondition crCondition = (CRCondition)SerializationUtils.fromJsonString((String)returnData, CRCondition.class);
        String entityNumCache = pageCache.get("entitynumbercachekey");
        FilterBuilder filterBuilder = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)entityNumCache), crCondition.getFilterCondition());
        filterBuilder.buildFilter(false);
        String[] scripts = filterBuilder.buildFilterScript();
        String expression = scripts[0];
        String advExpression = crCondition.getExpression();
        if (StringUtils.isNotBlank((CharSequence)expression) && StringUtils.isNotBlank((CharSequence)advExpression)) {
            expression = expression + " and (" + advExpression + ")";
        } else if (StringUtils.isBlank((CharSequence)expression) && StringUtils.isNotBlank((CharSequence)advExpression)) {
            expression = advExpression;
        }
        String exprTran = crCondition.getExprTran() == null ? "" : crCondition.getExprTran();
        String destValueShow = exprTran.length() > 300 ? exprTran.substring(0, 297) + "..." : exprTran;
        dataModel.setValue(filterDesc, (Object)destValueShow);
        dataModel.setValue(filterJson, (Object)returnData);
        dataModel.setValue(filterFormula, (Object)expression);
    }

    public static void closeCallSetEntryFilter(IDataModel dataModel, IPageCache pageCache, String returnData, String filterField, String filterJsonField, String filterFormulaField) {
        CRCondition crCondition = (CRCondition)SerializationUtils.fromJsonString((String)returnData, CRCondition.class);
        String entityNumCache = pageCache.get("entitynumbercachekey");
        FilterBuilder filterBuilder = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)entityNumCache), crCondition.getFilterCondition());
        filterBuilder.buildFilter(false);
        String[] scripts = filterBuilder.buildFilterScript();
        String exprTran = crCondition.getExprTran() == null ? "" : crCondition.getExprTran();
        String destValueShow = exprTran.length() > 300 ? exprTran.substring(0, 297) + "..." : exprTran;
        String rowIndex = pageCache.get("rowIndex");
        dataModel.setValue(filterField, (Object)destValueShow, Integer.parseInt(rowIndex));
        dataModel.setValue(filterJsonField, (Object)returnData, Integer.parseInt(rowIndex));
        dataModel.setValue(filterFormulaField, (Object)scripts[0], Integer.parseInt(rowIndex));
    }

    public static void showColTreeFormWithEntry(AbstractFormPlugin formPlugin, String entityNumber, int currentRowIndex, boolean includePkField, String closeCallBackActionId, IDataEntityProperty matchedProperty) {
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        EntityFieldTreeBuildOption option = new EntityFieldTreeBuildOption();
        option.setIncludeEntryEntityAsKeyPrefix(false);
        option.setIncludePKField(includePkField);
        option.setIncludeBDRefProp(false);
        if (matchedProperty != null) {
            if (matchedProperty instanceof BasedataProp) {
                BasedataEntityType basedataEntityType = new BasedataEntityType();
                basedataEntityType.setName(((BasedataProp)matchedProperty).getBaseEntityId());
                ((BasedataProp)matchedProperty).setComplexType((IDataEntityType)basedataEntityType);
            }
            option.setMatchedProperty(matchedProperty);
        }
        TreeNode treeNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)type, (PropTreeBuildOption)option);
        IPageCache pageCache = formPlugin.getPageCache();
        pageCache.put("entityType", entityNumber);
        pageCache.put("rowIndex", String.valueOf(currentRowIndex));
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_selectfield");
        String nodesJson = SerializationUtils.toJsonString((Object)treeNode);
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)formPlugin, closeCallBackActionId));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        formPlugin.getView().showForm(showParameter);
    }

    public static void showColTreeFormWithEntry(AbstractFormPlugin formPlugin, String treeJson, int currentRowIndex, String closeCallBackActionId) {
        IPageCache pageCache = formPlugin.getPageCache();
        pageCache.put("rowIndex", String.valueOf(currentRowIndex));
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_selectfield");
        showParameter.getCustomParams().put("treenodes", treeJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)formPlugin, closeCallBackActionId));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        formPlugin.getView().showForm(showParameter);
    }

    public static void closeCallSetEntryField(IDataModel model, IPageCache pageCache, String returnData, String field, String fieldKey) {
        String currentRowIndex = pageCache.get("rowIndex");
        int rowIndex = Integer.parseInt(currentRowIndex);
        if (ObjectUtils.isNotEmpty((Object)returnData)) {
            String entityNumber = pageCache.get("entityType");
            String fieldName = FormShowHelper.getFullPropertyName(entityNumber, returnData);
            model.setValue(field, (Object)fieldName, rowIndex);
            model.setValue(fieldKey, (Object)returnData, rowIndex);
        }
    }

    public static void showColTreeForm(AbstractFormPlugin formPlugin, String entityNumber, boolean includePkField, String closeCallBackActionId) {
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        EntityFieldTreeBuildOption option = new EntityFieldTreeBuildOption();
        option.setIncludeEntryEntityAsKeyPrefix(true);
        option.setIncludePKField(includePkField);
        option.setIncludeBDRefProp(false);
        TreeNode treeNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)type, (PropTreeBuildOption)option);
        IPageCache pageCache = formPlugin.getPageCache();
        pageCache.put("entityType", entityNumber);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_selectfield");
        String nodesJson = SerializationUtils.toJsonString((Object)treeNode);
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)formPlugin, closeCallBackActionId));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        formPlugin.getView().showForm(showParameter);
    }

    public static void closeCallSetField(IDataModel model, IPageCache pageCache, String returnData, String field, String fieldKey) {
        if (ObjectUtils.isNotEmpty((Object)returnData)) {
            String entityNumber = pageCache.get("entityType");
            String fieldName = FormShowHelper.getFullPropertyName(entityNumber, returnData);
            model.setValue(field, (Object)fieldName);
            model.setValue(fieldKey, (Object)returnData);
        }
    }

    private static String getFullPropertyName(String entityNumber, String fieldKey) {
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        return FormShowHelper.getFullPropertyName(entityType, fieldKey);
    }

    private static String getFullPropertyName(MainEntityType entityType, String targetKey) {
        DynamicProperty property = RowDataModel.findProperty((MainEntityType)entityType, (String)targetKey);
        if (null == property) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5177\u4f53\u7684\u5b57\u6bb5\u3002", (String)"InvpMatchConfigEditPlugin_2", (String)"scmc-invp-form", (Object[])new Object[0]));
        }
        return property.getDisplayName().getLocaleValue();
    }

    public static void showCustomColTreeFormWithEntry(AbstractFormPlugin formPlugin, String nodesJson, int rowIdx, Boolean includePkField, String closeCallBackActionId, BasedataProp ... includeProps) {
        IPageCache pageCache = formPlugin.getPageCache();
        pageCache.put("rowIndex", String.valueOf(rowIdx));
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_selectfield");
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)formPlugin, closeCallBackActionId));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        formPlugin.getView().showForm(showParameter);
    }

    public static void showColsTreeForm(AbstractFormPlugin formPlugin, String entityNumber, IColsSelectStrategy selectStrategy, List<String> filterFields, boolean includePkField, String closeCallBackActionId, PropertyDataType ... dataTypes) {
        SelectParams params = new SelectParams();
        MetaHelper meta = new MetaHelper(selectStrategy, entityNumber);
        String jsonTree = meta.buildTree2JSON(filterFields, includePkField, dataTypes);
        params.setJsonTree(jsonTree);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("invp_fieldselected");
        showParameter.getCustomParams().putAll(params.toMap());
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)formPlugin, closeCallBackActionId));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        IFormView view = formPlugin.getView();
        view.showForm(showParameter);
    }

    public static void showTreeForm(AbstractFormPlugin formPlugin, String entityNumber, boolean includePkField, String closeCallBackActionId) {
        SelectParams params = new SelectParams();
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        EntityFieldTreeBuildOption option = new EntityFieldTreeBuildOption();
        option.setIncludeEntryEntityAsKeyPrefix(true);
        option.setIncludePKField(includePkField);
        option.setIncludeBDRefProp(false);
        TreeNode node = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)type, (PropTreeBuildOption)option);
        if ("invp_invlevel".equals(node.getId())) {
            FormShowHelper.removeUnusedNode(node);
        }
        params.setJsonTree(SerializationUtils.toJsonString((Object)node));
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("invp_fieldselected");
        showParameter.getCustomParams().putAll(params.toMap());
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)formPlugin, closeCallBackActionId));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        IFormView view = formPlugin.getView();
        view.showForm(showParameter);
    }

    private static void removeUnusedNode(TreeNode node) {
        List children = node.getChildren();
        Iterator iterator = children.iterator();
        while (iterator.hasNext()) {
            TreeNode child = (TreeNode)iterator.next();
            if ("useorg".equals(child.getId())) {
                iterator.remove();
            }
            if (child.getChildren() == null || child.getChildren().isEmpty()) continue;
            FormShowHelper.removeUnusedNode(child);
        }
    }
}

