/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.common.helper;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.invp.business.pojo.InvLevelDimension;
import kd.scmc.invp.business.pojo.InvPlanContext;
import kd.scmc.invp.business.pojo.InvPlanScheme;
import kd.scmc.invp.business.step.InvPlanStepExecutor;
import kd.scmc.invp.common.helper.PlanTypeHelper;

public class InvPlanHelper {
    private static Log logger = LogFactory.getLog((String)"kd.scmc.invp.common.helper.InvPlanHelper");
    private static final BigDecimal MAX_VALUE = new BigDecimal("9999999999999");

    public static Long doInvPlan(Map<String, Object> params) {
        Long planOrg = (Long)params.get("planOrg");
        Date planDate = (Date)params.get("planDate");
        Long schemeId = (Long)params.get("schemeId");
        int outTime = (Integer)params.getOrDefault("outTime", 3600);
        boolean debugMode = (Boolean)params.getOrDefault("debugMode", false);
        InvPlanStepExecutor executor = new InvPlanStepExecutor(schemeId, planOrg, planDate, outTime, debugMode);
        return executor.execute();
    }

    public static String getExceptionMessage(Throwable e) {
        logger.error(e.getMessage(), e);
        StringBuilder builder = new StringBuilder();
        if (e instanceof KDBizException) {
            return e.getMessage();
        }
        if (e.getCause() != null) {
            builder.append(e.getCause()).append("\n");
            int i = 0;
            for (StackTraceElement stackTraceElement : e.getCause().getStackTrace()) {
                builder.append(stackTraceElement).append("\n");
                if (++i < 10) continue;
                builder.append("...").append("\n");
                break;
            }
        } else {
            builder.append(e).append("\n");
            int i = 0;
            for (StackTraceElement stackTraceElement : e.getStackTrace()) {
                builder.append(stackTraceElement).append("\n");
                if (++i < 10) continue;
                builder.append("...").append("\n");
                break;
            }
        }
        return builder.toString();
    }

    public static String loadKDString(String description, String resourceId, Object ... args) {
        return ResManager.loadKDString((String)description, (String)resourceId, (String)"scmc-invp-form", (Object[])args);
    }

    public static String getBillOperateErrorMsg(OperationResult operateResult) {
        StringBuilder errorMsgBuilder = new StringBuilder();
        if (!StringUtils.isEmpty((String)operateResult.getMessage())) {
            errorMsgBuilder.append(operateResult.getMessage()).append("\n");
        }
        List allErrorOrValidateInfo = operateResult.getAllErrorOrValidateInfo();
        Map<String, String> errorMap = InvPlanHelper.getOperateErrorMsg(allErrorOrValidateInfo);
        Map billNos = operateResult.getBillNos();
        for (Map.Entry<String, String> error : errorMap.entrySet()) {
            if (!StringUtils.isEmpty((String)((String)billNos.get(error.getKey())))) {
                errorMsgBuilder.append(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u7801\uff1a", (String)"InvPlanSavePlanOrder_0", (String)"scmc-invp-form", (Object[])new Object[0])).append((String)billNos.get(error.getKey())).append("\n");
            }
            errorMsgBuilder.append(error.getValue());
        }
        return errorMsgBuilder.toString();
    }

    public static Map<String, String> getOperateErrorMsg(List<IOperateInfo> allErrorOrValidateInfo) {
        HashMap<String, String> errorMap = new HashMap<String, String>();
        if (allErrorOrValidateInfo != null && !allErrorOrValidateInfo.isEmpty()) {
            for (IOperateInfo operateInfo : allErrorOrValidateInfo) {
                Object billId = operateInfo.getPkValue();
                errorMap.putIfAbsent(billId.toString(), "");
                errorMap.put(billId.toString(), (String)errorMap.get(billId.toString()) + operateInfo.getMessage() + "\n");
            }
        }
        return errorMap;
    }

    public static Set<Object> doBillOperation(String operate, String entityNum, Object[] ids, String message, StringBuilder errorMsgBuilder) {
        HashSet<Object> successIds = new HashSet<Object>();
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("WF", "false");
                OperationResult auditResult = OperationServiceHelper.executeOperate((String)operate, (String)entityNum, (Object[])ids, (OperateOption)operateOption);
                if (!auditResult.isSuccess()) {
                    errorMsgBuilder.append(message).append("\n");
                    errorMsgBuilder.append(InvPlanHelper.getBillOperateErrorMsg(auditResult));
                }
                successIds.addAll(auditResult.getSuccessPkIds());
            }
            catch (Exception e) {
                errorMsgBuilder.append(message).append("\n");
                errorMsgBuilder.append(InvPlanHelper.getExceptionMessage(e));
                txHandle.markRollback();
            }
        }
        return successIds;
    }

    public static Map<String, Integer> getFieldIndexMap(RowMeta rowMeta) {
        HashMap<String, Integer> fieldIndexMap = new HashMap<String, Integer>(16);
        for (Field field : rowMeta.getFields()) {
            String alias = field.getAlias();
            fieldIndexMap.put(alias, rowMeta.getFieldIndex(alias));
        }
        return fieldIndexMap;
    }

    public static String getMatchKey(Row row, List<String> matchFields) {
        StringBuilder matchValueBuilder = new StringBuilder();
        for (String matchField : matchFields) {
            Object fieldValue = row.get(matchField);
            if (row.get(matchField) instanceof DynamicObject) {
                fieldValue = ((DynamicObject)row.get(matchField)).get("id");
            }
            if (fieldValue == null) {
                fieldValue = "null";
            }
            matchValueBuilder.append(fieldValue).append("$");
        }
        return matchValueBuilder.toString();
    }

    public static int getOrderPeriod(int currentDay, List<Integer> supplyDayList, int curDayCount, int nextDayCount) {
        int currentPeriod;
        supplyDayList.sort(Comparator.comparingInt(o -> o));
        int fromDay = 0;
        int toDay = 0;
        int dayCount = curDayCount;
        for (Integer day : supplyDayList) {
            if (day < currentDay) continue;
            fromDay = day;
            break;
        }
        if (fromDay == 0) {
            fromDay = supplyDayList.get(0);
            dayCount = nextDayCount;
        }
        for (Integer day : supplyDayList) {
            if (day <= fromDay) continue;
            toDay = day;
            break;
        }
        if (toDay == 0) {
            toDay = supplyDayList.get(0);
        }
        currentPeriod = (currentPeriod = fromDay - currentDay) < 0 ? currentPeriod + curDayCount : currentPeriod;
        int orderPeriod = toDay - fromDay;
        orderPeriod = orderPeriod <= 0 ? orderPeriod + dayCount : orderPeriod;
        return currentPeriod + orderPeriod;
    }

    public static int castWeekDay(int dayOfWeek) {
        if (1 == dayOfWeek) {
            return 7;
        }
        return dayOfWeek - 1;
    }

    public static void initInvLevel(InvPlanContext ctx) {
        InvPlanScheme scheme = ctx.getScheme();
        String mainPlanType = scheme.getMainPlanType();
        String selector = InvPlanHelper.getInvLevelSelector(mainPlanType, scheme.getDimension());
        HashSet<Long> idSet = new HashSet<Long>(ctx.getCalRange().size());
        for (Map<String, Object> levelInfo : ctx.getCalRange().values()) {
            idSet.add((Long)levelInfo.get("id"));
        }
        QFilter filter = new QFilter("id", "in", idSet);
        DynamicObjectCollection invLevels = QueryServiceHelper.query((String)"invp_invlevel", (String)selector, (QFilter[])filter.toArray());
        Map<Object, Object> level2DayMap = new HashMap();
        if ("D".equals(mainPlanType)) {
            level2DayMap = InvPlanHelper.getLevel2DayMap(idSet);
        }
        HashMap<Long, DynamicObject> invLevelMap = new HashMap<Long, DynamicObject>();
        HashMap<String, Integer> planDay2PeriodMap = new HashMap<String, Integer>();
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        for (DynamicObject invLevel : invLevels) {
            if ("D".equals(mainPlanType)) {
                List planDays = (List)level2DayMap.get(invLevel.getLong("id"));
                invLevel.set("supplyday", (Object)planDays);
                String dayKey = invLevel.getString("supplytype");
                StringBuilder keyBuilder = new StringBuilder();
                keyBuilder.append(dayKey);
                for (Integer planDay : planDays) {
                    keyBuilder.append("-").append(planDay);
                }
                dayKey = keyBuilder.toString();
                if (!planDay2PeriodMap.containsKey(dayKey)) {
                    int orderPeriod = InvPlanHelper.getOrderPeriod(planDays, invLevel.getString("supplytype"));
                    planDay2PeriodMap.put(dayKey, orderPeriod);
                }
                int orderPeriod = (Integer)planDay2PeriodMap.get(dayKey);
                BigDecimal safeInvDays = invLevel.getBigDecimal("safeinvdays");
                BigDecimal leadTime = invLevel.getBigDecimal("leadtime");
                BigDecimal tarInvDays = new BigDecimal(orderPeriod).add(safeInvDays).add(leadTime);
                invLevel.set("tgtinvdays", (Object)tarInvDays);
                paramList.add(new Object[]{new BigDecimal(orderPeriod), tarInvDays, invLevel.getLong("id")});
            }
            invLevelMap.put(invLevel.getLong("id"), invLevel);
        }
        if (!paramList.isEmpty()) {
            String dbRouteKey = MetadataServiceHelper.getDataEntityType((String)"invp_invlevel").getDBRouteKey();
            DB.executeBatch((DBRoute)DBRoute.of((String)dbRouteKey), (String)"UPDATE T_INVP_INVLEVEL SET FORDERPERIOD = ?, FTGTINVDAYS= ? WHERE FID = ?", paramList);
        }
        paramList.clear();
        ctx.setInvLevelMap(invLevelMap);
    }

    private static Map<Long, List<Integer>> getLevel2DayMap(Set<Long> idSet) {
        StringBuilder sql = new StringBuilder(128);
        sql.append("SELECT A.FID FLEVELID,B.FVALUE FDAY FROM T_INVP_LEVELSUPPLYDAY  A INNER JOIN T_INVP_SUPPLYDAY B ON A.FBASEDATAID  = B.FID WHERE A.FID IN (");
        sql.append(String.join((CharSequence)",", idSet.stream().map(id -> id.toString()).collect(Collectors.toList()))).append(")");
        Map level2DayMap = (Map)DB.query((DBRoute)DBRoute.of((String)"scm"), (String)sql.toString(), (ResultSetHandler)new ResultSetHandler<Map<Long, List<Integer>>>(){

            public Map<Long, List<Integer>> handle(ResultSet rs) throws Exception {
                HashMap<Long, List<Integer>> resultMap = new HashMap<Long, List<Integer>>();
                while (rs.next()) {
                    long levelId = rs.getLong("FLEVELID");
                    int day = rs.getInt("FDAY");
                    resultMap.computeIfAbsent(levelId, key -> new ArrayList()).add(day);
                }
                return resultMap;
            }
        });
        return level2DayMap;
    }

    private static String getInvLevelSelector(String planType, InvLevelDimension dimension) {
        StringBuilder selectorBuilder = new StringBuilder();
        HashSet<String> fieldSet = new HashSet<String>();
        QFilter qFilter = PlanTypeHelper.buildFilter(planType);
        qFilter.and("enable", "=", (Object)Boolean.TRUE);
        qFilter.and("entryentity.plantype", "=", (Object)planType);
        qFilter.and("entryentity.relentity", "=", (Object)"invp_invlevel");
        qFilter.and("entryentity.isshow", "=", (Object)true);
        qFilter.and("ispreset", "=", (Object)false);
        String selectFields = "entryentity.relfieldkey as relfieldkey";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)InvPlanHelper.class.getName(), (String)"invp_levelfactor", (String)selectFields, (QFilter[])qFilter.toArray(), null);){
            for (Row row : dataSet) {
                String relFieldKey = row.getString("relfieldkey");
                if (!StringUtils.isNotEmpty((String)relFieldKey)) continue;
                fieldSet.add(relFieldKey);
            }
        }
        if ("A".equals(planType)) {
            fieldSet.add("reorder");
            fieldSet.add("ecobatch");
        }
        if ("D".equals(planType)) {
            fieldSet.add("tgtinvdays");
            fieldSet.add("safeinvdays");
            fieldSet.add("dailyconsume");
            fieldSet.add("urgentinvdays");
            fieldSet.add("supplytype");
            fieldSet.remove("supplyday");
            fieldSet.add("null as supplyday");
        }
        if ("B".equals(planType)) {
            fieldSet.add("max");
            fieldSet.add("min");
        }
        selectorBuilder.append(String.join((CharSequence)",", fieldSet)).append(",");
        selectorBuilder.append("postprocessingtime,");
        selectorBuilder.append("deliverytime,");
        selectorBuilder.append("preprocessingtime,");
        selectorBuilder.append("leadtime,");
        selectorBuilder.append("id,");
        for (String dimensionField : dimension.getDimensions()) {
            selectorBuilder.append(dimensionField).append(",");
        }
        selectorBuilder.append("planner,");
        selectorBuilder.append("number,");
        selectorBuilder.append("plangroup");
        return selectorBuilder.toString();
    }

    public static int getOrderPeriod(List<Integer> supplyDayList, String supplyType) {
        int orderPeriod = 0;
        Calendar calendar = Calendar.getInstance();
        if (supplyType.equals("A")) {
            int currentDay = InvPlanHelper.castWeekDay(calendar.get(7));
            orderPeriod = InvPlanHelper.getOrderPeriod(currentDay, supplyDayList, 7, 7);
        } else {
            int curDayCount = calendar.getActualMaximum(5);
            calendar.add(2, 1);
            int nextDayCount = calendar.getActualMaximum(5);
            orderPeriod = InvPlanHelper.getOrderPeriod(calendar.get(5), supplyDayList, curDayCount, nextDayCount);
        }
        return orderPeriod;
    }

    public static DynamicObject getInvPlanSchemeDynamicObj(Long schemeId) {
        long fieldMapId;
        DynamicObject scheme = BusinessDataServiceHelper.loadSingleFromCache((Object)schemeId, (String)"invp_scheme");
        DynamicObject demandModel = BusinessDataServiceHelper.loadSingle((Object)scheme.getDynamicObject("demandmodel").getLong("id"), (String)"invp_model_register");
        DynamicObject supplyModel = BusinessDataServiceHelper.loadSingle((Object)scheme.getDynamicObject("supplymodel").getLong("id"), (String)"invp_model_register");
        if (scheme.getDynamicObject("dimension") != null) {
            DynamicObject invDimensionInfo = BusinessDataServiceHelper.loadSingle((Object)scheme.getDynamicObject("dimension").getLong("id"), (String)"msplan_plan_dimension");
            scheme.set("dimension", (Object)invDimensionInfo);
        }
        HashSet<Long> filedMapIdSet = new HashSet<Long>();
        DynamicObjectCollection demandEntries = demandModel.getDynamicObjectCollection("entryentityds");
        for (DynamicObject entry : demandEntries) {
            filedMapIdSet.add(entry.getDynamicObject("billfieldmap").getLong("id"));
        }
        long outPutResultMapId = demandModel.getDynamicObject("outputresult").getLong("id");
        filedMapIdSet.add(outPutResultMapId);
        DynamicObjectCollection supplyEntries = supplyModel.getDynamicObjectCollection("entryentityds");
        for (DynamicObject entry : supplyEntries) {
            filedMapIdSet.add(entry.getDynamicObject("billfieldmap").getLong("id"));
        }
        long out2SupplyMapId = supplyModel.getDynamicObject("outputmappingsupply").getLong("id");
        filedMapIdSet.add(out2SupplyMapId);
        QFilter filter = new QFilter("id", "in", (Object)filedMapIdSet.toArray());
        String selectProperties = "id,isenable,sourcebill,targetobj,colsmap.selectvalue,colsmap.targetobjcol,colsmap.sourcebillcol,colsmap.formula,colsmap.formula_tag";
        DynamicObject[] fields = BusinessDataServiceHelper.load((String)"sbs_billfieldmapping", (String)selectProperties, (QFilter[])filter.toArray());
        Map<Long, DynamicObject> fieldMap = Arrays.stream(fields).collect(Collectors.toMap(field -> field.getLong("id"), field -> field));
        for (DynamicObject demandEntry : demandEntries) {
            fieldMapId = demandEntry.getDynamicObject("billfieldmap").getLong("id");
            demandEntry.set("billfieldmap", (Object)fieldMap.get(fieldMapId));
        }
        demandModel.set("entryentityds", (Object)demandEntries);
        demandModel.set("outputresult", (Object)fieldMap.get(outPutResultMapId));
        scheme.set("demandmodel", (Object)demandModel);
        for (DynamicObject supplyEntry : supplyEntries) {
            fieldMapId = supplyEntry.getDynamicObject("billfieldmap").getLong("id");
            supplyEntry.set("billfieldmap", (Object)fieldMap.get(fieldMapId));
        }
        supplyModel.set("entryentityds", (Object)supplyEntries);
        supplyModel.set("outputmappingsupply", (Object)fieldMap.get(out2SupplyMapId));
        scheme.set("supplymodel", (Object)supplyModel);
        HashSet<Long> matchMappingIds = new HashSet<Long>();
        long sup2DemandMappingId = scheme.getDynamicObject("suptodemmapping").getLong("id");
        long demand2LevelMappingId = scheme.getDynamicObject("demtolevelmapping").getLong("id");
        matchMappingIds.add(sup2DemandMappingId);
        matchMappingIds.add(demand2LevelMappingId);
        Map matchMappingMap = BusinessDataServiceHelper.loadFromCache((Object[])matchMappingIds.toArray(), (String)"invp_matchmapping_config");
        scheme.set("suptodemmapping", matchMappingMap.get(sup2DemandMappingId));
        scheme.set("demtolevelmapping", matchMappingMap.get(demand2LevelMappingId));
        long algoId = scheme.getDynamicObject("algorithmplan").getLong("id");
        DynamicObject algoPlan = BusinessDataServiceHelper.loadSingle((Object)algoId, (String)"invp_algoconfig", (String)"number,entryentity,batchcal,enable,status,entryentity.algorithm,entryentity.algorithm.algotype");
        scheme.set("algorithmplan", (Object)algoPlan);
        return scheme;
    }

    public static void doCalcByOneBatch(Map<String, Object> params) {
        InvPlanContext batchCtx = InvPlanHelper.buildBatchContext(params);
        List logIds = (List)params.get("logentries");
        int rate = (Integer)params.get("rate");
        InvPlanStepExecutor executor = new InvPlanStepExecutor();
        executor.executeOneBatch(batchCtx, logIds, rate);
    }

    private static InvPlanContext buildBatchContext(Map<String, Object> params) {
        Date planDate;
        InvPlanContext batchCtx = new InvPlanContext();
        batchCtx.setLogId(Long.parseLong(params.get("logId").toString()));
        batchCtx.setSchemeId(Long.parseLong(params.get("schemeId").toString()));
        batchCtx.setPlanOrg(Long.parseLong(params.get("planOrgId").toString()));
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            planDate = fmt.parse(params.get("planDate").toString());
        }
        catch (ParseException e) {
            logger.error((Throwable)e);
            throw new KDException(e.getMessage());
        }
        batchCtx.setPlanDate(planDate);
        batchCtx.setCalcNum((String)params.get("calNum"));
        Map calRange = (Map)params.get("calRange");
        for (Map calRangeMap : calRange.values()) {
            calRangeMap.forEach((key, value) -> calRangeMap.put(key, Long.parseLong(value.toString())));
        }
        batchCtx.setCalRange(calRange);
        batchCtx.setDebugMode((Boolean)params.get("debugMode"));
        batchCtx.setMatchDetailId(Long.parseLong(params.get("matchDetailId").toString()));
        return batchCtx;
    }

    public static DataSet mergeDataSet(DataSet dataSet1, DataSet dataSet2) {
        if (dataSet1 != null && dataSet2 != null) {
            return dataSet1.union(dataSet2);
        }
        if (dataSet1 != null) {
            return dataSet1;
        }
        if (dataSet2 != null) {
            return dataSet2;
        }
        return null;
    }

    public static Date getPureDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static void maxValueCheck(BigDecimal ... values) {
        for (BigDecimal value : values) {
            if (value.compareTo(MAX_VALUE) <= 0) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8ba1\u7b97\u7684\u7ed3\u679c\u503c[%s]\u8d85\u8fc7\u7cfb\u7edf\u9884\u5236\u6700\u5927\u503c[9999999999999]\uff0c\u8bf7\u51cf\u5c11\u53c2\u4e0e\u8fd0\u7b97\u7684\u6570\u636e\uff01", (String)"InvpSafeStockCalHelper_0", (String)"scmc-invp-form", (Object[])new Object[0]), value));
        }
    }

    public static String getPlanOrgInfo(Long planOrg) {
        StringBuilder message = new StringBuilder();
        String selectFields = "id,name,number";
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)planOrg)};
        DynamicObject orgInfo = QueryServiceHelper.queryOne((String)"bos_org", (String)selectFields, (QFilter[])filters);
        if (orgInfo != null) {
            message.append(orgInfo.getString("name")).append('(').append(orgInfo.getString("number")).append(')');
        }
        return message.toString();
    }
}

