/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.common.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.botp.CRCondition;
import kd.bos.exception.KDBizException;
import kd.bos.formula.FormulaEngine;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.invp.business.bean.FactorCalcRule;
import kd.scmc.invp.common.helper.InvpLevelFactorHelper;
import kd.scmc.invp.common.helper.InvpQuerySchemaHelper;
import kd.scmc.invp.common.helper.ModelFilterHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class InvpCalcRuleHelper {
    private static Set<Long> buildFactorIdSet(DynamicObject calcRuleDym) {
        HashSet<Long> factorSet = new HashSet<Long>(4);
        DynamicObjectCollection rows = calcRuleDym.getDynamicObjectCollection("calcruleentry");
        for (DynamicObject row : rows) {
            DynamicObjectCollection factors = row.getDynamicObjectCollection("levelfactors");
            for (DynamicObject factor : factors) {
                factorSet.add(factor.getLong("fbasedataid.id"));
            }
        }
        return factorSet;
    }

    static Map<Long, Object> calcFactor(DynamicObject invlevelRowDym, DynamicObject calcRuleDym, Map<Long, DynamicObject> querySchemaMap) {
        Set<Long> factorIdSet = InvpCalcRuleHelper.buildFactorIdSet(calcRuleDym);
        String plantype = calcRuleDym.getString("plantype");
        HashMap<Long, Object> factorValMap = new HashMap<Long, Object>(4);
        for (Long l : factorIdSet) {
            DynamicObject dynamicObject = querySchemaMap.get(l);
            if (null != dynamicObject) {
                Object val = InvpQuerySchemaHelper.queryByRule(invlevelRowDym, dynamicObject);
                factorValMap.put(l, val);
                continue;
            }
            Map<Long, String> fieldMap = InvpLevelFactorHelper.getFieldMap(Collections.singletonList(l), plantype);
            String field = fieldMap.get(l);
            if (!StringUtils.isNotBlank((CharSequence)field)) continue;
            Object val = invlevelRowDym.get(field);
            factorValMap.put(l, val);
        }
        ArrayList<Long> exceptionFactorList = new ArrayList<Long>(factorValMap.size());
        for (Map.Entry entry : factorValMap.entrySet()) {
            if (null != entry.getValue()) continue;
            exceptionFactorList.add((Long)entry.getKey());
        }
        if (CollectionUtils.isNotEmpty(exceptionFactorList)) {
            List<String> list = InvpCalcRuleHelper.getFactorInfoList(exceptionFactorList);
            throw new KDBizException(ResManager.loadKDString((String)"\u4ee5\u4e0b\u5e93\u5b58\u6c34\u4f4d\u56e0\u5b50 {0} \u65e0\u6cd5\u901a\u8fc7\u53d6\u6570\u89c4\u5219\u5f97\u5230\u7ed3\u679c\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u3002", (String)"InvpSmartCalcHelper_4", (String)"scmc-invp-form", (Object[])new Object[]{list}));
        }
        HashMap<Long, Object> hashMap = new HashMap<Long, Object>(4);
        List<FactorCalcRule> list = InvpCalcRuleHelper.buildResultFactorIdSet(calcRuleDym);
        boolean loop = true;
        while (loop) {
            Iterator<FactorCalcRule> iterator = list.iterator();
            int count = list.size();
            while (iterator.hasNext()) {
                FactorCalcRule factorCalcRule = iterator.next();
                if (!CollectionUtils.containsAll(factorValMap.keySet(), factorCalcRule.getCalcFactorIdSet())) continue;
                Long factorId = factorCalcRule.getResultFactorId();
                Object factorVal = InvpCalcRuleHelper.calc(factorValMap, factorCalcRule);
                factorValMap.put(factorId, factorVal);
                hashMap.put(factorId, factorVal);
                iterator.remove();
            }
            if (list.isEmpty()) break;
            if (count != list.size()) continue;
            List<Long> factorIdList = list.stream().map(FactorCalcRule::getResultFactorId).collect(Collectors.toList());
            List<String> factorList = InvpCalcRuleHelper.getFactorInfoList(factorIdList);
            throw new KDBizException(ResManager.loadKDString((String)"\u4ee5\u4e0b\u5e93\u5b58\u6c34\u4f4d\u56e0\u5b50 {0} \u65e0\u6cd5\u901a\u8fc7\u8ba1\u7b97\u89c4\u5219\u5f97\u5230\u7ed3\u679c\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u3002", (String)"InvpSmartCalcHelper_3", (String)"scmc-invp-form", (Object[])new Object[]{factorList}));
        }
        return hashMap;
    }

    private static List<String> getFactorInfoList(Collection<Long> factorIdList) {
        QFilter qFilter = new QFilter("id", "in", factorIdList);
        Map map = BusinessDataServiceHelper.loadFromCache((String)"invp_levelfactor", (String)"name", (QFilter[])qFilter.toArray());
        return map.values().stream().map(item -> item.getString("name")).collect(Collectors.toList());
    }

    private static Object calc(Map<Long, Object> factorValMap, FactorCalcRule factorCalcRule) {
        String calcExp = factorCalcRule.getCalcExp();
        HashMap<String, Object> factorMap = new HashMap<String, Object>(4);
        for (Long factorId : factorCalcRule.getCalcFactorIdSet()) {
            String factorKey = InvpCalcRuleHelper.getFactorKey(factorId);
            Object factorVal = factorValMap.get(factorId);
            factorMap.put(factorKey, factorVal);
        }
        return FormulaEngine.execExcelFormula((String)calcExp, factorMap);
    }

    private static List<FactorCalcRule> buildResultFactorIdSet(DynamicObject calcRuleDym) {
        ArrayList<FactorCalcRule> calcRuleList = new ArrayList<FactorCalcRule>(4);
        DynamicObjectCollection rows = calcRuleDym.getDynamicObjectCollection("calcruleentry");
        for (DynamicObject row : rows) {
            DynamicObject resultFactor = row.getDynamicObject("levelfactor");
            String calcExpJson = row.getString("calcrulejson_tag");
            CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)calcExpJson, CRCondition.class);
            String calcExp = condition.getExpression();
            DynamicObjectCollection factors = row.getDynamicObjectCollection("levelfactors");
            HashSet<Long> calcFactorSet = new HashSet<Long>(4);
            for (DynamicObject factor : factors) {
                calcFactorSet.add(factor.getLong("fbasedataid.id"));
            }
            calcRuleList.add(new FactorCalcRule((Long)resultFactor.getPkValue(), calcExp, calcFactorSet));
        }
        return calcRuleList;
    }

    static Map<Long, DynamicObject> buildQuerySchemaMap(Collection<DynamicObject> querySchemaDymCollection) {
        HashMap<Long, DynamicObject> map = new HashMap<Long, DynamicObject>(4);
        for (DynamicObject querySchema : querySchemaDymCollection) {
            querySchema = ModelFilterHelper.loadFullDym(querySchema);
            Long levelFactorId = querySchema.getLong("levelfactor.id");
            map.put(levelFactorId, querySchema);
        }
        return map;
    }

    public static String getFactorKey(Object factorId) {
        return StringUtils.wrap((String)String.valueOf(factorId), (String)"a");
    }

    public static Long getFactorId(String factorKey) {
        String factorId = StringUtils.substring((String)factorKey, (int)1, (int)(factorKey.length() - 1));
        return NumberUtils.toLong((String)factorId);
    }
}

