/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.common.helper;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.invp.common.helper.ModelFilterHelper;

public class InvpFactorCalHelper {
    private Object schemePk;
    private String queueName;
    private String entityName;
    private String logEntityName;
    private String consumerSign;
    private boolean enableLog;
    private int batchSize;
    private List<Object> invLevelIds;
    private static final Log log = LogFactory.getLog(InvpFactorCalHelper.class);

    public InvpFactorCalHelper(String queueName, String entityName, String logEntityName, String consumerSign) {
        this.queueName = queueName;
        this.entityName = entityName;
        this.logEntityName = logEntityName;
        this.consumerSign = consumerSign;
    }

    public void dispatch(DynamicObject schemeDym) {
        if (schemeDym == null) {
            return;
        }
        this.schemePk = schemeDym.getPkValue();
        this.invLevelIds = ModelFilterHelper.getInvLevelIds(schemeDym);
        if (this.invLevelIds.isEmpty()) {
            log.info("\u5f53\u524d\u65b9\u6848\u201c{}\u201d\u83b7\u53d6\u5230\u7684\u6c34\u4f4d\u4fe1\u606f\u4e3a\u7a7a\u3002", (Object)schemeDym.getString("number"));
            return;
        }
        QFilter batchSizeFilter = new QFilter("enable", "=", (Object)"1").and("calentity", "=", (Object)this.entityName);
        DynamicObject batchSizeConf = BusinessDataServiceHelper.loadSingle((String)"invp_batchcal_conf", (QFilter[])batchSizeFilter.toArray());
        this.batchSize = batchSizeConf.get("batchsize") == null || batchSizeConf.getInt("batchsize") == 0 ? 1000 : batchSizeConf.getInt("batchsize");
        this.enableLog = batchSizeConf.getBoolean("enablelog");
        this.doDispatch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDispatch() {
        ArrayList<DynamicObject> logEntities = new ArrayList<DynamicObject>(this.invLevelIds.size() / this.batchSize + 1);
        try (MessagePublisher pub = null;){
            pub = MQFactory.get().createSimplePublisher("scmc", this.queueName);
            ArrayList<Object> pubList = new ArrayList<Object>(this.batchSize);
            int curBatch = 0;
            Date date = new Date();
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSSS");
            String masterId = format.format(date);
            for (int i = 0; i < this.invLevelIds.size(); ++i) {
                Object invLevelId = this.invLevelIds.get(i);
                pubList.add(invLevelId);
                if (pubList.size() < this.batchSize) continue;
                this.publishMessage(curBatch++, masterId, pubList, date, pub, logEntities);
                pubList.clear();
            }
            if (!pubList.isEmpty()) {
                this.publishMessage(curBatch, masterId, pubList, date, pub, logEntities);
            }
        }
        if (this.enableLog && !logEntities.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])logEntities.toArray(new DynamicObject[0]));
        }
    }

    private void publishMessage(int curBatch, String masterId, List<Object> pubList, Date date, MessagePublisher pub, List<DynamicObject> logEntities) {
        String subTaskNo = InvpFactorCalHelper.generateNum(++curBatch);
        String messageStr = this.buildJsonObject(masterId, subTaskNo, pubList);
        pub.publish(messageStr);
        if (this.enableLog) {
            DynamicObject logEntity = this.buildLogEntity(masterId, subTaskNo, date, pubList);
            logEntities.add(logEntity);
        }
    }

    private String buildJsonObject(String masterId, String subTaskNo, List<Object> pubList) {
        HashMap<String, Object> msgParam = new HashMap<String, Object>();
        msgParam.put("consumerSign", this.consumerSign);
        msgParam.put("masterId", masterId);
        msgParam.put("subtaskno", subTaskNo);
        msgParam.put("schemaId", this.schemePk);
        msgParam.put("levelList", pubList);
        msgParam.put("enablelog", this.enableLog ? "TRUE" : "FALSE");
        msgParam.put("logentityname", this.logEntityName);
        return SerializationUtils.toJsonString(msgParam);
    }

    private DynamicObject buildLogEntity(String masterId, String subId, Date date, List<Object> pubList) {
        DynamicObject logEntity = BusinessDataServiceHelper.newDynamicObject((String)this.logEntityName);
        logEntity.set("mastertaskno", (Object)masterId);
        logEntity.set("subtaskno", (Object)subId);
        logEntity.set("creator", (Object)RequestContext.get().getCurrUserId());
        logEntity.set("createtime", (Object)date);
        logEntity.set("scheme", this.schemePk);
        logEntity.set("status", (Object)"A");
        logEntity.set("subtaskcount", (Object)pubList.size());
        String msg = SerializationUtils.toJsonString(pubList);
        logEntity.set("invlevelidmsg", (Object)(msg.length() > 100 ? msg.substring(0, 100).concat("...") : msg));
        logEntity.set("invlevelidmsg_tag", (Object)msg);
        return logEntity;
    }

    private static String generateNum(Integer num) {
        DecimalFormat format = null;
        format = num <= 9999 ? new DecimalFormat("0000") : new DecimalFormat("00000");
        return format.format(num);
    }

    public static void updateLogStatus(Object masterId, Object subTaskNo, String status, Date execTime, Exception e, String logEntityName) {
        Date endDate = new Date();
        long cost = endDate.getTime() - execTime.getTime();
        QFilter filter = new QFilter("subtaskno", "=", (Object)subTaskNo.toString());
        filter.and("mastertaskno", "=", (Object)masterId.toString());
        DynamicObject task = BusinessDataServiceHelper.loadSingle((String)logEntityName, (QFilter[])filter.toArray());
        task.set("status", (Object)status);
        task.set("subtaskstart", (Object)execTime);
        task.set("subtaskend", (Object)endDate);
        task.set("msgusertime", (Object)cost);
        if (e != null) {
            String errMsg = InvpFactorCalHelper.parseMsg(e);
            task.set("errormsg", (Object)(errMsg.length() > 100 ? errMsg.substring(0, 100).concat("...") : errMsg));
            task.set("errormsg_tag", (Object)errMsg);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{task});
    }

    private static String parseMsg(Exception e) {
        StackTraceElement[] stackTrace;
        StringBuilder msgStr = new StringBuilder();
        msgStr.append(e.getMessage());
        for (StackTraceElement stackTraceElement : stackTrace = e.getStackTrace()) {
            msgStr.append("\r\n at ").append(stackTraceElement);
        }
        return msgStr.toString();
    }
}

