/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.common.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.field.FieldEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.invp.common.helper.PlanTypeHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.keyvalue.MultiKey;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class InvpLevelFactorHelper {
    private static String[] FLAGS = new String[]{"isshow", "islock", "ismustinput"};

    public static Map<Long, String> getFieldMap(Collection<Long> factorIdList, String plantype) {
        QFilter qFilter = new QFilter("id", "in", factorIdList);
        qFilter.and("entryentity.relentity", "=", (Object)"invp_invlevel");
        qFilter.and("entryentity.plantype", "=", (Object)plantype);
        HashMap<Long, String> resultMap = new HashMap<Long, String>(4);
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)"invp_invlevel");
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)InvpLevelFactorHelper.class.getName(), (String)"invp_levelfactor", (String)"id,number,entryentity.relfieldkey as relfieldkey", (QFilter[])qFilter.toArray(), null);){
            while (dataSet.hasNext()) {
                DynamicProperty property;
                Row row = dataSet.next();
                String fieldKey = row.getString("relfieldkey");
                if (StringUtils.isBlank((CharSequence)fieldKey) || null == (property = RowDataModel.findProperty((MainEntityType)mainEntityType, (String)fieldKey))) continue;
                Long key = row.getLong("id");
                resultMap.put(key, property.getName());
            }
        }
        return resultMap;
    }

    public static Set<String> showFields(IFormView view, String planType) {
        HashSet<String> showFields = new HashSet<String>(4);
        String entityType = view.getEntityId();
        String status = (String)view.getModel().getValue("status");
        boolean isDraft = status.equals("A");
        QFilter qFilter = PlanTypeHelper.buildFilter(planType);
        qFilter.and("enable", "=", (Object)Boolean.TRUE);
        qFilter.and("entryentity.plantype", "=", (Object)planType);
        qFilter.and("entryentity.relentity", "=", (Object)entityType);
        MultiKeyMap<String, Boolean> cfgMap = InvpLevelFactorHelper.loadLevelFactorCtlMap(entityType, planType, new String[0]);
        HashSet<Object> fieldKeys = new HashSet<Object>(4);
        for (MultiKey key : cfgMap.keySet()) {
            fieldKeys.add(key.getKey(0));
        }
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityType);
        for (String string : fieldKeys) {
            Control control;
            DynamicProperty property = RowDataModel.findProperty((MainEntityType)mainEntityType, (String)string);
            if (null == property) continue;
            String fieldName = property.getName();
            Boolean isshow = (Boolean)cfgMap.get((Object)string, (Object)"isshow");
            Boolean islock = (Boolean)cfgMap.get((Object)string, (Object)"islock") != false && isshow != false;
            Boolean ismustinput = (Boolean)cfgMap.get((Object)string, (Object)"ismustinput") != false && isshow != false;
            if (isshow.booleanValue()) {
                showFields.add(fieldName);
            }
            view.setVisible(isshow, new String[]{fieldName});
            if (isDraft) {
                view.setEnable(Boolean.valueOf(islock == false), new String[]{fieldName});
            }
            if (!((control = view.getControl(fieldName)) instanceof FieldEdit)) continue;
            FieldEdit fieldEdit = (FieldEdit)control;
            fieldEdit.setMustInput(ismustinput.booleanValue());
        }
        return showFields;
    }

    public static MultiKeyMap<String, Boolean> loadLevelFactorCtlMap(String entityType, String planType, String ... ctlFields) {
        MultiKeyMap cfgMap = new MultiKeyMap();
        if (ArrayUtils.isEmpty((Object[])ctlFields)) {
            ctlFields = FLAGS;
        }
        QFilter qFilter = PlanTypeHelper.buildFilter(planType);
        qFilter.and("enable", "=", (Object)Boolean.TRUE);
        qFilter.and("entryentity.plantype", "=", (Object)planType);
        qFilter.and("entryentity.relentity", "=", (Object)entityType);
        String selectFields = "entryentity.relfieldkey as relfieldkey,entryentity.isshow as isshow,entryentity.islock as islock,entryentity.ismustinput as ismustinput";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)InvpLevelFactorHelper.class.getName(), (String)"invp_levelfactor", (String)selectFields, (QFilter[])qFilter.toArray(), null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                String fieldKey = row.getString("relfieldkey");
                if (StringUtils.isBlank((CharSequence)fieldKey)) continue;
                for (String ctlField : ctlFields) {
                    Boolean flagVal = row.getBoolean(ctlField);
                    cfgMap.put((Object)fieldKey, (Object)ctlField, (Object)flagVal);
                }
            }
        }
        return cfgMap;
    }

    public static void hideFields(IFormView view, Collection<String> entryFields, Collection<String> excludeFields, Collection<String> showFields) {
        ArrayList<String> hideFields = new ArrayList<String>(4);
        for (String entryField : entryFields) {
            if (excludeFields.contains(entryField) || showFields.contains(entryField)) continue;
            hideFields.add(entryField);
        }
        if (CollectionUtils.isNotEmpty(hideFields)) {
            view.setVisible(Boolean.FALSE, hideFields.toArray(new String[0]));
            view.setEnable(Boolean.FALSE, hideFields.toArray(new String[0]));
            for (String hideField : hideFields) {
                FieldProp fieldProp;
                Control control = view.getControl(hideField);
                if (!(control instanceof FieldEdit)) continue;
                FieldEdit fieldEdit = (FieldEdit)control;
                fieldEdit.setMustInput(Boolean.FALSE.booleanValue());
                IDataEntityProperty prop = fieldEdit.getProperty();
                if (prop instanceof FieldProp) {
                    fieldProp = (FieldProp)prop;
                    fieldProp.setMustInput(Boolean.FALSE.booleanValue());
                    continue;
                }
                if (!(prop instanceof BasedataProp)) continue;
                fieldProp = (BasedataProp)prop;
                fieldProp.setMustInput(Boolean.FALSE.booleanValue());
            }
        }
    }
}

