/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.common.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.invp.business.pojo.InvPlanStepResult;
import kd.scmc.invp.common.consts.InvPlanLogConstants;

public class InvpLogHelper {
    public static void processLogInfo(DynamicObject invPlanLog, String calcNum) {
        ArrayList<Object> paramList = new ArrayList<Object>();
        String calStatus = InvpLogHelper.getPlanLogStatus(calcNum);
        if (StringUtils.isEmpty((String)calStatus)) {
            calStatus = InvPlanLogConstants.STATUS_USER_STOP;
        }
        if (calStatus.equals(InvPlanLogConstants.STATUS_RUNNING)) {
            calStatus = InvPlanLogConstants.STATUS_FAIL;
        }
        Date startTime = invPlanLog.getDate(InvPlanLogConstants.START_TIME);
        Date endTime = TimeServiceHelper.now();
        paramList.add(endTime);
        String timeSpan = new BigDecimal(String.valueOf(endTime.getTime() - startTime.getTime())).divide(new BigDecimal("60000"), 4, RoundingMode.UP).toPlainString();
        paramList.add(timeSpan);
        paramList.add(calStatus);
        if (InvPlanLogConstants.STATUS_SUCCESS.equals(calStatus)) {
            paramList.add(100);
        }
        paramList.add(invPlanLog.getLong("id"));
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE T_INVP_PLANLOG SET FENDTIME = ?,FTIMESPAN = ? ,FSTATUS = ? ");
        if (InvPlanLogConstants.STATUS_SUCCESS.equals(calStatus)) {
            sql.append(",FPROCESSRATE = ?");
        }
        sql.append(" WHERE FID  = ?");
        DB.execute((DBRoute)DBRoute.of((String)"scm"), (String)sql.toString(), (Object[])paramList.toArray());
    }

    public static String getPlanLogStatus(String calcNum) {
        DistributeSessionlessCache sessionLessCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("invPlanCalc");
        return (String)sessionLessCache.get(calcNum);
    }

    public static void setPlanLogStatus(String calcNum, String status) {
        DistributeSessionlessCache sessionLessCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("invPlanCalc");
        sessionLessCache.put(calcNum, (Object)status);
    }

    public static void initLogRate(String calcNum) {
        DistributeSessionlessCache sessionLessCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("invPlanCalc");
        sessionLessCache.put(calcNum + "rate", (Object)"0");
    }

    public static void initRunningBatchNum(String calcNum, int batchNum) {
        DistributeSessionlessCache sessionLessCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("invPlanCalc");
        sessionLessCache.put(calcNum + "runbatchnum", (Object)(batchNum + ""));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decreaseRunningBatchNum(String calcNum) {
        DistributeSessionlessCache sessionLessCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("invPlanCalc");
        int runningCount = 0;
        DLock dLock = DLock.create((String)calcNum);
        try {
            dLock.lock();
            String runNumber = (String)sessionLessCache.get(calcNum + "runbatchnum");
            if (StringUtils.isEmpty((String)runNumber)) {
                return;
            }
            runningCount = Integer.parseInt(runNumber) - 1;
            sessionLessCache.put(calcNum + "runbatchnum", (Object)(runningCount + ""));
        }
        finally {
            dLock.unlock();
        }
    }

    public static int getRunningBatchNum(String calcNum) {
        DistributeSessionlessCache sessionLessCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("invPlanCalc");
        String runNum = (String)sessionLessCache.get(calcNum + "runbatchnum");
        if (StringUtils.isEmpty((String)runNum)) {
            return 0;
        }
        return Integer.parseInt(runNum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateLogRate(String calcNum, int rate, Long logId) {
        DLock dLock = DLock.create((String)calcNum);
        try {
            dLock.lock();
            String logRate = InvpLogHelper.getLogRate(calcNum);
            if (StringUtils.isEmpty((String)logRate)) {
                return;
            }
            int newRate = Integer.parseInt(logRate) + rate;
            try (TXHandle txHandle = TX.requiresNew();){
                DB.execute((DBRoute)DBRoute.of((String)"scm"), (String)"UPDATE T_INVP_PLANLOG SET FPROCESSRATE = ? WHERE FID = ?", (Object[])new Object[]{newRate, logId});
            }
            InvpLogHelper.settLogRate(calcNum, newRate);
        }
        finally {
            dLock.unlock();
        }
    }

    public static String getLogRate(String calcNum) {
        DistributeSessionlessCache sessionLessCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("invPlanCalc");
        return (String)sessionLessCache.get(calcNum + "rate");
    }

    public static void settLogRate(String calcNum, int lotRate) {
        DistributeSessionlessCache sessionLessCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("invPlanCalc");
        sessionLessCache.put(calcNum + "rate", (Object)String.valueOf(lotRate));
    }

    public static void clear(String calcNum) {
        DistributeSessionlessCache sessionLessCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("invPlanCalc");
        sessionLessCache.remove(calcNum);
        sessionLessCache.remove(calcNum + "rate");
        sessionLessCache.remove(calcNum + "runbatchnum");
    }

    public static void updateInvPlanEntryLog(Long entryId, InvPlanStepResult stepResult) {
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE T_INVP_PLANLOGENTRY SET FPROCESSDATA = ?,FSTEPTIMESPAN = ?,FSTEPRESULT = ?,FDETAILMSG = ?,FDETAILMSG_TAG = ? WHERE FENTRYID = ?;");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(stepResult.getProcessData());
        params.add(stepResult.getStepTimeSpan());
        params.add(stepResult.getStepResult());
        String detailMsg = stepResult.getDetailMsg();
        if (detailMsg.length() > 50) {
            params.add(detailMsg.substring(0, 50));
        } else {
            params.add(detailMsg);
        }
        params.add(detailMsg);
        params.add(entryId);
        try (TXHandle txHandle = TX.requiresNew();){
            DB.execute((DBRoute)DBRoute.of((String)"scm"), (String)sql.toString(), (Object[])params.toArray());
        }
    }
}

