/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.common.helper;

import java.util.Collection;
import java.util.StringJoiner;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.invp.common.helper.ModelFilterHelper;
import kd.scmc.invp.common.helper.QFilterHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class InvpQuerySchemaHelper {
    public static Object queryByRule(DynamicObject invlevelRow, DynamicObject querySchema) {
        querySchema = ModelFilterHelper.loadFullDym(querySchema);
        DynamicObjectCollection rows = querySchema.getDynamicObjectCollection("entryentity");
        for (DynamicObject row : rows) {
            DynamicObject queryRuleDym = row.getDynamicObject("queryrule");
            String nextstep = row.getString("nextstep");
            Object value = InvpQuerySchemaHelper.query(invlevelRow, queryRuleDym);
            if (value != null) {
                return InvpQuerySchemaHelper.getPkValue(value);
            }
            if (!"B".equals(nextstep)) continue;
            return 0;
        }
        return null;
    }

    private static Object query(DynamicObject invlevelRow, DynamicObject queryRuleDym) {
        queryRuleDym = ModelFilterHelper.loadFullDym(queryRuleDym);
        String entityKey = queryRuleDym.getString("srcentity.number");
        String srcFieldKey = queryRuleDym.getString("srcfieldkey");
        QFilter qFilter = InvpQuerySchemaHelper.buildQFilter(invlevelRow, queryRuleDym);
        QFilter srcFilter = QFilterHelper.parseQFilter(entityKey, queryRuleDym.getString("srcfilterjson_tag"));
        String orderFields = InvpQuerySchemaHelper.buildOrderFields(queryRuleDym);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)InvpQuerySchemaHelper.class.getName(), (String)entityKey, (String)srcFieldKey, (QFilter[])qFilter.and(srcFilter).toArray(), (String)orderFields, (int)1);){
            if (dataSet.hasNext()) {
                Row row = dataSet.next();
                Object object = row.get(srcFieldKey);
                return object;
            }
        }
        return null;
    }

    private static String buildOrderFields(DynamicObject queryRuleDym) {
        DynamicObjectCollection rows = queryRuleDym.getDynamicObjectCollection("orderentry");
        if (CollectionUtils.isEmpty((Collection)rows)) {
            return null;
        }
        DynamicObject srcEntityType = queryRuleDym.getDynamicObject("srcentity");
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)srcEntityType.getString("number"));
        StringJoiner orderFields = new StringJoiner(",");
        for (DynamicObject row : rows) {
            String orderField = row.getString("orderfieldkey");
            String order = row.getString("order");
            DynamicProperty property = RowDataModel.findProperty((MainEntityType)mainEntityType, (String)orderField);
            if (null == property) continue;
            if (property.getParent() instanceof EntryType) {
                orderField = property.getParent().getName() + "." + property.getName();
            }
            orderFields.add(" " + orderField + " " + order + " ");
        }
        return orderFields.toString();
    }

    private static QFilter buildQFilter(DynamicObject invlevelRow, DynamicObject queryRuleDym) {
        StringBuilder stringBuilder = new StringBuilder();
        String sourceEntity = queryRuleDym.getString("srcentity.number");
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)sourceEntity);
        DynamicObjectCollection rows = queryRuleDym.getDynamicObjectCollection("matchentry");
        for (DynamicObject row : rows) {
            QFilter qFilter;
            String ldMatchFieldKey = row.getString("ldmatchfieldkey");
            String srcMatchFieldKey = row.getString("srcmatchfieldkey");
            BasedataProp property = (BasedataProp)RowDataModel.findProperty((MainEntityType)entityType, (String)srcMatchFieldKey);
            String matchtype = row.getString("matchtype");
            Object matchVal = InvpQuerySchemaHelper.getPkValue(invlevelRow.get(ldMatchFieldKey));
            String leftBracket = row.getString("leftbracket");
            String rightBracket = row.getString("rightbracket");
            String logic = row.getString("logic");
            srcMatchFieldKey = InvpQuerySchemaHelper.getFieldName((IDataEntityProperty)property);
            if ("A".equals(matchtype)) {
                qFilter = new QFilter(srcMatchFieldKey, "=", matchVal);
            } else {
                DynamicObject matchGroup = row.getDynamicObject("matchgroup");
                String groupObjNumber = matchGroup.getString("groupobj.number");
                qFilter = property.getBaseEntityId().equals(groupObjNumber) ? ModelFilterHelper.buildQFilterWithGroup2Data(matchGroup, srcMatchFieldKey, matchVal) : ModelFilterHelper.buildQFilterWithData2Group(matchGroup, srcMatchFieldKey, matchVal);
            }
            if (stringBuilder.length() != 0) {
                stringBuilder.append(StringUtils.wrap((String)logic, (String)" "));
            }
            stringBuilder.append(leftBracket);
            if (null == qFilter) {
                qFilter = new QFilter("1", "=", (Object)2);
            }
            stringBuilder.append(StringUtils.wrap((String)qFilter.toString(), (String)" "));
            stringBuilder.append(rightBracket);
        }
        return QFilter.of((String)stringBuilder.toString(), (Object[])new Object[0]);
    }

    private static String getFieldName(IDataEntityProperty property) {
        IDataEntityType entityType = property.getParent();
        if (entityType instanceof SubEntryType) {
            return entityType.getParent().getName() + "." + entityType.getName() + "." + property.getName();
        }
        if (entityType instanceof EntryType) {
            return entityType.getName() + "." + property.getName();
        }
        return property.getName();
    }

    private static Object getPkValue(Object val) {
        if (val instanceof DynamicObject) {
            return ((DynamicObject)val).getPkValue();
        }
        return val;
    }
}

