/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.common.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.invp.common.helper.BalKeyHelper;
import kd.scmc.invp.common.helper.InvPlanHelper;
import kd.scmc.invp.common.helper.ModelFilterHelper;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.map.MultiKeyMap;

public class InvpSafeStockCalHelper {
    private static final Log log = LogFactory.getLog(InvpSafeStockCalHelper.class);

    public static void doCal(Object schemeId, List<Object> invLevelIds) {
        if (schemeId == null || invLevelIds.isEmpty()) {
            return;
        }
        DynamicObject schemeDym = BusinessDataServiceHelper.loadSingleFromCache((Object)schemeId, (String)"invp_safestock_scheme");
        DynamicObject matchDimensionDym = ModelFilterHelper.loadFullDym(schemeDym.getDynamicObject("demmapping"));
        DynamicObject modelDym = ModelFilterHelper.loadFullDym(schemeDym.getDynamicObject("consumptionmodel"));
        Map<String, QFilter> srcFilterMap = ModelFilterHelper.buildSrcDataFilter(modelDym);
        Map<String, String> selectFieldMap = ModelFilterHelper.buildSelectFields(modelDym);
        MultiKeyMap<String, BidiMap<String, String>> fieldMap = ModelFilterHelper.buildFieldMap(modelDym);
        int traceDays = schemeDym.getInt("tracedays");
        String planType = schemeDym.getString("mainplantype");
        Date today = new Date();
        Date toDate = InvpSafeStockCalHelper.shortDate(today, 1);
        Date fromDate = InvpSafeStockCalHelper.shortDate(today, -traceDays + 1);
        String updateType = schemeDym.getString("updatetype");
        boolean addNew = "A".equals(updateType);
        BigDecimal coefficient = schemeDym.getBigDecimal("coefficient");
        ArrayList<Integer> leadTimes = new ArrayList<Integer>();
        List<Map<String, Object>> dimensionList = InvpSafeStockCalHelper.getDimensionMap(schemeDym, leadTimes, invLevelIds);
        Map<String, String> dimensionToRecordMap = InvpSafeStockCalHelper.getDimensionToRecordMap();
        HashMap<String, DynamicObject> recordMap = new HashMap<String, DynamicObject>(64);
        String writeBackFiled = schemeDym.getString("invlevelcolsign");
        HashMap<Object, BigDecimal> updateLevelMap = new HashMap<Object, BigDecimal>(dimensionList.size() * 2);
        for (int i = 0; i < dimensionList.size(); ++i) {
            Map<String, Object> dimensionMap = dimensionList.get(i);
            HashMap<String, QFilter> qFilterMap = new HashMap<String, QFilter>(dimensionList.size());
            Set<String> entityKeySet = srcFilterMap.keySet();
            for (Map.Entry<String, QFilter> entry : srcFilterMap.entrySet()) {
                String entryKey = entry.getKey();
                QFilter entryValue = entry.getValue();
                BidiMap modelToSrcFieldMap = (BidiMap)fieldMap.get((Object)"invp_safestock_model", (Object)entryKey);
                QFilter dimensionQFilter = ModelFilterHelper.buildModelDimensionQFilter(matchDimensionDym, dimensionMap, (BidiMap<String, String>)modelToSrcFieldMap);
                QFilter bizDateFilter = InvpSafeStockCalHelper.getBizDateFilter(fromDate, toDate, (BidiMap<String, String>)modelToSrcFieldMap);
                QFilter mergeFilter = entryValue.copy().and(dimensionQFilter).and(bizDateFilter);
                qFilterMap.put(entryKey, mergeFilter);
            }
            BigDecimal summary = new BigDecimal(0);
            ArrayList<Double> consumptionArray = new ArrayList<Double>(traceDays);
            try {
                DataSet dataSet = ModelFilterHelper.loadUnionDataSet(entityKeySet, selectFieldMap, qFilterMap);
                dataSet = dataSet.groupBy(new String[]{"bizdate"}).sum("baseqty").finish();
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    BigDecimal baseQty = row.getBigDecimal("baseqty");
                    summary = summary.add(baseQty);
                    consumptionArray.add(baseQty.doubleValue());
                }
                if (consumptionArray.size() < traceDays) {
                    InvpSafeStockCalHelper.fillConsumptionArray(consumptionArray, traceDays);
                }
                BigDecimal avgConsumption = summary.divide(BigDecimal.valueOf(traceDays), 2, RoundingMode.HALF_UP);
                BigDecimal safeStock = InvpSafeStockCalHelper.calStandardDeviation(consumptionArray, avgConsumption, coefficient.doubleValue(), (Integer)leadTimes.get(i));
                BigDecimal safeStockDays = avgConsumption.compareTo(BigDecimal.ZERO) != 0 ? safeStock.divide(avgConsumption, 2, RoundingMode.HALF_UP) : BigDecimal.ZERO;
                InvPlanHelper.maxValueCheck(avgConsumption, safeStock, safeStockDays);
                if (!StringUtils.isBlank((CharSequence)writeBackFiled)) {
                    Object invLevelId = dimensionMap.get("invlevelid");
                    if ("D".equals(planType)) {
                        updateLevelMap.put(invLevelId, safeStockDays);
                    } else if ("A".equals(planType) || "B".equals(planType)) {
                        updateLevelMap.put(invLevelId, safeStock);
                    }
                }
                String keyCol = InvpSafeStockCalHelper.getKeyCol(dimensionMap);
                DynamicObject record = InvpSafeStockCalHelper.generateRecord(schemeDym, dimensionMap, dimensionToRecordMap, avgConsumption, safeStock, safeStockDays, keyCol);
                recordMap.put(keyCol, record);
                continue;
            }
            catch (Exception e) {
                throw new KDBizException(e.getMessage());
            }
        }
        InvpSafeStockCalHelper.saveRecord(recordMap, addNew);
        if (!StringUtils.isBlank((CharSequence)writeBackFiled)) {
            InvpSafeStockCalHelper.writeBack(writeBackFiled, updateLevelMap, planType);
        }
    }

    @Deprecated
    public static void calculateSafeStock(DynamicObject schemeDym) {
    }

    private static void writeBack(String writeBackFiled, Map<Object, BigDecimal> updateLevelMap, String planType) {
        DynamicObject[] invLevels;
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)writeBackFiled)) {
            log.info("\u6ca1\u6709\u914d\u7f6e\u5e93\u5b58\u6c34\u4f4d\u4fe1\u606f\u5b57\u6bb5\uff0c\u65e0\u9700\u66f4\u65b0");
            return;
        }
        Set<String> selectFields = InvpSafeStockCalHelper.buildSelectFields();
        selectFields.add("id");
        selectFields.add(writeBackFiled);
        for (DynamicObject invLevel : invLevels = BusinessDataServiceHelper.load((String)"invp_invlevel", (String)String.join((CharSequence)",", selectFields), (QFilter[])new QFilter("id", "in", updateLevelMap.keySet()).toArray())) {
            Object pkValue = invLevel.getPkValue();
            invLevel.set(writeBackFiled, (Object)updateLevelMap.get(pkValue));
            InvpSafeStockCalHelper.reCalFieldsValue(invLevel, planType);
        }
        SaveServiceHelper.update((DynamicObject[])invLevels, (OperateOption)OperateOption.create());
    }

    private static Set<String> buildSelectFields() {
        HashSet<String> selectFields = new HashSet<String>(16);
        selectFields.addAll(Arrays.asList("urgentinvdays", "safeinvdays", "leadtime", "tgtinvdays", "orderperiod", "reorder", "dailyconsume", "safeinv"));
        return selectFields;
    }

    private static void reCalFieldsValue(DynamicObject invLevel, String planType) {
        BigDecimal leadTime = invLevel.getBigDecimal("leadtime");
        BigDecimal dailyConsume = invLevel.getBigDecimal("dailyconsume");
        if ("D".equals(planType)) {
            BigDecimal safeInvDays = invLevel.getBigDecimal("safeinvdays");
            BigDecimal urgentDays = leadTime.add(safeInvDays).setScale(2, RoundingMode.HALF_UP);
            BigDecimal tgtDays = leadTime.add(safeInvDays).add(invLevel.getBigDecimal("orderperiod")).setScale(2, RoundingMode.HALF_UP);
            InvPlanHelper.maxValueCheck(urgentDays, tgtDays);
            invLevel.set("urgentinvdays", (Object)urgentDays);
            invLevel.set("tgtinvdays", (Object)tgtDays);
        } else if ("A".equals(planType) && dailyConsume.compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal reorder = invLevel.getBigDecimal("safeinv").add(dailyConsume.multiply(leadTime)).setScale(2, RoundingMode.HALF_UP);
            InvPlanHelper.maxValueCheck(reorder);
            invLevel.set("reorder", (Object)reorder);
        }
    }

    private static void fillConsumptionArray(List<Double> consumptionArray, int traceDays) {
        int size;
        for (int i = size = consumptionArray.size(); i < traceDays; ++i) {
            consumptionArray.add(0.0);
        }
    }

    private static void saveRecord(Map<String, DynamicObject> recordMap, boolean addNew) {
        if (recordMap.isEmpty()) {
            return;
        }
        if (addNew) {
            SaveServiceHelper.save((DynamicObject[])recordMap.values().toArray(new DynamicObject[0]));
            return;
        }
        HashSet<String> keySet = new HashSet<String>(recordMap.keySet());
        DataSet oldData = QueryServiceHelper.queryDataSet((String)InvpSafeStockCalHelper.class.getName(), (String)"invp_safestock_record", (String)"id,keycol", (QFilter[])new QFilter("keycol", "in", keySet).toArray(), (String)"createtime desc");
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(recordMap.size());
        HashSet<Long> oldIds = new HashSet<Long>(recordMap.size());
        while (oldData.hasNext()) {
            String keyCol;
            DynamicObject updateDym;
            Row next = oldData.next();
            Long id = next.getLong("id");
            if (id == null || (updateDym = recordMap.remove(keyCol = next.getString("keycol"))) == null) continue;
            oldIds.add(id);
            updateDym.set("id", (Object)id);
            updateList.add(updateDym);
        }
        if (!updateList.isEmpty()) {
            try (TXHandle txHandle = TX.requiresNew();){
                try {
                    DeleteServiceHelper.delete((String)"invp_safestock_record", (QFilter[])new QFilter("id", "in", oldIds).toArray());
                    SaveServiceHelper.save((DynamicObject[])updateList.toArray(new DynamicObject[0]));
                }
                catch (Exception exception) {
                    log.error("\u66f4\u65b0\u73b0\u6709\u5b89\u5168\u5e93\u5b58\u8bb0\u5f55\u5931\u8d25\uff0c\u5b89\u5168\u5e93\u5b58id\uff1a{}", oldIds);
                }
            }
        }
        if (!recordMap.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])recordMap.values().toArray(new DynamicObject[0]));
        }
    }

    private static Map<String, String> getDimensionToRecordMap() {
        HashMap<String, String> dimensionToRecordMap = new HashMap<String, String>();
        dimensionToRecordMap.put("bd_material", "bd_material");
        dimensionToRecordMap.put("bd_materialgroupstandard", "bd_materialgroupstandard");
        dimensionToRecordMap.put("bd_materialgroup", "bd_materialgroup");
        dimensionToRecordMap.put("bos_org", "bos_org");
        dimensionToRecordMap.put("bd_warehouse", "bd_warehouse");
        return dimensionToRecordMap;
    }

    private static DynamicObject generateRecord(DynamicObject scheme, Map<String, Object> dimensionMap, Map<String, String> dimensionToRecordMap, BigDecimal avgConsumption, BigDecimal safeStock, BigDecimal safeStockDays, String keyColStr) {
        DynamicObject record = BusinessDataServiceHelper.newDynamicObject((String)"invp_safestock_record");
        record.set("modifytime", (Object)new Date());
        record.set("consumeperday", (Object)avgConsumption);
        record.set("safestock", (Object)safeStock);
        record.set("safestockdays", (Object)safeStockDays);
        record.set("keycol", (Object)keyColStr);
        record.set("scheme", scheme.getPkValue());
        record.set("dimension", (Object)scheme.getDynamicObject("dimension"));
        record.set("enable", (Object)"1");
        record.set("modifier", (Object)RequestContext.get().getCurrUserId());
        for (Map.Entry<String, Object> dimensionEntry : dimensionMap.entrySet()) {
            String dimensionField = dimensionEntry.getKey();
            if ("invlevelid".equals(dimensionField)) continue;
            String recordField = dimensionToRecordMap.get(dimensionField);
            Object val = dimensionEntry.getValue();
            record.set(recordField, val);
        }
        return record;
    }

    private static String getKeyCol(Map<String, Object> dimensionMap) {
        return BalKeyHelper.calKeyStr(dimensionMap);
    }

    private static BigDecimal calStandardDeviation(List<Double> consumptionArray, BigDecimal avgConsumption, Double coefficient, Integer leadTime) {
        int size = consumptionArray.size();
        double variance = 0.0;
        for (Double consumption : consumptionArray) {
            variance += Math.pow(consumption - avgConsumption.doubleValue(), 2.0);
        }
        double standardDeviation = Math.sqrt(variance / (double)size);
        double safeStockDays = coefficient * standardDeviation * Math.sqrt(leadTime.intValue());
        return BigDecimal.valueOf(safeStockDays).setScale(2, RoundingMode.HALF_UP);
    }

    private static QFilter getBizDateFilter(Date fromDate, Date toDate, BidiMap<String, String> modelToSrcFieldMap) {
        String srcBillFieldKey = (String)modelToSrcFieldMap.get((Object)"bizdate");
        return new QFilter(srcBillFieldKey, ">=", (Object)fromDate).and(srcBillFieldKey, "<", (Object)toDate);
    }

    private static List<Map<String, Object>> getDimensionMap(DynamicObject schemeDym, List<Integer> leadTimes, List<Object> invLevelIds) {
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>(5);
        DynamicObject dimension = schemeDym.getDynamicObject("dimension");
        dimension = BusinessDataServiceHelper.loadSingleFromCache((Object)dimension.getPkValue(), (String)"msplan_plan_dimension");
        DynamicObjectCollection dimensions = dimension.getDynamicObjectCollection("entryentity");
        HashSet<String> dimensionKeys = new HashSet<String>(invLevelIds.size() * 2);
        for (DynamicObject row : dimensions) {
            String entityKey = row.getString("associationobject.number");
            dimensionKeys.add(entityKey);
        }
        StringBuilder builder = new StringBuilder("id");
        String selectFields = String.join((CharSequence)",", dimensionKeys);
        builder.append(",").append(selectFields);
        builder.append(",").append("leadtime");
        QFilter filter = new QFilter("id", "in", invLevelIds);
        DataSet invLevelData = QueryServiceHelper.queryDataSet((String)ModelFilterHelper.class.getName(), (String)"invp_invlevel", (String)builder.toString(), (QFilter[])filter.toArray(), null);
        while (invLevelData.hasNext()) {
            Row row = invLevelData.next();
            int leadTime = row.getInteger("leadtime");
            leadTimes.add(leadTime);
            HashMap<String, Object> map = new HashMap<String, Object>(4);
            for (String dimensionKey : dimensionKeys) {
                map.put(dimensionKey, row.get(dimensionKey));
            }
            map.put("invlevelid", row.get("id"));
            mapList.add(map);
        }
        return mapList;
    }

    private static Date shortDate(Date date, int days) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.add(5, days);
        return calendar.getTime();
    }
}

