/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.common.helper;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;

public class InvpScheduleTaskHelper {
    private static final Log logger = LogFactory.getLog(InvpScheduleTaskHelper.class);

    public static void executeSchemeById(Object schemeId) {
        DynamicObject invScheme = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"invp_schedule_scheme");
        String schemeType = invScheme.getString("schemetype");
        DynamicObject planScheme = invScheme.getDynamicObject("planscheme");
        if (planScheme == null) {
            logger.error("\u5e93\u5b58\u8ba1\u5212-\u8c03\u5ea6\u65b9\u6848\u7684\u8ba1\u5212\u65b9\u6848\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u6267\u884c\u5b9a\u65f6\u4efb\u52a1");
            return;
        }
        Object planSchemeId = planScheme.getPkValue();
        logger.info(String.format("\u5e93\u5b58\u8ba1\u5212\u7b97\u6cd5\u8fd0\u884c\u53c2\u6570:planScheme = %s", planSchemeId));
        HashMap<String, Object> param = new HashMap<String, Object>(2);
        param.put("schemaId", planSchemeId);
        switch (schemeType) {
            case "invp_scheme": {
                logger.info("\u5f00\u59cb\u6267\u884c\u5e93\u5b58\u8ba1\u5212");
                InvpScheduleTaskHelper.executePlanScheme(invScheme);
                break;
            }
            case "invp_safestock_scheme": {
                logger.info("\u5f00\u59cb\u8ba1\u7b97\u5b89\u5168\u5e93\u5b58");
                InvpScheduleTaskHelper.calSafeStockDays(param);
                break;
            }
            case "invp_dailyavgcomsumption": {
                logger.info("\u5f00\u59cb\u8ba1\u7b97\u65e5\u5747\u6d88\u8017");
                InvpScheduleTaskHelper.calPreDailyUse(param);
                break;
            }
            case "invp_invlevel": {
                logger.info("\u5f00\u59cb\u8ba1\u7b97\u5e93\u5b58\u6c34\u4f4d\u4fe1\u606f");
                InvpScheduleTaskHelper.calInvLevel(param);
                break;
            }
            default: {
                logger.info(String.format("\u672a\u77e5\u7c7b\u578b\u7684\u65b9\u6848\u7c7b\u578b\uff1a%s", schemeType));
            }
        }
    }

    private static void executePlanScheme(DynamicObject dynamicObject) {
        DynamicObject org = dynamicObject.getDynamicObject("org");
        DynamicObject planScheme = dynamicObject.getDynamicObject("planscheme");
        if (org == null || planScheme == null) {
            logger.error("\u5e93\u5b58\u8ba1\u5212-\u8c03\u5ea6\u65b9\u6848\u7684\u8ba1\u5212\u7ec4\u7ec7\u6216\u8005\u8ba1\u5212\u65b9\u6848\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u6267\u884c\u5b9a\u65f6\u4efb\u52a1");
            return;
        }
        logger.info(String.format("\u5e93\u5b58\u8ba1\u5212\u7b97\u6cd5\u8fd0\u884c\u53c2\u6570:org = %s, planScheme = %s", org.getPkValue(), planScheme.getPkValue()));
        HashMap<String, Object> param = new HashMap<String, Object>(4);
        param.put("planOrg", org.getPkValue());
        param.put("planDate", new Date());
        param.put("schemeId", planScheme.getPkValue());
        DispatchServiceHelper.invokeBizService((String)"scmc", (String)"invp", (String)"InvPlanService", (String)"doInvPlan", (Object[])new Object[]{param});
    }

    private static void calSafeStockDays(Map<String, Object> param) {
        DispatchServiceHelper.invokeBizService((String)"scmc", (String)"invp", (String)"SafeStockService", (String)"executeCal", (Object[])new Object[]{param});
    }

    private static void calPreDailyUse(Map<String, Object> param) {
        DispatchServiceHelper.invokeBizService((String)"scmc", (String)"invp", (String)"DailyAvgConsumptionService", (String)"calc", (Object[])new Object[]{param});
    }

    private static void calInvLevel(Map<String, Object> param) {
        DispatchServiceHelper.invokeBizService((String)"scmc", (String)"invp", (String)"InvLevelService", (String)"calc", (Object[])new Object[]{param});
    }
}

