/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.common.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.invp.common.helper.InvpCalcRuleHelper;
import kd.scmc.invp.common.helper.InvpLevelFactorHelper;
import kd.scmc.invp.common.helper.ModelFilterHelper;
import org.apache.commons.lang3.StringUtils;

public class InvpSmartCalcHelper {
    public static void calc(DynamicObject invlevelDym) {
        DynamicObject smartCalcCfgDym = InvpSmartCalcHelper.querySmartCalcCfg(invlevelDym);
        if (null == smartCalcCfgDym) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5e93\u5b58\u6c34\u4f4d\u4fe1\u606f\u3010{0}\u3011\u6ca1\u6709\u914d\u7f6e\u667a\u80fd\u8ba1\u7b97\u8bbe\u7f6e\uff0c\u65e0\u6cd5\u6267\u884c\u667a\u80fd\u8ba1\u7b97\u3002", (String)"InvpSmartCalcHelper_0", (String)"scmc-invp-form", (Object[])new Object[]{invlevelDym.getString("number")}));
        }
        InvpSmartCalcHelper.validate(invlevelDym, smartCalcCfgDym);
        DynamicObject calcRuleDym = ModelFilterHelper.loadFullDym(smartCalcCfgDym.getDynamicObject("calcrulecfg"));
        DynamicObjectCollection querySchemas = smartCalcCfgDym.getDynamicObjectCollection("queryschema");
        List<Long> ids = querySchemas.stream().map(item -> item.getLong("fbasedataid.id")).collect(Collectors.toList());
        Collection<DynamicObject> querySchemaDymCollection = ModelFilterHelper.batchLoadFullDym("invp_queryschema", ids);
        DynamicObjectCollection collection = invlevelDym.getDynamicObjectCollection("entryentity");
        for (int i = 0; i < collection.size(); ++i) {
            DynamicObject invlevelRowDym = (DynamicObject)collection.get(i);
            Map<String, Object> map = InvpSmartCalcHelper.calc(invlevelRowDym, calcRuleDym, querySchemaDymCollection);
            for (Map.Entry<String, Object> valueEntry : map.entrySet()) {
                invlevelRowDym.set(valueEntry.getKey(), valueEntry.getValue());
            }
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{invlevelDym});
    }

    private static final DynamicObject querySmartCalcCfg(DynamicObject invlevelDym) {
        QFilter qFilter = new QFilter("invlevel", "=", invlevelDym.getPkValue());
        return BusinessDataServiceHelper.loadSingleFromCache((String)"invp_smartcalccfg", (String)"calcrulecfg,queryschema", (QFilter[])qFilter.toArray());
    }

    private static void validate(DynamicObject invlevelDym, DynamicObject smartCalcCfgDym) {
        String plantype = invlevelDym.getString("mainplantype");
        DynamicObject calcRuleDym = smartCalcCfgDym.getDynamicObject("calcrulecfg");
        if (null == calcRuleDym) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5e93\u5b58\u6c34\u4f4d\u4fe1\u606f\u3010{0}\u3011\u6ca1\u6709\u914d\u7f6e\u667a\u80fd\u8ba1\u7b97\u8bbe\u7f6e\uff0c\u65e0\u6cd5\u6267\u884c\u667a\u80fd\u8ba1\u7b97\u3002", (String)"InvpSmartCalcHelper_0", (String)"scmc-invp-form", (Object[])new Object[]{invlevelDym.getString("number")}));
        }
        calcRuleDym = ModelFilterHelper.loadFullDym(calcRuleDym);
        DynamicObjectCollection querySchemas = smartCalcCfgDym.getDynamicObjectCollection("queryschema");
        ArrayList<Long> ids = new ArrayList<Long>(querySchemas.size());
        for (DynamicObject querySchema : querySchemas) {
            ids.add(querySchema.getLong("fbasedataid.id"));
        }
        Collection<DynamicObject> querySchemaDymList = ModelFilterHelper.batchLoadFullDym("invp_queryschema", ids);
        String levelNumber = invlevelDym.getString("number");
        if (!plantype.equals(calcRuleDym.getString("plantype"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5e93\u5b58\u6c34\u4f4d\u4fe1\u606f\u3010{0}\u3011\u7684\u8ba1\u5212\u7c7b\u578b\u4e0e\u667a\u80fd\u8ba1\u7b97\u8bbe\u7f6e\u8ba1\u7b97\u89c4\u5219\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u6267\u884c\u667a\u80fd\u8ba1\u7b97\u3002", (String)"InvpSmartCalcHelper_1", (String)"scmc-invp-form", (Object[])new Object[]{levelNumber}));
        }
        for (DynamicObject querySchemaDym : querySchemaDymList) {
            if (plantype.equals(querySchemaDym.getString("plantype"))) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u5e93\u5b58\u6c34\u4f4d\u4fe1\u606f\u3010{0}\u3011\u7684\u8ba1\u5212\u7c7b\u578b\u4e0e\u667a\u80fd\u8ba1\u7b97\u8bbe\u7f6e\u53d6\u6570\u65b9\u6848\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u6267\u884c\u667a\u80fd\u8ba1\u7b97\u3002", (String)"InvpSmartCalcHelper_2", (String)"scmc-invp-form", (Object[])new Object[]{levelNumber}));
        }
    }

    public static Map<String, Object> calc(DynamicObject invlevelRowDym, DynamicObject calcRuleDym, Collection<DynamicObject> querySchemaDymCollection) {
        IDataEntityType entryType = invlevelRowDym.getDataEntityType();
        RowDataModel rowDataModel = new RowDataModel(entryType.getName(), MetadataServiceHelper.getDataEntityType((String)"invp_invlevel"));
        rowDataModel.setRowContext(invlevelRowDym);
        String plantype = calcRuleDym.getString("plantype");
        Map<Long, DynamicObject> querySchemaMap = InvpCalcRuleHelper.buildQuerySchemaMap(querySchemaDymCollection);
        Map<Long, Object> resultFactorValMap = InvpCalcRuleHelper.calcFactor(invlevelRowDym, calcRuleDym, querySchemaMap);
        Map<Long, String> levelFieldMap = InvpLevelFactorHelper.getFieldMap(resultFactorValMap.keySet(), plantype);
        HashMap<String, Object> assignMap = new HashMap<String, Object>(levelFieldMap.size());
        for (Map.Entry<Long, Object> factoryEntry : resultFactorValMap.entrySet()) {
            Long factorId = factoryEntry.getKey();
            Object factorVal = factoryEntry.getValue();
            String fieldName = levelFieldMap.get(factorId);
            if (!StringUtils.isNotBlank((CharSequence)fieldName)) continue;
            assignMap.put(fieldName, factorVal);
        }
        return assignMap;
    }
}

