/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.common.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class ModelFilterHelper {
    static List<Map<String, Object>> getDimensionMap(DynamicObject dacSchemeDym, List<Object> invLevelList) {
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>(5);
        DynamicObject dimension = ModelFilterHelper.loadFullDym(dacSchemeDym.getDynamicObject("dimension"));
        DynamicObjectCollection dimensions = dimension.getDynamicObjectCollection("entryentity");
        HashSet<String> dimensionKeys = new HashSet<String>(invLevelList.size() * 2);
        for (DynamicObject row : dimensions) {
            String entityKey = row.getString("associationobject.number");
            dimensionKeys.add(entityKey);
        }
        StringBuilder builder = new StringBuilder("id");
        String selectFields = String.join((CharSequence)",", dimensionKeys);
        builder.append(",").append(selectFields);
        QFilter filter = new QFilter("id", "in", invLevelList);
        DataSet invLevelData = QueryServiceHelper.queryDataSet((String)ModelFilterHelper.class.getName(), (String)"invp_invlevel", (String)builder.toString(), (QFilter[])filter.toArray(), null);
        while (invLevelData.hasNext()) {
            Row row = invLevelData.next();
            HashMap<String, Object> map = new HashMap<String, Object>(4);
            for (String dimensionKey : dimensionKeys) {
                map.put(dimensionKey, row.get(dimensionKey));
            }
            map.put("invlevelid", row.get("id"));
            mapList.add(map);
        }
        return mapList;
    }

    static List<Object> getInvLevelIds(DynamicObject dacSchemeDym) {
        String filterJson;
        String planType = dacSchemeDym.getString("mainplantype");
        DynamicObject dimension = ModelFilterHelper.loadFullDym(dacSchemeDym.getDynamicObject("dimension"));
        DynamicObjectCollection bosOrgCollection = dacSchemeDym.getDynamicObjectCollection("bosorg");
        List<Long> planner = ModelFilterHelper.getMulSelectBaseDataId(dacSchemeDym.getDynamicObjectCollection("planner"));
        List<Long> planGrp = ModelFilterHelper.getMulSelectBaseDataId(dacSchemeDym.getDynamicObjectCollection("plangroup"));
        HashSet orgs = new HashSet(bosOrgCollection.size() * 2);
        bosOrgCollection.forEach(org -> orgs.add(org.getLong("fbasedataid.id")));
        QFilter filter = new QFilter("mainplantype", "=", (Object)planType);
        filter.and("dimension", "=", dimension.getPkValue());
        filter.and("bos_org", "in", orgs);
        if (planner.size() > 0) {
            filter.and("planner", "in", planner);
        }
        if (planGrp.size() > 0) {
            filter.and("plangroup", "in", planGrp);
        }
        if (!StringUtils.isBlank((CharSequence)(filterJson = dacSchemeDym.getString("selectrulejson_tag")))) {
            MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"invp_invlevel");
            FilterCondition condition = (FilterCondition)SerializationUtils.fromJsonString((String)filterJson, FilterCondition.class);
            FilterBuilder filterBuilder = new FilterBuilder(entityType, condition);
            filterBuilder.buildFilter();
            filter.and(filterBuilder.getQFilter());
        }
        filter.and("enable", "=", (Object)"1");
        DataSet invLevelData = QueryServiceHelper.queryDataSet((String)ModelFilterHelper.class.getName(), (String)"invp_invlevel", (String)"id", (QFilter[])filter.toArray(), null);
        ArrayList<Object> invLevelIdSet = new ArrayList<Object>(64);
        while (invLevelData.hasNext()) {
            Row row = invLevelData.next();
            Long levelId = row.getLong("id");
            invLevelIdSet.add(levelId);
        }
        return invLevelIdSet;
    }

    public static QFilter buildModelDimensionQFilter(DynamicObject dimensionMatchDym, Map<String, Object> dimensionValMap, BidiMap<String, String> fieldMap) {
        StringBuilder stringBuilder = new StringBuilder();
        String sourceEntity = dimensionMatchDym.getString("srcentity.number");
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)sourceEntity);
        DynamicObjectCollection rows = dimensionMatchDym.getDynamicObjectCollection("matchentry");
        String logic = "";
        for (DynamicObject row : rows) {
            QFilter qFilter;
            String targetField = row.getString("tgtmatchfieldkey");
            String sourceField = row.getString("srcmatchfieldkey");
            BasedataProp property = (BasedataProp)RowDataModel.findProperty((MainEntityType)entityType, (String)sourceField);
            String fieldName = property.getName();
            String srcFieldName = (String)fieldMap.get((Object)targetField);
            String matchtype = row.getString("matchtype");
            Object matchVal = dimensionValMap.get(fieldName);
            String leftBracket = row.getString("leftbracket");
            String rightBracket = row.getString("rightbracket");
            if ("A".equals(matchtype)) {
                qFilter = new QFilter(srcFieldName, "=", matchVal);
            } else {
                DynamicObject matchGroup = row.getDynamicObject("matchgroup");
                String groupObjNumber = matchGroup.getString("groupobj.number");
                qFilter = property.getBaseEntityId().equals(groupObjNumber) ? ModelFilterHelper.buildQFilterWithGroup2Data(matchGroup, srcFieldName, matchVal) : ModelFilterHelper.buildQFilterWithData2Group(matchGroup, srcFieldName, matchVal);
            }
            if (stringBuilder.length() != 0) {
                stringBuilder.append(logic);
            }
            logic = row.getString("logic");
            stringBuilder.append(leftBracket);
            if (null == qFilter) {
                qFilter = new QFilter("1", "=", (Object)2);
            }
            stringBuilder.append(StringUtils.wrap((String)qFilter.toString(), (String)" "));
            stringBuilder.append(rightBracket);
        }
        return QFilter.of((String)stringBuilder.toString(), (Object[])new Object[0]);
    }

    public static QFilter buildQFilterWithData2Group(DynamicObject groupEntity, String srcField, Object matchVal) {
        if (null == groupEntity || null == matchVal) {
            return null;
        }
        String groupType = (String)groupEntity.getDynamicObject("groupobj").getPkValue();
        String dataType = (String)groupEntity.getDynamicObject("dataobj").getPkValue();
        Map groupMap = (Map)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"DataGroupService", (String)"getGroupIds", (Object[])new Object[]{dataType, Collections.singleton(matchVal), groupType});
        return new QFilter(srcField, "in", groupMap.get(matchVal));
    }

    public static QFilter buildQFilterWithGroup2Data(DynamicObject groupEntity, String srcField, Object matchVal) {
        if (null == groupEntity || null == matchVal) {
            return null;
        }
        String type = (groupEntity = ModelFilterHelper.loadFullDym(groupEntity)).getString("relationtype");
        if ("in".equals(type)) {
            String dateEntity = groupEntity.getString("dataobj.number");
            String groupkey = groupEntity.getString("groupkey");
            DynamicObjectCollection collection = QueryServiceHelper.query((String)dateEntity, (String)"id", (QFilter[])new QFilter(groupkey, "=", matchVal).toArray());
            List ids = collection.stream().map(item -> item.get("id")).collect(Collectors.toList());
            return new QFilter(srcField, "in", ids);
        }
        String relationEntity = groupEntity.getString("relationobj.number");
        String datakey = groupEntity.getString("datakey");
        String groupkey = groupEntity.getString("groupkey");
        DynamicObjectCollection collection = QueryServiceHelper.query((String)relationEntity, (String)datakey, (QFilter[])new QFilter(groupkey, "=", matchVal).toArray());
        List ids = collection.stream().map(item -> item.get(datakey)).collect(Collectors.toList());
        return new QFilter(srcField, "in", ids);
    }

    public static QFilter joinFilter(List<QFilter> filterList, boolean isAnd) {
        if (CollectionUtils.isEmpty(filterList)) {
            return null;
        }
        QFilter qFilter = filterList.get(0).copy();
        for (int i = 1; i < filterList.size(); ++i) {
            if (isAnd) {
                qFilter.and(filterList.get(i).copy());
                continue;
            }
            qFilter.or(filterList.get(i).copy());
        }
        return qFilter;
    }

    public static Map<String, QFilter> buildSrcDataFilter(DynamicObject cfgDym) {
        HashMap<String, QFilter> map = new HashMap<String, QFilter>(4);
        DynamicObjectCollection rows = cfgDym.getDynamicObjectCollection("entryentityds");
        for (DynamicObject row : rows) {
            QFilter filter;
            String entityKey = row.getDynamicObject("srcbillds").getString("number");
            String filterJson = row.getString("filtervalueds");
            if (StringUtils.isBlank((CharSequence)filterJson)) {
                filter = new QFilter("1", "=", (Object)1);
            } else {
                FilterCondition condition = (FilterCondition)SerializationUtils.fromJsonString((String)filterJson, FilterCondition.class);
                FilterBuilder filterBuilder = new FilterBuilder(MetadataServiceHelper.getDataEntityType((String)entityKey), condition);
                filterBuilder.buildFilter();
                filter = filterBuilder.getQFilter();
            }
            map.put(entityKey, filter);
        }
        return map;
    }

    public static Map<String, String> buildSelectFields(DynamicObject cfgDym) {
        HashMap<String, String> map = new HashMap<String, String>(4);
        DynamicObjectCollection rows = cfgDym.getDynamicObjectCollection("entryentityds");
        for (DynamicObject row : rows) {
            String entityKey = row.getDynamicObject("srcbillds").getString("number");
            DynamicObject fieldMappingDym = ModelFilterHelper.loadFullDym(row.getDynamicObject("billfieldmap"));
            DynamicObjectCollection fieldRows = fieldMappingDym.getDynamicObjectCollection("colsmap");
            StringJoiner selectFields = new StringJoiner(",");
            for (DynamicObject fieldRow : fieldRows) {
                String targetobjcol = fieldRow.getString("targetobjcol");
                String sourcebillcol = fieldRow.getString("sourcebillcol");
                if (StringUtils.isNotBlank((CharSequence)sourcebillcol)) {
                    selectFields.add(sourcebillcol + " as " + targetobjcol);
                    continue;
                }
                String formula = fieldRow.getString("formula_tag");
                CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)formula, CRCondition.class);
                if (!StringUtils.isNotBlank((CharSequence)condition.getExpression())) continue;
                String field = condition.getExpression();
                if (field.contains(".")) {
                    selectFields.add(field + " as " + targetobjcol);
                    continue;
                }
                if (!entityKey.equals(field)) continue;
                selectFields.add("'" + field + "' as " + targetobjcol);
            }
            map.put(entityKey, selectFields.toString());
        }
        return map;
    }

    public static DataSet loadDataSet(String entityKey, Map<String, String> fieldMap, QFilter qFilter) {
        String selectFiedls = fieldMap.get(entityKey);
        return QueryServiceHelper.queryDataSet((String)ModelFilterHelper.class.getName(), (String)entityKey, (String)selectFiedls, (QFilter[])qFilter.toArray(), null);
    }

    public static DataSet loadUnionDataSet(Set<String> entityKeySet, Map<String, String> fieldMap, Map<String, QFilter> filterMap) {
        ArrayList<DataSet> dataSetList = new ArrayList<DataSet>(entityKeySet.size());
        for (String entityKey : entityKeySet) {
            QFilter qFilter = filterMap.get(entityKey);
            DataSet dataSet = ModelFilterHelper.loadDataSet(entityKey, fieldMap, qFilter);
            dataSetList.add(dataSet);
        }
        DataSet returnDataSet = (DataSet)CollectionUtils.get(dataSetList, (int)0);
        for (int i = 1; i < dataSetList.size(); ++i) {
            returnDataSet = returnDataSet.union((DataSet)dataSetList.get(i));
        }
        return returnDataSet;
    }

    public static QFilter mergeFilter(QFilter ... qFilters) {
        if (ArrayUtils.isEmpty((Object[])qFilters)) {
            return null;
        }
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(qFilters.length);
        for (QFilter qFilter : qFilters) {
            if (null == qFilter) continue;
            filterList.add(qFilter);
        }
        return ModelFilterHelper.joinFilter(filterList, Boolean.TRUE);
    }

    static MultiKeyMap<String, BidiMap<String, String>> buildFieldMap(DynamicObject modelDym) {
        MultiKeyMap map = new MultiKeyMap();
        DynamicObjectCollection rows = modelDym.getDynamicObjectCollection("entryentityds");
        for (DynamicObject row : rows) {
            DynamicObject fieldMappingDym = ModelFilterHelper.loadFullDym(row.getDynamicObject("billfieldmap"));
            String srcEntityKey = fieldMappingDym.getString("sourcebill.number");
            String targetEntityKey = fieldMappingDym.getString("targetobj.number");
            BidiMap<String, String> fieldMap = ModelFilterHelper.buildCommonFieldMap(fieldMappingDym);
            map.put((Object)targetEntityKey, (Object)srcEntityKey, fieldMap);
        }
        return map;
    }

    public static DynamicObject loadFullDym(DynamicObject dym) {
        return BusinessDataServiceHelper.loadSingleFromCache((Object)dym.getPkValue(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)dym.getDataEntityType().getName()));
    }

    public static Collection<DynamicObject> batchLoadFullDym(String entityKey, Collection<Long> ids) {
        QFilter qFilter = new QFilter("id", "in", ids);
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)entityKey, (QFilter[])qFilter.toArray());
        return dynamicObjectMap.values();
    }

    public static BidiMap<String, String> buildResultFieldMap(DynamicObject modelDym) {
        DynamicObject outputResult = modelDym.getDynamicObject("outputresult");
        return ModelFilterHelper.buildCommonFieldMap(outputResult);
    }

    public static BidiMap<String, String> buildCommonFieldMap(DynamicObject billFieldMapping) {
        DynamicObject fieldMappingDym = ModelFilterHelper.loadFullDym(billFieldMapping);
        String srcEntityKey = fieldMappingDym.getString("sourcebill.number");
        DynamicObjectCollection fieldRows = fieldMappingDym.getDynamicObjectCollection("colsmap");
        DualHashBidiMap fieldMap = new DualHashBidiMap();
        for (DynamicObject fieldRow : fieldRows) {
            String targetobjcol = fieldRow.getString("targetobjcol");
            String sourcebillcol = fieldRow.getString("sourcebillcol");
            if (StringUtils.isNotBlank((CharSequence)sourcebillcol)) {
                fieldMap.put((Object)targetobjcol, (Object)sourcebillcol);
                continue;
            }
            String formula = fieldRow.getString("formula_tag");
            CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)formula, CRCondition.class);
            if (!StringUtils.isNotBlank((CharSequence)condition.getExpression())) continue;
            String field = condition.getExpression();
            if (field.contains(".")) {
                fieldMap.put((Object)targetobjcol, (Object)field);
                continue;
            }
            if (!srcEntityKey.equals(field)) continue;
            fieldMap.put((Object)targetobjcol, (Object)field);
        }
        return fieldMap;
    }

    public static BidiMap<String, String> buildDimensionFieldMap() {
        DualHashBidiMap fieldMap = new DualHashBidiMap();
        fieldMap.put((Object)"bd_material", (Object)"material");
        fieldMap.put((Object)"bd_materialgroupstandard", (Object)"GROUPSTANDARD");
        fieldMap.put((Object)"bd_materialgroup", (Object)"materialgroup");
        fieldMap.put((Object)"bos_org", (Object)"bizorg");
        fieldMap.put((Object)"bd_warehouse", (Object)"warehouse");
        return fieldMap;
    }

    public static List<Long> getMulSelectBaseDataId(DynamicObjectCollection collection) {
        ArrayList<Long> result = new ArrayList<Long>(16);
        if (collection != null && collection.size() > 0) {
            for (DynamicObject dynamicObject : collection) {
                result.add(dynamicObject.getDynamicObject("fbasedataid").getLong("id"));
            }
        }
        return result;
    }
}

