/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.common.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.scmc.invp.business.InvpInitModelHelper;

public class PlanViewOrgHelper {
    public static String getCtrlViewByEntityType(String entityType) {
        String ctrlViewNum = "";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)PlanViewOrgHelper.class.getName(), (String)"bd_basedataview", (String)"basedata, ctrlview.number", (QFilter[])new QFilter[]{new QFilter("basedata", "=", (Object)entityType)}, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                if (row.get("ctrlview.number") == null) continue;
                ctrlViewNum = row.getString("ctrlview.number");
            }
        }
        return ctrlViewNum;
    }

    public static boolean setDefaultOrgItem(String formId, List<FilterColumn> commonFilterColumns, String planorg) {
        ArrayList<Object> orgPks = new ArrayList<Object>(16);
        for (FilterColumn filterColumn : commonFilterColumns) {
            CommonFilterColumn columnFilter = (CommonFilterColumn)filterColumn;
            if (!columnFilter.getFieldName().startsWith(planorg)) continue;
            Set<Long> orgIds = InvpInitModelHelper.getOrgIdsByPlanView();
            Long uid = RequestContext.get().getCurrUserId();
            HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((Long)uid, (String)BizAppServiceHelp.getAppIdByAppNumber((String)"invp"), (String)formId, (String)"47150e89000000ac");
            columnFilter.getComboItems().clear();
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(16);
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(3);
            if (!result.hasAllOrgPerm()) {
                QFilter permFilter = new QFilter("id", "in", (Object)result.getHasPermOrgs());
                qFilters.add(permFilter);
            }
            QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
            QFilter pkFilter = new QFilter("id", "in", orgIds);
            qFilters.add(enableFilter);
            qFilters.add(pkFilter);
            Map orgMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"id,name", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"id");
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"bos_org");
            DynamicObjectCollection orgColl = new DynamicObjectCollection((DynamicObjectType)mainEntityType, null);
            if (orgMap != null) {
                orgColl.addAll(orgMap.values());
            }
            for (DynamicObject org : orgColl) {
                Object orgPk = org.getPkValue();
                orgPks.add(orgPk);
                comboItems.add(new ComboItem(new LocaleString(org.getLocaleString("name").getLocaleValue()), orgPk.toString()));
            }
            columnFilter.setComboItems(comboItems);
            ArrayList<String> defaultOrg = new ArrayList<String>();
            long currentOrgId = RequestContext.get().getOrgId();
            boolean match = orgPks.stream().map(orgx -> Long.valueOf(orgx.toString())).anyMatch(orgx -> orgx.equals(currentOrgId));
            if (!match && !ObjectUtils.isEmpty((Object)orgColl)) {
                defaultOrg.add(String.valueOf(((DynamicObject)orgColl.get(0)).getPkValue()));
            } else if (match) {
                defaultOrg.add(String.valueOf(currentOrgId));
            } else {
                columnFilter.setDefaultValue(null);
                return false;
            }
            columnFilter.setDefaultValues(defaultOrg);
            break;
        }
        return true;
    }
}

