/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.common.helper;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class ReqApplyBillHelper {
    public static void calDefaultReqApplyLogical(List<DynamicObject> reqList) {
        for (DynamicObject reqApplyBill : reqList) {
            DynamicObjectCollection billEntry = reqApplyBill.getDynamicObjectCollection("billentry");
            for (DynamicObject row : billEntry) {
                String unitConvertDir;
                DynamicObject auxUnit;
                DynamicObject material = row.getDynamicObject("material");
                DynamicObject unit = row.getDynamicObject("unit");
                DynamicObject baseUnit = row.getDynamicObject("baseunit");
                if (material == null) {
                    return;
                }
                DynamicObject materialMaster = material.getDynamicObject("masterid");
                if (baseUnit == null && (baseUnit = materialMaster.getDynamicObject("baseunit")) != null) {
                    row.set("baseunit", (Object)baseUnit);
                }
                Long materialMasterId = (Long)materialMaster.getPkValue();
                BigDecimal baseQty = row.getBigDecimal("baseqty");
                if (baseUnit != null) {
                    BigDecimal qty = ReqApplyBillHelper.getDesQtyConv(materialMasterId, baseUnit, baseQty, unit);
                    row.set("applyqty", (Object)qty);
                }
                if ((auxUnit = row.getDynamicObject("auxunit")) == null) {
                    DynamicObject auxptyUnit = materialMaster.getDynamicObject("auxptyunit");
                    row.set("auxunit", (Object)auxptyUnit);
                }
                if ((auxUnit = row.getDynamicObject("auxunit")) == null || !"A".equals(unitConvertDir = materialMaster.getString("unitconvertdir")) && !"C".equals(unitConvertDir)) continue;
                BigDecimal auxQty = ReqApplyBillHelper.getDesQtyConv(materialMasterId, baseUnit, baseQty, auxUnit);
                row.set("auxqty", (Object)auxQty);
            }
        }
    }

    public static BigDecimal getDesQtyConv(Long materialId, DynamicObject srcUnit, BigDecimal srcQty, DynamicObject desUnit) {
        BigDecimal desQty = BigDecimal.ZERO;
        if (materialId != null && srcUnit != null && desUnit != null && srcQty != null && srcQty.compareTo(BigDecimal.ZERO) != 0) {
            if (srcUnit.getPkValue().equals(desUnit.getPkValue())) {
                desQty = srcQty;
            } else {
                DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)((Long)srcUnit.getPkValue()), (Long)((Long)desUnit.getPkValue()));
                if (muConv != null) {
                    int numberator = muConv.getInt("numerator");
                    int denominator = muConv.getInt("denominator");
                    if (denominator != 0) {
                        desQty = srcQty.multiply(new BigDecimal(numberator)).divide(new BigDecimal(denominator), ReqApplyBillHelper.getPrecision(desUnit), ReqApplyBillHelper.getPrecisionType(desUnit));
                    }
                }
            }
        }
        return desQty;
    }

    public static int getPrecision(DynamicObject unit) {
        int precision = 10;
        if (unit != null) {
            precision = unit.getInt("precision");
        }
        return precision;
    }

    public static int getPrecisionType(DynamicObject unit) {
        int precisionType = 4;
        if (unit != null && StringUtils.isNotBlank((Object)unit.get("precisionaccount"))) {
            String precisionAccount;
            switch (precisionAccount = unit.getString("precisionaccount")) {
                case "1": {
                    precisionType = 4;
                    break;
                }
                case "2": {
                    precisionType = 1;
                    break;
                }
                case "3": {
                    precisionType = 0;
                    break;
                }
            }
        }
        return precisionType;
    }
}

