/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.scmc.invp.common.consts.InvPlanLogConstants;
import kd.scmc.invp.common.helper.InvPlanHelper;

public class InvPlanLogEditPlugin
extends AbstractBillPlugIn
implements ProgresssListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar progressBar = (ProgressBar)this.getControl("progressbar");
        if (progressBar != null) {
            progressBar.addProgressListener((ProgresssListener)this);
        }
    }

    public void onProgress(ProgressEvent evt) {
        this.getView().invokeOperation("refresh");
        Integer processRate = (Integer)this.getModel().getValue("processrate");
        evt.setProgress(processRate.intValue());
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ProgressBar progressBar = (ProgressBar)this.getControl("progressbar");
        if (progressBar != null) {
            String status = (String)this.getModel().getValue("status");
            if (StringUtils.equalsIgnoreCase((CharSequence)status, (CharSequence)InvPlanLogConstants.STATUS_RUNNING)) {
                progressBar.start();
            }
            Integer processRate = (Integer)this.getModel().getValue("processrate");
            this.setProgressBarColorAndStatus(status);
            progressBar.setPercent(processRate.intValue());
            HashMap<String, String> value2ColorMap = new HashMap<String, String>();
            value2ColorMap.put(InvPlanLogConstants.STEP_RESULT_FINISH, "#1BA854");
            value2ColorMap.put(InvPlanLogConstants.STEP_RESULT_ERROR, "rgba(255,0,0,0.7)");
            value2ColorMap.put(InvPlanLogConstants.STEP_RESULT_USER_STOP, "rgba(255,0,0,0.7)");
            value2ColorMap.put(InvPlanLogConstants.STEP_RESULT_PART_ERROR, "#fdc200");
            this.setCellColor(this.getView(), "entryentity", "stepresult", value2ColorMap);
            if (!StringUtils.equalsIgnoreCase((CharSequence)status, (CharSequence)InvPlanLogConstants.STATUS_RUNNING)) {
                progressBar.stop();
            }
        }
    }

    private void setProgressBarColorAndStatus(String cStatus) {
        String color = "#1BA854";
        Label processDescription = (Label)this.getControl("processdescription");
        if (StringUtils.equalsIgnoreCase((CharSequence)cStatus, (CharSequence)InvPlanLogConstants.STATUS_RUNNING)) {
            processDescription.setText(InvPlanHelper.loadKDString("\u8fd0\u7b97\u4e2d...", "InvPlanLogEditPlugin_0", new Object[0]));
            this.getView().setVisible(Boolean.FALSE, new String[]{"imgerror", "imgsuccess"});
            return;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)cStatus, (CharSequence)InvPlanLogConstants.STATUS_FAIL) || StringUtils.equalsIgnoreCase((CharSequence)cStatus, (CharSequence)InvPlanLogConstants.STATUS_USER_STOP)) {
            color = "rgba(255,0,0,0.7)";
            processDescription.setText(InvPlanHelper.loadKDString("\u8fd0\u7b97\u5931\u8d25", "InvPlanLogEditPlugin_1", new Object[0]));
            this.getView().setVisible(Boolean.FALSE, new String[]{"imgsuccess"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"imgerror"});
        } else {
            processDescription.setText(InvPlanHelper.loadKDString("\u8fd0\u7b97\u6210\u529f", "InvPlanLogEditPlugin_2", new Object[0]));
            this.getView().setVisible(Boolean.FALSE, new String[]{"imgerror"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"imgsuccess"});
        }
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        fieldMap.put("fc", color);
        this.getView().updateControlMetadata("progressbar", fieldMap);
    }

    private void setCellColor(IFormView fv, String entryKey, String fieldKey, Map<String, String> value2ColorMap) {
        if (fv == null || StringUtils.isBlank((CharSequence)entryKey) || StringUtils.isBlank((CharSequence)fieldKey)) {
            return;
        }
        IDataModel dm = fv.getModel();
        EntryGrid entryGrid = (EntryGrid)fv.getControl(entryKey);
        if (entryGrid == null) {
            return;
        }
        int rows = dm.getEntryRowCount(entryKey);
        ArrayList<CellStyle> cells = new ArrayList<CellStyle>();
        for (int i = 0; i < rows; ++i) {
            Object data = dm.getValue(fieldKey, i);
            String color = value2ColorMap.get(data.toString());
            if (StringUtils.isEmpty((CharSequence)color)) continue;
            CellStyle cell = new CellStyle();
            cell.setFieldKey(fieldKey);
            cell.setRow(i);
            cell.setForeColor(color);
            cells.add(cell);
        }
        if (!cells.isEmpty()) {
            entryGrid.setCellStyle(cells);
            fv.updateView(entryKey);
        }
    }
}

