/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.formplugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.invp.common.consts.CommonConst;
import kd.scmc.invp.common.helper.DataModelHelper;
import kd.scmc.invp.common.helper.FormUtil;
import kd.scmc.invp.common.helper.InvpCalcRuleHelper;
import kd.scmc.invp.common.helper.PlanTypeHelper;
import org.apache.commons.collections4.MapUtils;

public class InvpCalcRuleCfgEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"calcrule"});
        FormUtil.addF7Listener(this, "levelfactor");
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fieldKey;
        switch (fieldKey = evt.getProperty().getName()) {
            case "levelfactor": {
                this.beforeF7WithLevelFactor(evt);
                break;
            }
        }
    }

    private void beforeF7WithLevelFactor(BeforeF7SelectEvent evt) {
        IDataModel model = this.getModel();
        String planType = (String)model.getValue("plantype");
        if (null == planType) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8ba1\u5212\u7c7b\u578b\u3002", (String)"InvCalcRuleCfgEditPlugin_1", (String)"scmc-invp-form", (Object[])new Object[0]));
        }
        QFilter filter = PlanTypeHelper.buildFilter(planType);
        filter.and("enable", "=", (Object)Boolean.TRUE);
        evt.addCustomQFilter(filter);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        Object oldValue = changeSet[0].getOldValue();
        int rowIdx = changeSet[0].getRowIndex();
        switch (propertyName) {
            case "createorg": 
            case "plantype": {
                this.clearCalcRuleEntry(propertyName, newValue, oldValue);
                break;
            }
            case "calcrule": {
                this.ruleChange(newValue, oldValue);
                break;
            }
            case "levelfactor": {
                this.levelFactorChange(rowIdx);
                break;
            }
        }
    }

    private void levelFactorChange(int rowIdx) {
        DataModelHelper.clearEntryField(this.getModel(), rowIdx, "calcrule", "calcrulejson_tag", "calcdesc", "levelfactors");
        this.getView().updateView("calcruleentry", rowIdx);
    }

    private void clearCalcRuleEntry(String propName, Object newValue, Object oldValue) {
        if (oldValue != null) {
            HashMap<Object, Object> confirmInfo = new HashMap<Object, Object>(16);
            confirmInfo.put(CommonConst.OLD_VALUE, this.getPkVal(oldValue));
            confirmInfo.put("propName", propName);
            if (newValue != null) {
                confirmInfo.put(CommonConst.NEW_VALUE, this.getPkVal(newValue));
            }
            String msg = ResManager.loadKDString((String)"\u5207\u6362\u521b\u5efa\u7ec4\u7ec7\u3001\u8ba1\u5212\u7c7b\u578b\u5c06\u6e05\u9664\u9875\u9762\u7684\u8ba1\u7b97\u89c4\u5219\u4fe1\u606f\uff0c\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u64cd\u4f5c\uff1f", (String)"InvCalcRuleCfgEditPlugin_0", (String)"scmc-invp-form", (Object[])new Object[0]);
            ConfirmCallBackListener callBackListener = new ConfirmCallBackListener(propName, (IFormPlugin)this);
            this.getView().showConfirm(msg, null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, callBackListener, null, SerializationUtils.toJsonString(confirmInfo));
        } else {
            this.getModel().setValue(propName, newValue);
        }
    }

    private Object getPkVal(Object obj) {
        if (obj instanceof DynamicObject) {
            return ((DynamicObject)obj).getPkValue();
        }
        return obj;
    }

    private void ruleChange(Object newValue, Object oldValue) {
        DataModelHelper.clearField(StringUtils.isBlank((Object)newValue), this.getModel(), "calcrulejson_tag");
    }

    public void click(EventObject evt) {
        String fieldKey;
        super.click(evt);
        IDataModel model = this.getModel();
        Control control = (Control)evt.getSource();
        switch (fieldKey = control.getKey()) {
            case "calcrule": {
                this.clickCalcRule(model, control);
                break;
            }
        }
    }

    private void clickCalcRule(IDataModel model, Control control) {
        int currentRowIndex = control.getModel().getEntryCurrentRowIndex("calcruleentry");
        String rulejson = (String)model.getValue("calcrulejson_tag", currentRowIndex);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("invp_calcruleform");
        String treejson = this.buildTreeJson(model);
        showParameter.getCustomParams().put("formula", rulejson);
        showParameter.getCustomParams().put("treenodes", treejson);
        showParameter.getCustomParams().put("functiontypes", null);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "calcrule"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private String buildTreeJson(IDataModel model) {
        String planType = (String)model.getValue("plantype");
        DynamicObject levelfactor = (DynamicObject)model.getValue("levelfactor");
        if (null == planType || null == levelfactor) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8ba1\u5212\u7c7b\u578b\u3001\u6c34\u4f4d\u56e0\u5b50\u3002", (String)"InvCalcRuleCfgEditPlugin_2", (String)"scmc-invp-form", (Object[])new Object[0]));
        }
        QFilter filter = new QFilter(PlanTypeHelper.getFieldName(planType), "=", (Object)Boolean.TRUE);
        filter.and("enable", "=", (Object)Boolean.TRUE);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"invp_levelfactor", (String)"number,name", (QFilter[])filter.toArray());
        TreeNode root = new TreeNode("", "root", "\u6c34\u4f4d\u56e0\u5b50");
        root.setIsOpened(true);
        root.setCheckable(false);
        List list = Stream.of(dynamicObjects).map(item -> new TreeNode("root", InvpCalcRuleHelper.getFactorKey(item.getPkValue()), item.getString("name"))).collect(Collectors.toList());
        root.addChildren(list);
        return SerializationUtils.toJsonString((Object)root);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        String returnData = (String)evt.getReturnData();
        if (actionId == null || returnData == null) {
            return;
        }
        switch (actionId) {
            case "calcrule": {
                this.receiveFormula(returnData, "calcrulejson_tag", "calcrule");
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent closedEvent) {
        super.confirmCallBack(closedEvent);
        String callBackId = closedEvent.getCallBackId();
        MessageBoxResult result = closedEvent.getResult();
        String customValue = closedEvent.getCustomVaule();
        switch (callBackId) {
            case "createorg": 
            case "plantype": {
                this.confirmCB(result, customValue);
                break;
            }
        }
    }

    private void confirmCB(MessageBoxResult result, String customValue) {
        if (StringUtils.isBlank((CharSequence)customValue)) {
            return;
        }
        Map confirmInfo = (Map)SerializationUtils.fromJsonString((String)customValue, Map.class);
        String propName = MapUtils.getString((Map)confirmInfo, (Object)"propName");
        if (MessageBoxResult.Yes.equals((Object)result)) {
            Object newValue = confirmInfo.get(CommonConst.NEW_VALUE);
            this.getModel().beginInit();
            this.getModel().setValue(propName, newValue);
            this.getModel().deleteEntryData("calcruleentry");
            this.getModel().createNewEntryRow("calcruleentry");
            this.getModel().endInit();
            this.getView().updateView();
        } else {
            Object oldValue = confirmInfo.get(CommonConst.OLD_VALUE);
            this.getModel().beginInit();
            this.getModel().setValue(propName, oldValue);
            this.getModel().endInit();
            this.getView().updateView(propName);
        }
    }

    private void receiveFormula(String formulaJson, String formulaFldKey, String descFldKey) {
        int rowIdx = this.getModel().getEntryCurrentRowIndex("calcruleentry");
        if (StringUtils.isNotBlank((CharSequence)formulaJson)) {
            CRFormula formula = (CRFormula)SerializationUtils.fromJsonString((String)formulaJson, CRFormula.class);
            this.getModel().setValue(formulaFldKey, (Object)formulaJson, rowIdx);
            this.getModel().setValue(descFldKey, (Object)formula.getExprDesc(), rowIdx);
        } else {
            this.getModel().setValue(formulaFldKey, (Object)"", rowIdx);
            this.getModel().setValue(descFldKey, (Object)"", rowIdx);
        }
    }
}

