/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scmc.invp.business.strategy.FilterStrategy;
import kd.scmc.invp.common.consts.PropertyDataType;
import kd.scmc.invp.common.helper.DataModelHelper;
import kd.scmc.invp.common.helper.FormShowHelper;
import kd.scmc.invp.common.helper.FormUtil;
import kd.scmc.invp.formplugin.InvpFactorTplEditPlugin;

public class InvpDailyAvgConsumptionEditPlugin
extends InvpFactorTplEditPlugin
implements BeforeF7SelectListener,
BeforeFilterF7SelectListener {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"invlevelfield", "prerule"});
        FormUtil.addF7Listener(this, "invlevel", "matchdimension", "consumptionmodel", "dimension", "plangroup", "planner");
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("selectrule");
        filterGrid.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fieldKey;
        super.beforeF7Select(evt);
        switch (fieldKey = evt.getProperty().getName()) {
            case "invlevel": {
                this.beforeF7WithInvLevel(evt);
                break;
            }
            case "matchdimension": {
                this.beforeF7WithMatchDimension(evt);
                break;
            }
            case "consumptionmodel": {
                this.beforeF7WithModel(evt);
                break;
            }
        }
    }

    @Override
    protected QFilter getMatchConfFilter() {
        QFilter forward = new QFilter("tgtentity", "=", (Object)"invp_dac_model");
        forward = forward.and("srcentity", "=", (Object)"invp_invlevel");
        QFilter reverse = new QFilter("tgtentity", "=", (Object)"invp_invlevel");
        reverse = reverse.and("srcentity", "=", (Object)"invp_dac_model");
        return forward.or(reverse);
    }

    private void beforeF7WithInvLevel(BeforeF7SelectEvent evt) {
        Object planOrg = this.getModel().getValue("createorg");
        if (planOrg == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u521b\u5efa\u7ec4\u7ec7\u3002", (String)"InvpDailyAvgConsumptionEditPlugin_0", (String)"scmc-invp-form", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        DynamicObject planOrgDy = (DynamicObject)planOrg;
        QFilter filter = BaseDataServiceHelper.getBaseDataFilter((String)"invp_invlevel", (Long)((Long)planOrgDy.getPkValue()));
        filter.and("enable", "=", (Object)Boolean.TRUE);
        evt.addCustomQFilter(filter);
    }

    private void beforeF7WithModel(BeforeF7SelectEvent evt) {
        Object planOrg = this.getModel().getValue("createorg");
        if (planOrg == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u521b\u5efa\u7ec4\u7ec7\u3002", (String)"InvpDailyAvgConsumptionEditPlugin_0", (String)"scmc-invp-form", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        DynamicObject planOrgDy = (DynamicObject)planOrg;
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"invp_model_register", (Long)((Long)planOrgDy.getPkValue()));
        QFilter qFilter = new QFilter("businessentity", "=", (Object)"invp_dac_model");
        qFilter.and("enable", "=", (Object)"1");
        qFilter.and(baseDataFilter);
        evt.addCustomQFilter(qFilter);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        Object oldValue = changeSet[0].getOldValue();
        switch (propertyName) {
            case "basedatetype": {
                this.basedatetypeChange(newValue);
                break;
            }
            case "prerule": {
                this.preruleChange(newValue);
                break;
            }
            case "invlevelfield": {
                this.invlevelFieldChange(newValue);
                break;
            }
            case "mainplantype": {
                this.getModel().setValue("invlevelfield", null);
                break;
            }
        }
    }

    @Override
    protected String getMatchDimensionKey() {
        return "matchdimension";
    }

    private void invlevelFieldChange(Object newValue) {
        if (ObjectUtils.isEmpty((Object)newValue)) {
            DataModelHelper.clearField(this.getModel(), "invlevelfieldkey");
        }
    }

    private void preruleChange(Object newValue) {
        int rowIdx = this.getModel().getEntryCurrentRowIndex("exceptionentry");
        if (ObjectUtils.isEmpty((Object)newValue)) {
            DataModelHelper.clearEntryField(this.getModel(), rowIdx, "prerulejson_tag", "preruleformula_tag");
        }
    }

    private void basedatetypeChange(Object newValue) {
        int rowIdx = this.getModel().getEntryCurrentRowIndex("matchentry");
        if ("A".equals(newValue)) {
            this.getModel().setValue("dateselector", (Object)0, rowIdx);
        }
    }

    public void click(EventObject evt) {
        String fieldKey;
        super.click(evt);
        IDataModel model = this.getModel();
        Control control = (Control)evt.getSource();
        switch (fieldKey = control.getKey()) {
            case "invlevelfield": {
                this.clickInvLevelField();
                break;
            }
            case "prerule": {
                this.clickPreRule(model);
                break;
            }
        }
    }

    private void clickPreRule(IDataModel model) {
        int currentRowIndex = model.getEntryCurrentRowIndex("exceptionentry");
        FormShowHelper.showEntryFilterForm(this, model, "invp_dac_model", currentRowIndex, "prerulejson_tag", "prerule");
    }

    private void clickInvLevelField() {
        ArrayList<String> fields = new ArrayList<String>(4);
        fields.addAll(this.getSelectField());
        FilterStrategy filterStrategy = new FilterStrategy(fields);
        FormShowHelper.showColsTreeForm(this, "invp_invlevel", filterStrategy, null, false, "invlevelfield", new PropertyDataType[0]);
    }

    private Set<String> getSelectField() {
        HashSet<String> result = new HashSet<String>(16);
        String planType = (String)this.getModel().getValue("mainplantype");
        QFilter filter = new QFilter("id", "=", (Object)1763869143305945088L).and("enable", "=", (Object)"1").and("entryentity.plantype", "=", (Object)planType).and("entryentity.relentity", "=", (Object)"invp_invlevel");
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"invp_levelfactor", (String)"id,entryentity.relfieldkey as relfieldkey", (QFilter[])filter.toArray(), null);
        for (Row row : dataSet) {
            String fieldKey = row.getString("relfieldkey");
            if (!StringUtils.isNotEmpty((CharSequence)fieldKey)) continue;
            result.add(fieldKey);
        }
        return result;
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        String returnData = (String)evt.getReturnData();
        IDataModel dataModel = this.getModel();
        IPageCache pageCache = this.getPageCache();
        if (actionId == null || returnData == null) {
            return;
        }
        switch (actionId) {
            case "invlevelfield": {
                this.closeCallSetEntryField(returnData, "invlevelfield", "invlevelfieldkey", "invp_invlevel");
                break;
            }
            case "prerule": {
                FormShowHelper.closeCallSetEntryFilter(dataModel, pageCache, returnData, "prerule", "prerulejson_tag", "preruleformula_tag");
                break;
            }
        }
    }

    public void closeCallSetEntryField(String returnData, String field, String fieldKey, String entityKey) {
        IDataModel model = this.getModel();
        JSONArray jsonArr = (JSONArray)SerializationUtils.fromJsonString((String)returnData, JSONArray.class);
        if (jsonArr != null && !jsonArr.isEmpty()) {
            JSONObject jsonObject;
            Map entryMap = MetadataServiceHelper.getDataEntityType((String)entityKey).getAllEntities();
            if (entryMap.containsKey((jsonObject = jsonArr.getJSONObject(0)).get((Object)"id"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5177\u4f53\u7684\u5b57\u6bb5\u3002", (String)"InvpMatchConfigEditPlugin_2", (String)"scmc-invp-form", (Object[])new Object[0]));
            } else {
                model.setValue(field, jsonObject.get((Object)"text"));
                model.setValue(fieldKey, jsonObject.get((Object)"id"));
            }
        }
    }
}

