/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scmc.invp.common.helper.FormUtil;

public class InvpFactorTplEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
BeforeFilterF7SelectListener {
    private static final List<String> standardFields = Arrays.asList("org", "masterid", "sourcedata", "bitindex", "srcindex", "createorg", "number", "name", "mainplantype", "dimension", "planner", "plangroup", "status", "status", "enable", "useorg", "ctrlstrategy", "bos_org", "bd_warehouse", "bd_materialgroupstandard", "bd_materialgroup", "bd_material", "supplytype", "orderperiod", "supplyday", "tgtinvdays", "urgentinvdays", "safeinvdays", "reorder", "ecobatch", "safeinv", "max", "min", "leadtime", "preprocessingtime", "deliverytime", "postprocessingtime", "dailyconsume", "creator", "createtime", "modifier", "modifytime", "auditor", "audittime", "disabler", "disabledate");

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtil.addF7Listener(this, "dimension", "plangroup", "planner");
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("selectrule");
        filterGrid.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initMatchConf();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String key;
        super.beforeDoOperation(e);
        switch (key = ((AbstractOperate)e.getSource()).getOperateKey()) {
            case "save": 
            case "submit": {
                this.beforeSave();
                break;
            }
        }
    }

    private void beforeSave() {
        IDataModel model = this.getModel();
        FilterGrid grid = (FilterGrid)this.getControl("selectrule");
        FilterCondition condition = grid.getFilterGridState().getFilterCondition();
        String jsonStr = SerializationUtils.toJsonString((Object)condition);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"invp_invlevel");
        FilterBuilder filterBuilder = new FilterBuilder(entityType, condition);
        filterBuilder.buildFilter(false);
        String[] scripts = filterBuilder.buildFilterScript();
        model.setValue("selectrulejson_tag", (Object)jsonStr);
        model.setValue("selectruleformula_tag", (Object)scripts[0]);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fieldKey;
        switch (fieldKey = evt.getProperty().getName()) {
            case "planner": {
                this.beforeF7Planner(evt);
                break;
            }
            case "plangroup": {
                this.beforeF7PlanGrp(evt);
                break;
            }
        }
    }

    private void beforeF7Planner(BeforeF7SelectEvent evt) {
        QFilter qFilter = new QFilter("opergrptype", "=", (Object)"JHZ");
        qFilter.and("invalid", "=", (Object)"0");
        evt.addCustomQFilter(qFilter);
    }

    private void beforeF7PlanGrp(BeforeF7SelectEvent evt) {
        QFilter qFilter = new QFilter("operatorgrouptype", "=", (Object)"JHZ");
        qFilter.and("enable", "=", (Object)"1");
        evt.addCustomQFilter(qFilter);
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent event) {
        String refEntityId;
        switch (refEntityId = event.getRefEntityId()) {
            case "bd_material": {
                this.beforeMatOrWhFilterF7(event, "bd_material");
                break;
            }
            case "bd_materialgroup": {
                this.beforeMaterialGrpFilterF7(event);
                break;
            }
            case "bd_warehouse": {
                this.beforeMatOrWhFilterF7(event, "bd_warehouse");
                break;
            }
        }
    }

    private void beforeMatOrWhFilterF7(BeforeFilterF7SelectEvent event, String entityId) {
        Object bosOrg = this.getModel().getValue("bosorg");
        if (bosOrg == null || ((DynamicObjectCollection)bosOrg).isEmpty()) {
            event.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u4e1a\u52a1\u7ec4\u7ec7\u3002", (String)"InvpMatchConfigEditPlugin_9", (String)"scmc-invp-form", (Object[])new Object[0]));
            return;
        }
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObjectCollection bosOrgs = (DynamicObjectCollection)bosOrg;
        ArrayList orgIds = new ArrayList(bosOrgs.size() * 2);
        bosOrgs.forEach(org -> orgIds.add(org.getLong("fbasedataid.id")));
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)entityId, orgIds, (boolean)true);
        qFilter.and(baseDataFilter);
        qFilter.and("status", "=", (Object)"C");
        event.addCustomQFilter(qFilter);
    }

    private void beforeMaterialGrpFilterF7(BeforeFilterF7SelectEvent event) {
        Object bosOrg = this.getModel().getValue("bosorg");
        if (bosOrg == null || ((DynamicObjectCollection)bosOrg).isEmpty()) {
            event.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u4e1a\u52a1\u7ec4\u7ec7\u3002", (String)"InvpMatchConfigEditPlugin_9", (String)"scmc-invp-form", (Object[])new Object[0]));
            return;
        }
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        event.addCustomQFilter(qFilter);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.updateSelectRuleFilter();
    }

    protected void updateSelectRuleFilter() {
        DynamicObject dimension = (DynamicObject)this.getModel().getValue("dimension");
        if (dimension == null) {
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl("selectrule");
            filterGrid.SetValue(new FilterCondition());
            filterGrid.setFilterColumns(new ArrayList());
            this.getView().updateView("selectrule");
            return;
        }
        DynamicObjectCollection entries = dimension.getDynamicObjectCollection("entryentity");
        Set<String> fields = entries.stream().map(entry -> entry.getDynamicObject("associationobject").getString("number")).collect(Collectors.toSet());
        fields.remove("bos_org");
        fields.remove("bd_materialgroupstandard");
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("selectrule");
        filterGrid.SetValue(new FilterCondition());
        filterGrid.setFilterColumns(this.getFilterColumns(fields));
        filterGrid.setEntityNumber("invp_invlevel");
        this.getView().updateView("selectrule");
        String filterJson = this.getModel().getDataEntity().getString("selectrulejson_tag");
        if (StringUtils.isNotBlank((CharSequence)filterJson)) {
            FilterCondition condition = (FilterCondition)SerializationUtils.fromJsonString((String)filterJson, FilterCondition.class);
            filterGrid.SetValue(condition);
        }
    }

    private List<Map<String, Object>> getFilterColumns(Set<String> fields) {
        EntityTypeUtil entityTypeUtil = new EntityTypeUtil();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"invp_invlevel");
        List<Map<String, Object>> filterColumns = entityTypeUtil.getFilterColumns((IDataEntityType)entityType, true);
        filterColumns = filterColumns.stream().filter(columnInfo -> {
            String fieldName = (String)columnInfo.get("fieldName");
            String fieldNameSuffix = "";
            fieldNameSuffix = fieldName.contains(".") ? fieldName.substring(0, fieldName.indexOf(".")) : fieldName;
            boolean flag = true;
            if (standardFields.contains(fieldNameSuffix) && fieldName.contains(".")) {
                flag = fieldName.contains(".number") || fieldName.contains(".name");
            }
            return flag && (fields.contains(fieldNameSuffix) || !standardFields.contains(fieldNameSuffix));
        }).collect(Collectors.toList());
        return filterColumns;
    }

    protected void initMatchConf() {
        Object dimensionObj = this.getModel().getValue("dimension");
        String matchDimensionKey = this.getMatchDimensionKey();
        if (dimensionObj == null) {
            this.getModel().setValue(matchDimensionKey, null);
            return;
        }
        DynamicObject dimension = (DynamicObject)dimensionObj;
        QFilter filter = new QFilter("ispreset", "=", (Object)"1");
        List<Object> matchConfIds = this.getMatchConfIds(dimension, filter);
        if (matchConfIds.isEmpty()) {
            this.getModel().setValue(matchDimensionKey, null);
            return;
        }
        this.getModel().setValue(matchDimensionKey, matchConfIds.get(0));
    }

    protected String getMatchDimensionKey() {
        return null;
    }

    protected void beforeF7WithMatchDimension(BeforeF7SelectEvent evt) {
        DynamicObject dimension = (DynamicObject)this.getModel().getValue("dimension");
        if (dimension == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u5e93\u5b58\u6c34\u4f4d\u7ef4\u5ea6\u3002", (String)"InvpFactorTplEditPlugin_0", (String)"scmc-invp-form", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        List<Object> matchConfIds = this.getMatchConfIds(dimension, null);
        evt.addCustomQFilter(new QFilter("id", "in", matchConfIds));
    }

    protected List<Object> getMatchConfIds(DynamicObject dimension, QFilter qFilter) {
        if (dimension == null) {
            return new ArrayList<Object>(1);
        }
        HashSet<String> dimensions = new HashSet<String>();
        DynamicObjectCollection entries = dimension.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entries) {
            dimensions.add(entry.getString("associationobject.number"));
        }
        dimensions.remove("bd_materialgroupstandard");
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        QFilter filter = this.getMatchConfFilter();
        enable.and(filter);
        if (qFilter != null) {
            enable.and(qFilter);
        }
        Map matchConfigs = BusinessDataServiceHelper.loadFromCache((String)"invp_matchmapping_config", (String)"id,tgtentity.id,srcentity.id,matchentry.tgtmatchfieldkey,matchentry.srcmatchfieldkey", (QFilter[])enable.toArray());
        List matchConfigList = matchConfigs.values().stream().filter(matchConfig -> {
            HashSet<String> cols = new HashSet<String>();
            String tarEntity = matchConfig.getString("tgtentity.id");
            DynamicObjectCollection matchEntries = matchConfig.getDynamicObjectCollection("matchentry");
            for (DynamicObject entry : matchEntries) {
                if ("invp_invlevel".equals(tarEntity)) {
                    cols.add(entry.getString("tgtmatchfieldkey"));
                    continue;
                }
                cols.add(entry.getString("srcmatchfieldkey"));
            }
            return dimensions.size() == cols.size() && cols.removeAll(dimensions) && cols.isEmpty();
        }).collect(Collectors.toList());
        return matchConfigList.stream().map(mapInfo -> mapInfo.getLong("id")).collect(Collectors.toList());
    }

    protected QFilter getMatchConfFilter() {
        throw new RuntimeException("no implements found.");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        Object oldValue = changeSet[0].getOldValue();
        switch (propertyName) {
            case "dimension": {
                this.dimensionChange(oldValue);
                break;
            }
            case "planner": {
                this.changePlanner(oldValue);
                break;
            }
            case "plangroup": {
                this.changePlanGroup(oldValue);
                break;
            }
        }
    }

    private void dimensionChange(Object oldValue) {
        if (oldValue == null) {
            IDataModel model = this.getModel();
            model.setValue("selectrulejson_tag", null);
            model.setValue("selectruleformula_tag", null);
            this.updateSelectRuleFilter();
            this.initMatchConf();
        } else {
            String message = ResManager.loadKDString((String)"\u5e93\u5b58\u6c34\u4f4d\u7ef4\u5ea6\u5207\u6362\uff0c\u5c06\u6e05\u7a7a\u8ba1\u5212\u8303\u56f4\u8fc7\u6ee4\u6761\u4ef6\u548c\u5339\u914d\u7ef4\u5ea6\u6620\u5c04\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"InvpDailyAvgConsumptionEditPlugin_1", (String)"scmc-invp", (Object[])new Object[0]);
            this.getView().showConfirm(message, "", MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("dimension"), null, ((DynamicObject)oldValue).getPkValue().toString());
        }
    }

    private void changePlanner(Object oldValue) {
        Object planGroup = this.getModel().getValue("plangroup");
        if (planGroup != null && !((MulBasedataDynamicObjectCollection)planGroup).isEmpty()) {
            List orgIdList = ((MulBasedataDynamicObjectCollection)oldValue).stream().map(org -> org.getDynamicObject("fbasedataid").getString("id")).collect(Collectors.toList());
            String message = ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u4f9d\u636e\u8ba1\u5212\u5458\u786e\u8ba4\u8ba1\u5212\u8303\u56f4\u5417\uff1f\u6b64\u64cd\u4f5c\u5c06\u6e05\u7a7a\u8ba1\u5212\u7ec4\u7684\u4fe1\u606f\u3002", (String)"InvpSchemeEditPlugin_15", (String)"scmc-invp", (Object[])new Object[0]);
            this.getView().showConfirm(message, "", MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("planner"), null, SerializationUtils.toJsonString(orgIdList));
        }
    }

    private void changePlanGroup(Object oldValue) {
        Object planner = this.getModel().getValue("planner");
        if (planner != null && !((MulBasedataDynamicObjectCollection)planner).isEmpty()) {
            List orgIdList = ((MulBasedataDynamicObjectCollection)oldValue).stream().map(org -> org.getDynamicObject("fbasedataid").getString("id")).collect(Collectors.toList());
            String message = ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u4f9d\u636e\u8ba1\u5212\u7ec4\u786e\u8ba4\u8ba1\u5212\u8303\u56f4\u5417\uff1f\u6b64\u64cd\u4f5c\u5c06\u6e05\u7a7a\u8ba1\u5212\u5458\u7684\u4fe1\u606f\u3002", (String)"InvpSchemeEditPlugin_16", (String)"scmc-invp", (Object[])new Object[0]);
            this.getView().showConfirm(message, "", MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("plangroup"), null, SerializationUtils.toJsonString(orgIdList));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        String customValue = messageBoxClosedEvent.getCustomVaule();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        switch (callBackId) {
            case "dimension": {
                this.dimensionCallBack(result, customValue);
                break;
            }
            case "planner": {
                this.plannerCallBack(result);
                break;
            }
            case "plangroup": {
                this.planGroupCallBack(result);
                break;
            }
        }
    }

    private void dimensionCallBack(MessageBoxResult result, String oldId) {
        if (MessageBoxResult.Yes == result) {
            IDataModel model = this.getModel();
            model.setValue("selectrulejson_tag", null);
            model.setValue("selectruleformula_tag", null);
            this.updateSelectRuleFilter();
            this.initMatchConf();
        } else {
            this.getModel().beginInit();
            this.getModel().setItemValueByID("dimension", (Object)Long.parseLong(oldId));
            this.getModel().endInit();
            this.getView().updateView("dimension");
        }
    }

    private void plannerCallBack(MessageBoxResult result) {
        if (MessageBoxResult.Yes == result) {
            this.setFieldValue("plangroup", null);
        } else {
            this.setFieldValue("planner", null);
        }
    }

    private void planGroupCallBack(MessageBoxResult result) {
        if (MessageBoxResult.Yes == result) {
            this.setFieldValue("planner", null);
        } else {
            this.setFieldValue("plangroup", null);
        }
    }

    private void setFieldValue(String field, Object value) {
        this.getModel().beginInit();
        this.getModel().setValue(field, value);
        this.getModel().endInit();
        this.getView().updateView(field);
    }
}

