/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.formplugin;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.IPageCache;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.invp.business.InvpInitModelHelper;
import kd.scmc.invp.common.enumeration.InitContextEnum;
import kd.scmc.invp.common.helper.PlanViewOrgHelper;

public class InvpInitModelListPlugin
extends AbstractListPlugin {
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List commonFilterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        boolean hasRight = PlanViewOrgHelper.setDefaultOrgItem("invp_init_model", commonFilterColumns, "org");
        if (!hasRight) {
            IPageCache pageCache = this.getView().getPageCache();
            pageCache.put("hasPlanOrg", "FALSE");
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u53ef\u4f7f\u7528\u7684\u8ba1\u5212\u7ec4\u7ec7\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u8fdb\u884c\u6388\u6743\u3002", (String)"InvpInitModelListPlugin_4", (String)"scmc-invp-formplugin", (Object[])new Object[0]));
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String field = args.getFieldName();
        if (field != null && field.contains("org")) {
            Set<Long> orgIds = InvpInitModelHelper.getOrgIdsByPlanView();
            QFilter orgFilter = new QFilter("id", "in", orgIds);
            args.addCustomQFilter(orgFilter);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        IPageCache pageCache = this.getView().getPageCache();
        String hasPlanOrg = pageCache.get("hasPlanOrg");
        if ("FALSE".equals(hasPlanOrg)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u53ef\u4f7f\u7528\u7684\u8ba1\u5212\u7ec4\u7ec7\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u8fdb\u884c\u6388\u6743\u3002", (String)"InvpInitModelListPlugin_4", (String)"scmc-invp-formplugin", (Object[])new Object[0]));
        }
        String key = e.getOperateKey();
        IListView listView = (IListView)this.getView();
        List selectedMainOrgIds = listView.getSelectedMainOrgIds();
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"gen_inititem") && e.getOperationResult().isSuccess() && this.checkUseOrg(selectedMainOrgIds)) {
            this.generateConfigItem();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"exec_init") && e.getOperationResult().isSuccess() && this.checkUseOrg(selectedMainOrgIds)) {
            this.execInit();
        }
    }

    private void execInit() {
        List selectedMainOrgIds;
        IListView listView = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listView.getSelectedRows();
        StringBuilder msg = new StringBuilder();
        List<Long> ids = this.getPkValues(selectedRows);
        QFilter qFilter = new QFilter("id", "in", ids);
        ArrayList<InitContextEnum> initEnums = new ArrayList<InitContextEnum>(ids.size());
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"invp_init_model", (String)"id,modelitem,initstatus", (QFilter[])new QFilter[]{qFilter}, null);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            String initType = row.getString("modelitem");
            String initStatus = row.getString("initstatus");
            InitContextEnum initEnum = null;
            switch (initType) {
                case "A": {
                    initEnum = InitContextEnum.ResModule;
                    break;
                }
                case "B": {
                    initEnum = InitContextEnum.AlgoModule;
                    break;
                }
            }
            if (StringUtils.equals((CharSequence)initStatus, (CharSequence)"A") && initEnum != null) {
                if (msg.length() > 0) {
                    msg.append('\u3001');
                }
                msg.append(initEnum.getName());
                Long queryId = row.getLong("id");
                ids.remove(queryId);
                continue;
            }
            if (initEnum == null) continue;
            initEnums.add(initEnum);
        }
        this.getPageCache().put("init_ids", SerializationUtils.toJsonString(ids));
        if (msg.length() > 0) {
            msg.append(ResManager.loadKDString((String)"\u642d\u5efa\u5df2\u5b8c\u6210\uff0c\u4e0d\u518d\u91cd\u590d\u642d\u5efa\u3002", (String)"InvpInitModelListPlugin_1", (String)"scmc-invp-form", (Object[])new Object[0]));
        }
        if (!(selectedMainOrgIds = listView.getSelectedMainOrgIds()).isEmpty()) {
            Long useOrgId = (Long)selectedMainOrgIds.get(0);
            InvpInitModelHelper.initInvPlanData(useOrgId, ids, initEnums);
        }
        this.getView().invokeOperation("refresh");
        String tip = ResManager.loadKDString((String)"\u642d\u5efa\u6210\u529f\u3002", (String)"InvpInitModelListPlugin_3", (String)"scmc-invp-formplugin", (Object[])new Object[0]);
        StringBuilder sb = new StringBuilder();
        for (InitContextEnum initEnum : initEnums) {
            sb.append(initEnum.getName()).append(tip).append("\r\n");
        }
        if (sb.length() == 0) {
            this.getView().showTipNotification(msg.toString());
            return;
        }
        if (msg.length() > 0) {
            sb.append((CharSequence)msg);
        }
        this.getView().showSuccessNotification(sb.toString());
    }

    private List<Long> getPkValues(ListSelectedRowCollection selectedRows) {
        ArrayList<Long> ids = new ArrayList<Long>(selectedRows.size());
        for (ListSelectedRow selectedRow : selectedRows) {
            Long id = (Long)selectedRow.getPrimaryKeyValue();
            ids.add(id);
        }
        return ids;
    }

    private void generateConfigItem() {
        IListView listView = (IListView)this.getView();
        List selectedMainOrgIds = listView.getSelectedMainOrgIds();
        if (!selectedMainOrgIds.isEmpty()) {
            InvpInitModelHelper.initConfigData((Long)selectedMainOrgIds.get(0));
            this.getView().invokeOperation("refresh");
        }
    }

    private boolean checkUseOrg(List<Long> selectedMainOrgIds) {
        if (selectedMainOrgIds.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8ba1\u5212\u7ec4\u7ec7\u3002", (String)"InvpInitModelListPlugin_0", (String)"scmc-invp-form", (Object[])new Object[0]));
            return false;
        }
        if (selectedMainOrgIds.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u4e2a\u8ba1\u5212\u7ec4\u7ec7\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"InvpInitModelListPlugin_2", (String)"scmc-invp-form", (Object[])new Object[0]));
            return false;
        }
        return true;
    }
}

