/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.formplugin;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.invp.common.consts.CommonConst;
import kd.scmc.invp.common.helper.FormUtil;
import kd.scmc.invp.common.helper.InvpLevelFactorHelper;
import kd.scmc.invp.common.helper.MrpMaterialGroupStandardHelper;
import org.apache.commons.collections4.MapUtils;

public class InvpInvLevelDataEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public static final String CACHE_HASMATERIALGROUP = "cache_hasmaterialgroup";
    private static final String CONFIRM_DIMENSION = "confirm_dimension";
    public static final String[] DIMENSION_FIELDS = new String[]{"bos_org", "bd_warehouse", "bd_materialgroupstandard", "bd_materialgroup", "bd_material", "materialname"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtil.addF7Listener(this, "dimension", "bd_materialgroupstandard", "bd_materialgroup", "bd_material", "bos_org");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IDataModel model = this.getModel();
        DynamicObjectCollection entry = model.getEntryEntity("entryentity");
        for (DynamicObject dynamicObject : entry) {
            DynamicObject bos_org = dynamicObject.getDynamicObject("bos_org");
            DynamicObject materialStandard = dynamicObject.getDynamicObject("bd_materialgroupstandard");
            if (bos_org == null || materialStandard == null) continue;
            String bosOrgId = String.valueOf(bos_org.getLong("id"));
            String materialStandardId = String.valueOf(materialStandard.getLong("id"));
            if (this.getPageCache().get(bosOrgId) != null) continue;
            this.getPageCache().put(bosOrgId, materialStandardId);
        }
        this.showDimensionFields();
        String mainplantype = (String)model.getValue("mainplantype");
        this.showLevelFactorFields(mainplantype);
    }

    private void showLevelFactorFields(String mainplantype) {
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)"invp_invleveldata");
        EntityType entryType = (EntityType)mainEntityType.getAllEntities().get("entryentity");
        Set<String> entryFields = entryType.getFields().keySet();
        Set<String> showFields = InvpLevelFactorHelper.showFields(this.getView(), mainplantype);
        InvpLevelFactorHelper.hideFields(this.getView(), entryFields, Arrays.asList(DIMENSION_FIELDS), showFields);
    }

    private void showDimensionFields() {
        InvpLevelFactorHelper.hideFields(this.getView(), Arrays.asList(DIMENSION_FIELDS), Collections.emptyList(), Collections.emptyList());
        DynamicObject value = (DynamicObject)this.getModel().getValue("dimension");
        List<MrpMaterialGroupStandardHelper.InvpInvDimensionEntry> entryList = MrpMaterialGroupStandardHelper.getInventoryDimension(value);
        for (MrpMaterialGroupStandardHelper.InvpInvDimensionEntry entry : entryList) {
            String entityNumber = entry.getAssociationobject();
            String fieldName = entry.getDimensionname();
            BasedataEdit basedataEdit = (BasedataEdit)this.getControl(entityNumber);
            if (basedataEdit == null) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u6c34\u4f4d\u4fe1\u606f\u4e0d\u652f\u6301%s\u7684\u7ef4\u5ea6\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e", (String)"InventoryLevelBasePlugin_4", (String)"scmc-invp-form", (Object[])new Object[0]), fieldName));
                continue;
            }
            if (!"bd_material".equals(entityNumber)) {
                basedataEdit.setCaption(new LocaleString(fieldName));
            } else {
                basedataEdit.setCaption(new LocaleString(String.format(ResManager.loadKDString((String)"%s\u7f16\u7801", (String)"InventoryLevelBasePlugin_5", (String)"scmc-invp-form", (Object[])new Object[0]), fieldName)));
            }
            basedataEdit.setMustInput(true);
            this.getPageCache().put(CACHE_HASMATERIALGROUP, "false");
            if ("bd_materialgroup".equals(entityNumber)) {
                this.getPageCache().put(CACHE_HASMATERIALGROUP, "true");
            }
            if ("bd_material".equals(entityNumber)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"materialname"});
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{entityNumber});
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (CONFIRM_DIMENSION.equals(callBackId) && MessageBoxResult.Yes == messageBoxClosedEvent.getResult()) {
            this.getModel().deleteEntryData("entryentity");
            this.showDimensionFields();
        } else if (CONFIRM_DIMENSION.equals(callBackId) && MessageBoxResult.Cancel == messageBoxClosedEvent.getResult()) {
            this.getModel().beginInit();
            if (this.getPageCache().get("oldValue") != null) {
                String oldValue = this.getPageCache().get("oldValue");
                this.getModel().setValue("dimension", (Object)Long.valueOf(oldValue));
                this.getView().updateView("dimension");
            }
            this.getModel().endInit();
        } else if ("createorg".equals(callBackId)) {
            MessageBoxResult result = messageBoxClosedEvent.getResult();
            String customValue = messageBoxClosedEvent.getCustomVaule();
            this.confirmOrg(result, customValue);
        } else if ("mainplantype".equals(callBackId)) {
            MessageBoxResult result = messageBoxClosedEvent.getResult();
            String customValue = messageBoxClosedEvent.getCustomVaule();
            this.confirmPlanType(result, customValue);
        }
    }

    private void confirmOrg(MessageBoxResult result, String customValue) {
        if (StringUtils.isBlank((CharSequence)customValue)) {
            return;
        }
        IDataModel model = this.getModel();
        Map confirmInfo = (Map)SerializationUtils.fromJsonString((String)customValue, Map.class);
        String propName = MapUtils.getString((Map)confirmInfo, (Object)"propName");
        if (MessageBoxResult.Yes.equals((Object)result)) {
            Object newValue = confirmInfo.get(CommonConst.NEW_VALUE);
            model.beginInit();
            model.setValue(propName, newValue);
            model.deleteEntryData("entryentity");
            model.endInit();
            this.getView().updateView();
        } else {
            Object oldValue = confirmInfo.get(CommonConst.OLD_VALUE);
            model.setValue(propName, oldValue);
        }
    }

    private void confirmPlanType(MessageBoxResult result, String customValue) {
        if (StringUtils.isBlank((CharSequence)customValue)) {
            return;
        }
        IDataModel model = this.getModel();
        Map confirmInfo = (Map)SerializationUtils.fromJsonString((String)customValue, Map.class);
        String propName = MapUtils.getString((Map)confirmInfo, (Object)"propName");
        if (MessageBoxResult.Yes.equals((Object)result)) {
            Object newValue = confirmInfo.get(CommonConst.NEW_VALUE);
            model.beginInit();
            model.setValue(propName, newValue);
            model.deleteEntryData("entryentity");
            model.endInit();
            this.getView().updateView("entryentity");
            this.showLevelFactorFields((String)newValue);
        } else {
            Object oldValue = confirmInfo.get(CommonConst.OLD_VALUE);
            model.setValue(propName, oldValue);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        Object oldValue = changeSet[0].getOldValue();
        String propName = e.getProperty().getName();
        IDataModel model = this.getModel();
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        String appID = this.getView().getFormShowParameter().getAppId();
        switch (propName) {
            case "dimension": {
                if (oldValue != null) {
                    DynamicObject dym = (DynamicObject)oldValue;
                    this.getPageCache().put("oldValue", String.valueOf(dym.getLong("id")));
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5e93\u5b58\u6c34\u4f4d\u7ef4\u5ea6\u5207\u6362\uff0c\u5c06\u6e05\u9664\u6c34\u4f4d\u56e0\u5b50\u6570\u636e\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"InvpInvLevelDataEditPlugin_0", (String)"scmc-invp-form", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CONFIRM_DIMENSION));
                    break;
                }
                this.showDimensionFields();
                break;
            }
            case "safeinv": 
            case "leadtime": 
            case "dailyconsume": {
                Object planType = this.getModel().getValue("plantype");
                if ("mrp".equals(appID) || "C".equals(planType)) break;
                BigDecimal s = (BigDecimal)model.getValue("safeinv");
                Integer l = (Integer)model.getValue("leadtime");
                BigDecimal d = (BigDecimal)model.getValue("dailyconsume");
                Object val = e.getChangeSet()[0].getNewValue();
                if (propName.equals("safeinv")) {
                    s = (BigDecimal)val;
                } else if (propName.equals("leadtime")) {
                    l = (Integer)val;
                } else {
                    d = (BigDecimal)val;
                }
                if (s == null || l == null || d == null) break;
                BigDecimal add = d.multiply(new BigDecimal(l)).add(s);
                model.setValue("reorder", (Object)add);
                break;
            }
            case "bos_org": {
                model.setValue("bd_materialgroupstandard", null, rowIndex);
                DynamicObject org = (DynamicObject)this.getModel().getValue("bos_org", rowIndex);
                if (org == null) break;
                String org_id = String.valueOf(org.getLong("id"));
                if (this.getPageCache().get(org_id) == null) break;
                String standardId = this.getPageCache().get(org_id);
                this.getModel().setValue("bd_materialgroupstandard", (Object)Long.valueOf(standardId), rowIndex);
                break;
            }
            case "bd_materialgroupstandard": {
                model.setValue("bd_materialgroup", null, rowIndex);
                DynamicObject bos_org = (DynamicObject)this.getModel().getValue("bos_org", rowIndex);
                DynamicObject material_standard = (DynamicObject)this.getModel().getValue("bd_materialgroupstandard");
                if (bos_org == null || material_standard == null) break;
                Long orgId = bos_org.getLong("id");
                Long standard_id = material_standard.getLong("id");
                this.getPageCache().put(String.valueOf(orgId), String.valueOf(standard_id));
                break;
            }
            case "bd_materialgroup": {
                model.setValue("bd_material", null, rowIndex);
                break;
            }
            case "mainplantype": {
                this.mainPlanTypeChange(propName, newValue, oldValue);
                break;
            }
        }
    }

    private void mainPlanTypeChange(String propName, Object newValue, Object oldValue) {
        boolean hasChanged = false;
        DynamicObjectCollection collection = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject dynamicObject : collection) {
            if (newValue.equals(dynamicObject.getString("plantype"))) continue;
            hasChanged = true;
            break;
        }
        if (hasChanged) {
            HashMap<Object, Object> confirmInfo = new HashMap<Object, Object>(16);
            confirmInfo.put(CommonConst.OLD_VALUE, this.getPkVal(oldValue));
            confirmInfo.put("propName", propName);
            if (newValue != null) {
                confirmInfo.put(CommonConst.NEW_VALUE, this.getPkVal(newValue));
            }
            String msg = ResManager.loadKDString((String)"\u8ba1\u5212\u7c7b\u578b\u5207\u6362\uff0c\u5c06\u6e05\u9664\u6c34\u4f4d\u56e0\u5b50\u6570\u636e\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"InvpInvLevelDataEditPlugin_1", (String)"scmc-invp-form", (Object[])new Object[0]);
            ConfirmCallBackListener callBackListener = new ConfirmCallBackListener(propName, (IFormPlugin)this);
            this.getView().showConfirm(msg, null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, callBackListener, null, SerializationUtils.toJsonString(confirmInfo));
        } else {
            this.showLevelFactorFields((String)newValue);
        }
    }

    private Object getPkVal(Object obj) {
        if (obj instanceof DynamicObject) {
            return ((DynamicObject)obj).getPkValue();
        }
        return obj;
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        RowDataEntity[] rows;
        super.afterAddRow(e);
        IDataModel model = this.getModel();
        String mainplantype = (String)model.getValue("mainplantype");
        for (RowDataEntity row : rows = e.getRowDataEntities()) {
            model.setValue("plantype", (Object)mainplantype, row.getRowIndex());
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String filedKey = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        if ("bd_materialgroupstandard".equals(filedKey)) {
            int rowIdx = this.getModel().getEntryCurrentRowIndex("entryentity");
            DynamicObject bos_org = (DynamicObject)this.getModel().getValue("bos_org", rowIdx);
            if (bos_org != null) {
                QFilter standardFilter = MrpMaterialGroupStandardHelper.getGroupStandardFilter("bd_material", bos_org.getLong("id"), true);
                showParameter.getListFilterParameter().setFilter(standardFilter);
            } else {
                QFilter qFilter = new QFilter("1", "!=", (Object)"1", true);
                showParameter.getListFilterParameter().setFilter(qFilter);
            }
        } else if ("bd_materialgroup".equals(filedKey)) {
            int rowIdx = this.getModel().getEntryCurrentRowIndex("entryentity");
            DynamicObject materialGroup_Standard = (DynamicObject)this.getModel().getValue("bd_materialgroupstandard", rowIdx);
            if (materialGroup_Standard != null) {
                QFilter qFilter = new QFilter("standard", "=", (Object)materialGroup_Standard.getLong("id"));
                showParameter.getListFilterParameter().setFilter(qFilter);
                beforeF7SelectEvent.getFormShowParameter().setCustomParam("groupStandard", materialGroup_Standard.getPkValue());
            } else {
                QFilter qFilter = new QFilter("1", "!=", (Object)"1", true);
                showParameter.getListFilterParameter().setFilter(qFilter);
            }
        } else if ("bd_material".equals(filedKey) && "true".equals(this.getPageCache().get(CACHE_HASMATERIALGROUP))) {
            int rowIdx = this.getModel().getEntryCurrentRowIndex("entryentity");
            DynamicObject materialGroup = (DynamicObject)this.getModel().getValue("bd_materialgroup", rowIdx);
            if (materialGroup == null) {
                QFilter qFilter = new QFilter("1", "!=", (Object)"1", true);
                showParameter.getListFilterParameter().setFilter(qFilter);
            } else {
                QFilter[] stdFilter = new QFilter[]{new QFilter("group", "=", materialGroup.getPkValue())};
                HashSet<Object> mts = new HashSet<Object>(64);
                try (DataSet ds = QueryServiceHelper.queryDataSet((String)"finish", (String)"bd_materialgroupdetail", (String)"material,group", (QFilter[])stdFilter, null);){
                    for (Row d : ds) {
                        Object mt = d.get("material");
                        mts.add(mt);
                    }
                }
                QFilter materialFilter = new QFilter("id", "in", mts);
                showParameter.getListFilterParameter().setFilter(materialFilter);
                DynamicObject std = (DynamicObject)this.getModel().getValue("bd_materialgroupstandard", rowIdx);
                if (std != null) {
                    beforeF7SelectEvent.getFormShowParameter().setCustomParam("groupStandard", std.getPkValue());
                }
            }
        }
    }
}

