/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scmc.invp.common.consts.CommonConst;
import kd.scmc.invp.common.consts.InvLevelConstants;
import kd.scmc.invp.common.consts.InventoryDimension;
import kd.scmc.invp.common.helper.FormUtil;
import kd.scmc.invp.common.helper.InvPlanHelper;
import kd.scmc.invp.common.helper.InvpLevelFactorHelper;
import kd.scmc.invp.common.helper.MrpMaterialGroupStandardHelper;

public class InvpInvLevelEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(InvpInvLevelEditPlugin.class);

    public void afterBindData(EventObject e) {
        DynamicObject dimension = (DynamicObject)this.getModel().getValue("dimension");
        this.setDimensionFields(dimension);
        String planType = (String)this.getModel().getValue("mainplantype");
        this.setPlanTypeFields(planType);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String planType = (String)this.getModel().getValue("mainplantype");
        this.setPlanTypeFields(planType);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        Object oldValue = changeSet[0].getOldValue();
        if (newValue != null && newValue.equals(oldValue) || newValue == null && oldValue == null) {
            return;
        }
        String propName = e.getProperty().getName();
        String planType = (String)this.getModel().getValue("mainplantype");
        switch (propName) {
            case "mainplantype": {
                this.planTypeChange(oldValue, newValue);
                break;
            }
            case "dimension": {
                this.dimensionChange(oldValue, newValue);
                break;
            }
            case "bd_materialgroupstandard": {
                this.materialGroupStandChange(oldValue, newValue);
                break;
            }
            case "bd_materialgroup": {
                this.materialGroupChange(oldValue, newValue);
                break;
            }
            case "planner": {
                this.plannerChange(oldValue, newValue);
                break;
            }
            case "supplytype": {
                this.supplyTypeChange(oldValue, newValue);
                break;
            }
            case "supplyday": {
                if (!"D".equals(planType)) break;
                this.calOrderPeriod();
                break;
            }
            case "safeinvdays": {
                if (!"D".equals(planType)) break;
                this.calUrgentInvDays();
                this.calTarInvDays();
                break;
            }
            case "leadtime": {
                if ("D".equals(planType)) {
                    this.calUrgentInvDays();
                    this.calTarInvDays();
                }
                if (!"A".equals(planType)) break;
                this.calReOrder();
                break;
            }
            case "orderperiod": {
                if (!"D".equals(planType)) break;
                this.calTarInvDays();
                break;
            }
            case "safeinv": 
            case "dailyconsume": {
                if (!"A".equals(planType)) break;
                this.calReOrder();
                break;
            }
            case "preprocessingtime": 
            case "deliverytime": 
            case "postprocessingtime": {
                this.calcLeadTime();
                break;
            }
        }
    }

    private void calReOrder() {
        BigDecimal dailyConsume = (BigDecimal)this.getModel().getValue("dailyconsume");
        if (dailyConsume.compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal leadTime = (BigDecimal)this.getModel().getValue("leadtime");
            BigDecimal safeInv = (BigDecimal)this.getModel().getValue("safeinv");
            BigDecimal reOrder = dailyConsume.multiply(leadTime).add(safeInv);
            this.getModel().setValue("reorder", (Object)reOrder);
        }
    }

    private void calcLeadTime() {
        BigDecimal preProcessTime = (BigDecimal)this.getModel().getValue("preprocessingtime");
        BigDecimal deliveryTime = (BigDecimal)this.getModel().getValue("deliverytime");
        BigDecimal postProcessTime = (BigDecimal)this.getModel().getValue("postprocessingtime");
        BigDecimal leadTime = preProcessTime.add(deliveryTime).add(postProcessTime);
        this.getModel().setValue("leadtime", (Object)leadTime);
    }

    private void calTarInvDays() {
        BigDecimal safeInvDays = (BigDecimal)this.getModel().getValue("safeinvdays");
        BigDecimal leadTime = (BigDecimal)this.getModel().getValue("leadtime");
        BigDecimal orderPeriod = (BigDecimal)this.getModel().getValue("orderperiod");
        BigDecimal tarInvDays = safeInvDays.add(leadTime).add(orderPeriod);
        this.getModel().setValue("tgtinvdays", (Object)tarInvDays);
    }

    private void calUrgentInvDays() {
        BigDecimal safeInvDays = (BigDecimal)this.getModel().getValue("safeinvdays");
        BigDecimal leadTime = (BigDecimal)this.getModel().getValue("leadtime");
        BigDecimal urgentInvDays = safeInvDays.add(leadTime);
        this.getModel().setValue("urgentinvdays", (Object)urgentInvDays);
    }

    public void calOrderPeriod() {
        MulBasedataDynamicObjectCollection supplyDays = (MulBasedataDynamicObjectCollection)this.getModel().getValue("supplyday");
        String supplyType = (String)this.getModel().getValue("supplytype");
        if (supplyDays == null || supplyDays.isEmpty()) {
            this.getModel().setValue("orderperiod", null);
        } else {
            List<Integer> supplyDayList = supplyDays.stream().map(supplyDay -> supplyDay.getDynamicObject("fbasedataid").getInt("value")).collect(Collectors.toList());
            supplyDayList.sort(Comparator.comparingInt(obj -> obj));
            int orderPeriod = InvPlanHelper.getOrderPeriod(supplyDayList, supplyType);
            this.getModel().setValue("orderperiod", (Object)new BigDecimal(orderPeriod).setScale(0));
        }
    }

    private void plannerChange(Object oldValue, Object newValue) {
        if (newValue == null) {
            this.getModel().setValue("plangroup", null);
        } else {
            DynamicObject planner = (DynamicObject)newValue;
            this.getModel().setItemValueByID("plangroup", (Object)planner.getLong("operatorgrpid"));
        }
    }

    private void materialGroupChange(Object oldValue, Object newValue) {
        this.getModel().setValue("bd_material", null);
    }

    private void materialGroupStandChange(Object oldValue, Object newValue) {
        this.getModel().setValue("bd_materialgroup", null);
    }

    private void dimensionChange(Object oldValue, Object newValue) {
        DynamicObject dimension = (DynamicObject)newValue;
        if (oldValue != null) {
            HashMap<Object, String> params = new HashMap<Object, String>();
            params.put(CommonConst.OLD_VALUE, ((DynamicObject)oldValue).getPkValue().toString());
            params.put("propName", "dimension");
            ConfirmCallBackListener callBackListener = new ConfirmCallBackListener("dimension", (IFormPlugin)this);
            String message = ResManager.loadKDString((String)"\u5e93\u5b58\u6c34\u4f4d\u7ef4\u5ea6\u5207\u6362\uff0c\u5c06\u6e05\u9664\u5e93\u5b58\u6c34\u4f4d\u7ef4\u5ea6\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"InvpInvLevelBasePlugin_2", (String)"scmc-invp-form", (Object[])new Object[0]);
            this.getView().showConfirm(message, "", MessageBoxOptions.OKCancel, ConfirmTypes.Default, callBackListener, null, SerializationUtils.toJsonString(params));
        } else {
            this.setDimensionFields(dimension);
        }
    }

    private void setDimensionFields(DynamicObject levelDimenSion) {
        InvpLevelFactorHelper.hideFields(this.getView(), InvLevelConstants.DIMENSION_FIELDS, Collections.emptyList(), Collections.emptyList());
        List<MrpMaterialGroupStandardHelper.InvpInvDimensionEntry> entryList = MrpMaterialGroupStandardHelper.getInventoryDimension(levelDimenSion);
        for (MrpMaterialGroupStandardHelper.InvpInvDimensionEntry entry : entryList) {
            String entityNumber = entry.getAssociationobject();
            String fieldName = entry.getDimensionname();
            FieldEdit baseDataEdit = (FieldEdit)this.getControl(entityNumber);
            if (baseDataEdit == null) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u6c34\u4f4d\u4fe1\u606f\u4e0d\u652f\u6301%s\u7684\u7ef4\u5ea6\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e", (String)"InventoryLevelBasePlugin_4", (String)"scmc-invp-form", (Object[])new Object[0]), fieldName));
                continue;
            }
            baseDataEdit.setCaption(new LocaleString(fieldName));
            baseDataEdit.setMustInput(true);
            this.getView().setEnable(Boolean.valueOf(true), new String[]{entityNumber});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{entityNumber});
        }
    }

    private void supplyTypeChange(Object oldValue, Object newValue) {
        this.getModel().setValue("supplyday", null);
    }

    private void planTypeChange(Object oldValue, Object newValue) {
        HashMap<Object, Object> confirmInfo = new HashMap<Object, Object>(16);
        confirmInfo.put(CommonConst.NEW_VALUE, newValue);
        confirmInfo.put(CommonConst.OLD_VALUE, oldValue);
        confirmInfo.put("propName", "mainplantype");
        String msg = ResManager.loadKDString((String)"\u8ba1\u5212\u7c7b\u578b\u5207\u6362\uff0c\u5c06\u6e05\u9664\u5e93\u5b58\u6c34\u4f4d\u56e0\u5b50\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"InvpInvLevelBasePlugin_3", (String)"scmc-invp-form", (Object[])new Object[0]);
        ConfirmCallBackListener callBackListener = new ConfirmCallBackListener("mainplantype", (IFormPlugin)this);
        this.getView().showConfirm(msg, null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, callBackListener, null, SerializationUtils.toJsonString(confirmInfo));
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        try {
            MessageBoxResult result = messageBoxClosedEvent.getResult();
            Map customMap = (Map)SerializationUtils.fromJsonString((String)messageBoxClosedEvent.getCustomVaule(), Map.class);
            String callBackId = messageBoxClosedEvent.getCallBackId();
            if (result == MessageBoxResult.Yes) {
                switch (callBackId) {
                    case "mainplantype": {
                        Container levelInfoPanel = (Container)this.getControl("invlevelinfo");
                        for (Control item : levelInfoPanel.getItems()) {
                            IDataEntityProperty property = this.getModel().getDataEntityType().findProperty(item.getKey());
                            if (property == null) continue;
                            this.getModel().setValue(item.getKey(), null);
                        }
                        String planType = (String)this.getModel().getValue("mainplantype");
                        this.setPlanTypeFields(planType);
                        break;
                    }
                    case "dimension": {
                        Container dimensionPanel = (Container)this.getControl("fs_baseinfo1");
                        for (Control item : dimensionPanel.getItems()) {
                            IDataEntityProperty property = this.getModel().getDataEntityType().findProperty(item.getKey());
                            if (property == null) continue;
                            this.getModel().setValue(item.getKey(), null);
                        }
                        DynamicObject dimension = (DynamicObject)this.getModel().getValue("dimension");
                        this.setDimensionFields(dimension);
                        break;
                    }
                }
            } else {
                Object oldValue = customMap.get(CommonConst.OLD_VALUE);
                String propName = (String)customMap.get("propName");
                switch (callBackId) {
                    case "dimension": {
                        oldValue = Long.valueOf((String)oldValue);
                        break;
                    }
                }
                this.getModel().beginInit();
                this.getModel().setValue(propName, oldValue);
                this.getModel().endInit();
                this.getView().updateView(propName);
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u51fa\u73b0\u672a\u77e5\u5f02\u5e38\uff0c\u8bf7\u4e0e\u7ba1\u7406\u5458\u8054\u7cfb\u3002", (String)"InvpCommonMsg", (String)"scmc-invp-form", (Object[])new Object[0]));
        }
    }

    private void setPlanTypeFields(String newPlanType) {
        Set<String> showFields = InvpLevelFactorHelper.showFields(this.getView(), newPlanType);
        List invLevelInfos = ((Container)this.getView().getControl("invlevelinfo")).getItems();
        ArrayList<String> invLevelInfoKey = new ArrayList<String>(invLevelInfos.size());
        for (Control invLevelInfo : invLevelInfos) {
            invLevelInfoKey.add(invLevelInfo.getKey());
        }
        InvpLevelFactorHelper.hideFields(this.getView(), invLevelInfoKey, new ArrayList<String>(), showFields);
    }

    public void registerListener(EventObject e) {
        FormUtil.addF7Listener(this, "planner", "dimension", "bd_materialgroupstandard", "bd_materialgroup", "bd_material", "bos_org", "bd_warehouse", "supplyday", "createorg");
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String propName;
        switch (propName = evt.getProperty().getName()) {
            case "createorg": {
                this.beforeCreateOrgSelect(evt);
                break;
            }
            case "planner": {
                this.beforePlannerSelect(evt);
                break;
            }
            case "bd_warehouse": {
                this.beforeWarehouseSelect(evt);
                break;
            }
            case "bd_materialgroup": {
                this.beforeMaterialGroupSelect(evt);
                break;
            }
            case "bd_material": {
                this.beforeMaterialSelect(evt);
                break;
            }
            case "supplyday": {
                this.beforeSupplyDaySelect(evt);
                break;
            }
        }
    }

    private void beforeSupplyDaySelect(BeforeF7SelectEvent evt) {
        String supplyType = (String)this.getModel().getValue("supplytype");
        QFilter filter = new QFilter("supplytype", "=", (Object)supplyType);
        evt.getCustomQFilters().add(filter);
    }

    private void beforeMaterialSelect(BeforeF7SelectEvent evt) {
        DynamicObject bosOrg = (DynamicObject)this.getModel().getValue("bos_org");
        if (bosOrg == null) {
            QFilter filter = new QFilter("1", "!=", (Object)"1", true);
            evt.getCustomQFilters().add(filter);
        } else {
            QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_material", (Long)bosOrg.getLong("id"));
            evt.getCustomQFilters().add(baseDataFilter);
        }
        Object dimension = ((DynamicObject)this.getModel().getValue("dimension")).getPkValue();
        InventoryDimension dim = new InventoryDimension(dimension);
        Map<String, String> entityToNameMap = dim.getEntityToNameMap();
        if (entityToNameMap.containsKey("bd_materialgroup")) {
            DynamicObject materialGroup = (DynamicObject)this.getModel().getValue("bd_materialgroup");
            if (materialGroup == null) {
                QFilter qFilter = new QFilter("1", "!=", (Object)"1", true);
                evt.getCustomQFilters().add(qFilter);
            } else {
                QFilter[] stdFilter = new QFilter[]{new QFilter("group", "=", materialGroup.getPkValue())};
                HashSet<Object> mts = new HashSet<Object>(64);
                try (DataSet ds = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_materialgroupdetail", (String)"material,group", (QFilter[])stdFilter, null);){
                    for (Row d : ds) {
                        Object mt = d.get("material");
                        mts.add(mt);
                    }
                }
                QFilter materialFilter = new QFilter("id", "in", mts);
                evt.getCustomQFilters().add(materialFilter);
                DynamicObject std = (DynamicObject)this.getModel().getValue("bd_materialgroupstandard");
                if (std != null) {
                    evt.getFormShowParameter().setCustomParam("groupStandard", std.getPkValue());
                }
            }
        }
    }

    private void beforeMaterialGroupSelect(BeforeF7SelectEvent evt) {
        QFilter filter;
        DynamicObject groupStand = (DynamicObject)this.getModel().getValue("bd_materialgroupstandard");
        if (groupStand != null) {
            filter = new QFilter("standard", "=", groupStand.getPkValue());
            evt.getFormShowParameter().setCustomParam("groupStandard", groupStand.getPkValue());
        } else {
            filter = new QFilter("1", "!=", (Object)"1", true);
        }
        evt.getCustomQFilters().add(filter);
    }

    private void beforeWarehouseSelect(BeforeF7SelectEvent evt) {
        DynamicObject bosOrg = (DynamicObject)this.getModel().getValue("bos_org");
        if (bosOrg == null) {
            QFilter filter = new QFilter("1", "!=", (Object)"1", true);
            evt.getCustomQFilters().add(filter);
        } else {
            QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_warehouse", (Long)bosOrg.getLong("id"));
            evt.getCustomQFilters().add(baseDataFilter);
        }
    }

    private void beforePlannerSelect(BeforeF7SelectEvent evt) {
        QFilter enableFilter;
        DynamicObject bizOrg = (DynamicObject)this.getModel().getValue("createorg");
        if (bizOrg == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u521b\u5efa\u7ec4\u7ec7", (String)"QuoteStrategyPlugin_0", (String)"scmc-plat-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        QFilter filterGridFilter = new QFilter("operatorgrouptype", "=", (Object)"JHZ");
        QFilter operatorGroupIdFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_operatorgroup", (Long)((Long)bizOrg.getPkValue()));
        Map currentBizOrgBizOperatorGroup = BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (String)"id", (QFilter[])new QFilter[]{filterGridFilter, operatorGroupIdFilter, enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE)});
        if (currentBizOrgBizOperatorGroup != null && !currentBizOrgBizOperatorGroup.isEmpty()) {
            HashSet keySet = new HashSet(currentBizOrgBizOperatorGroup.keySet());
            QFilter qFilter = new QFilter("operatorgrpid", "in", new ArrayList(keySet));
            QFilter qFilter1 = new QFilter("invalid", "=", (Object)Boolean.FALSE);
            evt.addCustomQFilter(qFilter.and(qFilter1));
        } else if (currentBizOrgBizOperatorGroup == null || currentBizOrgBizOperatorGroup.isEmpty()) {
            evt.addCustomQFilter(new QFilter("operatorgrpid", "in", null));
        }
    }

    private void beforeCreateOrgSelect(BeforeF7SelectEvent evt) {
    }

    private void resetData(List<String> clearFields) {
        for (String clearField : clearFields) {
            this.getModel().setValue(clearField, null);
        }
    }
}

