/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.scmc.invp.common.consts.InvpLevelFactorConst;
import kd.scmc.invp.common.helper.DataModelHelper;
import kd.scmc.invp.common.helper.FormShowHelper;
import kd.scmc.invp.common.helper.PlanTypeHelper;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;

public class InvpLevelFactorEditPlugin
extends AbstractBasePlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"relfield"});
    }

    public void click(EventObject evt) {
        String fieldKey;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (fieldKey = control.getKey()) {
            case "relfield": {
                this.clickRelField();
                break;
            }
        }
    }

    private void clickRelField() {
        int rowIdx = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject relentity = (DynamicObject)this.getModel().getValue("relentity", rowIdx);
        FormShowHelper.showColTreeFormWithEntry((AbstractFormPlugin)this, relentity.getString("number"), rowIdx, false, "relfield", null);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        String returnData = (String)evt.getReturnData();
        IDataModel dataModel = this.getModel();
        IPageCache pageCache = this.getPageCache();
        if (actionId == null || returnData == null) {
            return;
        }
        switch (actionId) {
            case "relfield": {
                FormShowHelper.closeCallSetEntryField(dataModel, pageCache, returnData, "relfield", "relfieldkey");
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        int rowIdx = changeSet[0].getRowIndex();
        Object newValue = changeSet[0].getNewValue();
        switch (propertyName) {
            case "relfield": {
                this.relFieldChange(newValue, rowIdx);
                break;
            }
            case "isreorderpoint": 
            case "ismaxandmin": 
            case "isbalanceinv": 
            case "isfixedperiod": {
                this.mainPlanTypeChange(propertyName, newValue);
                break;
            }
        }
    }

    private void mainPlanTypeChange(String propertyName, Object newValue) {
        String planType = PlanTypeHelper.findPlanType(propertyName);
        if (((Boolean)newValue).booleanValue()) {
            int[] rowIdxs = this.getModel().batchCreateNewEntryRow("entryentity", InvpLevelFactorConst.RELENTITY_ARRAY.length);
            for (int i = 0; i < InvpLevelFactorConst.RELENTITY_ARRAY.length; ++i) {
                String entity = InvpLevelFactorConst.RELENTITY_ARRAY[i];
                int rowIdx = rowIdxs[i];
                this.getModel().setValue("plantype", (Object)planType, rowIdx);
                this.getModel().setValue("relentity", (Object)entity, rowIdx);
            }
        } else {
            ArrayList<Integer> rowIdxList = new ArrayList<Integer>(2);
            DynamicObjectCollection rows = this.getModel().getEntryEntity("entryentity");
            for (int i = 0; i < rows.size(); ++i) {
                DynamicObject row = (DynamicObject)rows.get(i);
                if (!planType.equals(row.getString("plantype"))) continue;
                rowIdxList.add(i);
            }
            if (!rowIdxList.isEmpty()) {
                this.getModel().deleteEntryRows("entryentity", ArrayUtils.toPrimitive((Integer[])rowIdxList.toArray(new Integer[0])));
            }
        }
    }

    private void relFieldChange(Object newValue, int rowIdx) {
        if (ObjectUtils.isEmpty((Object)newValue)) {
            DataModelHelper.clearEntryField(this.getModel(), rowIdx, "relfieldkey");
        }
    }
}

