/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MaterielProp;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.scmc.invp.business.IColsSelectStrategy;
import kd.scmc.invp.business.strategy.CompositeStrategy;
import kd.scmc.invp.business.strategy.TypeSelectStategy;
import kd.scmc.invp.common.Lang.InvpLang;
import kd.scmc.invp.common.consts.PropertyDataType;
import kd.scmc.invp.common.helper.FormShowHelper;

public class InvpMatchConfigEditPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"tgtmatchfield", "srcmatchfield"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String newValue;
        super.propertyChanged(e);
        String changeKey = e.getProperty().getName();
        IDataModel model = this.getModel();
        int rowIndex = model.getEntryCurrentRowIndex("matchentry");
        ChangeData changeData = e.getChangeSet()[0];
        if ("matchgroup".equals(changeKey) || "matchtype".equals(changeKey)) {
            model.beginInit();
            model.setValue("tgtmatchfield", null, rowIndex);
            model.setValue("srcmatchfield", null, rowIndex);
            model.setValue("tgtmatchfieldkey", null, rowIndex);
            model.setValue("srcmatchfieldkey", null, rowIndex);
            model.endInit();
            this.getView().updateView("matchentry");
        } else if ("tgtentity".equals(changeKey) || "srcentity".equals(changeKey)) {
            this.entityChanged(changeData.getOldValue(), changeData.getNewValue(), changeKey);
        } else if (("tgtmatchfield".equals(changeKey) || "srcmatchfield".equals(changeKey)) && (newValue = (String)changeData.getNewValue()).isEmpty()) {
            String key = "tgtmatchfield".equals(changeKey) ? "tgtmatchfieldkey" : "srcmatchfieldkey";
            model.beginInit();
            model.setValue(key, null, rowIndex);
            model.endInit();
            this.getView().updateView("matchentry");
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String fieldKey = control.getKey();
        if ("tgtmatchfield".equals(fieldKey) || "srcmatchfield".equals(fieldKey)) {
            this.clickSelectedField(fieldKey);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        IDataModel model = this.getModel();
        super.closedCallBack(e);
        Object returnData = e.getReturnData();
        if (returnData == null) {
            return;
        }
        switch (actionId = e.getActionId()) {
            case "tgtmatchfield": {
                String tarEntryNumber = ((DynamicObject)model.getValue("tgtentity")).getString("number");
                this.closeCallSetEntryField((String)returnData, "tgtmatchfield", "tgtmatchfieldkey", tarEntryNumber);
                break;
            }
            case "srcmatchfield": {
                String srcEntryNumber = ((DynamicObject)model.getValue("srcentity")).getString("number");
                this.closeCallSetEntryField((String)returnData, "srcmatchfield", "srcmatchfieldkey", srcEntryNumber);
                break;
            }
        }
    }

    private void entityChanged(Object oldValue, Object newValue, String changeKey) {
        if (oldValue != null) {
            HashMap<String, Object> confirmParam = new HashMap<String, Object>(4);
            confirmParam.put("changeValue", changeKey);
            confirmParam.put("oldValue", ((DynamicObject)oldValue).getPkValue());
            if (newValue != null) {
                confirmParam.put("newValue", ((DynamicObject)newValue).getPkValue());
            }
            DynamicProperty property = MetadataServiceHelper.getDataEntityType((String)"invp_matchmapping_config").getProperty(changeKey);
            String msg = InvpLang.changeEntity("scmc-invp-form", property.getDisplayName().getLocaleValue());
            ConfirmCallBackListener callBackListener = new ConfirmCallBackListener("changeCallBack", (IFormPlugin)this);
            this.getView().showConfirm(msg, null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, callBackListener, null, SerializationUtils.toJsonString(confirmParam));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String callBackId = evt.getCallBackId();
        MessageBoxResult result = evt.getResult();
        String param = evt.getCustomVaule();
        if ("changeCallBack".equals(callBackId)) {
            this.updateEntityValue(result, param);
        }
    }

    private void updateEntityValue(MessageBoxResult result, String param) {
        if (StringUtils.isBlank((CharSequence)param)) {
            return;
        }
        Map paramMap = (Map)SerializationUtils.fromJsonString((String)param, Map.class);
        String changeKey = (String)paramMap.get("changeValue");
        IDataModel model = this.getModel();
        model.beginInit();
        if (MessageBoxResult.Yes.equals((Object)result)) {
            model.deleteEntryData("matchentry");
            model.createNewEntryRow("matchentry");
            model.setValue(changeKey, paramMap.get("newValue"));
        } else {
            model.setValue(changeKey, paramMap.get("oldValue"));
        }
        model.endInit();
        this.getView().updateView();
    }

    private void clickSelectedField(String fieldKey) {
        IDataModel model = this.getModel();
        DynamicObject entity = null;
        String propertyKey = "tgtentity";
        if ("tgtmatchfield".equals(fieldKey)) {
            entity = model.getDataEntity().getDynamicObject("tgtentity");
        } else if ("srcmatchfield".equals(fieldKey)) {
            entity = model.getDataEntity().getDynamicObject("srcentity");
            propertyKey = "srcentity";
        }
        if (entity == null) {
            this.getView().showTipNotification(InvpLang.plsSelectedValue("invp_matchmapping_config", propertyKey));
            return;
        }
        int rowIndex = model.getEntryCurrentRowIndex("matchentry");
        DynamicObject curRow = model.getEntryRowEntity("matchentry", rowIndex);
        String matchType = curRow.getString("matchtype");
        String entityNumber = entity.getString("number");
        this.showSelectFieldForm(matchType, entityNumber, rowIndex, fieldKey);
    }

    private void showSelectFieldForm(String matchType, String entityNumber, int rowIndex, String fieldKey) {
        this.getPageCache().put("rowIndex", String.valueOf(rowIndex));
        IDataModel model = this.getModel();
        if ("A".equals(matchType)) {
            FormShowHelper.showTreeForm(this, entityNumber, Boolean.FALSE, fieldKey);
        } else if ("B".equals(matchType)) {
            DynamicObject curRow = model.getEntryRowEntity("matchentry", rowIndex);
            DynamicObject matchGroup = curRow.getDynamicObject("matchgroup");
            if (matchGroup == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5206\u7ec4\u5173\u7cfb\u3002", (String)"InvpMatchConfigEditPlugin_6", (String)"scmc-invp-form", (Object[])new Object[0]));
                return;
            }
            DynamicObject dataObj = matchGroup.getDynamicObject("dataobj");
            String dataObjNumber = dataObj.getString("number");
            DynamicObject groupObj = matchGroup.getDynamicObject("groupobj");
            String groupObjNumber = groupObj.getString("number");
            IColsSelectStrategy selectStrategy = this.buildSelectedStrategy(rowIndex, dataObjNumber, groupObjNumber, fieldKey);
            FormShowHelper.showColsTreeForm(this, entityNumber, selectStrategy, null, Boolean.FALSE, fieldKey, new PropertyDataType[0]);
        }
    }

    private IColsSelectStrategy buildSelectedStrategy(int rowIndex, String dataObjNum, String groupObjNum, String fieldKey) {
        String tarEntityNumber;
        MainEntityType type;
        DynamicProperty property;
        IDataModel model = this.getModel();
        MaterielProp baseDataPropData = "bd_material".equals(dataObjNum) ? new MaterielProp() : new BasedataProp();
        baseDataPropData.setBaseEntityId(dataObjNum);
        BasedataProp baseDataPropGroup = new BasedataProp();
        baseDataPropGroup.setBaseEntityId(groupObjNum);
        TypeSelectStategy selectStrategyData = new TypeSelectStategy((IDataEntityProperty)baseDataPropData, false);
        TypeSelectStategy selectStrategyGroup = new TypeSelectStategy((IDataEntityProperty)baseDataPropGroup, false);
        String srcNum = (String)model.getValue("srcmatchfieldkey", rowIndex);
        String targetNum = (String)model.getValue("tgtmatchfieldkey", rowIndex);
        if ("tgtmatchfield".equals(fieldKey) && StringUtils.isNotEmpty((CharSequence)srcNum)) {
            String srcEntityNumber = ((DynamicObject)model.getValue("srcentity")).getString("number");
            MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)srcEntityNumber);
            DynamicProperty property2 = RowDataModel.findProperty((MainEntityType)mainEntityType, (String)srcNum);
            if (property2 != null) {
                String selectedProp = ((BasedataProp)property2).getBaseEntityId();
                return groupObjNum.equals(selectedProp) ? selectStrategyData : selectStrategyGroup;
            }
        } else if ("srcmatchfield".equals(fieldKey) && StringUtils.isNotEmpty((CharSequence)targetNum) && (property = RowDataModel.findProperty((MainEntityType)(type = MetadataServiceHelper.getDataEntityType((String)(tarEntityNumber = ((DynamicObject)model.getValue("tgtentity")).getString("number")))), (String)targetNum)) != null) {
            String selectedProp = ((BasedataProp)property).getBaseEntityId();
            return groupObjNum.equals(selectedProp) ? selectStrategyData : selectStrategyGroup;
        }
        return new CompositeStrategy(Arrays.asList(selectStrategyData, selectStrategyGroup));
    }

    public void closeCallSetEntryField(String returnData, String field, String fieldKey, String entryNumber) {
        IDataModel model = this.getModel();
        String currentRowIndex = this.getPageCache().get("rowIndex");
        int rowIndex = Integer.parseInt(currentRowIndex);
        JSONArray jsonArr = (JSONArray)SerializationUtils.fromJsonString((String)returnData, JSONArray.class);
        if (jsonArr != null && !jsonArr.isEmpty()) {
            JSONObject jsonObject;
            Map entryMap = MetadataServiceHelper.getDataEntityType((String)entryNumber).getAllEntities();
            if (entryMap.containsKey((jsonObject = jsonArr.getJSONObject(0)).get((Object)"id"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5177\u4f53\u7684\u5b57\u6bb5\u3002", (String)"InvpMatchConfigEditPlugin_2", (String)"scmc-invp-form", (Object[])new Object[0]));
            } else {
                model.setValue(field, jsonObject.get((Object)"text"), rowIndex);
                model.setValue(fieldKey, jsonObject.get((Object)"id"), rowIndex);
            }
        }
    }
}

