/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.formplugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.invp.common.Lang.InvpLang;
import kd.scmc.invp.common.enumeration.InvpEntityFieldTypeEnum;
import kd.scmc.invp.common.helper.FilterConditionHelper;
import kd.scmc.invp.common.helper.QueryInvpAppKey;

public class InvpModelRegisterEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
CellClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addBaseDataF7Listener("businessentity", "outputtype", "outputresult", "outputmappingsupply", "billfieldmap");
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentityds");
        if (entryGrid != null) {
            entryGrid.addCellClickListener((CellClickListener)this);
        }
    }

    private void addBaseDataF7Listener(String ... keys) {
        for (String key : keys) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getControl(key);
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String appPkValue = this.getAppPkValue();
        if (StringUtils.isNotEmpty((String)appPkValue)) {
            this.getModel().setValue("apptype", (Object)appPkValue);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "businessentity": {
                this.beforeBusinessEntitySelect(e);
                break;
            }
            case "billfieldmap": {
                this.addOutputMappingF7Filter(e, "billfieldmap");
                break;
            }
            case "outputresult": {
                this.addOutputResultF7Filter(e);
                break;
            }
            case "outputmappingsupply": {
                this.addOutputMappingF7Filter(e, "outputmappingsupply");
                break;
            }
            case "outputtype": {
                this.addOutputTypeF7Filter(e);
                break;
            }
        }
    }

    private void addOutputResultF7Filter(BeforeF7SelectEvent e) {
        IDataModel model = this.getModel();
        Object businessEntity = model.getValue("businessentity");
        Object outPutType = model.getValue("outputtype");
        if (businessEntity == null || outPutType == null) {
            this.getView().showTipNotification(InvpLang.plsSelectedValue("invp_model_register", outPutType == null ? "outputtype" : "businessentity"));
            e.setCancel(true);
        } else {
            String targetEntityNum = ((DynamicObject)businessEntity).getString("number");
            String outPutTypeNum = ((DynamicObject)outPutType).getString("number");
            String appPkValue = this.getAppPkValue();
            QFilter qFilter = new QFilter("sourcebill", "=", (Object)targetEntityNum).and(new QFilter("isenable", "=", (Object)Boolean.TRUE)).and(new QFilter("targetobj", "=", (Object)outPutTypeNum));
            if (StringUtils.isNotEmpty((String)appPkValue)) {
                qFilter.and(new QFilter("bizapp", "=", (Object)appPkValue));
            }
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            showParameter.getListFilterParameter().getQFilters().add(qFilter);
        }
    }

    private void addOutputMappingF7Filter(BeforeF7SelectEvent e, String fieldKey) {
        String appPkValue;
        IDataModel model = this.getModel();
        Object businessEntity = model.getValue("businessentity");
        if (businessEntity == null) {
            this.getView().showTipNotification(InvpLang.plsSelectedValue("invp_model_register", "businessentity"));
            e.setCancel(true);
            return;
        }
        String targetEntityNum = ((DynamicObject)businessEntity).getString("number");
        QFilter qFilter = new QFilter("targetobj", "=", (Object)targetEntityNum).and(new QFilter("isenable", "=", (Object)Boolean.TRUE));
        if ("outputmappingsupply".equals(fieldKey)) {
            qFilter.and(new QFilter("sourcebill", "=", (Object)"invp_plan_advice"));
        }
        if (StringUtils.isNotEmpty((String)(appPkValue = this.getAppPkValue()))) {
            qFilter.and(new QFilter("bizapp", "=", (Object)appPkValue));
        }
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        if ("billfieldmap".equals(fieldKey)) {
            showParameter.setCaption(ResManager.loadKDString((String)"\u5b57\u6bb5\u6620\u5c04\u914d\u7f6e\u5217\u8868", (String)"InvpModelRegisterEditPlugin_4", (String)"scmc-invp-form", (Object[])new Object[0]));
        }
        showParameter.getListFilterParameter().getQFilters().add(qFilter);
    }

    private void addOutputTypeF7Filter(BeforeF7SelectEvent e) {
        Object businessEntity = this.getModel().getValue("businessentity");
        if (businessEntity == null) {
            this.getView().showTipNotification(InvpLang.plsInputValue("invp_model_register", "businessentity"));
            e.setCancel(true);
            return;
        }
        String entityNumber = ((DynamicObject)businessEntity).getString("number");
        QFilter qFilter = new QFilter("1", "=", (Object)1);
        switch (entityNumber) {
            case "invp_demand_model": {
                qFilter.and(new QFilter("number", "=", (Object)"invp_plan_advice"));
                break;
            }
            case "invp_safestock_model": {
                qFilter.and(new QFilter("number", "=", (Object)"invp_safestock_record"));
                break;
            }
            case "invp_dac_model": {
                qFilter.and(new QFilter("number", "=", (Object)"invp_dac_record"));
                break;
            }
        }
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        showParameter.getListFilterParameter().getQFilters().add(qFilter);
    }

    private void beforeBusinessEntitySelect(BeforeF7SelectEvent e) {
        Object modelType = this.getModel().getValue("modeltype");
        if (modelType == null) {
            this.getView().showTipNotification(InvpLang.plsInputValue("invp_model_register", "modeltype"));
            e.setCancel(true);
            return;
        }
        QFilter qFilter = new QFilter("1", "=", (Object)1);
        switch (modelType.toString()) {
            case "1": {
                qFilter.and(new QFilter("number", "=", (Object)"invp_supply_model"));
                break;
            }
            case "2": {
                qFilter.and(new QFilter("number", "=", (Object)"invp_demand_model"));
                break;
            }
            case "3": {
                qFilter.and(new QFilter("number", "in", (Object)new String[]{"invp_safestock_model", "invp_dac_model"}));
                break;
            }
        }
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        showParameter.getListFilterParameter().getQFilters().add(qFilter);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object newValue = valueSet[0].getNewValue();
        Object oldValue = valueSet[0].getOldValue();
        int rowIndex = valueSet[0].getRowIndex();
        switch (propName) {
            case "businessentity": {
                this.businessEntryChanged(oldValue, newValue);
                break;
            }
            case "billfieldmap": {
                this.changeBillFieldMap(newValue, rowIndex);
                break;
            }
            case "modeltype": {
                this.modelTypeChangeConfirm(oldValue, newValue);
                break;
            }
            case "outputtype": {
                this.getModel().setValue("outputresult", null);
                this.getView().updateView("outputresult");
                break;
            }
        }
    }

    private void modelTypeChangeConfirm(Object oldValue, Object newValue) {
        if (oldValue != null) {
            HashMap<String, Object> confirmParam = new HashMap<String, Object>(4);
            confirmParam.put("oldValue", oldValue);
            confirmParam.put("newValue", newValue);
            MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"invp_model_register");
            StringBuilder msg = new StringBuilder();
            msg.append(entityType.getProperty("businessentity").getDisplayName());
            msg.append("\u3001");
            if ("1".equals(oldValue)) {
                msg.append(entityType.getProperty("outputmappingsupply").getDisplayName());
                msg.append("\u3001");
            } else if ("2".equals(oldValue) || "3".equals(oldValue)) {
                msg.append(entityType.getProperty("outputtype").getDisplayName());
                msg.append("\u3001");
                msg.append(entityType.getProperty("outputresult").getDisplayName());
                msg.append("\u3001");
            }
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u8bf7\u6ce8\u610f\uff0c\u5207\u6362\u6a21\u578b\u7c7b\u578b\u5c06\u6e05\u7a7a\uff1a%s\u8be6\u7ec6\u4fe1\u606f\u7684\u5206\u5f55\u4fe1\u606f\u3002", (String)"InvpModelRegisterEditPlugin_3", (String)"scmc-invp-form", (Object[])new Object[0]), msg.toString()), null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("modelTypeCallback"), null, SerializationUtils.toJsonString(confirmParam));
        }
    }

    private void changeModelType() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        model.beginInit();
        model.setValue("businessentity", null);
        model.setValue("outputresult", null);
        model.setValue("outputtype", null);
        model.setValue("outputmappingsupply", null);
        model.deleteEntryData("entryentity");
        model.deleteEntryData("entryentityds");
        model.endInit();
        view.updateView();
    }

    private void changeBillFieldMap(Object newValue, int rowIndex) {
        if (newValue == null) {
            this.getModel().setValue("srcbillds", null, rowIndex);
            return;
        }
        DynamicObject mapNumDy = (DynamicObject)newValue;
        DynamicObject srcBill = mapNumDy.getDynamicObject("sourcebill");
        this.getModel().setValue("srcbillds", (Object)srcBill, rowIndex);
        this.getModel().setValue("filterdescds", null, rowIndex);
        this.getModel().setValue("filtervalueds", null, rowIndex);
    }

    private void businessEntryChanged(Object oldValue, Object newValue) {
        String value;
        String string = value = newValue == null ? null : ((DynamicObject)newValue).getString("number");
        if (oldValue != null) {
            HashMap<String, String> confirmParam = new HashMap<String, String>(4);
            confirmParam.put("oldValue", ((DynamicObject)oldValue).getString("number"));
            confirmParam.put("newValue", value);
            String modelType = (String)this.getModel().getValue("modeltype");
            StringBuilder msg = new StringBuilder();
            MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"invp_model_register");
            if ("1".equals(modelType)) {
                msg.append(entityType.getProperty("outputmappingsupply").getDisplayName());
                msg.append("\u3001");
            } else if ("2".equals(modelType) || "3".equals(modelType)) {
                msg.append(entityType.getProperty("outputtype").getDisplayName());
                msg.append("\u3001");
                msg.append(entityType.getProperty("outputresult").getDisplayName());
                msg.append("\u3001");
            }
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5207\u6362\u76ee\u6807\u5b9e\u4f53\u5c06\u66f4\u6539\uff1a%s\u8be6\u7ec6\u4fe1\u606f\u7684\u5206\u5f55\u4fe1\u606f\uff0c\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u64cd\u4f5c\uff1f", (String)"InvpModelRegisterEditPlugin_2", (String)"scmc-invp-form", (Object[])new Object[0]), msg.toString()), null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("businessEntryCallback"), null, SerializationUtils.toJsonString(confirmParam));
        } else {
            this.queryMetaDataInfo(value);
        }
    }

    private void queryMetaDataInfo(String newValue) {
        Map allFields;
        MainEntityType dataEntityType;
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentityds");
        model.deleteEntryData("entryentity");
        if (StringUtils.isNotEmpty((String)newValue) && (dataEntityType = this.getMainEntityType("businessentity")) != null && (allFields = dataEntityType.getAllFields()) != null && allFields.size() > 0) {
            this.getModel().batchCreateNewEntryRow("entryentity", allFields.size());
            int index = 0;
            this.getModel().beginInit();
            for (String field : allFields.keySet()) {
                this.buildRow(dataEntityType, index, field);
                ++index;
            }
            this.getModel().endInit();
        }
        this.getView().updateView("entryentityds");
        this.getView().updateView("entryentity");
    }

    private void buildRow(MainEntityType dataEntityType, int rowIndex, String signid) {
        DynamicProperty findProperty = (DynamicProperty)dataEntityType.findProperty(signid);
        this.getModel().setValue("signid", (Object)signid, rowIndex);
        if (findProperty.getParent() instanceof EntryType) {
            EntryType entry = (EntryType)findProperty.getParent();
            this.getModel().setValue("signid", (Object)(entry.getName() + '.' + signid), rowIndex);
        } else {
            this.getModel().setValue("signid", (Object)signid, rowIndex);
        }
        LocaleString signName = findProperty.getDisplayName();
        this.getModel().setValue("signname", (Object)signName, rowIndex);
        String dataType = InvpEntityFieldTypeEnum.getMetaDataFieldType(findProperty);
        this.getModel().setValue("datatype", (Object)dataType, rowIndex);
    }

    private MainEntityType getMainEntityType(String entityName) {
        DynamicObject accEntity = (DynamicObject)this.getModel().getValue(entityName);
        if (accEntity != null) {
            Object billEntityPkValue = accEntity.getPkValue();
            return MetadataServiceHelper.getDataEntityType((String)billEntityPkValue.toString());
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u4e0d\u5c5e\u4e8e\u5b9e\u4f53F7\u7c7b\u578b\u7684\u5b57\u6bb5\u3002", (String)"InvpModelRegisterEditPlugin_1", (String)"scmc-invp-form", (Object[])new Object[0]), entityName));
    }

    public void cellClick(CellClickEvent e) {
        String fieldKey = e.getFieldKey();
        int row = e.getRow();
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if ("filterdescds".equals(fieldKey)) {
            boolean isPreset = (Boolean)this.getModel().getValue("ispreset");
            if (isPreset || OperationStatus.VIEW.equals((Object)status)) {
                return;
            }
            DynamicObject billMap = (DynamicObject)this.getModel().getValue("billfieldmap", row);
            if (billMap == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5b9e\u4f53\u5b57\u6bb5\u6620\u5c04\u7f16\u7801\u3002", (String)"InvpModelRegisterEditPlugin_0", (String)"scmc-invp-form", (Object[])new Object[0]));
                return;
            }
            this.openConditionSet(row, billMap);
        }
    }

    private void openConditionSet(int row, DynamicObject bill) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("invp_conditionsetup");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "conditionSetCallback"));
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        Object filterds = this.getModel().getValue("filtervalueds", row);
        if (bill != null) {
            String number = bill.getString("sourcebill.number");
            params.put("number", number);
        }
        params.put("filter", filterds);
        params.put("row", row);
        fsp.setCustomParams(params);
        this.getView().showForm(fsp);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Map data;
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if ("conditionSetCallback".equals(actionId) && (data = (Map)event.getReturnData()) != null) {
            String filter = (String)data.get("filter");
            String number = (String)data.get("number");
            int row = (Integer)data.get("row");
            String filterDesc = FilterConditionHelper.translateJsonString(filter, number);
            this.getModel().setValue("filtervalueds", (Object)filter, row);
            this.getModel().setValue("filterdescds", (Object)filterDesc, row);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent msg) {
        super.confirmCallBack(msg);
        String callBackAction = msg.getCallBackId();
        String param = msg.getCustomVaule();
        Map paramMap = (Map)SerializationUtils.fromJsonString((String)param, Map.class);
        Object oldValue = paramMap.get("oldValue");
        MessageBoxResult result = msg.getResult();
        IDataModel model = this.getModel();
        if ("businessEntryCallback".equals(callBackAction)) {
            if (MessageBoxResult.Yes.equals((Object)result)) {
                model.setValue("outputresult", null);
                model.setValue("outputtype", null);
                model.setValue("outputmappingsupply", null);
                this.queryMetaDataInfo((String)paramMap.get("newValue"));
            } else if (MessageBoxResult.Cancel.equals((Object)result)) {
                model.beginInit();
                model.setValue("businessentity", oldValue);
                model.endInit();
                this.getView().updateView("businessentity");
            }
        } else if ("modelTypeCallback".equals(callBackAction)) {
            if (MessageBoxResult.Yes.equals((Object)result)) {
                this.changeModelType();
            } else {
                model.beginInit();
                model.setValue("modeltype", oldValue);
                this.setFieldVisible(oldValue);
                this.getView().updateView();
                model.endInit();
            }
        }
    }

    private void setFieldVisible(Object modelType) {
        boolean visible = false;
        if ("1".equals(modelType)) {
            visible = true;
        }
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{"outputmappingsupply"});
        this.getView().setVisible(Boolean.valueOf(!visible), new String[]{"outputtype", "outputresult"});
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
    }

    private String getAppPkValue() {
        String appId = this.getView().getFormShowParameter().getAppId();
        if (StringUtils.isNotEmpty((String)appId)) {
            return QueryInvpAppKey.getInvpAppKey(appId);
        }
        return null;
    }
}

