/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.formplugin;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.scmc.invp.common.Lang.InvpLang;
import kd.scmc.invp.common.helper.InvPlanHelper;

public class InvpPlanCalEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        long userId = RequestContext.get().getCurrUserId();
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((long)userId, (String)"15", (String)BizAppServiceHelp.getAppIdByAppNumber((String)"invp"), (String)"invp_plancal", (String)"47150e89000000ac");
        List orgIds = result.getHasPermOrgs();
        Set<Long> planViewOrgIds = InvpPlanCalEditPlugin.getOrgIdsByPlanView();
        long orgId = RequestContext.get().getOrgId();
        if (!orgIds.isEmpty()) {
            this.setOrgByPermission(orgId, orgIds, planViewOrgIds);
        } else if (result.hasAllOrgPerm() && planViewOrgIds.contains(orgId)) {
            this.getModel().setValue("org", (Object)RequestContext.get().getOrgId());
        }
    }

    public void registerListener(EventObject e) {
        BasedataEdit org;
        super.registerListener(e);
        BasedataEdit planProgram = (BasedataEdit)this.getView().getControl("planscheme");
        if (planProgram != null) {
            planProgram.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((org = (BasedataEdit)this.getView().getControl("org")) != null) {
            org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if ("org".equals(key)) {
            this.getModel().setValue("planscheme", null);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate op = (FormOperate)args.getSource();
        String key = op.getOperateKey();
        if ("startcalculate".equals(key)) {
            this.validateCalculate(args);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate op = (FormOperate)args.getSource();
        String key = op.getOperateKey();
        if ("startcalculate".equals(key) && args.getOperationResult().isSuccess()) {
            this.executePlan();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        Control con = (Control)evt.getSource();
        String key = con.getKey();
        ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
        ListFilterParameter listFilterParameter = param.getListFilterParameter();
        if ("org".equals(key)) {
            param.setCustomParam("isIncludeAllSub", (Object)Boolean.TRUE);
            QFilter idFilter = new QFilter("id", "in", InvpPlanCalEditPlugin.getOrgIdsByPlanView());
            listFilterParameter.getQFilters().add(idFilter);
        } else if ("planscheme".equals(key)) {
            Object org = this.getModel().getValue("org");
            if (org == null) {
                this.getView().showTipNotification(InvpLang.plsSelectedValue("invp_plancal", "org"));
                evt.setCancel(true);
            } else {
                QFilter planFilter = new QFilter("createorg", "=", ((DynamicObject)org).getPkValue());
                planFilter.and(new QFilter("status", "=", (Object)"C"));
                planFilter.and(new QFilter("enable", "=", (Object)"1"));
                listFilterParameter.getQFilters().add(planFilter);
            }
        }
    }

    private void validateCalculate(BeforeDoOperationEventArgs args) {
        IDataModel model = this.getModel();
        Object org = model.getValue("org");
        Object planScheme = model.getValue("planscheme");
        Object planDate = model.getValue("plandate");
        if (org == null || planScheme == null || planDate == null) {
            String propertyKey = org == null ? "org" : "planscheme";
            this.getView().showTipNotification(InvpLang.plsSelectedValue("invp_plancal", propertyKey));
            args.setCancel(true);
        }
    }

    private static Set<Long> getOrgIdsByPlanView() {
        HashSet<Long> idSet = new HashSet<Long>(16);
        QFilter viewfilter = new QFilter("view", "=", (Object)914427355726916608L).and(new QFilter("isctrlunit", "=", (Object)Boolean.TRUE));
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"InvpPlanEditPlugin", (String)"bos_org_structure", (String)"org", (QFilter[])viewfilter.toArray(), null);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            long id = row.getLong("org");
            idSet.add(id);
        }
        return idSet;
    }

    private void setOrgByPermission(long orgId, List<Long> orgIds, Set<Long> planViewOrgIds) {
        if (orgIds.contains(orgId) && planViewOrgIds.contains(orgId)) {
            this.getModel().setValue("org", (Object)RequestContext.get().getOrgId());
        } else {
            this.getModel().setValue("org", null);
        }
    }

    private void executePlan() {
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        DynamicObject invpScheme = (DynamicObject)model.getValue("planscheme");
        Date planDate = (Date)model.getValue("plandate");
        int outTime = (Integer)model.getValue("outtime");
        boolean debugMode = (Boolean)model.getValue("debugmode");
        HashMap<String, Object> param = new HashMap<String, Object>(4);
        param.put("planOrg", org.getPkValue());
        param.put("planDate", planDate);
        param.put("schemeId", invpScheme.getPkValue());
        param.put("outTime", outTime);
        param.put("debugMode", debugMode);
        Long logId = InvPlanHelper.doInvPlan(param);
        this.showLogForm(logId);
    }

    private void showLogForm(Object logId) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId("invp_invplan_log");
        showParameter.setBillStatus(BillOperationStatus.VIEW);
        showParameter.setPkId(logId);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setHasRight(true);
        this.getView().showForm((FormShowParameter)showParameter);
    }
}

