/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.invp.common.consts.CommonConst;
import kd.scmc.invp.common.helper.DataModelHelper;
import kd.scmc.invp.common.helper.FormShowHelper;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class InvpQueryRuleEditPlugin
extends AbstractBillPlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"srcfield", "srcfiltercondition", "ldmatchfield", "srcmatchfield", "orderfield"});
    }

    public void click(EventObject evt) {
        String fieldKey;
        super.click(evt);
        IDataModel model = this.getModel();
        Control control = (Control)evt.getSource();
        switch (fieldKey = control.getKey()) {
            case "srcfield": {
                this.clickSrcField(model);
                break;
            }
            case "srcfiltercondition": {
                this.clickSrcFilterForm(model);
                break;
            }
            case "ldmatchfield": {
                this.clickLevelDimensionMatchField(model);
                break;
            }
            case "srcmatchfield": {
                this.clickSrcMatchField(model);
                break;
            }
            case "orderfield": {
                this.clickOrderField(model);
                break;
            }
        }
    }

    private void clickSrcField(IDataModel model) {
        DynamicObject entityObj = model.getDataEntity().getDynamicObject("srcentity");
        if (entityObj == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u6765\u6e90\u5b9e\u4f53\u3002", (String)"InvpQueryRuleEditPlugin_1", (String)"scmc-invp-form", (Object[])new Object[0]));
            return;
        }
        String entityNumber = entityObj.getString("number");
        FormShowHelper.showColTreeForm((AbstractFormPlugin)this, entityNumber, false, "srcfield");
    }

    private void clickOrderField(IDataModel model) {
        int rowIndex = model.getEntryCurrentRowIndex("orderentry");
        DynamicObject entity = model.getDataEntity().getDynamicObject("srcentity");
        if (entity == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u6765\u6e90\u5b9e\u4f53\u3002", (String)"InvpQueryRuleEditPlugin_1", (String)"scmc-invp-form", (Object[])new Object[0]));
            return;
        }
        String entityNumber = entity.getString("number");
        FormShowHelper.showColTreeFormWithEntry((AbstractFormPlugin)this, entityNumber, rowIndex, Boolean.FALSE, "orderfield", null);
    }

    private void clickLevelDimensionMatchField(IDataModel model) {
        int rowIdx = model.getEntryCurrentRowIndex("matchentry");
        DynamicObject row = model.getEntryRowEntity("matchentry", rowIdx);
        String matchType = row.getString("matchtype");
        DynamicObject levelDimension = (DynamicObject)model.getValue("leveldimension");
        if (null == levelDimension) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5e93\u5b58\u6c34\u4f4d\u7ef4\u5ea6\u3002", (String)"InvpQueryRuleEditPlugin_4", (String)"scmc-invp-form", (Object[])new Object[0]));
            return;
        }
        QFilter filter = new QFilter("id", "=", levelDimension.getPkValue());
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"msplan_plan_dimension", (String)"dimensionname,associationobject", (QFilter[])filter.toArray());
        TreeNode root = new TreeNode("", "root", "\u6c34\u4f4d\u7ef4\u5ea6");
        root.setIsOpened(true);
        root.setCheckable(false);
        DynamicObjectCollection collection = dynamicObject.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection filterCollection = new ArrayList(collection.size());
        if ("B".equals(matchType)) {
            DynamicObject matchGroup = row.getDynamicObject("matchgroup");
            if (null == matchGroup) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5339\u914d\u5206\u7ec4\u3002", (String)"InvpQueryRuleEditPlugin_2", (String)"scmc-invp-form", (Object[])new Object[0]));
                return;
            }
            DynamicObject dataobj = matchGroup.getDynamicObject("dataobj");
            BasedataProp basedataProp = new BasedataProp();
            basedataProp.setBaseEntityId(dataobj.getString("number"));
            String filterEntityType = dataobj.getString("number");
            for (DynamicObject object : collection) {
                if (!filterEntityType.equals(object.getDynamicObject("associationobject").getString("number"))) continue;
                filterCollection.add(object);
            }
        } else {
            filterCollection = collection;
        }
        ArrayList<TreeNode> list = new ArrayList<TreeNode>(filterCollection.size());
        for (DynamicObject item : filterCollection) {
            list.add(new TreeNode("root", item.getDynamicObject("associationobject").getString("number"), item.getString("dimensionname")));
        }
        root.addChildren(list);
        FormShowHelper.showCustomColTreeFormWithEntry((AbstractFormPlugin)this, SerializationUtils.toJsonString((Object)root), rowIdx, false, "ldmatchfield", new BasedataProp[0]);
    }

    private void clickSrcMatchField(IDataModel model) {
        int rowIdx = model.getEntryCurrentRowIndex("matchentry");
        DynamicObject entity = model.getDataEntity().getDynamicObject("srcentity");
        if (entity == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u6765\u6e90\u5b9e\u4f53\u3002", (String)"InvpQueryRuleEditPlugin_1", (String)"scmc-invp-form", (Object[])new Object[0]));
            return;
        }
        String entityNumber = entity.getString("number");
        DynamicObject row = model.getEntryRowEntity("matchentry", rowIdx);
        String matchType = row.getString("matchtype");
        if ("A".equals(matchType)) {
            String levelDimension = (String)model.getValue("ldmatchfieldkey");
            BasedataProp basedataProp = new BasedataProp();
            basedataProp.setBaseEntityId(levelDimension);
            FormShowHelper.showColTreeFormWithEntry((AbstractFormPlugin)this, entityNumber, rowIdx, Boolean.FALSE, "srcmatchfield", (IDataEntityProperty)basedataProp);
        } else if ("B".equals(matchType)) {
            DynamicObject matchGroup = row.getDynamicObject("matchgroup");
            if (null == matchGroup) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5339\u914d\u5206\u7ec4\u3002", (String)"InvpQueryRuleEditPlugin_2", (String)"scmc-invp-form", (Object[])new Object[0]));
                return;
            }
            DynamicObject groupobj = matchGroup.getDynamicObject("groupobj");
            BasedataProp basedataProp = new BasedataProp();
            basedataProp.setBaseEntityId(groupobj.getString("number"));
            FormShowHelper.showColTreeFormWithEntry((AbstractFormPlugin)this, entityNumber, rowIdx, Boolean.FALSE, "srcmatchfield", (IDataEntityProperty)basedataProp);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        String returnData = (String)evt.getReturnData();
        IDataModel dataModel = this.getModel();
        IPageCache pageCache = this.getPageCache();
        if (actionId == null || returnData == null) {
            return;
        }
        switch (actionId) {
            case "leveldimension": {
                this.setLdMatchField(dataModel, pageCache, returnData, "ldmatchfield", "ldmatchfieldkey");
                break;
            }
            case "srcfield": {
                FormShowHelper.closeCallSetField(dataModel, pageCache, returnData, "srcfield", "srcfieldkey");
                break;
            }
            case "srcfiltercondition": {
                FormShowHelper.closeCallSetFilter(dataModel, pageCache, returnData, "srcfiltercondition", "srcfilterjson_tag", "srcfilterformula_tag");
                break;
            }
            case "ldmatchfield": {
                this.setLdMatchField(dataModel, pageCache, returnData, "ldmatchfield", "ldmatchfieldkey");
                break;
            }
            case "srcmatchfield": {
                FormShowHelper.closeCallSetEntryField(dataModel, pageCache, returnData, "srcmatchfield", "srcmatchfieldkey");
                break;
            }
            case "orderfield": {
                FormShowHelper.closeCallSetEntryField(dataModel, pageCache, returnData, "orderfield", "orderfieldkey");
                break;
            }
        }
    }

    private void setLdMatchField(IDataModel model, IPageCache pageCache, String returnData, String ldmatchfield, String ldmatchfieldkey) {
        DynamicObject levelDimension = (DynamicObject)model.getValue("leveldimension");
        QFilter filter = new QFilter("id", "=", levelDimension.getPkValue());
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"msplan_plan_dimension", (String)"dimensionname,associationobject", (QFilter[])filter.toArray());
        DynamicObjectCollection collection = dynamicObject.getDynamicObjectCollection("entryentity");
        for (DynamicObject object : collection) {
            String number = object.getDynamicObject("associationobject").getString("number");
            String name = object.getString("dimensionname");
            if (!returnData.equals(number)) continue;
            String currentRowIndex = pageCache.get("rowIndex");
            int rowIndex = Integer.parseInt(currentRowIndex);
            model.setValue("ldmatchfield", (Object)name, rowIndex);
            model.setValue("ldmatchfieldkey", (Object)number, rowIndex);
            break;
        }
    }

    private void clickSrcFilterForm(IDataModel model) {
        DynamicObject srcBill = (DynamicObject)model.getValue("srcentity");
        if (srcBill == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u6765\u6e90\u5b9e\u4f53\u3002", (String)"InvpQueryRuleEditPlugin_1", (String)"scmc-invp-form", (Object[])new Object[0]));
            return;
        }
        String entityNumber = srcBill.getString("number");
        FormShowHelper.showFilterForm((AbstractFormPlugin)this, model, entityNumber, "srcfilterjson_tag", "srcfiltercondition");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        int rowIdx = changeSet[0].getRowIndex();
        Object newValue = changeSet[0].getNewValue();
        Object oldValue = changeSet[0].getOldValue();
        switch (propertyName) {
            case "srcentity": {
                this.srcEntityChange(newValue, oldValue);
                break;
            }
            case "srcfield": {
                this.srcFieldChange(newValue, oldValue);
                break;
            }
            case "srcfiltercondition": {
                this.srcConditionChange(newValue);
                break;
            }
            case "matchtype": {
                this.matchTypeChange(newValue, rowIdx);
                break;
            }
            case "matchgroup": {
                this.matchGroupChange(newValue, rowIdx);
                break;
            }
            case "leveldimension": {
                this.levelDimensionChange(newValue, oldValue);
                break;
            }
            case "ldmatchfield": {
                this.levelDimensionFieldChange(newValue, rowIdx);
                break;
            }
            case "srcmatchfield": {
                this.srcMatchFieldChange(newValue, rowIdx);
                break;
            }
            case "orderfield": {
                this.tgtOrderFieldChange(newValue, rowIdx);
                break;
            }
        }
    }

    private void srcFieldChange(Object newValue, Object oldValue) {
        if (ObjectUtils.isEmpty((Object)newValue)) {
            DataModelHelper.clearField(this.getModel(), "srcfieldkey");
        }
    }

    private void srcMatchFieldChange(Object newValue, int rowIdx) {
        if (ObjectUtils.isEmpty((Object)newValue)) {
            DataModelHelper.clearEntryField(this.getModel(), rowIdx, "srcmatchfieldkey");
        }
    }

    private void tgtOrderFieldChange(Object newValue, int rowIdx) {
        if (ObjectUtils.isEmpty((Object)newValue)) {
            DataModelHelper.clearEntryField(this.getModel(), rowIdx, "orderfieldkey");
        }
    }

    private void levelDimensionFieldChange(Object newValue, int rowIdx) {
        if (ObjectUtils.isEmpty((Object)newValue)) {
            DataModelHelper.clearEntryField(this.getModel(), rowIdx, "ldmatchfieldkey");
        }
        DataModelHelper.clearEntryField(this.getModel(), rowIdx, "srcmatchfield", "srcmatchfieldkey");
        this.getView().updateView("matchentry", rowIdx);
    }

    private void matchGroupChange(Object newValue, int rowIdx) {
        String matchType = (String)this.getModel().getValue("matchtype", rowIdx);
        if ("A".equals(matchType)) {
            DataModelHelper.clearEntryField(null != newValue, this.getModel(), rowIdx, "matchgroup");
        } else {
            DataModelHelper.clearEntryField(this.getModel(), rowIdx, "ldmatchfield", "ldmatchfieldkey", "srcmatchfield", "srcmatchfieldkey");
        }
        this.getView().updateView("matchentry", rowIdx);
    }

    private void srcConditionChange(Object newValue) {
        DataModelHelper.clearField(ObjectUtils.isEmpty((Object)newValue), this.getModel(), "srcfiltercondition", "srcfilterjson_tag", "srcfilterformula_tag");
    }

    private void matchTypeChange(Object newValue, int rowIdx) {
        DataModelHelper.clearEntryField(this.getModel(), rowIdx, "matchgroup", "ldmatchfield", "ldmatchfieldkey", "srcmatchfield", "srcmatchfieldkey");
        this.getView().updateView("matchentry", rowIdx);
    }

    private void srcEntityChange(Object newValue, Object oldValue) {
        if (oldValue != null) {
            DynamicObject oldValDym = (DynamicObject)oldValue;
            DynamicObject newValDym = (DynamicObject)newValue;
            HashMap<Object, Object> confirmInfo = new HashMap<Object, Object>(16);
            confirmInfo.put(CommonConst.OLD_VALUE, oldValDym.getPkValue());
            if (newValDym != null) {
                confirmInfo.put(CommonConst.NEW_VALUE, newValDym.getPkValue());
            }
            String msg = ResManager.loadKDString((String)"\u5207\u6362\u6765\u6e90\u5b9e\u4f53\u5c06\u6e05\u9664\u9875\u9762\u7684\u5339\u914d\u89c4\u5219\uff0c\u53d6\u6570\u4f18\u5148\u7ea7\uff0c\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u64cd\u4f5c\uff1f", (String)"InvpQueryRuleEditPlugin_3", (String)"scmc-invp-form", (Object[])new Object[0]);
            ConfirmCallBackListener callBackListener = new ConfirmCallBackListener("srcentity", (IFormPlugin)this);
            this.getView().showConfirm(msg, null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, callBackListener, null, SerializationUtils.toJsonString(confirmInfo));
        } else {
            this.getModel().setValue("srcentity", newValue);
        }
    }

    private void levelDimensionChange(Object newValue, Object oldValue) {
        if (oldValue != null) {
            DynamicObject oldValDym = (DynamicObject)oldValue;
            DynamicObject newValDym = (DynamicObject)newValue;
            HashMap<Object, Object> confirmInfo = new HashMap<Object, Object>(16);
            confirmInfo.put(CommonConst.OLD_VALUE, oldValDym.getPkValue());
            if (newValDym != null) {
                confirmInfo.put(CommonConst.NEW_VALUE, newValDym.getPkValue());
            }
            String msg = ResManager.loadKDString((String)"\u5207\u6362\u5e93\u5b58\u6c34\u4f4d\u7ef4\u5ea6\u5c06\u6e05\u9664\u9875\u9762\u7684\u5339\u914d\u89c4\u5219\uff0c\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u64cd\u4f5c\uff1f", (String)"InvpQueryRuleEditPlugin_5", (String)"scmc-invp-form", (Object[])new Object[0]);
            ConfirmCallBackListener callBackListener = new ConfirmCallBackListener("leveldimension", (IFormPlugin)this);
            this.getView().showConfirm(msg, null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, callBackListener, null, SerializationUtils.toJsonString(confirmInfo));
        } else {
            this.getModel().setValue("leveldimension", newValue);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent closedEvent) {
        super.confirmCallBack(closedEvent);
        String callBackId = closedEvent.getCallBackId();
        MessageBoxResult result = closedEvent.getResult();
        String customValue = closedEvent.getCustomVaule();
        switch (callBackId) {
            case "srcentity": {
                this.srcEntityConfirmCB(result, customValue);
                break;
            }
            case "leveldimension": {
                this.levelDimensionConfirmCB(result, customValue);
                break;
            }
        }
    }

    private void levelDimensionConfirmCB(MessageBoxResult result, String customValue) {
        if (StringUtils.isBlank((CharSequence)customValue)) {
            return;
        }
        Map confirmInfo = (Map)SerializationUtils.fromJsonString((String)customValue, Map.class);
        if (MessageBoxResult.Yes.equals((Object)result)) {
            Object newValue = confirmInfo.get(CommonConst.NEW_VALUE);
            this.getModel().beginInit();
            this.getModel().setValue("leveldimension", newValue);
            this.getModel().deleteEntryData("matchentry");
            this.getModel().createNewEntryRow("matchentry");
            this.getModel().endInit();
            this.getView().updateView();
        } else {
            Object oldValue = confirmInfo.get(CommonConst.OLD_VALUE);
            this.getModel().beginInit();
            this.getModel().setValue("leveldimension", oldValue);
            this.getModel().endInit();
            this.getView().updateView("leveldimension");
        }
    }

    private void srcEntityConfirmCB(MessageBoxResult result, String customValue) {
        if (StringUtils.isBlank((CharSequence)customValue)) {
            return;
        }
        Map confirmInfo = (Map)SerializationUtils.fromJsonString((String)customValue, Map.class);
        if (MessageBoxResult.Yes.equals((Object)result)) {
            Object newValue = confirmInfo.get(CommonConst.NEW_VALUE);
            this.getModel().beginInit();
            this.getModel().setValue("srcentity", newValue);
            DataModelHelper.clearField(this.getModel(), "srcfield", "srcfieldkey", "srcfiltercondition", "srcfilterjson_tag", "srcfilterformula_tag");
            this.getModel().deleteEntryData("matchentry");
            this.getModel().createNewEntryRow("matchentry");
            this.getModel().deleteEntryData("orderentry");
            this.getModel().createNewEntryRow("orderentry");
            this.getModel().endInit();
            this.getView().updateView();
        } else {
            Object oldValue = confirmInfo.get(CommonConst.OLD_VALUE);
            this.getModel().beginInit();
            this.getModel().setValue("srcentity", oldValue);
            this.getModel().endInit();
            this.getView().updateView("srcentity");
        }
    }
}

