/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.formplugin;

import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.scmc.invp.common.helper.DataModelHelper;
import kd.scmc.invp.common.helper.FormUtil;
import kd.scmc.invp.common.helper.PlanTypeHelper;

public class InvpQuerySchemaEditPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"plantype"});
        FormUtil.addF7Listener(this, "levelfactor", "queryrule");
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fieldKey = evt.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        switch (fieldKey) {
            case "levelfactor": {
                this.beforeF7WithLevelFactor(evt, showParameter);
                break;
            }
            case "queryrule": {
                this.beforeF7WithQueryRule(evt);
                break;
            }
        }
    }

    private void beforeF7WithQueryRule(BeforeF7SelectEvent evt) {
        IDataModel model = this.getModel();
        DynamicObject levelDimension = (DynamicObject)model.getValue("leveldimension");
        if (null == levelDimension) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5e93\u5b58\u6c34\u4f4d\u7ef4\u5ea6\u3002", (String)"InvpQuerySchemaEditPlugin_0", (String)"scmc-invp-form", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        QFilter qFilter = new QFilter("leveldimension", "=", levelDimension.getPkValue());
        evt.addCustomQFilter(qFilter);
    }

    private void beforeF7WithLevelFactor(BeforeF7SelectEvent evt, ListShowParameter showParameter) {
        IDataModel model = this.getModel();
        String planType = (String)model.getValue("plantype");
        if (null == planType) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201d\u8ba1\u5212\u7c7b\u578b\u3002", (String)"InvpQuerySchemaEditPlugin_1", (String)"scmc-invp-form", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        QFilter qFilter = new QFilter(PlanTypeHelper.getFieldName(planType), "=", (Object)Boolean.TRUE);
        evt.addCustomQFilter(qFilter);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        int rowIdx = changeSet[0].getRowIndex();
        Object newValue = changeSet[0].getNewValue();
        Object oldValue = changeSet[0].getOldValue();
        switch (propertyName) {
            case "plantype": {
                this.planTypeChange();
                break;
            }
        }
        this.getView().updateView();
    }

    private void planTypeChange() {
        DataModelHelper.clearField(this.getModel(), "levelfactor");
        this.getView().updateView("levelfactor");
    }
}

