/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.formplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scmc.invp.common.consts.CommonConst;
import kd.scmc.invp.common.consts.InventoryDimension;
import kd.scmc.invp.common.helper.FormUtil;
import kd.scmc.invp.common.helper.InvpLevelFactorHelper;
import kd.scmc.invp.common.helper.MrpMaterialGroupStandardHelper;

public class InvpSafeStockRecEditPlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    private List<String> dimensionFields = Arrays.asList("bos_org", "bd_material", "bd_materialgroup", "bd_materialgroupstandard", "bd_warehouse");

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtil.addF7Listener(this, "bd_material", "bd_materialgroup", "bd_materialgroupstandard", "bd_warehouse");
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initBosOrg();
    }

    private void initBosOrg() {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        IPageCache pageCache = parentView.getPageCache();
        String defaultOrg = pageCache.get("defaultOrg");
        Long orgId = null;
        orgId = StringUtils.isBlank((CharSequence)defaultOrg) ? Long.valueOf(RequestContext.get().getOrgId()) : Long.valueOf(defaultOrg);
        this.getModel().setValue("bos_org", (Object)orgId);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object dimension = this.getModel().getValue("dimension");
        if (dimension == null) {
            return;
        }
        this.setDimensionFieldsView((DynamicObject)dimension);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        super.propertyChanged(e);
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        Object oldValue = changeSet[0].getOldValue();
        if (newValue != null && newValue.equals(oldValue) || newValue == null && oldValue == null) {
            return;
        }
        switch (propName = e.getProperty().getName()) {
            case "dimension": {
                this.dimensionChange(oldValue, newValue);
                break;
            }
            case "safestock": 
            case "consumeperday": {
                this.safeStockChange();
                break;
            }
            case "bos_org": {
                this.orgChange(oldValue, newValue);
                break;
            }
            case "bd_materialgroupstandard": {
                this.grpStandardChange();
                break;
            }
            case "bd_materialgroup": {
                this.materialGrpChange(newValue);
                break;
            }
        }
    }

    private void materialGrpChange(Object newValue) {
        Object standard = this.getModel().getValue("bd_materialgroupstandard");
        if (newValue == null || standard != null) {
            return;
        }
        Object standardProp = ((DynamicObject)newValue).get("standard");
        this.getModel().beginInit();
        this.getModel().setValue("bd_materialgroupstandard", standardProp);
        this.getModel().endInit();
        this.getView().updateView("bd_materialgroupstandard");
    }

    private void grpStandardChange() {
        this.getModel().beginInit();
        this.getModel().setValue("bd_materialgroup", null);
        this.getModel().endInit();
        this.getView().updateView("bd_materialgroup");
    }

    private void orgChange(Object oldValue, Object newValue) {
        HashMap<Object, Object> params = new HashMap<Object, Object>();
        params.put(CommonConst.OLD_VALUE, oldValue == null ? null : ((DynamicObject)oldValue).getPkValue());
        params.put("propName", "bos_org");
        ConfirmCallBackListener callBackListener = new ConfirmCallBackListener("bos_org", (IFormPlugin)this);
        String message = ResManager.loadKDString((String)"\u4e1a\u52a1\u7ec4\u7ec7\u5207\u6362\uff0c\u5c06\u6e05\u9664\u7ec4\u7ec7\u76f8\u5173\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"InvpSafeStockEditPlugin_5", (String)"scmc-invp-form", (Object[])new Object[0]);
        this.getView().showConfirm(message, "", MessageBoxOptions.OKCancel, ConfirmTypes.Default, callBackListener, null, SerializationUtils.toJsonString(params));
    }

    private void safeStockChange() {
        Object stock = this.getModel().getValue("safestock");
        Object consume = this.getModel().getValue("consumeperday");
        if (stock == null || consume == null) {
            this.getModel().setValue("safestockdays", null);
            return;
        }
        BigDecimal consumePerDay = new BigDecimal(consume.toString());
        if (consumePerDay.compareTo(BigDecimal.ZERO) == 0) {
            this.getModel().setValue("safestockdays", null);
            return;
        }
        BigDecimal safeStock = new BigDecimal(stock.toString());
        BigDecimal safeStockDays = safeStock.divide(consumePerDay, 2, RoundingMode.HALF_UP);
        this.getModel().setValue("safestockdays", (Object)safeStockDays.doubleValue());
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId;
        super.confirmCallBack(e);
        MessageBoxResult result = e.getResult();
        Map customMap = (Map)SerializationUtils.fromJsonString((String)e.getCustomVaule(), Map.class);
        switch (callBackId = e.getCallBackId()) {
            case "dimension": {
                if (result == MessageBoxResult.Yes) {
                    this.clearDimensionFields();
                    break;
                }
                this.recoverData(customMap);
                break;
            }
            case "bos_org": {
                this.confirmBosOrgChange(e.getResult(), e.getCustomVaule());
                break;
            }
        }
    }

    private void confirmBosOrgChange(MessageBoxResult result, String customValue) {
        if (result == MessageBoxResult.Yes) {
            this.getModel().beginInit();
            for (String dimensionField : this.dimensionFields) {
                if ("bos_org".equals(dimensionField)) continue;
                this.getModel().setValue(dimensionField, null);
            }
            this.getModel().endInit();
            for (String dimensionField : this.dimensionFields) {
                this.getView().updateView(dimensionField);
            }
        } else {
            Map customMap = (Map)SerializationUtils.fromJsonString((String)customValue, Map.class);
            this.recoverData(customMap);
        }
    }

    private void recoverData(Map<String, Object> customMap) {
        Object oldValue = customMap.get(CommonConst.OLD_VALUE);
        String propName = (String)customMap.get("propName");
        if (oldValue != null) {
            oldValue = oldValue instanceof Long ? oldValue : Long.valueOf(oldValue.toString());
        }
        this.getModel().beginInit();
        this.getModel().setValue(propName, oldValue);
        this.getModel().endInit();
        this.getView().updateView(propName);
    }

    private void clearDimensionFields() {
        this.getModel().beginInit();
        for (String dimensionField : this.dimensionFields) {
            this.getModel().setValue(dimensionField, null);
        }
        this.getModel().endInit();
        DynamicObject dimension = (DynamicObject)this.getModel().getValue("dimension");
        this.setDimensionFieldsView(dimension);
        for (String dimensionField : this.dimensionFields) {
            this.getView().updateView(dimensionField);
        }
    }

    private void dimensionChange(Object oldValue, Object newValue) {
        DynamicObject dimension = (DynamicObject)newValue;
        if (oldValue != null) {
            HashMap<Object, Object> params = new HashMap<Object, Object>();
            params.put(CommonConst.OLD_VALUE, ((DynamicObject)oldValue).getPkValue());
            params.put("propName", "dimension");
            ConfirmCallBackListener callBackListener = new ConfirmCallBackListener("dimension", (IFormPlugin)this);
            String message = ResManager.loadKDString((String)"\u5e93\u5b58\u6c34\u4f4d\u7ef4\u5ea6\u5207\u6362\uff0c\u5c06\u6e05\u9664\u5e93\u5b58\u6c34\u4f4d\u7ef4\u5ea6\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"InvpInvLevelBasePlugin_2", (String)"scmc-invp-form", (Object[])new Object[0]);
            this.getView().showConfirm(message, "", MessageBoxOptions.OKCancel, ConfirmTypes.Default, callBackListener, null, SerializationUtils.toJsonString(params));
        } else {
            this.setDimensionFieldsView(dimension);
        }
    }

    private void setDimensionFieldsView(DynamicObject dimension) {
        this.hideFields(dimension);
    }

    private void hideFields(DynamicObject dimenSion) {
        InvpLevelFactorHelper.hideFields(this.getView(), this.dimensionFields, Collections.emptyList(), Collections.emptyList());
        List<MrpMaterialGroupStandardHelper.InvpInvDimensionEntry> entryList = MrpMaterialGroupStandardHelper.getInventoryDimension(dimenSion);
        for (MrpMaterialGroupStandardHelper.InvpInvDimensionEntry entry : entryList) {
            String entityNumber = entry.getAssociationobject();
            String fieldName = entry.getDimensionname();
            FieldEdit baseDataEdit = (FieldEdit)this.getControl(entityNumber);
            if (baseDataEdit == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b89\u5168\u5e93\u5b58\u8bb0\u5f55\u4e0d\u652f\u6301\u201c{0}\u201d\u7684\u7ef4\u5ea6\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"InvpSafeStockEditPlugin_4", (String)"scmc-invp-form", (Object[])new Object[]{fieldName}));
                continue;
            }
            baseDataEdit.setMustInput(true);
            this.getView().setEnable(Boolean.TRUE, new String[]{entityNumber});
            this.getView().setVisible(Boolean.TRUE, new String[]{entityNumber});
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String propName;
        switch (propName = e.getProperty().getName()) {
            case "bd_warehouse": {
                this.beforeWarehouseSelect(e);
                break;
            }
            case "bd_materialgroup": {
                this.beforeMTGrpSelect(e);
                break;
            }
            case "bd_material": {
                this.beforeMaterialSelect(e);
                break;
            }
            case "bd_materialgroupstandard": {
                this.beforeGroupStandardSelect(e);
                break;
            }
        }
    }

    private void beforeGroupStandardSelect(BeforeF7SelectEvent e) {
        DynamicObject bosOrg = (DynamicObject)this.getModel().getValue("bos_org");
        if (bosOrg == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e1a\u52a1\u7ec4\u7ec7\u3002", (String)"InvpSafeStockEditPlugin_0", (String)"scmc-invp-form", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        Set ids = (Set)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupStandardByOrgs", (Object[])new Object[]{"bd_material", Collections.singletonList((Long)bosOrg.getPkValue()), Boolean.TRUE});
        e.getCustomQFilters().add(new QFilter("id", "in", (Object)ids));
    }

    private void beforeMaterialSelect(BeforeF7SelectEvent e) {
        Object dimension = this.getModel().getValue("dimension");
        if (dimension == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5e93\u5b58\u6c34\u4f4d\u7ef4\u5ea6\u3002", (String)"InvpSafeStockEditPlugin_3", (String)"scmc-invp-form", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        Object bosOrg = this.getModel().getValue("bos_org");
        if (bosOrg == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e1a\u52a1\u7ec4\u7ec7\u3002", (String)"InvpSafeStockEditPlugin_0", (String)"scmc-invp-form", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_material", (Long)((DynamicObject)bosOrg).getLong("id"));
        e.getCustomQFilters().add(baseDataFilter);
        InventoryDimension dim = new InventoryDimension(((DynamicObject)dimension).getPkValue());
        Map<String, String> entityToNameMap = dim.getEntityToNameMap();
        if (!entityToNameMap.containsKey("bd_materialgroup")) {
            return;
        }
        Object group = this.getModel().getValue("bd_materialgroup");
        if (group == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7269\u6599\u5206\u7c7b\u3002", (String)"InvpSafeStockEditPlugin_2", (String)"scmc-invp-form", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        QFilter[] stdFilter = new QFilter[]{new QFilter("group", "=", ((DynamicObject)group).getPkValue())};
        HashSet<Object> mts = new HashSet<Object>(64);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_materialgroupdetail", (String)"material,group", (QFilter[])stdFilter, null);){
            for (Row d : ds) {
                Object mt = d.get("material");
                mts.add(mt);
            }
        }
        QFilter materialFilter = new QFilter("id", "in", mts);
        e.getCustomQFilters().add(materialFilter);
        Object std = this.getModel().getValue("bd_materialgroupstandard");
        if (std != null) {
            e.getFormShowParameter().setCustomParam("groupStandard", ((DynamicObject)std).getPkValue());
        }
    }

    private void beforeMTGrpSelect(BeforeF7SelectEvent e) {
        DynamicObject bosOrg = (DynamicObject)this.getModel().getValue("bos_org");
        if (bosOrg == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e1a\u52a1\u7ec4\u7ec7\u3002", (String)"InvpSafeStockEditPlugin_0", (String)"scmc-invp-form", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        Object groupStand = this.getModel().getValue("bd_materialgroupstandard");
        Object groupStandardId = null;
        if (groupStand != null) {
            DynamicObject groupStandDy = (DynamicObject)groupStand;
            groupStandardId = groupStandDy.getPkValue();
            e.getFormShowParameter().setCustomParam("groupStandard", groupStandDy.getPkValue());
        }
        QFilter fs = (QFilter)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupByOrgs", (Object[])new Object[]{"bd_material", Collections.singletonList((Long)bosOrg.getPkValue()), groupStandardId, false});
        e.getCustomQFilters().add(fs);
    }

    private void beforeWarehouseSelect(BeforeF7SelectEvent e) {
        DynamicObject bosOrg = (DynamicObject)this.getModel().getValue("bos_org");
        if (bosOrg == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e1a\u52a1\u7ec4\u7ec7\u3002", (String)"InvpSafeStockEditPlugin_0", (String)"scmc-invp-form", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_warehouse", (Long)bosOrg.getLong("id"));
        e.getCustomQFilters().add(baseDataFilter);
    }

    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        IDataModel bill = this.getModel();
        BillModel billModel = (BillModel)bill;
        boolean isFromWebApi = billModel.isFromWebApi();
        if (!isFromWebApi) {
            return;
        }
        Object mtGroup = bill.getValue("bd_materialgroup");
        if (mtGroup == null) {
            return;
        }
        DynamicObject mtGroupDy = (DynamicObject)mtGroup;
        DynamicObject standard = mtGroupDy.getDynamicObject("standard");
        bill.setValue("bd_materialgroupstandard", (Object)standard);
    }
}

