/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.formplugin;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scmc.invp.business.FieldSelectorHelper;
import kd.scmc.invp.formplugin.InvpFactorTplEditPlugin;

public class InvpSafeStockSchemeEditPlugin
extends InvpFactorTplEditPlugin
implements BeforeF7SelectListener {
    public static MainEntityType getMainEntityType(String fieldName) {
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)fieldName);
        if (type == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5143\u6570\u636e{0}\u5b9e\u4f53\u4e0d\u5b58\u5728\u3002", (String)"InvpSchemeEditPlugin_6", (String)"scmc-invp-form", (Object[])new Object[]{fieldName}));
        }
        return type;
    }

    private void addBaseDataF7Listener(String ... keys) {
        for (String key : keys) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getControl(key);
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"invlevelfield"});
        this.addBaseDataF7Listener("demmapping", "consumptionmodel");
        this.addClickListeners(new String[]{"servicelevel", "invlevelcol"});
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("selectrule");
        filterGrid.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        switch (propName) {
            case "servicelevel": {
                this.changeServiceLevel(newValue);
                break;
            }
            case "invlevelcol": {
                this.changeColName("invlevelcol", "invlevelcolsign");
                break;
            }
            case "mainplantype": {
                this.getModel().setValue("invlevelcol", null);
                this.getModel().setValue("invlevelcolsign", null);
                break;
            }
        }
    }

    private void changeServiceLevel(Object newValue) {
        if (StringUtils.isBlank((Object)newValue)) {
            this.getModel().setValue("coefficient", null);
        }
    }

    private void changeColName(String colName, String colSign) {
        String val = (String)this.getModel().getValue(colName);
        if (StringUtils.isBlank((CharSequence)val)) {
            this.getModel().setValue(colSign, null);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (source.getKey()) {
            case "servicelevel": {
                this.clickServiceLevel();
                break;
            }
            case "invlevelcol": {
                this.clickSrcCol("invlevelcol");
                break;
            }
        }
    }

    private void clickSrcCol(String colName) {
        MainEntityType srcEntityType = InvpSafeStockSchemeEditPlugin.getMainEntityType("invp_invlevel");
        PropTreeBuildOption ops = new PropTreeBuildOption();
        ops.addMatchedClassTypes(DecimalProp.class);
        ops.addMatchedClassTypes(IntegerProp.class);
        TreeNode srcBillNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)srcEntityType, (PropTreeBuildOption)ops);
        this.removeTreeNode(srcBillNode, this.getSelectField());
        FormShowParameter showParameter = FieldSelectorHelper.showSelectFieldForm(srcBillNode);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, colName));
        this.getView().showForm(showParameter);
    }

    private void removeTreeNode(TreeNode node, Set<String> fieldKey) {
        List children = node.getChildren();
        Iterator iterator = children.iterator();
        while (iterator.hasNext()) {
            TreeNode child = (TreeNode)iterator.next();
            if (!fieldKey.contains(child.getId()) && !"billhead".equals(child.getId())) {
                iterator.remove();
            }
            if (child.getChildren() == null || child.getChildren().isEmpty()) continue;
            this.removeTreeNode(child, fieldKey);
        }
    }

    private Set<String> getSelectField() {
        HashSet<String> result = new HashSet<String>(16);
        String planType = (String)this.getModel().getValue("mainplantype");
        QFilter filter = new QFilter("id", "in", (Object)new Long[]{1763871355096684544L, 1763898510471735296L}).and("enable", "=", (Object)"1").and("entryentity.plantype", "=", (Object)planType).and("entryentity.relentity", "=", (Object)"invp_invlevel");
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"invp_levelfactor", (String)"id,entryentity.relfieldkey as relfieldkey", (QFilter[])filter.toArray(), null);
        for (Row row : dataSet) {
            String fieldKey = row.getString("relfieldkey");
            if (!StringUtils.isNotEmpty((CharSequence)fieldKey)) continue;
            result.add(fieldKey);
        }
        return result;
    }

    private void clickServiceLevel() {
        ListShowParameter form = ShowFormHelper.createShowListForm((String)"invp_cus_servicelevel", (boolean)false);
        form.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "chose_sevicelevel"));
        this.getView().showForm((FormShowParameter)form);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        Object data = event.getReturnData();
        if (data == null) {
            return;
        }
        switch (actionId) {
            case "invlevelcol": {
                this.callBackInvLevelCol("invlevelcol", "invlevelcolsign", data.toString());
                break;
            }
            case "chose_sevicelevel": {
                ListSelectedRowCollection rows = (ListSelectedRowCollection)data;
                ListSelectedRow row = rows.get(0);
                Object pkValue = row.getPrimaryKeyValue();
                DynamicObject serviceLevel = BusinessDataServiceHelper.loadSingleFromCache((Object)pkValue, (String)"invp_cus_servicelevel");
                BigDecimal level = serviceLevel.getBigDecimal("servicelevel");
                BigDecimal coefficient = serviceLevel.getBigDecimal("coefficient");
                String levelString = level.toString();
                int idx = levelString.indexOf(".");
                levelString = levelString.substring(0, idx + 3);
                this.getModel().setValue("servicelevel", (Object)levelString);
                this.getModel().setValue("coefficient", (Object)coefficient);
                break;
            }
        }
    }

    private void callBackInvLevelCol(String colName, String colSign, String returnCol) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)returnCol)) {
            return;
        }
        if ("entryentity".equals(returnCol)) {
            return;
        }
        IDataModel model = this.getModel();
        if (returnCol.equals("invp_invlevel") || returnCol.equals("billhead")) {
            return;
        }
        MainEntityType sourceType = EntityMetadataCache.getDataEntityType((String)"invp_invlevel");
        model.setValue(colSign, (Object)FieldSelectorHelper.getFullCol(sourceType, returnCol));
        model.setValue(colName, (Object)FieldSelectorHelper.getColName(sourceType, returnCol));
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        super.beforeF7Select(e);
        switch (key = e.getProperty().getName()) {
            case "demmapping": {
                this.beforeF7WithMatchDimension(e);
                break;
            }
            case "invlevel": {
                this.beforeInvLevelSelect(e);
                break;
            }
            case "consumptionmodel": {
                this.beforeSafeStockModelSelect(e);
                break;
            }
        }
    }

    private void beforeSafeStockModelSelect(BeforeF7SelectEvent e) {
        Object planOrg = this.getModel().getValue("createorg");
        if (planOrg == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u8ba1\u5212\u7ec4\u7ec7\u3002", (String)"InvpSafeStockSchemeEditPlugin_0", (String)"scmc-invp-form", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        DynamicObject planOrgDy = (DynamicObject)planOrg;
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"invp_model_register", (Long)((Long)planOrgDy.getPkValue()));
        QFilter qFilter = new QFilter("businessentity", "=", (Object)"invp_safestock_model");
        qFilter.and("enable", "=", (Object)"1");
        qFilter.and(baseDataFilter);
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        showParameter.getListFilterParameter().setFilter(qFilter);
    }

    @Override
    protected QFilter getMatchConfFilter() {
        QFilter forward = new QFilter("tgtentity", "=", (Object)"invp_safestock_model");
        forward = forward.and("srcentity", "=", (Object)"invp_invlevel");
        QFilter reverse = new QFilter("tgtentity", "=", (Object)"invp_invlevel");
        reverse = reverse.and("srcentity", "=", (Object)"invp_safestock_model");
        return forward.or(reverse);
    }

    private void beforeInvLevelSelect(BeforeF7SelectEvent e) {
        Object planOrg = this.getModel().getValue("createorg");
        if (planOrg == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u8ba1\u5212\u7ec4\u7ec7\u3002", (String)"InvpSafeStockSchemeEditPlugin_0", (String)"scmc-invp-form", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        DynamicObject planOrgDy = (DynamicObject)planOrg;
        QFilter filter = BaseDataServiceHelper.getBaseDataFilter((String)"invp_invlevel", (Long)((Long)planOrgDy.getPkValue()));
        filter.and("enable", "=", (Object)"1");
        ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
        listShowParameter.getListFilterParameter().setFilter(filter);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"manualcalculate"});
    }

    @Override
    protected String getMatchDimensionKey() {
        return "demmapping";
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        if ("save".equals(operateKey)) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"manualcalculate"});
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"manualcalculate"});
    }
}

